/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

typedef struct {
  int size;
  int *prev;
  int *next;
}FHead;

team_t team = {
    /* Team name to be displayed on webpage */
    "pewp eat0rs",
    /* First member full name */
    "Christon DeWan",
    /* First member email address */
    "cdewan@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "Dirk Morris",
    /* Second member email address (blank if none) */
    "dmorris@andrew.cmu.edu"
};


void printblock(FHead *head)
{
  int size = head->size;
  printf("***\nBlock starting at address %i\n",(int)head);
  if (size < 0){
    size = size ^(1<<31);
    printf("Size of taken block is %i\n",size); 
  } else {
    printf("Size of free block is %i\n",size);
  }
  if (head->size == *((int *)((int)head + size - 4))) printf ("Boundary tags match.\n****\n");
  else printf ("Boundary tags do *NOT* match.\n****\n");
}

void blockwrite(int *start, int size)
{
  int altsize = size | (1<<31);
  *start = *(start + size/4 -1) = altsize;
}

void freeblockwrite(int *start, int size)
{
  
  int *base = (int *)dseg_lo;
  FHead *next,*head = (FHead *)start;
  
  

  if (size == 0)
    return;

  *start = *(start + size/4 -1) = size;
  head->next = (int *)(*base);
  head->prev = (int *)0;

  if(*base){
    next = (FHead *)(*base);
 
    next->prev = start;
  }

  *((int **)base) = start;

}

void removefree(FHead *thisblock)
{
  int *listhead = (int *)dseg_lo;
  FHead *prevblock,*nextblock;
  
  prevblock = (FHead *)(thisblock->prev);
  nextblock = (FHead *)(thisblock->next);


  if (prevblock) prevblock->next = (int *)nextblock;
  else *((int **)listhead) = (int *)nextblock;

  if (nextblock) nextblock->prev = (int *)prevblock;

}

void codown(FHead *head)
{
 
  int downsize,fullsize,size,*start = (int *)head;

  
  downsize = *(start-1);  
  size = *start;  
  fullsize = size + downsize;
  
  /*  printf("COing block of size %i,\n",size); */

  if (downsize < 0) return;

  if ((int)start <= (int)(dseg_lo) + 4) return;

  /* printf("With block of size %i.\n",downsize); */

  removefree((FHead *)(start-downsize/4));
  removefree((FHead *)start);

  freeblockwrite(start-downsize/4, fullsize);
}

void coup(FHead *head)
{
  int *start = (int *)head;
  int size = * start;
  int nextblocksize;
  FHead * next = (FHead *)(start + size/4);
  if (next->size < 0) return;
  if (next >= (FHead *)dseg_hi) return;
  nextblocksize = next->size;
  removefree((FHead *)next);
  removefree((FHead *)start);
  freeblockwrite(start ,size + nextblocksize);
  
  
}

int mm_init (void)
{
  int HEAP_HEAD = 4;
  int startsize;
  int *result;

  startsize = mem_pagesize();
  result = mem_sbrk(startsize-12);

  *(result) = 0;
  
  freeblockwrite(result+1,startsize-HEAP_HEAD-12);

  return -(!result);
}

int newPage(int size)
{
  int newblocksize;
  int *result;
  /*  printf("*NewPage* \n"); */

  newblocksize = mem_pagesize();
  newblocksize = (size + newblocksize -1)/newblocksize*newblocksize;

  result = mem_sbrk(newblocksize);
  
  if (!result) return 0;

  freeblockwrite(result,newblocksize); /*add one to keep 8bit aligned*/
  codown((FHead *)result);

  return 1;
}
 
void *mm_malloc (size_t size)
{
  int H_SIZE=4;
  FHead *thisblock;
  int * listhead;
  int PADDING = 8;
  int originalsize,nextblocksize;
  size = ((size + PADDING + 15)/16)*16;
  /*    printf("mm_malloc %i \n",size); */
 
  listhead = (int *)dseg_lo;

  thisblock = (FHead *)(*listhead);
  

  

  if (!thisblock){
    newPage(size);
    thisblock = (FHead *)(*listhead);
  }else
    while(thisblock->size < size) 
    {

      
      if (thisblock->next == 0 ) {
	if (!newPage(size)){ 
	  /*	  printf("nope"); */
	  return NULL;
	}
	thisblock = (FHead *)(*listhead); }
      else {thisblock = (FHead*)(thisblock->next);}
    }


  originalsize = thisblock->size;
  nextblocksize = originalsize-size;
  
  /*
  if (nextblocksize < 16){
    nextblocksize = 0;
    size = originalsize;
  }
  */

  removefree(thisblock);

  blockwrite((int *)thisblock,size);

  /* printf("Next bloc of size %i\n",nextblocksize);*/


  freeblockwrite((int *)((int)thisblock + size),nextblocksize);

  /*printf(".");*/

  return ((void *)((int)thisblock + H_SIZE)); 
}

void mm_free (void *ptr)
{
  int size = *((int *)ptr - 1) ^ (1<<31);
  /*    printf("****Freeing block of size:%i\n",size); */

  freeblockwrite((int *)ptr-1,size);
  coup((FHead *)((int)ptr-4));
  codown((FHead *)((int)ptr-4));
  
}

