/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Doctor Gonzo",
    /* First member full name */
    "John Bucy",
    /* First member email address */
    "bucy@gloop.org",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};





int coalesce(void);

struct HEADER {
  /* high-order bit flags whether this is an allocated or free block */
  unsigned int size;

  /* pointer to next free block */
  /* this value is only guaranteed to be good for free blocks */
  struct HEADER *next;
  /* pointer to previous free block */
  struct HEADER *prev;

  /* make it a multiple of 8 bytes */
  char pad[4];
};

/* size of header plus size of footer */
#define HEADERSIZE (sizeof(struct HEADER)) 

/* same semantics of size field of HEADER */
/* typedef unsigned int FOOTER; */


#define NUMFREELISTS 14

struct TABLE {


  /* 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 
     4096, 8192, 16384, 32768, 65536 */

  /* for freeLists[n], the range is 2^(n + 3) <= size < 2^(n + 4) */

  struct HEADER *freeLists[NUMFREELISTS];

  /* roving pointers into variable-length free lists */
  struct HEADER *rovingPointers[NUMFREELISTS];

  struct HEADER *firstBlock;

  /* total size of heap */
  int heapTot;
  /* total amount of memory allocated -- including header overhead */
  int totAlloc;
  unsigned coalCtr;
};

#define Table ((struct TABLE *)dseg_lo)

/* flag on a size field that says whether the block is allocated */
#define ALLOCBIT 0x80000000


int log2(int x) {

  /* one of our favorites from Lab 1... */
  /* return the floor of the log base 2 of the input */

  int middle = 16;

  /* this gets us x - (1 << middle) */
  int arrow = x + (~(1 << middle) + 1);

  /* this makes arrow either -1, 0 or 1 */
  arrow = (arrow >> 31) | (!!arrow) ;

  middle = middle + ((arrow) << 3);


  arrow = x + (~(1 << middle) + 1);
  arrow = (arrow >> 31) | (!!arrow);
  middle = middle + ((arrow) << 2);

  arrow = x + (~(1 << middle) + 1);
  arrow = (arrow >> 31) | (!!arrow);
  middle = middle + ((arrow) << 1);

  arrow = x + (~(1 << middle) + 1);
  arrow = (arrow >> 31) | (!!arrow);
  middle = middle + arrow;

  arrow = x + (~(1 << middle) + 1);
  /* last time through, we need this to be only 0 or -1; since we're getting
     the lower integer bound on the log, we don't want to increment arrow
     here */
  arrow = (arrow >> 31);
  middle = middle + arrow;

  return middle;
}



int mm_init (void)
{
  int c;
  int pad;
  struct HEADER *newblock;

  /* get us some space to put the free-list table into */
  if(!mem_sbrk(mem_pagesize())) {
    return -1;
  }

  for(c = 0; c < NUMFREELISTS; c++) {
    Table->freeLists[c] = 0;
    Table->rovingPointers[c] = 0;
  }

  /* make one block out of what's left of the new page */
  newblock = (struct HEADER *)((int)Table + sizeof(struct TABLE));

  pad = ((int)newblock % 8) == 0 
    ? 0 
    : 8 - ((int)newblock % 8);

  /* align newblock */
  newblock = (struct HEADER *)((unsigned)newblock + pad);
  newblock->size = (struct HEADER*)
    (1 + (unsigned)dseg_hi - (unsigned)newblock - HEADERSIZE);

  newblock->next = 0;
  newblock->prev = 0;

  /* assume that the page size is less than 65536 */
  Table->freeLists[log2(newblock->size) - 3] = newblock;
  Table->rovingPointers[log2(newblock->size) - 3] = newblock;

  Table->firstBlock = newblock;

  Table->heapTot = newblock->size + HEADERSIZE;
  Table->totAlloc = newblock->size + HEADERSIZE;

  Table->coalCtr = 0;

  return 0;
}

void *mm_malloc (size_t size)
{
  int firstpass = 0;
  int pagespace;
  struct HEADER *newblock, *newfrag;

  int index;
  /* round the size to a multiple of 8 */
  size += 
    ((8 - (size & 7)) == 8)
    ? HEADERSIZE % 8 
    : (8 - (size & 7)) + (HEADERSIZE % 8);

 again:

  /* look through the free-lists */
  if(size < 65536) {
    index = log2(size) - 3;
  }
  else {
    index = NUMFREELISTS - 1;
  }

  /* loop over free lists */
  for(index = index; index < NUMFREELISTS; index++) {
    struct HEADER *startPoint, *freelist;

    if(!(Table->freeLists[index])) { continue; }

    /* loop through a particular free-list */
    startPoint = 0;

    /* invariant: Table->rovingPointers[index] == 0 iff
       Table->freeLists[index] == 0 */
    freelist = Table->rovingPointers[index];

    if(!freelist) {
      printf("Error in roving pointer table detected!\n");
      exit(1);
    }

    for(;;) {
      int othersize = size;
      othersize += HEADERSIZE;
      othersize += ((sizeof(struct HEADER) % 8) == 0)
	? 0
	: 8 - (HEADERSIZE % 8);
      othersize += 8;

      /* Sanity Checks... */
      if(!freelist) {
	printf("Error in roving pointer table detected!\n");
	exit(1);
      }

      if(freelist->size & ALLOCBIT) {
	printf("Allocated block found in free list!\n");
	exit(1);
      }

      /* block is exactly the right size */
      if(freelist->size == size) {
	/* mark block as allocated */
	freelist->size |= ALLOCBIT;

	/* splice out block */

	/* block is in middle of free list */
	if((freelist->next) && (freelist->prev)) {
	  freelist->next->prev = freelist->prev;
	  freelist->prev->next = freelist->next;
	  Table->rovingPointers[index] = freelist->next;
	} 
	/* beginning of list */
	else if(freelist->next) {
	  Table->freeLists[index] = freelist->next;
	  freelist->next->prev = 0;
	  Table->rovingPointers[index] = freelist->next;
	}
	/* end of list */
	else if(freelist->prev) {
	  freelist->prev->next = 0;
	  Table->rovingPointers[index] = Table->freeLists[index];
	}
	/* list of one element */
	else {
	  Table->freeLists[index] = 0;
	  Table->rovingPointers[index] = 0;
	}

	Table->totAlloc += size + HEADERSIZE;

	return (char*)((int)freelist + sizeof(struct HEADER));
      }


      /* this size restriction is funny-looking; the point is so that
	 we don't split a block and end up with a 16-byte fragment
	 that is all header and footer and no data */


      else if(freelist->size >= othersize) {
	int origsize;
	struct HEADER *block, *frag;

	block = freelist;
	origsize = block->size & (~ALLOCBIT);
	block->size = size;
	block->size |= ALLOCBIT;
	
	frag = 
	  (struct HEADER *)((unsigned)freelist + HEADERSIZE + size);
	
	frag->size = origsize - HEADERSIZE - size;

	/* probably unnecessary */
	frag->size &= (~ALLOCBIT);


	/* splice block out of freelist and splice frag into freelist */
	/* Frag goes into some other freelist than the one we're in */
	if((log2(frag->size) - 3) != index) {
	  int fragindex;
	  /* splice out frag */
	  /* 4 cases as above */
	  /* middle of list */
	  if(block->prev && block->next) {
	    block->prev->next = block->next;
	    block->next->prev = block->prev;
	    Table->rovingPointers[index] = block->next;
	  }
	  /* end of list */
	  else if(block->prev) {
	    block->prev->next = 0;
	    Table->rovingPointers[index] = Table->freeLists[index];
	  }
	  /* beginning of list */
	  else if(block->next) {
	    block->next->prev = 0;
	    Table->freeLists[index] = block->next;
	    Table->rovingPointers[index] = block->next;
	  }
	  /* list of one element */
	  else {
	    Table->freeLists[index] = 0;
	    Table->rovingPointers[index] = 0;
	  }

	  /* file frag */
	  frag->prev = 0;
	  fragindex = frag->size < 65536 ? log2(frag->size) - 3 : NUMFREELISTS - 1;
	  frag->next = Table->freeLists[fragindex];
	  Table->freeLists[fragindex] = frag;
	  Table->rovingPointers[fragindex] = frag;
	  if(frag->next)
	    frag->next->prev = frag;
	}

	/* frag goes into the current freelist */
	else {
	  /* middle of list */
	  if(block->prev && block->next) {
	    block->prev->next = frag;
	    block->next->prev = frag;
	    frag->prev = block->prev;
	    frag->next = block->next;
	    Table->rovingPointers[index] = frag;
	  }
	  /* end of list */
	  else if(block->prev) {
	    block->prev->next = frag;
	    frag->prev = block->prev;
	    frag->next = 0;
	    Table->rovingPointers[index] = frag;
	  }
	  /* beginning of list */
	  else if(block->next) {
	    frag->prev = 0;
	    frag->next = block->next;
	    Table->freeLists[index] = frag;
	    frag->next->prev = frag;
	    Table->rovingPointers[index] = frag;
	  }
	  /* list of one element */
	  else {
	    Table->freeLists[index] = frag;
	    frag->next = frag->prev = 0;
	    Table->rovingPointers[index] = frag;
	  }
	}
	
	Table->totAlloc += size + HEADERSIZE;
	return (char*)((unsigned)block + sizeof(struct HEADER));
      }
      
      /* could have another case here for block big enough for request
	 but not big enough to fragment ... might help utilization */

      if(freelist->size >= size) {
	/* mark block as allocated */
	freelist->size |= ALLOCBIT;

	/* splice out block */

	/* block is in middle of free list */
	if((freelist->next) && (freelist->prev)) {
	  freelist->next->prev = freelist->prev;
	  freelist->prev->next = freelist->next;
	  Table->rovingPointers[index] = freelist->next;
	} 
	/* beginning of list */
	else if(freelist->next) {
	  Table->freeLists[index] = freelist->next;
	  freelist->next->prev = 0;
	  Table->rovingPointers[index] = freelist->next;
	}
	/* end of list */
	else if(freelist->prev) {
	  freelist->prev->next = 0;
	  Table->rovingPointers[index] = Table->freeLists[index];
	}
	/* list of one element */
	else {
	  Table->freeLists[index] = 0;
	  Table->rovingPointers[index] = 0;
	}

	Table->totAlloc += freelist->size + HEADERSIZE;
	return (char*)((int)freelist + sizeof(struct HEADER));
      }

      else {
	if(!startPoint) {
	  startPoint = freelist;
	}

	freelist = freelist->next;
	if(!freelist) freelist = Table->freeLists[index];

	if(startPoint == freelist) {
	  break;
	}
      }
    } /* loop through a free list */

  } /* loop over free lists */
  



  /*   uh-oh...we couldn't find a free block in any of the free lists */
  if(!firstpass) {
    firstpass++;
    if(((Table->heapTot - Table->totAlloc) >= size)) 
      if((Table->coalCtr++ % 100) == 0) {
	if(coalesce()) goto again;
      }
  }


  /*   still none: 
       get a new page, break off a piece to service the request, 
       file the rest */
  
  if((size + HEADERSIZE) <= mem_pagesize()) {
    pagespace = mem_pagesize();
  }
  else {
    pagespace = (((size + HEADERSIZE) / mem_pagesize()) + 1) * mem_pagesize();
  }
  newblock = (struct HEADER*)mem_sbrk(pagespace);
  if(!newblock) return newblock;
  
  Table->heapTot += pagespace;

  /* don't create a fragment if there is not enough extra space to
     do it with */
  if(pagespace >= (size + 2*HEADERSIZE + 8)) {
    Table->totAlloc += size + HEADERSIZE;
    newblock->size = size;
    newblock->size |= ALLOCBIT;


    newfrag = (struct HEADER *)((int)newblock + size + HEADERSIZE);
    newfrag->size = 1 + (unsigned)dseg_hi - (unsigned)newfrag - HEADERSIZE;
    newfrag->size &= (~ALLOCBIT);

    index = newfrag->size < 65536 ? log2(newfrag->size) - 3 : NUMFREELISTS - 1;
  
    newfrag->prev = 0;
    newfrag->next = Table->freeLists[index];
    Table->freeLists[index] = newfrag;
    Table->rovingPointers[index] = newfrag;
    if(newfrag->next)
      newfrag->next->prev = newfrag;
  }
  else {
    Table->totAlloc += pagespace;
    newblock->size = pagespace - HEADERSIZE;
    newblock->size |= ALLOCBIT;
  }

  return (char*)((unsigned)newblock + sizeof(struct HEADER));
}

void mm_free (void *ptr)
{
  struct HEADER *block;
  int index;

  /* get the start of the header */
  block = (struct HEADER *)((unsigned)ptr - sizeof(struct HEADER));

  /* flip off the allocated flag */
  block->size &= (~ALLOCBIT);
  if(block->size < 65536) 
    index = log2(block->size) - 3;
  else
    index = NUMFREELISTS - 1;

  Table->totAlloc -= (block->size + HEADERSIZE);

  block->prev = 0;
  block->next = Table->freeLists[index];
  Table->freeLists[index] = block;
  if(block->next)
    block->next->prev = block;
  Table->rovingPointers[index] = block;
}
 

/* go through the whole heap and coalesce the free blocks together */
/* returns 0 if no coalescing was performed, nonzero otherwise */
int coalesce(void) {
  int success = 0;
  struct HEADER *ptr = Table->firstBlock;
  struct HEADER *ptr2;
  int index;

  /* loop through the whole heap */
  for(;;) {

    /* skip over the allocated blocks */
    while(((unsigned)ptr < (unsigned)dseg_hi) 
	  && (ALLOCBIT & ptr->size)) 
      {
	ptr = (struct HEADER *)((unsigned)ptr + 
				(ptr->size & (~ALLOCBIT)) + HEADERSIZE);
      }

    if((unsigned)ptr >= (unsigned)dseg_hi) return success;
    
    /* look at the next block after ptr */
    ptr2 = (struct HEADER*)((unsigned)ptr + 
			    (ptr->size & (~ALLOCBIT)) + HEADERSIZE);

    if((unsigned)ptr2 >= (unsigned)dseg_hi) return success;

    /* if the next block is allocated, there's nothing to do */
    if(ptr2->size & ALLOCBIT) {
      ptr = ptr2;
      continue;
    }

    /* ok...we have at least 2 consecutive free blocks ... proceed with
       coalescing */

    /* splice out ptr from whichever free list */

    if(ptr->size < 65536) index = log2(ptr->size) - 3;
    else index = NUMFREELISTS - 1;

    if(ptr->next && ptr->prev) {
      ptr->next->prev = ptr->prev;
      ptr->prev->next = ptr->next;
      Table->rovingPointers[index] = ptr->next;
    }
    else if(ptr->next) {
      Table->freeLists[index] = ptr->next;
      ptr->next->prev = 0;
      Table->rovingPointers[index] = ptr->next;
    }
    else if(ptr->prev) {
      ptr->prev->next = 0;
      Table->rovingPointers[index] = Table->freeLists[index];
    }
    else {
      Table->rovingPointers[index] = 0;
      Table->freeLists[index] = 0;
    }

    /* loop over the consecutive free blocks */      
    while(((unsigned)ptr2 < (unsigned)dseg_hi) && !(ptr2->size & ALLOCBIT)) {

      if(ptr2->size < 65536) 
	index = log2(ptr2->size) - 3;
      else
	index = NUMFREELISTS - 1;

      /* splice each block out of the free list */
      if(ptr2->next && ptr2->prev) {
	ptr2->next->prev = ptr2->prev;
	ptr2->prev->next = ptr2->next;
	Table->rovingPointers[index] = ptr2->next;
      }
      else if(ptr2->next) {
	Table->freeLists[index] = ptr2->next;
	ptr2->next->prev = 0;
	Table->rovingPointers[index] = ptr2->next;
      }
      else if(ptr2->prev) {
	ptr2->prev->next = 0;
	Table->rovingPointers[index] = Table->freeLists[index];
      }
      else {
	Table->rovingPointers[index] = 0;
	Table->freeLists[index] = 0;
      }

      ptr2 = (struct HEADER *)
	((unsigned)ptr2 + (ptr2->size & (~ALLOCBIT)) + HEADERSIZE);
    }

    /* ptr is pointing to the first free block */
    /* ptr2 is pointing to the first allocated block after this run of
       free blocks */ 

    ptr->size = (struct HEADER *)((unsigned)ptr2 - (unsigned)ptr - HEADERSIZE);
    ptr->size &= (~ALLOCBIT);

    if(ptr->size < 65536)
      index = log2(ptr->size) - 3;
    else
      index = NUMFREELISTS - 1;

    /* file the coalesced block */    
    ptr->prev = 0;
    ptr->next = Table->freeLists[index];
    Table->freeLists[index] = ptr;
    Table->rovingPointers[index] = ptr;
    if(ptr->next)
      ptr->next->prev = ptr;
    
    success++;

    ptr = (struct HEADER*)((unsigned)ptr2 + ptr2->size + HEADERSIZE);
  }
  return success;
}


