/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "McGuire & Yang",
    /* First member full name */
    "Adam McGuire",
    /* First member email address */
    "amcguire",
    /* Second member full name (leave blank if none) */
    "Yueh-Huan Yang",
    /* Second member email address (blank if none) */
    "yuehhuan"
};

typedef unsigned long word;

#define HEAP ((word*)(dseg_lo))

/* constants used for repettitive small malloc optimization (RSMO) */

#define RSMO

#define SMALL_MALLOC_SIZE           96
#define SMALL_MALLOC_DUP_THRESHOLD  10 /* 40 */
#define SMALL_MALLOC_DUP_NUM        10 /* 40 */

#define SMALL_MALLOC_GROWTH_RATE    3
#define SMALL_MALLOC_AGE_RATE       1

#define BLOCK_SIZE(block) (((word*)(block))[0] & 0xFFFFFFFE)
#define BLOCK_ALLOCD(block) (((word*)(block))[0] & 0x00000001)

inline static void set_heap_end(word* heap_end)
{

  HEAP[8 + 16] = (word)(heap_end);

}

inline static word* get_heap_end()
{

  return (word*)(HEAP[8 + 16]);

}

static word* expand_heap(int num_words)
{

  size_t heap_leftover = (int)(dseg_hi) - (int)(get_heap_end()) + 1;
  int num_pages = (num_words * 4 - heap_leftover + mem_pagesize() - 1) / mem_pagesize(); 
  /* return (word*)(mem_sbrk(mem_pagesize() * num_pages)); */
  return (word*)(mem_sbrk(num_words * 4 - heap_leftover));

}

/*

  Fast integer (floored) log base 2 courtesy of Lab 1

*/

inline static int log_2(int x)
{

  int a;
  int v;

  /* binary search to find the most significant 1 in the bits of x */

  a = (!!(x & 0xFFFF0000)) << 4;
  x = (x >> a) & 0x0000FFFF;

  v = (!!(x & 0x0000FF00)) << 3;
  x = (x >> v) & 0xFF;
  a = a + v;

  v = (!!(x & 0xF0)) << 2;
  x = (x >> v) & 0xF;
  a = a + v;

  v = (!!(x & 0xC)) << 1;
  x = (x >> v) & 0x3;
  a = a + v;

  v = !!(x & 0x2);
  return a + v;

}

/*

  Computes the index of the free list in which a free block of block_size should
  be stored

*/


inline static int get_free_list_index(size_t block_size)
{

  size_t size = (block_size - 2) * 4;

  /* logarithmic distribution */

  if (size >= 512) {
    return 7;
  } else {
    return log_2(size / 2);
  }

}

/*

  Creates a "free" block of block_size words starting at address block and adds it
  to the beginning of the appropriate free list

*/

static void create_free_block(word* block, size_t block_size)
{

  int free_list_index = get_free_list_index(block_size);
  word* head_block = (word*)(HEAP[free_list_index]);

  block[0] = block_size & 0xFFFFFFFE;
  block[1] = 0;

  block[block_size - 2] = (word)(head_block);
  block[block_size - 1] = block[0];

  if (head_block) {
    head_block[1] = (word)(block);
  }

  HEAP[free_list_index] = (word)(block);
  
}

/*

  Creates an "allocated" block of block_size words starting at address block

*/

static void create_alloc_block(word* block, size_t block_size)
{

  block[0] = block_size | 0x00000001;
  block[block_size - 1] = block[0];

}

/*

  Removes a block from a specified free list

*/

static void unfree_block(word* block, int free_list_index)
{

  size_t block_size = block[0] & 0xFFFFFFFE;

  word* prev_block = (word*)(block[1]);
  word* next_block = (word*)(block[block_size - 2]);

  /* update the pointers for the previous block in the free list */

  if (prev_block) {

    size_t prev_block_size = prev_block[0] & 0xFFFFFFFE;
    prev_block[prev_block_size - 2] = (word)(next_block);

  } else {

    HEAP[free_list_index] = (word)(next_block);    

  }

  /* update the pointers for the next block in the free list */

  if (next_block) {
    next_block[1] = (word)(prev_block);
  }

}

int mm_init()
{

  int index;

  /* initially make our heap one page */

  if (!(mem_sbrk(mem_pagesize()))) {
    return 0;
  }

  /* intialize the free list table */

  for (index = 0; index < 8; index++) {
    HEAP[index] = 0;
  }
  
  /* initialize the small malloc history table */
 
  for (index = 0; index < 16; index++) {
    HEAP[index + 8] = 0;
  }

  set_heap_end(HEAP + 8 + 16 + 1);
  return -1;

}

void* mm_malloc(size_t size)
{

  /* note block_size and new_block_size are always the number of _words_
     for the entire block (including header and footer) */

  size_t new_block_size = 2 * ((size + 7) / 8) + 2;
  word* new_block = 0;

  size_t block_size;
  word* block;

  size_t best_block_size;
  word* best_block;
  
  int free_list_index = get_free_list_index(new_block_size);
  int index;
 
  #ifdef RSMO

  /* update the small malloc history */

  if (size < SMALL_MALLOC_SIZE) {

    index = size / (SMALL_MALLOC_SIZE / 16);
    HEAP[8 + index] += SMALL_MALLOC_GROWTH_RATE;

    if (HEAP[8 + index] > SMALL_MALLOC_DUP_THRESHOLD) {

      size_t heap_leftover = (int)(dseg_hi) - (int)(get_heap_end()) + 1; 
      HEAP[8 + index] = SMALL_MALLOC_AGE_RATE;
  
      block_size = 2 * (((index + 1) * (SMALL_MALLOC_SIZE / 16) + 7) / 8) + 2;
      block = get_heap_end();
  
      if (heap_leftover / 4 < block_size * SMALL_MALLOC_DUP_NUM) {

        /* allocate additional pages */

        if (!expand_heap(block_size * SMALL_MALLOC_DUP_NUM)) {
          block = 0;
	} else {
          block = get_heap_end();
	}

      }

      if (block) {

        /* create a bunch of free blocks the same size we are allocating so that 
           future allocations of the same size will end up close to each other  */

        for (index = 0; index < SMALL_MALLOC_DUP_NUM; index++) {
          create_free_block(block + index * block_size, block_size);
        }

        set_heap_end(block + block_size * SMALL_MALLOC_DUP_NUM);

      }

    }

  }

  /* "age" the small malloc history */

  for (index = 0; index < 16; index++) {
    if (HEAP[8 + index] > 0) HEAP[8 + index] -= SMALL_MALLOC_AGE_RATE;
  }

  #endif

  /* search the free lists for a best fit block big enough for our new block */

  for (index = free_list_index; index < 8; index++) {

    block = (word*)(HEAP[index]);

    best_block = 0;
    best_block_size = -1;

    while (block) {

      block_size = BLOCK_SIZE(block);

      if (block_size >= new_block_size) {

        if (block_size < best_block_size) {
          best_block = block;
          best_block_size = block_size;
        }

      }

      block = (word*)(block[block_size - 2]);

    }  

    if (best_block) {

      unfree_block(best_block, index);
      new_block = best_block;

      if (best_block_size - new_block_size >= 4) {
 
        /* we need to split the block */

        create_alloc_block(new_block, new_block_size);
        create_free_block(new_block + new_block_size, best_block_size - new_block_size);     
  
      } else {
  
        /* we use the entire block */

        create_alloc_block(new_block, best_block_size);

      }

      break;

    }

  }

  if (new_block == 0) {
   
    /* compute the number of bytes left in the heap we have allocated */ 

    size_t heap_leftover = (int)(dseg_hi) - (int)(get_heap_end()) + 1;

    if (heap_leftover / 4 < new_block_size) {

      /* allocate additional pages */

      if (!expand_heap(new_block_size)) {
        return 0;
      }

    }

    new_block = get_heap_end();
    
    create_alloc_block(new_block, new_block_size);
    set_heap_end(new_block + new_block_size);

  }

  return new_block + 1;

}

void mm_free(void* pointer)
{

  word* block = (word*)(pointer) - 1;

  int prev_block_free;
  int next_block_free;  

  word* prev_block = block - BLOCK_SIZE(block - 1);
  word* next_block = block + BLOCK_SIZE(block);

  size_t prev_block_size;
  size_t next_block_size;
  size_t block_size;

  block_size = BLOCK_SIZE(block);

  if (block <= HEAP + 8 + 16 + 2) {
    prev_block_free = 0;
  } else {
    prev_block_free = !BLOCK_ALLOCD(prev_block);
    prev_block_size = BLOCK_SIZE(prev_block);
  }

  if (next_block >= get_heap_end()) {
    next_block_free = 0;
  } else {
    next_block_free = !BLOCK_ALLOCD(next_block);
    next_block_size = BLOCK_SIZE(next_block);
  }

  if (!prev_block_free) {

    if (!next_block_free) {

     /* coalescing case 1 */ 
     create_free_block(block, block_size);

    } else {

      /* coalescing case 2 */
      unfree_block(next_block, get_free_list_index(next_block_size));
      create_free_block(block, block_size + next_block_size);

    }
 
  } else {

    unfree_block(prev_block, get_free_list_index(prev_block_size));

    if (!next_block_free) {
 
      /* coalescing case 3 */
      create_free_block(prev_block, prev_block_size + block_size);

    } else {

      /* coalescing case 4 */
      unfree_block(next_block, get_free_list_index(next_block_size));
      create_free_block(prev_block, prev_block_size + block_size + next_block_size);

    }

  }

}

/* 97.532 best */
