/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "McGuire & Yang",
    /* First member full name */
    "Adam McGuire",
    /* First member email address */
    "amcguire",
    /* Second member full name (leave blank if none) */
    "Yueh-Huan Yang",
    /* Second member email address (blank if none) */
    "yuehhuan"
};

typedef unsigned long word;

#define HEAP ((word*)(dseg_lo))

static word* expand_heap(int num_pages)
{

  return (word*)(mem_sbrk(mem_pagesize() * num_pages));  

}

static void set_heap_end(word* heap_end)
{

  HEAP[32] = (word)(heap_end);

}

static word* get_heap_end()
{

  return (word*)(HEAP[32]);

}

static int log_2(int x)
{

  int a;
  int v;

  /* binary search to find the most significant 1 in the bits of x */

  a = (!!(x & 0xFFFF0000)) << 4;
  x = (x >> a) & 0x0000FFFF;

  v = (!!(x & 0x0000FF00)) << 3;
  x = (x >> v) & 0xFF;
  a = a + v;

  v = (!!(x & 0xF0)) << 2;
  x = (x >> v) & 0xF;
  a = a + v;

  v = (!!(x & 0xC)) << 1;
  x = (x >> v) & 0x3;
  a = a + v;

  v = !!(x & 0x2);
  return a + v;


}

static int get_free_list_index(size_t block_size)
{

  size_t size = (block_size - 2) * 4;

  /* logarithmic distribution */
  return log_2(size);

}

static void create_free_block(word* block, size_t block_size)
{

  int free_list_index = get_free_list_index(block_size);
  word* head_block = (word*)(HEAP[free_list_index]);

  block[0] = block_size & 0xFFFFFFFE;
  block[1] = 0;

  block[block_size - 2] = (word)(head_block);
  block[block_size - 1] = block[0];

  if (head_block) {
    head_block[1] = (word)(block);
  }

  HEAP[free_list_index] = (word)(block);
  
}

static void create_alloc_block(word* block, size_t block_size)
{

  block[0] = block_size | 0x00000001;
  block[block_size - 1] = block[0];

}

static void unfree_block(word* block, int free_list_index)
{

  size_t block_size = block[0] & 0xFFFFFFFE;

  word* prev_block = (word*)(block[1]);
  word* next_block = (word*)(block[block_size - 2]);

  /* update the pointers for the previous block in the free list */

  if (prev_block) {

    size_t prev_block_size = prev_block[0] & 0xFFFFFFFE;
    prev_block[prev_block_size - 2] = (word)(next_block);

  } else {

    HEAP[free_list_index] = (word)(next_block);    

  }

  /* update the pointers for the next block in the free list */

  if (next_block) {

    next_block[1] = (word)(prev_block);

  }

}

static void print_free_lists()
{

  int index;

  for (index = 0; index < 32; index++) {

    word* block;

    printf("  free_list[%d]\t", index);

    block = (word*)(HEAP[index]);

    while (block) {

      size_t block_size = block[0] & 0xFFFFFFFE;
   
      printf("[%d]", block_size);
      block = (word*)(block[block_size - 2]);

      if (block) printf("->");

    }

    printf("\n");

  }

}

static void print_memory_map()
{

  word* block = HEAP + 33;
  size_t total_size = 0;

  while (block < get_heap_end()) {

    size_t block_size = block[0] & 0xFFFFFFFE;

    if (block[0] & 0x00000001) {
      printf("%p [%d]\n", block, block_size);
    } else {
      printf("%p (%d)\n", block, block_size);
    }

    block += block_size;
    total_size += block_size;

  }

  printf(" total = %d words\n", total_size);

}

int mm_init()
{

  int index;

  /* initially make our heap one page */

  if (!expand_heap(1)) {
    return 0;
  }

  /* intialize the free list table */

  for (index = 0; index < 32; index++) {
    HEAP[index] = 0;
  }
  
  /* make a big free block out of the rest of the page and update the heap end */

  create_free_block(HEAP + 33, mem_pagesize() / 4 - 1 - 33); 
  set_heap_end(HEAP + mem_pagesize() / 4 - 1);

  return -1;

}

void* mm_malloc(size_t size)
{

  size_t new_block_size = 2 * ((size + 7) / 8) + 2;
  word* new_block = 0;

  size_t block_size;
  word* block;

  size_t best_block_size;
  word* best_block;
  
  int free_list_index = get_free_list_index(new_block_size);
  int index;

  /* search the free lists (bigger than our block) for a block big enough for our new block */

  for (index = free_list_index; index < 32; index++) {

    block = (word*)(HEAP[index]);

    best_block = 0;
    best_block_size = -1;

    while (block) {

      block_size = block[0] & 0xFFFFFFFE;

      if (block_size >= new_block_size) {

        if (block_size < best_block_size) {
          best_block = block;
          best_block_size = block_size;
        }

      }

      block = (word*)(block[block_size - 2]);

    }  

    if (best_block) {

      unfree_block(best_block, index);
      new_block = best_block;

      if (best_block_size - new_block_size > 4) {
 
        /* we need to split the block */

        create_alloc_block(new_block, new_block_size);
        create_free_block(new_block + new_block_size, best_block_size - new_block_size);     
  
      } else {
  
        /* we use the entire block */

        create_alloc_block(new_block, best_block_size);

      }

      break;

    }

  }

  if (new_block == 0) {
   
    size_t heap_leftover = (int)(dseg_hi) - (int)(get_heap_end()) + 1;

    if (heap_leftover / 4 >= new_block_size) {

      new_block = get_heap_end();
      create_alloc_block(new_block, new_block_size);
      set_heap_end(new_block + new_block_size);

    } else {

      /* we need to allocate more pages */

      int num_pages = (new_block_size * 4 - heap_leftover + mem_pagesize() - 1) / mem_pagesize();  
 
      new_block = get_heap_end();

      if (!expand_heap(num_pages)) {
        return 0;
      }

      create_alloc_block(new_block, new_block_size);
      set_heap_end(new_block + new_block_size);

    }

  }

  return new_block + 1;

}

void mm_free(void* pointer)
{

  word* block = (word*)(pointer) - 1;

  int prev_block_free;
  int next_block_free;  

  word* prev_block = block - (block[-1] & 0xFFFFFFFE);
  word* next_block = block + (block[0] & 0xFFFFFFFE);

  size_t prev_block_size;
  size_t next_block_size;
  size_t block_size;

  block_size = block[0] & 0xFFFFFFFE;

  if (block == HEAP + 33) {
    prev_block_free = 0;
  } else {
    prev_block_free = !(prev_block[0] & 0x00000001);
    prev_block_size = prev_block[0] & 0xFFFFFFFE;
  }

  if (next_block >= get_heap_end()) {
    next_block_free = 0;
  } else {
    next_block_free = !(next_block[0] & 0x00000001);
    next_block_size = next_block[0] & 0xFFFFFFFE;
  }

  if (!prev_block_free) {

    if (!next_block_free) {

     /* coalescing case 1 */ 
     create_free_block(block, block_size);

    } else {

      /* coalescing case 2 */
      unfree_block(next_block, get_free_list_index(next_block_size));
      create_free_block(block, block_size + next_block_size);

    }
 
  } else {

    unfree_block(prev_block, get_free_list_index(prev_block_size));

    if (!next_block_free) {
 
      /* coalescing case 3 */
      create_free_block(prev_block, prev_block_size + block_size);

    } else {

      /* coalescing case 4 */
      unfree_block(next_block, get_free_list_index(next_block_size));
      create_free_block(prev_block, prev_block_size + block_size + next_block_size);

    }

  }


}
