/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

#define PAGE_POW2 12
#define PAGE_SIZE 4096

#define trunc_to_pow_2(num, pow)((num >> pow) << pow))
#define round_up_to_pow2(num,pow) (((num + ((1 << pow) - 1)) >> pow) << pow)

#define set_block_alloc(size) ((size) | 1)
#define set_prev_block_alloc(size) ((size) | 2)

/*these macros return non-zero if the flags are set and zero otherwise*/
#define block_alloc(size) ((size) & 1)
#define prev_block_alloc(size) ((size) & 2)

#define zero_flags(size) ((size) & -4)
#define zero_block_alloc(size) ((size) & -2)
#define zero_prev_block_alloc(size) ((size) & -3)
#define word_up(ptr) ((ptr) + 1)
#define word_down(ptr) ((ptr) - 1)
#define ptr_to_next_block(ptr) ((ptr) + (*(ptr) >> 2))
/*note that this _only_ works if the previous block is free*/
#define ptr_to_prev_block(ptr) ((ptr) - (*(word_down(ptr)) >> 2))
#define ptr_to_footer(ptr) (word_down(ptr_to_next_block(ptr)))

team_t team = {
/* Team name to be displayed on webpage */
"free(beer)",
  /* First member full name */
  "Allison Bruce",
  /* First member email address */
  "abruce@andrew.cmu.edu",
  /* Second member full name (leave blank if none) */
  "",
  /* Second member email address (blank if none) */
  ""
};




int alloc_page(unsigned int *last_block,  unsigned int size) {
unsigned int *start, *set, *new, *end;
unsigned int allocate_bytes;


allocate_bytes = round_up_to_pow2(size,PAGE_POW2);

new = mem_sbrk(allocate_bytes);

start = (unsigned int *) dseg_lo;
end = word_up(start);
*end =   (unsigned int) (dseg_hi - 11);
*last_block = allocate_bytes + prev_block_alloc(*last_block);
set = ptr_to_footer(last_block);
*set = *last_block;
set = (unsigned int *) *end;
*set = 0;
if (new != NULL)
     return 0;
     else 
     return 1;
}



void add_block(unsigned int *p, unsigned int length) {
/*round up to nearest eight_byte alignment*/
int newsize, oldsize, splitsize;
int *nextp;

newsize =  round_up_to_pow2(length,3);
/*zero out two lowest order bits*/
oldsize = zero_flags(*p);

*p = set_block_alloc(newsize)+ prev_block_alloc(*p);

/*step past the newly added block */
nextp = ptr_to_next_block(p);

splitsize = oldsize - newsize;
if(splitsize > 0) { 

*nextp = set_prev_block_alloc(splitsize);

/*step to the end of the block*/
nextp = ptr_to_footer(nextp);
*nextp = splitsize;

}
else {
/*set the bit in the next block that says this block is in use*/
*nextp = set_prev_block_alloc(*nextp);
}

}

int mm_init (void)
{
unsigned int  *set, *start, *end;
char *new = NULL;


if ((mem_usage()) == -1) {
new = (char *) mem_sbrk(PAGE_SIZE);
} else
new =  dseg_lo;
start = (unsigned int *) dseg_lo;
end = start + 1;
*end =   (unsigned int) (dseg_hi - 11);
*start = (unsigned int) (dseg_lo + 12);
set = (int *) *end;
*set = 0;
set = (int *) *start;
*set = set_prev_block_alloc(*end - *start);

if (new != NULL)
     return 0;
     else
     return -1;
}

void *mm_malloc (size_t size)
{
  unsigned int *start;
  unsigned int *p, *end;
  unsigned int done = 0;
  
  start = (unsigned int*) dseg_lo;
  p = (unsigned int *) *start;
  end = (unsigned int *) *(start + 1);
  
  /*add the header length  to size*/
  size = size + 4;
  
  while(!done) { 
    if (p >= end) {
      done = alloc_page(p, size);     
      end = (unsigned int *) *(start + 1);
    }
    
    if (block_alloc(*p)  || (zero_flags(*p) < size))
      p = ptr_to_next_block(p);
    else
      break;
  }
  if (done) {
    /*    printf("ran out of memory\n");*/
    return NULL;
  }
  else {
    add_block( p, (unsigned int) size);
    return (p + 1);
  }
}

void mm_free (void *ptr)
{
  unsigned int *next, *last,*p;
  unsigned int choice;

  p = (unsigned int *) ptr;
  p = word_down(p);
  next = ptr_to_next_block(p);


  

  choice = prev_block_alloc(*p) + block_alloc(*next);
   
 
  switch (choice) {

  case 3:
    /* No Coalesce */
    *p = zero_block_alloc(*p);
    last = word_down(next);
    *last = *p;
    *next = zero_prev_block_alloc(*next);
    break;
    
  case 2:
    /* Coalesce w/ Next */
    *p = zero_block_alloc((*p + zero_flags(*next)));
    next = ptr_to_footer(next);
    *next = *p;
    break;
  case 1:
    /* Coalesce w/ Previous*/
    *next = zero_prev_block_alloc(*next);
    next = p;
    p = ptr_to_prev_block(p);
    *p = *p + zero_flags(*next);
    next = ptr_to_footer(next);
    *next = *p;
    break;
  case 0:
    /* Coalesce both Next and Previous */
    next = ptr_to_footer(next);
    *next = (zero_flags(*next) + zero_flags(*p));
    last = word_down(p);
    p = ptr_to_prev_block(p);
    *p = *last + *next;
    *next = *p;
    break;
  default:
    printf("ERROR\n");
    *p = zero_block_alloc(*p);
    last = word_down(next);
    *last = *p;
    *next = zero_prev_block_alloc(*next);
    break;
  }

}

