/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>
#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "greeberx",
    /* First member full name */
    "Attila Bergou",
    /* First member email address */
    "abergou",
    /* Second member full name (leave blank if none) */
    "Robert Rost",
    /* Second member email address (blank if none) */
    "rrost"
};
/*********************************************************
The first 96 bytes of the memory block that is going to be
allocated out is an array of pointers.  Each pointer is the
beginning of a linked list, thus the method that I implemented
was the method of segregated free lists.  The index of the
array is calculated by the function cal_index:  for sizes
less than 128 it is simply the size divided by 8.  For sizes
greater than 128 it is the log base 2 of the size (where sizes
are the sizes requested by the outside program).  In the
beginning of the program the different sizes of the POINTERS
and INTEGERS are defined.  They were initially defined using
sizeof (as can be seen commented out but were a lot faster to
define using the actual number.  To make the code portable to
other architectures the size of simply has to be uncommented.
This will somewhat slow the program down though.  NORM is a
very simple finction which calculates the NORMalized size of the
stored object.  It is intended to be used on the headers to
mask out the last two bits which are used as flags.
*********************************************************/
#define INT_SIZE     4/*sizeof(int)*/
#define POINTER_SIZE 4/*sizeof(int *)*/
#define ALIGNMENT    8
#define NORM(x)      (x&(~3))
/*********************************************************
The function pads a number so that the next pointer and header
are aligned to the right address to be returned.
*********************************************************/
int align_num(int num)
{
  int k = num%ALIGNMENT;

  if(k<=INT_SIZE)
    return num-k+INT_SIZE;

  return num-k+INT_SIZE+ALIGNMENT;
}
/*********************************************************
aligns the pointer to the right position.  This is only used
in mm_init and even there it can be discarded since the page
is going to be aligned for us and is only here for portability.
*********************************************************/
void *align_ptr(void *ptr)
{
  long k = ((long)ptr)%ALIGNMENT;

  if (k <= INT_SIZE)
    return (void *)((long)ptr-k+INT_SIZE);

  return (void *)((long)ptr-k+INT_SIZE)+ALIGNMENT;
}
/*********************************************************
marks the flag of the node as being free and copies its size into
the final block of memory that the segment has. Also marks the
flag of the header of the next segment saying that the 
previous one is free.
*********************************************************/
void mark_free(int *ptr)
{
  int size;

  size = *ptr = *ptr|1;
  ptr = (int *)((char *)ptr+NORM(size));
  *ptr = size; ptr++;
  *ptr = *ptr|2;

  return;
}
/*********************************************************
does the same things as above except marks the flags as used
not free.
*********************************************************/
void mark_used(int *ptr)
{
  int size;

  size = *ptr = *ptr&(~1);
  ptr++; ptr = (int *)((char *)ptr+NORM(size));
  *ptr = *ptr&(~2);

  return;
}
/*********************************************************
Function was described above already it simply calculates
the index in the array that the node should be stored at.
*********************************************************/
int cal_index (int x)
{
  int answer, temp;

  if(x>=65536)
    return 23;
  if(x<=16)
    return 0;
  if(x<128)
    return (x>>3)-2;

  /*take the logarithm of a number < 16 bits*/
  answer= temp = (!!(x>>8))<<3;
  x = x>>temp;
  temp = (!!(x>>4))<<2;
  answer+=temp;
  x=x>>temp;
  temp = (!!(x>>2))<<1;
  answer+=temp;
  x=x>>temp;
  temp = !!(x>>1);
  answer+=temp+(!!(x)>>1);
  
  return answer+7;
}
/*********************************************************
Inserts a memory segment into the linked list.
*********************************************************/
void insert (int *ptr)
{
  int **array, **next, **prev, index, size, *behind, *ahead;

  size = NORM(*ptr);
  mark_free(ptr);
  array = (int **)dseg_lo;
  index = cal_index(size);
  next = (int **)(ptr+1);
  prev = (int **)(next+1);
  behind = array[index];

  if(behind && (size>NORM(*behind))){
    ahead = *((int **)(behind+1));
    
    while(ahead && (size>NORM(*ahead))){
      behind = ahead;
      ahead =*((int **)(ahead+1));
    }
	  
    *prev = behind;
    *next = ahead;

    next = (int **)(behind+1);
    *next = ptr;

    if(ahead){
      prev = (int **)((int **)(ahead+1)+1);
      *prev = ptr;
    }
      
  }
  else{
    *prev = NULL;
    *next = behind;
    if(behind){
      prev = (int **)((int **)(behind+1)+1);
      *prev = ptr;
    }
    array[index] = ptr;
  }

  return;
}
/*********************************************************
Deletes a memory segment from the linked list.
*********************************************************/
void remove_link (int *ptr)
{
  int *prev, *next, **prev_next, **next_prev, index, **array;

  next = *((int **)(ptr+1));
  prev = *((int **)(ptr+2));

  if(prev){
    prev_next = (int **)(prev+1);
    *prev_next = next;
  }
  else{
    array = (int **)dseg_lo;
    index = cal_index(NORM(*ptr));
    array[index] = next;
  }
  if(next){
    next_prev = (int**)((int **)(next+1)+1);
    *next_prev = prev;
  }

  return;
}
/*********************************************************
Coealesces the memory upwards (sees if the previous block is
free and combines two).
*********************************************************/ 
void *coalesc_up(int *ptr)
{
  int *next, size, next_size;
  char *tracker;

  size = NORM(*ptr);
  tracker = (char *)(ptr+1)+size;
  
  next = (int *)tracker;
  next_size = *next;
  
  if(next_size&1){
    next_size = NORM(next_size);
    tracker = tracker+next_size;
    remove_link(next);
    *ptr = size = size+next_size+INT_SIZE;
    *((int *)tracker) = size;
  }

  return ptr;
}
/*********************************************************
Same thing as above except Coalesces down.
*********************************************************/
void *coalesc_down(int *ptr)
{
  int *prev, size, prev_size, prev_free;
  char *tracker;

  size = *ptr;
  prev_free = size&2;
  size = NORM(size);
  
  if(prev_free){
    tracker = (char *)(ptr-1);
    prev_size = NORM(*((int *)tracker));
    tracker = tracker-prev_size;
    prev = (int *)tracker;
    remove_link(prev);
    ptr = (int *)tracker;
    *ptr=size=size+prev_size+INT_SIZE;
    tracker=tracker+size;
    *((int *)tracker)=size;
  }

  return ptr;
}
/*********************************************************
Calls the two types of Coalesce functions when appropriate.
*********************************************************/
void *coalesc(int *ptr)
{
  int size;
  size = NORM(*ptr);

  if(((char *)ptr+size)<(dseg_hi-INT_SIZE*2))
    ptr = coalesc_up(ptr);
  if(((char *)ptr)>(dseg_lo+POINTER_SIZE*24+INT_SIZE))
    ptr = coalesc_down(ptr);

  return ptr;
}
/*********************************************************
splits a memory segment (if it is large enough to be split
without losing any memory) into a used part and a free part.
*********************************************************/
void split (int *ptr, int size)
{
  int *ptr_temp, calc_size;
  
  calc_size = NORM(*ptr);
  
  if(calc_size - size >= 12){
    *ptr = size|(*ptr&2);
    ptr_temp = ptr;
    ptr++;
    ptr = (int *)(((char *)ptr)+size);
    *ptr = calc_size-size-INT_SIZE;
    mark_used(ptr_temp);
    ptr = coalesc(ptr);
    insert(ptr);
  }
  else mark_used(ptr);

  return;
}
/*********************************************************
Initializes the heap and builds the array.
*********************************************************/
int mm_init (void)
{
  int **ptr, *remain, req, i;
  
  req = mem_pagesize()*2;
  ptr = mem_sbrk(req);
  
  for(i=0; i<24; i++){
    *ptr = NULL;
    ptr++;
  }
  
  remain = (int *)((dseg_hi+1)-INT_SIZE);
  *remain = 0;
  
  /*ptr = align_ptr(ptr);*/
  ptr++;
  remain = (int *)ptr;
  /**remain = 8084;*/*remain = dseg_hi-(char *)ptr+1-INT_SIZE*2;

  insert(remain);

  return 0;
}
/*********************************************************
The main body of the malloc.  This is what the program calls.
*********************************************************/
void *mm_malloc (size_t size)
{
  int **array = (int **)dseg_lo, index, *ptr, req;
  void *answer;

  if(size<=12) size = 12;
  else size=align_num(size);
  
  index=cal_index(size);

  while(index<24){
    ptr=array[index];
    while(ptr){
      if((*ptr)>size){
	remove_link(ptr);
	split(ptr, size);
	answer=ptr+1;
	return answer;
      }
      else ptr=*((int **)(ptr+1));
    }
    index++;
  }

  /* This means that whatever memory we had was not enough
     and that we have to request a new block */
  req = mem_pagesize();
  req = req*((size+INT_SIZE)/req+!!((size+INT_SIZE)%req));

  ptr = mem_sbrk(req);

  if(!ptr) return NULL; /*Out of memory*/

  ptr--; *ptr=(dseg_hi-(char*)(ptr+1)+1-INT_SIZE)|(*ptr&2);
  ptr = coalesc(ptr);
  split(ptr, size);

  answer=ptr+1; /*return the right thing*/
  return answer;
}
/*********************************************************
Frees a segment of memory and callc coalesc.  I didn't use
lazy coalescing because the speed improvement didn't make that
much of a difference, but coalescing MAJORLY improves the memory
fragmentation and usage.
*********************************************************/
void mm_free (void *ptr)
{
  int *ptr_calc = (int *)ptr-1; /* access size*/
  ptr_calc = coalesc(ptr_calc);
  insert(ptr_calc);
}
/*********************************************************/
