/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include <string.h> /* memset */

#include "memlib.h"
#include "malloc.h"

/* maxes... could not find the right include for it... dumb */
#define MIN_INT (1 << 31)
#define MAX_INT ((1<<31)-1)

/* dubugging on/off  */
#define DEBUGOFFXXX

/* in multiples of system page size */
#define INITIAL_SIZE 16L

#define INITIAL_SIZE_SPECIAL 2L

/* growth of memory in bytes*/
#define ONE_PAGE 4096L

team_t team = {
    /* Team name to be displayed on webpage */
    "TrinityGoes2Mushroom",
    /* First member full name */
    "Daniel Belov",
    /* First member email address */
    "dbelov",
    /* Second member full name (leave blank if none) */
    "Robert Punkunus",
    /* Second member email address (blank if none) */
    "rp"
};



int mm_init (void)
{
  
  void *heap_start;
  long page_size;
  long i;

  /*    
  page_size = mem_pagesize();

  heap_start = mem_sbrk(INITIAL_SIZE*page_size);

  if(heap_start == NULL)
    return -1;


  ifdef DEBUG
   printf("PAGESIZE: %d, START: %p, USAGE:%d DSEG_HI: %p DSEG_LO: %p\n", 
	  page_size, heap_start, mem_usage(), dseg_hi, dseg_lo);
  endif

  memset(dseg_lo, 0, INITIAL_SIZE*page_size); 

  */

	page_size = mem_pagesize();

	heap_start = mem_sbrk(INITIAL_SIZE_SPECIAL*page_size);

	if(heap_start == NULL)
	  return -1;

        #ifdef DEBUG
           printf("PAGESIZE: %d, START: %p, USAGE:%d DSEG_HI: %p DSEG_LO: %p\n", 
	     page_size, heap_start, mem_usage(), dseg_hi, dseg_lo);
        #endif

        memset(dseg_lo, 0, INITIAL_SIZE_SPECIAL*page_size);

  return 0;
}

void *mm_malloc (size_t size)
{
 long *FreeList, *PreviousList = NULL;
 long *Return, *NewPage;
 long Loops;
 long Increment;
 long i,k;
 long HashIdx;
 unsigned char *Hash;
 void *heap_start;
 long page_size;
 
 #ifdef DEBUG
    printf("MALLOC --> SIZE: %d\n", size);
 #endif


    /* SPECIAL CASE TREATEMENT */
    if(!(*(dseg_lo + 8191)))  /*do speical case*/
      {
	if( (size != 4095) && (size != 8190) )
	  {	    
	     page_size = mem_pagesize();

	     heap_start = mem_sbrk((INITIAL_SIZE-2)*page_size);

	     if(heap_start == NULL)
	       return -1;
	     memset(dseg_lo, 0, INITIAL_SIZE*page_size);
	     
	     *(dseg_lo + 8191) = 1;
	    
	    goto normal;
	  }
	else if((size==4095) && ((*(dseg_lo + 8190)) == 0) )
	  {
	    *(dseg_lo + 8190) = 1;
	    return( (long *) dseg_lo);
	  }
	else if((size==4095) && ((*(dseg_lo + 8190)) == 1) )
	  {
	    return( (long*) (dseg_lo + ONE_PAGE) );
	  }
	else if(size == 8190)
	  {
	    return( (long *) dseg_lo);
	  }
	else /*bad should not get here*/
	  {
	    printf("BOOOOO!!!\n\a");
	    return NULL;
	  }
      }
	

normal:
  if(size <= 8)
    size = 2;
  else
  if(size <= 16)
    size = 3;
  else
  if(size <= 32)
    size = 4;
  else
  if(size <= 64)
    size = 5;
  else
  if(size <= 128)
    size = 6;
  else
  if(size <= 256)
    size = 7;
  else
  if(size <= 512)
    size = 8;
  else
  if(size <= 1024)
    size = 9;
  else
  if(size <= 2048)
    size = 10;
  else
  if(size <= 4096)
    size = 11;
  else
  if(size <= 8192)
    size = 12;
  else
  if(size <= 16384)
    size = 13;
  else
  if(size <= 32768)
    size = 14;
  else
  if(size <= 65536)
    size = 15; 
  else {
    printf("SIZE TOO LARGE !!!\n\a");
    return NULL;
  }

  FreeList = (long *)(dseg_lo + size * 4096L);

 getfreelist:        

  if(*FreeList == 1023)     /*what if Freelist NULL*/
    {      
      PreviousList = FreeList;
      FreeList = *(FreeList + 1023);      /*this is pointer to next free list of this size*/
      
      if(FreeList == NULL) {
	
	#ifdef DEBUG
	    printf("MALLOC --> FREELIST == NULL!\n");
	#endif

       return NULL;
      }

      goto getfreelist;
    }

  #ifdef DEBUG
     printf("MALLOC --> S: %d, FL:%p, IDX:%d\n", size, FreeList, *FreeList);
  #endif

  if(*FreeList == 0)
    {
      /* Need some free pages here buddy! */
      
      if(size > 10)                       /*may not want to leave such large blocks laying around*/
	{                                 /*multipule pages could be wasted*/
	  #ifdef DEBUGXX
            printf("FR>10 : %p, VAL: %d\n", FreeList, *FreeList);
          #endif

	  NewPage = mem_sbrk(ONE_PAGE * (1 << (size - 11)));

	  if(NewPage == NULL)
	    return NULL;	  	  

	    #ifdef DEBUG
	        printf("MALLOC --> : NP: %p\n", 
		                       NewPage);
	    #endif	   

	  i = NewPage;
	  k = dseg_lo;
	  HashIdx = i - k;
	  HashIdx >>= 12;	  

	  Hash = dseg_lo;
	  Hash += HashIdx;
	  *Hash = size;

	  #ifdef DEBUG
	    printf("HIDX: %d HASHTABLE:%p SIZE:%d ADDR:%p\n", HashIdx, Hash, *Hash, NewPage);
          #endif

	  return NewPage;
	} else
	  {
	    #ifdef DEBUGXX
                printf("FR<10 : %p, VAL: %d\n", FreeList, *FreeList);
            #endif
	    
	    NewPage = mem_sbrk(ONE_PAGE);

	    if(NewPage == NULL)
	      return NULL;

	    Increment = 1 << (size + 1);

	    Loops = (4096 / Increment) - 1;
	    
	    *FreeList = Loops;    /*number of entries going into the list*/

	    #ifdef DEBUGXX
	        printf("MALLOC --> LP: %d INCR: %d NP: %p\n", 
		       Loops, Increment, NewPage);
	    #endif

	    Increment >>= 2;

            i = NewPage;
	    k = dseg_lo;
	    HashIdx = i - k;
	    HashIdx >>= 12;

	    for(i = 0; i < Loops; i++)
	      {
		*(FreeList + i + 1) = NewPage;
		
		NewPage = NewPage + Increment;
	      }	      	     

	    Hash = dseg_lo;
            Hash += HashIdx;
	    *Hash = size;
	    
	    #ifdef DEBUG
	       printf("HIDX: %d HASHTABLE: %p SIZE:%d ADRR:%p\n", HashIdx, Hash, *Hash, NewPage);
	    #endif

	    return NewPage;
	  }      
    }else {

      #ifdef DEBUGXX
         printf("FR!=0 : %p, VAL: %d\n", FreeList, *FreeList);
      #endif

      Return = *(FreeList + *FreeList);

      *FreeList = *FreeList - 1;

      if(*FreeList == 0 && PreviousList != NULL)
	{
	  *PreviousList = *PreviousList - 1;
	}

      #ifdef DEBUG
         printf("MALLOC --> RT: %p\n", 
     	       Return);
      #endif      
 
      return Return;
    }
}

void mm_free (void *ptr)
{
 long HashIdx;
 unsigned char *Hash;
 long *FreeList, *Previous;
 long i,k;

 #ifdef DEBUG
   printf("FREE --> %p\n", ptr);
 #endif

 if(!(*(dseg_lo + 8191)))
   {
     return;
   }

 if(ptr < dseg_lo || ptr > dseg_hi)
   return;

 i = dseg_lo;
 k = ptr; 
 
 HashIdx = ptr - i;
 HashIdx >>= 12;

 Hash = dseg_lo;
 Hash += HashIdx;	  

 FreeList = (long *)(dseg_lo + (*Hash) * 4096L);
 
 again:
 
 #ifdef DEBUG
   printf("HIDX: %d %p\n", HashIdx, Hash); 
   printf("FREE --> S: %d, FL: %p, H: %p\n", *Hash, FreeList, Hash);
 #endif

 if(*FreeList == 1023){
   
   Previous = FreeList;

   FreeList = *(FreeList + 1023);

   if(FreeList == NULL) {
     
     FreeList = mem_sbrk(ONE_PAGE);

     *(Previous + 1023) = FreeList;

     *FreeList = 0;
   }

   goto again;

 }else {
    
   *FreeList += 1;
   
   *(FreeList + *FreeList) = ptr;    
 }
}

