/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Palace of Kung-Fu",
    /* First member full name */
    "John Ketchpaw",
    /* First member email address */
    "jsk2",
    /* Second member full name (leave blank if none) */
    "Martin Makowiecki",
    /* Second member email address (blank if none) */
    "martinm"
};

#define uint unsigned int
#define blocksplit 116  //divide the list into two halves...by this value.  


typedef struct block{
  uint size;           // size of data area
  struct block* prev;  // pointer to previous block (in physical memory)
  struct block* left;  // pointer to previous block in list (if block is free)
  struct block* right; // pointer to next block in list (if block is free)
} block;

typedef struct memheader{
  struct block* last; // pointer to block of free memory containing dseg_hi, 
                      // if it exists, otherwise 0.
  struct block* top;  // our list of free memory. (circular)
  struct block* page; // pointer to first free block of memory that is 
                      // greater than blocksplit (cheezy seg.list)
  uint pagesize;      // value gotten from mem_pagesize();
} memheader;


int mm_init ()
{

  block* top;
  memheader* heap;

  heap= (memheader *)dseg_lo;
 
  if (!mem_sbrk(mem_pagesize()))  // grab one page to start with.
    return -1;
 
  // setup pointer to first free block, aligned to eight bytes
  top=heap->top = (block*)(dseg_lo+((sizeof(memheader)+7)&(~7)));

  //setup rest of data
  heap->pagesize=mem_pagesize();
  heap->last=top;  

  if (blocksplit < heap->pagesize)  //setup split pointer accordingly
     heap->page = heap->top;      
  else
    heap->page = NULL;

  // size of _data_ if block were allocated.
  top->size = ((uint)dseg_hi-(uint)top+1)-8;            

  top->right=top->left=top;             // circular linked list
  top->prev = 0;                        // no previous physical block


  return 0;
}

inline int allocated (block* theblock)
{
  return (theblock->size&1);   
}

int increaseheap (uint);
void removenode (block *);
void insertnode (block *, uint, block *);


void *mm_malloc (size_t size)
{
  uint size8;
  block * current;
  memheader * heap;
  block * best;

  size8 = (size+7)&(~7);             //round up to 8 byte increment.  

  heap=(memheader *)dseg_lo;

  current=heap->top;
 
  // list is sorted, so we can jump to the bigger chunks if nessecary
  if (size8 > blocksplit && (heap->page))        
    current = heap->page;

  best=0;


  if (current){        // current might be NULL                                                 
    // find a block. (sorted, so first fit = best fit)
    do
    {
      // this loop attempts to choose the bestfit block that has the most
      // desirable physically previous block (pick the block preceded by an
      // allocate of the same size, if it exists

      if (((current->size) >= size8) 
          && (!best || !current->prev 
              || ( (current->prev->size&(~1))-size8 ==0)) ) {
        best=current;
      }
      current = current->right;
    } while (current != heap->top && (!best || current->size==best->size));
  }

  current=best;
    
  if (current == NULL || current->size < size8) {
    // no block big enough...so we increase the heap.
    //increaseheap also inserts new block into proper location in lists
    if (increaseheap(size8)) {                     
      current=heap->last; 
    } else 
      return NULL;  //heap could not be expanded  
  }

  // current=the block we want to use.  pull it out of the list
  removenode(current);

  // can we split a block off?
  if (((signed)(current->size-size8-8)) >= 8) { 
    //insert new chunk into freelist.
    insertnode((block*)((char*)current+8+size8), 
	       current->size-size8-8,current);    
    //set the last pointer, if appropriate, otherwise, set the prev pointer
    //of the block following it.
    if (current == heap->last)
      heap->last=(block*)((char*)current+8+size8);
    else
      ((block*)((char*)current+current->size+8))->prev
        =(block*)((char*)current+8+size8);
    //reduce our size appropriately.
    current->size = size8;
  } 
  
 
  current->size |= 1;   //mark block as used

  // return pointer to data segment of this block.  
  return (void*)((char*)current+8);
}

int increaseheap(uint size8) 
{
  memheader* heap;
  block* newblock;
  uint neededspace;
  uint pages;


  heap = (memheader*)dseg_lo;
  neededspace=size8+8;   //add 8 for the header
 
  //if we can, we'll use free space already at the end of the heap.
  if (!allocated(heap->last))
    neededspace-=heap->last->size;
  
  // round up to next page.
  pages=neededspace/heap->pagesize;
  if (pages*heap->pagesize < neededspace)
    ++pages;

  
  if (!mem_sbrk(pages*heap->pagesize)) {
    return 0;                                                 
    // heap could not be expanded....fail fail fail fail
  }  
  if (!allocated(heap->last)) {
    heap->last->size+=pages*heap->pagesize; //coalesce new memory
  } 
  else {
    // add 7 instead of 8, since we know that the low bit is already set

    //location of new block (we hope)
    newblock=(block*)((char*)(heap->last)+(heap->last->size&(~1))+8);      

    //new chunk-header
    newblock->size=pages*heap->pagesize-8;                                 

    //point to last physical block
    newblock->prev=heap->last;                                             


    if (heap->top) {
      //insert into circular list
      newblock->left=heap->top->left;                                        
      newblock->right=heap->top; 
      heap->top->left->right=newblock; 
      heap->top->left=newblock;
    } else {
      // we have an empty list
      newblock->left=newblock;
      newblock->right=newblock;
      heap->top=newblock;
    }
    heap->last=newblock;
  }
 
  return 1;
}

void removenode (block* current)
{
  memheader*heap;

  heap=(memheader*)dseg_lo;

  if (current == heap->page) {
    //this is the first block greater blocksplit-
    if ( current->right == heap->top)      
      //this is the only block greater than blocksplit
      heap->page = NULL;
    else                                  
      //the one next to it is also greater than blocksplit
      heap->page = current->right;
  }

  if (current->left==current) {           // single node 
    heap->top=NULL;
  } 
  else
  {
    if (heap->top == current)
      heap->top = current->right; //if we removed the top node move pointer
 
    current->left->right=current->right;
    current->right->left=current->left;
    
  }
  
}

void insertnode (block* current, uint size, block* prev)
{
  block* loc;
  block* top;
  memheader* heap;

  heap=(memheader*)dseg_lo; 

  current->size=size;
  current->prev=prev;
  
  top=heap->top;
  loc = top;

  if (size >= blocksplit){
    if (heap->page)
      loc = heap->page;
    if (!heap->page || (heap->page->size >= size))     
      //there aren't any blocks that size or current is smaller than heap->page
      heap->page = current;
  }

  if (!loc) {                // if the list was empty...deal with it.
    heap->top=current;
    current->left=current->right=current;
    return;
  }

  //find location to insert block into list
  do
  {
    if (loc->size >= size)
      break;
    loc=loc->right;
  } while (loc!=top);

  // insert current into the list, before loc.
  current->right=loc;
  current->left=loc->left;
  loc->left->right=current;
  loc->left=current;

  if (top->size >= size)  // check to see if we wrapped around or not.
    heap->top=current;
}

void mm_free (void *ptr)
{

  block* current;
  memheader* heap;
  block* next;


  if (!ptr) {return;}  //check for null

  heap = (memheader*)dseg_lo;
  current = (block*)((char*)ptr-8);         //make sure to move pointer back
  current->size &= ~1;                      // set to unallocated
						
  					
  //try to coalesce the previous node

  if (current->prev && (((current->prev->size)&1) == 0)){   //unallocated
    removenode (current->prev);
    current->prev->size += current->size+8;
    if (current != heap->last)
      ((block*)((char*)current+current->size+8))->prev = current->prev;
    current = current->prev;
  }
  
  				
  //try to coalesce the next node

  next = (block*)((char*)current+current->size+8);
  if ((heap->last != current) && (((next->size)&1) == 0)){
    removenode(next);
    if (next != heap->last)
      ((block*)((char*)next+next->size+8))->prev = current;
    else
      heap->last=current;
    current->size += next->size+8;
  }
  
  insertnode(current, current->size, current->prev); 
}
