/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

/*
 * some sizeof checks:
 * Size of char is: 1
 * Size of char* is: 4
 * Size of void* is: 4
 * Size of int is: 4
 * Size of long is: 4
 *
 *
 */


#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "ehn",
    /* First member full name */
    "Jim Gajnak",
    /* First member email address */
    "jgajnak@cmu.edu",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

int jg = 0;

int try_incr_heap(int factor)
{

    // attempts to increase the heap by a factor of page size

    int pagesize = mem_pagesize();
    int used = mem_usage();
    int new_used;

    if (factor < 0)
    {
        printf("malloc.c(try_incr_heap) => FATAL: heap cannot be decreased!!!\n");
        exit(0);
    }

    mem_sbrk(factor * pagesize);

    new_used = mem_usage();

    if ((factor * pagesize) != (new_used - used))
    {
        printf("malloc.c(try_incr_heap) => FATAL: Attempt to increase heap FAILED!!!\n");
        return -1;
    }
    else
    {
        return 0;
    }

}

int round_to_eight(int somenum)
{
    // there's brain-dead routines, and then there's this

    while(somenum % 8 != 0)
       somenum++;

    return somenum;
}

int mm_init (void)
{
   int ret_val = 0;
   int size;
   long *addr = (long *)dseg_lo;

   if (mem_usage() <= 0)
	  ret_val = try_incr_heap(1);

   size = mem_usage() + 1;

   *addr = size;
   addr = (long *)((long)addr + 4); 
   *addr = (long)dseg_lo;
   addr = (long *)((long)addr + 4);
   *addr = (long)dseg_hi;
   addr = addr + size - 12;
   *addr = size;

   // some debugging output info
/* 
   printf("**********************\n");
   printf("mm_init call completed\n");
   printf("dseg_lo: %p\n", dseg_lo);
   printf("dseg_hi: %p\n", dseg_hi);
*/
   return ret_val;
}

void *mm_malloc (size_t size)
{
   long *addr = (long *)dseg_lo;
   long *ret_addr;
   long *more;
   long *more_too;
   int result;
   int reqSize = size;
   size = round_to_eight(size + 12);

   jg += 1;

   // printf("starting %d\n", jg);

	if (jg == 179)
	{
		printf("entering block\n");
		jg = 179;
	}
   
   while((long)(*addr) % 8 != 0)
	  addr = (long *)((long)(addr) + (long)(*addr) + 1);
  
   if ((long)addr > (long)dseg_hi)
   {
	  result = try_incr_heap((size / mem_pagesize()) + 1);
      if (-1 * result)
		 return NULL;
	  ret_addr = addr;
	  addr = (long *)((long)addr + 4);
	  *addr = (long)dseg_lo;
	  addr = (long *)((long)addr + 4);
	  *addr = (long)dseg_hi;
	  addr = (long *)((long)dseg_hi - 3);
	  *addr = mem_pagesize();
	  addr = ret_addr;
   }
  
   more = (long *)((long)addr + 8);
   // more_too = (long *)((long)more + 8);
   while((*addr < size) && ((long)(*more) != (long)dseg_hi)) //  ||  ((long)(*more_too) != (long)dseg_hi) )
   {
	  addr = (long *)(*((long *)((long)addr + 8)));
	  more = (long *)((long)addr + 8);
	  // more_too = (long *)((long)more + 8);
	  
   }
   if ((*((long *)((long)addr + 8)) == (long)dseg_hi) && (*addr < size))
   {
	  result = try_incr_heap((size / mem_pagesize()) + 1);
	  if (-1 * result)
		 return NULL;
	  result = mem_pagesize();
	  if (*addr % 8 == 0)
	  { 
		 // the block before dseg_hi is free
		 // we've got to merge the two
	     ret_addr = addr;
		 *addr = (long)(*addr) + ((long)result * ((size / mem_pagesize()) + 1));
		 addr = (long *)((long)addr + 8);
		 *addr = (long)dseg_hi;
         addr = (long *)((long)dseg_hi - 3);		 
		 *addr = *ret_addr;
		 addr = ret_addr;
	  }
	  else
	  {
		 ret_addr = addr;
		 addr = (long *)((long)addr + 8);
		 *addr = (long)(*addr) + 1;
		 addr = (long *)(*addr);
		 *addr = ((long)result * ((size / mem_pagesize()) + 1));
		 addr = (long *)((long)(addr) + 4);
		 *addr = (long)ret_addr;
		 addr = (long *)((long)(addr) + 4);
		 *addr = (long)dseg_hi;
		 addr = (long *)((long)dseg_hi - 3);
		 *addr = ((long)result * ((size / mem_pagesize()) + 1));
		 addr = ret_addr;
		 addr = (long *)((long)addr + 8);
		 addr = (long *)(*addr);
	  }
   }
  
   if (*addr - size > 12)
   {
	  //its worth it to make a chunk
	  ret_addr = addr;
	  addr = (long *)((long)addr + size);
	  *addr = *ret_addr - size;
	  addr = (long *)((long)addr + 4);
	  *addr = (long)(*(long *)((long)ret_addr + 4));
	  addr = (long *)((long)addr + 4);
	  *addr = (long)(*(long *)((long)ret_addr + 8));
	  addr = (long *)((long)ret_addr + (long)(*ret_addr) - 4);
	  *addr = *ret_addr - size;
	  addr = (long *)((long)addr + size);
/*	  if (*((long *)((long)addr + 4)) != (long)(dseg_lo))
      {
		 addr = (long *)((long)(*((long *)((long)addr + 4))) + 8);
		 *addr = ((long)addr + size);
		 addr = (long *)((long)addr + size);
      }
	  if (*((long *)((long)addr + 8)) != (long)(dseg_hi))
	  {
         addr = (long *)((long)(*((long *)((long)addr + 8))) + 4);
		 *addr = ((long)addr + size);
	  }
*/			
	  addr = ret_addr;
   }
else
   {
	  // its not
	  ret_addr = addr;
	  size = *addr;
/*	  if (*((long *)((long)ret_addr + 4)) != (long)(dseg_lo))
	  {
		 addr = (long *)((long)(*((long *)((long)ret_addr + 4))) + 8);
		 *addr = (long)*((long *)((long)(ret_addr) + 8));
	  }
	  if (*((long *)((long)ret_addr + 8)) != (long)(dseg_hi))
	  {
		 addr = (long *)((long)(*((long *)((long)ret_addr + 8))) + 4);
		 *addr = (long)*((long *)((long)(ret_addr) + 4));
	  }
	  */
	  if ((long)(*((long *)((long)addr + 4))) != (long)dseg_lo)
	  {
		 addr = (long *)((long)(*((long *)((long)addr + 4))));
		 addr = (long *)((long)addr + 8);
		 more = addr;
		 *addr = (long)*((long *)((long)(ret_addr) + 4));
		 if (*((long *)((long)ret_addr + 8)) != (long)(dseg_hi))
		 {
			addr = ret_addr;
			addr = (long *)(*((long *)((long)addr + 8)));
			addr = (long *)((long)addr + 4);
			*addr = (long)more;
			addr = ret_addr;
		 }

	  }
	  else
	  {
		 addr = (long *)((long)addr + 8);
		 if ((long)*addr != (long)dseg_hi)
		 {
			addr = (long *)((long)addr + 4);
			*addr = *((long *)((long)ret_addr + 4));
		 }
	  }
	  addr = ret_addr;
   }
  
   ret_addr = (long *)((long)addr + 8);
   
   *addr = size - 1;
   addr = (long *)((long)addr + (long)(*addr) - 3);
   *addr = size - 1;

   // some debugging output info

   printf("-----------------------------\n");
   printf("call to mm_malloc() completed\n");  
   printf("Returning: %p\n", ret_addr);
   printf("Requested Size: %d\n", reqSize);
   printf("Actual Size: %d\n", size);
   printf("dseg_lo: %p\n", dseg_lo);
   printf("dseg_hi: %p\n", dseg_hi);

   return ret_addr;
}

void mm_free (void *ptr)
{
   long *addr = ptr;
   long *swap;
   long mergeop = 0;
   long *more;
   
   addr = (long *)((long)addr - 8);
   
   swap = addr;
 /*  
   if ((*addr % 8) == 0)
   {
	  printf("**********>>>>> HEY! <<<<<<<********\n");
	  printf("this space is free already :-P\n");
	  printf("you asked for %p back...well, YOU'RE NOT GETTING IT!!!\n", swap);
	  printf("Size of block %ld\n", *addr);
	  printf("************************************\n");
	  exit(0);
   }
   else
   {
	  printf("Good...this space is used... ;-)\n");
	  printf("(Or, at least, you've fooled me into thinking its used)\n");
   }
   */
   //merge on left if possible...
   if (((long)addr != (long)dseg_lo) && (*((long *)((long)addr - 4)) % 8 == 0))
   {
	  //printf("yes, stuff on left to glob with\n");
/*	  addr = (long *)((long)addr - 1 + (long)*((long *)((long)addr - 4)));
	  *addr = (long)*addr + (long)*swap + 1;
	  mergeop = (long)(*addr);
	  addr = (long *)((long)addr + (long)*addr - 4);
	  *addr = mergeop;
	  addr = (long *)((long)addr - (long)*addr - 4);
	  mergeop = 1;
  */
	  addr = (long *)((long)addr - 4);
	  addr = (long *)((long)addr + 4 - (long)(*addr));
	  *addr = (long)*addr + (long)(*swap) + 1;
	  /* addr = (long *)((long)addr + 8);
	  more = (long *)((long)swap + 8);
	  *addr = (long)(*more);
	  addr = (long *)((long)addr - 8); */
      swap = (long *)((long)addr + (long)(*addr) - 4);
	  *swap = (long)(*addr);



	  mergeop = 1;
   }

   //merge on right...
   if (((long)addr + *addr != (long)dseg_hi) && (*((long *)((long)addr + *addr + 1)) % 8 == 0))
   {
	  // printf("yes, stuff on right to glob with\n");
	  // *addr = (long)(*addr) + (!mergeop) + (long)(*((long *)((long)addr + (long)*addr + 1)));
	  if (!mergeop)
	  {
		 addr = (long *)((long)addr + 4);
		 *addr = *((long *)((long)swap + (long)*swap + 5));
		 addr = (long *)((long)addr - 4);
	  }
	  addr = (long *)((long)addr + 8);
	  *addr = *((long *)((long)swap + (long)*swap + 13));
	  addr = (long *)((long)addr - 8);
	  *addr = (long)(*addr) + (!mergeop) + (long)(*((long *)((long)addr + (long)*addr + 1)));
	  mergeop = (long)(*addr);
	  addr = (long *)((long)addr + (long)(*addr) - 4);
	  *addr = mergeop;
	  addr = (long *)((long)addr + 4 - mergeop);
	  mergeop = 1;
   }  

   addr = swap;
   
   // do it the hard way...
   if (!mergeop)
   {
	  *addr = *addr + 1;
	  addr = (long *)((long)addr + (long)(*addr) - 4);
	  *addr = *addr + 1;
	  addr = swap;
	  if ((long)addr == (long)dseg_lo)
	  {
		 if ((long)addr + (long)(*addr) - 1 == (long)dseg_hi)
         {
			addr = (long *)((long)addr + 8);
			*addr = (long)dseg_hi;
		 }
         else
		 {
			addr = (long *)((long)addr + (long)*addr);
            while (((long)addr + (long)(*addr) - 1 != (long)dseg_hi) && (*addr % 8 != 0))
			   addr = (long *)((long)addr + (long)*addr + 1);
            //if ((long)addr + (long)(*addr) - 1 == (long)dseg_hi)
			if (*addr % 8 != 0)
			{
			   addr = swap;
	           addr = (long *)((long)addr + 8);
	           *addr = (long)dseg_hi;	
			}
            else
			{
			   swap = (long *)((long)swap + 8);
			   *swap = (long)addr;
			   swap = (long *)((long)swap - 8);
			}
		 }
		 

	  }
	  else
	  {
	  addr = (long *)((long)addr - 4);
	  while ((((long)addr + 4 - (long)(*addr)) != (long)dseg_lo) && (*addr % 8 != 0))
		 addr = (long *)((long)addr - (long)(*addr));
	  if (((long)addr + 4 - (long)(*addr)) != (long)dseg_lo)
	  {
		 addr = (long *)((long)swap + 4);
		 *addr = (long)dseg_lo;
		 addr = (long *)((long)addr + 4);
		 *addr = (long)swap;
		 addr = swap;
		 if ((long)addr + (long)(*addr) - 1 == (long)dseg_hi)
		 {
			addr = (long *)((long)addr + 8);
			*addr = (long)dseg_hi;
		 }
		 else
		 {
			addr = (long *)((long)addr + (long)*addr);
		 	while (((long)addr + (long)(*addr) - 1 != (long)dseg_hi) && (*addr % 8 != 0))
			   addr = (long *)((long)addr + (long)*addr + 1);
			// if ((long)addr + (long)(*addr) - 1 == (long)dseg_hi)
			if (*addr % 8 != 0)
			{
				addr = swap;
				addr = (long *)((long)addr + 8);
				*addr = (long)dseg_hi;
			}
			else
			{
			   swap = (long *)((long)swap + 8);
			   *swap = (long)addr;
			   swap = (long *)((long)swap - 8);
			}
		 }
	  }
	  else
	  {
		 // easy case - we've got the left pointer...
		 addr = (long *)((long)addr + 4 - (long)(*addr));
		 swap = (long *)((long)swap + 4);
		 *swap = (long)addr;
		 swap = (long *)((long)swap + 4);
		 addr = (long *)((long)addr + 8);
		 *swap = (long)(*addr);
		 swap = (long *)((long)swap - 8);
		 addr = swap;
	  }
	  }
	  // ok, now we make the other free places point
	  swap = (long *)((long)swap + 4);
	  if ((long)*swap != (long)dseg_lo)
	  {
		 addr = (long *)((long)*swap + 8);
		 *addr = ((long)swap - 4);
	  }
	  else
	  {
		 *swap = (long)dseg_lo;
	  }
	  swap = (long *)((long)swap + 4);
	  if ((long)*swap != (long)dseg_hi)
          {
                 addr = (long *)((long)*swap + 4);
                 *addr = ((long)swap - 8); 
          }
          else
          {
                 *swap = (long)dseg_hi;
          }
	  
   }
   
   // some debugging output info

   printf("+++++++++++++++++++++++++++++\n");
   printf("call to mm_free() completed\n");
   printf("Attempted to Free: %p\n", ptr);
   printf("dseg_lo: %p\n", dseg_lo);
   printf("dseg_hi: %p\n", dseg_hi);
				  
}

