/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 *  This uses a segregated list with the lists stored in arrays.  That is,
 *  freeArr points to the first of a list of free blocks size 16, and the
 *  sizes increase by a power of two up to freeArr[5], which stores blocks 
    of size
 *  512.  freeArr[6] stores blocks of size 512-2k and freeArr[7] stores blocks
 *  of size 2k-4k.
 *
 *  The block structure stores a pointer to the previous block of free 
 *  memory of the same size of itself.
 *  and a pointer to the next block of same size.  It also stores the size of
 *  the block.  In that size, since it will always be even, it has a 
 *  free bit.  In the least significant bit we store whether or not the
 *  previous block is used.  If it is used, it has a '1' for the least 
 *  significant
 *  bit.  If it is not used, it has a '0' for the least significant bit. 
 *  in the case of the final block, since there is no block after it 
 *  t o say it is used, we will store size two sizeof(int)'s from the end 
 *  of the block, and in the last sizeof(int) we will store a 0 for 
 *  the block itself being free, and a 1 if it is used
 */
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"


team_t team = {
    /* Team name to be displayed on webpage */
    "SUCK IT !!!",
    /* First member full name */
    "Heather Devine",
    /* First member email address */
    "hhd",
    /* Second member full name (leave blank if none) */
    "Laura Rosensteel",
    /* Second member email address (blank if none) */
    "lar"
};

/*  have lists for sizes 8, 16, 32, 64, 128, 256, 512, and > 512 
 * used will be denoted by a one in the lowest bit of the size
 * also, we will store the size again in the last word of the block
 * If the tailing size = 0 or 1 (it cant becasue we are 8 byte aligned)
 * this is a tag for the last word on the heap. (0 means the block itself
 * is not free, and 1 means that its allocated) */

typedef struct hoochiemama {
  int size; 
  struct hoochiemama* next; 
  struct hoochiemama* prev;
} block; 

int pow (int base, int power){
  int i;
  int returnBitch = 1;
  for (i=0; i<power; i++){ 
    returnBitch*=base;
  }
  return returnBitch;
}

int roundPow2(int num) {
  if(num%16==0)
    return num;
    if (num > 16) {
      int i;
      for (i = 16; i > 0; i = i*2) {
	if ((num > i) && (num < i*2)) {
	  return i*2;
	}
      } 
    } 
    else return 16;
    printf ("roundPow2 is fuct up !!!");
    return -1;
}

int roundPageSize(int num) {
    if (num > mem_pagesize()) {
      int i;
      for (i = 1; i > 0; i ++) {
	if (num>i*mem_pagesize() && num<(i+1)*mem_pagesize())
	  return i+1;
      }
    } 

    return 1;
}

block* formatAsUsed(block* x, int size){
  x->size = size;
  return x;
}

/*sets tailing size, and regular size with previous used info 
   set prev and next not in this function (for addpage)
   because it would get icky */


block* formatAsFreeAddPage (block* x, int size, int prevUsed){
   int q;
  /* store size in beginning of block */
  x->size = size;

  /*only change lower bit of size if prev is used */
  if (prevUsed) {
    *( (int *)x )  = size & 0x1;
  }
  /* store size in end of block */
  q = ((int)(&(*x))) + size - sizeof(int);
  *( (int *) q) = size;

  return x;
}



/* starting at memory address x, we set the size prev next etc
   this will return a block that is suitable to go on a 
   segregated list; for mm_init */

void formatAsFreeInit (block* x, int size, int prevUsed, block* prev, 
			 block* next){
  int q;
  /* store size in beginning of block; set prev and next */
  x->size = size;
  x->prev = prev;
  x->next = next;

  /*only change lower bit of size if prev is used */
  if (prevUsed) 
    *( (int *)x )  = size & 0x1;

  /* store size in end of block */
  q = ((int)(&(*x))) + size - sizeof(int);
  *( (int *) q) = size;

  return;
}

/* fizz has the prevused bit of size set */

void formatAsLastOnHeap (block* fizz, int used){
  int q;
  int size= fizz->size & ~0x1;

  /* store size in second int from end of block*/
  q = ((int)(&(*fizz))) + size - 2*sizeof(int);
  *( (int *) q) = fizz->size;

    /* store isUsed in end (last intsize) of block */
  if (used){
      q = ((int)(&(*fizz))) + size - sizeof(int);
      *( (int *) q) = 0x1;
  }
  else {
    q = ((int)(&(*fizz))) + size - sizeof(int);
    *( (int *) q) = 0;
  }

}

/* when mallocing, we want to make set the prevbit of the chunk
   after boogie to say that boogie is used. also if boogie is at the 
   end of the heap, we dont have to set anything, as there is no
   block after it*/
/* only used in malloc. assumes boogie is nnot last on heap */
void setAsUsed (block* boogie){
    int addressOfNextBlock = ((int)(&(*boogie))) + (boogie->size & ~0x1);
    block* nextBlock =(block *) addressOfNextBlock;
    int isNextLastOnHeap;
    nextBlock->size =  (*( (int *)  nextBlock) & ~0x1) + 0x1;
    /* we want to store used in the size of nexblock. if nextblock
       is the last on the heap, we'll have to set its size one place back
       on the trailing size */
    isNextLastOnHeap = ((int)(&(*nextBlock))) + *( (int *)  nextBlock)
      >= (int) dseg_lo +1;
    if (isNextLastOnHeap){
      *((int*)(int)(dseg_hi) +1 - 2*sizeof(int)) = nextBlock->size;
    }
    else{
      *((int*)(int)(dseg_hi) +1 - sizeof(int)) = nextBlock->size;
    }
 
}

/* when mm_free'ing, we want to make set the prevbit of the chunk
   after boogie to say that boogie is free. also if boogie is at the 
   end of the heap, we dont have to set anything, as there is no
   block after it*/

void setAsFree (block* boogie){
  int boogieIsLastOnHeap = (int)  ( ((int)(&(*boogie))) + 
			    (boogie->size & ~0x1) - 1) == ((int)dseg_hi);
  if (! boogieIsLastOnHeap){
    int* q;
    int addressOfNextBlock;
    block* nextBlock;

    q = (int*) (((int)(&(*boogie))) + (boogie->size & ~0x1));
    addressOfNextBlock = * q;
    nextBlock =(block *) addressOfNextBlock;
    if (nextBlock) {
       *( (int *)  nextBlock) = nextBlock->size & 0x0;
    } 
  }
  /* if boogie is the last in the heap, we say its used by 
     setting its last sizeof(int) bytes to 1(used) */
  else {
    int q;
    q = (((int)dseg_hi) + 1 - sizeof(int));
    *( (int *) q) = 0x1;
  }
}
/*this is used explicitly below in addPage, so we can assume
  that buttafucco is the last on the heap 
  also, this assumes that the previous block is coalesced
  already (ie the prevblock to that is used (we'll check just 
  to be sure)
*/
block* tryToCoalesce (block* buttafucco){
  int isPrevButtaFree = !(buttafucco->size & 0x1);
  if (isPrevButtaFree){
    int prevSize = *((int*)(((int)(&(*buttafucco))) - sizeof(int)));
    int buttaSize = buttafucco->size & ~0x1;
    int prevAddress = ((int)(&(*buttafucco))) - (prevSize & ~0x1);
    block* prevBlock = (block*) prevAddress;
    if ((*((int*)prevAddress))%2 ==0){
      printf("prevblock was not coalesced!");
    }

    buttafucco = prevBlock;
    buttafucco->size = buttaSize + (prevSize& ~0x1);
  }
  /* this sets the size in the end of the block as well as the 
     used bit in the end, 0 saying bttafucco is free */
  formatAsLastOnHeap(buttafucco, 0);
  return buttafucco;
}


/* increase the memory by pagesize, then add that large free
 * block to the 2k+ list, freeArr+8, which is in size order
 */
int addPage(void) {

  /* is last block on page used? 
     on the last block of a page, we will change the last bit 
     of the tailing size word to reflect if the block itself is used
     last block on heap is stored two intsizes from end, (see block struct
     declaration at top of malloc) and in last intsize is stored if the 
     block itself is used */
  

  int isPrevUsed =  *((int*)((int)dseg_hi - sizeof(int) +1));
  int sizeOfPrev =  (*((int*)((int)dseg_hi - 2*sizeof(int) +1))) & ~0x1;
  int addressOfPrev = (int)dseg_hi + 1 - sizeOfPrev;

  block* toInsert;

  block* tmp;
  
  block** freeArr = (block**)(dseg_lo);
    printf("added a page\n");
  if (mem_sbrk(mem_pagesize())==NULL)
    return 0;
  /*if the prev is free, we reset toInsert to start there,
    reset its size */
  
  if (!isPrevUsed){
    int addressOfTailTag, addressOfTailSize;
    toInsert = (block*)addressOfPrev;
    /* we set the prevUsed bit to 1, as the block before is used */
    toInsert->size = (sizeOfPrev + mem_pagesize()) + 0x1;;
    /* we set the size and used of current block at end */
    addressOfTailTag = (int)dseg_hi - sizeof(int)+1;
    addressOfTailSize = (int)dseg_hi - 2*sizeof(int)+1;
    *((int*)addressOfTailTag) = 0;
    *((int*)addressOfTailSize) = toInsert->size;
  }
  
  /* if theres nothing in the list, put it on front */
  if (freeArr[7]==NULL){
    tmp = toInsert;
    tmp->next = NULL;
    tmp->prev = NULL;
    freeArr[7] = tmp;
    return 1;
  }
  /*else look thru to find its place by increasing size */
  else {
    for (tmp = freeArr[7]; tmp!=NULL; tmp=tmp->next){
      if (toInsert->size <= tmp->size){
	toInsert->next = tmp;
	toInsert->prev = tmp->prev;
	if (tmp->prev !=NULL)
	  tmp->prev->next= toInsert;
	tmp->prev = toInsert;
	return 1;
      }
      /*end of list insertion */
      if (tmp->next == NULL){
	toInsert ->next = NULL;
	toInsert ->prev = tmp;
	tmp->next = toInsert;
	return 1;
      }

    }

    return 0;
  }
  
}

/* used below in the chunk off function, this assumes that the free block
   belongs on the freeArr[listIndex] list, and puts it there. 
   this is only used for the 7th and 8th lists, as they are in 
   sequential order
*/

void putOnIthList (block* toInsert, int listIndex){
  block** freeArr = (block**) dseg_lo;
  int q;
  if (freeArr[listIndex]==NULL){
    freeArr[listIndex] = toInsert;
    freeArr[listIndex]->prev = NULL;
    freeArr[listIndex]->next = NULL;
  }
  else{
    block* tmp;
    for(tmp = freeArr[listIndex]; tmp !=NULL; tmp = tmp->next){
      /* if we're at the correct place in list, insert */
      if (toInsert->size <= (tmp->size& ~0x1)){
	toInsert->next = tmp;
	toInsert->prev = tmp->prev;
	if (tmp->prev !=NULL)
	  tmp->prev->next = toInsert;
	tmp->prev = toInsert;
	break;
      }
      /* if we're at the end of the list, just put it there */
      if (tmp->next == NULL){
	tmp ->next = toInsert;
	toInsert->prev = tmp;
	toInsert->next = NULL;
	break;
      }
    }
  }
  /* store size in end of block */
  q = ((int)(&(*toInsert))) + (toInsert->size &~0x1) - sizeof(int);
  *( (int *) q) = toInsert->size & ~0x1;
  return; 
}




/* here we want to return the first size bytes of breakMe, and 
   throw the remaining bytes of breakMe into their appropriate list
   always assume no matter what you chunk off, you will have a multiple
   of 8, so there will never be fragments that dont fit into lists

   first we break off the chunk. then we try putting it on list 8, 7, 
   then distribute it in the remaining 6 lists. then we return the chunk
   breakMe can have sizeBit set
   */
block* chunkOffAndReformat (block* breakMe, int size){
  block* toReturn =  breakMe;
  block** freeArr = (block**) dseg_lo;
  /*if theres any leftovers when we're done with the first
    size bytes of breakMe, then we try to insert them */
  int leftovers = (breakMe->size & ~0x1) - size;
  int q;
  int addressOfNext;
  int nextSize;
  int isNextLastOnHeap;

  if (leftovers > 0){
    block* toInsert = (block*) (((int)(&(*breakMe))) + size);
    /* +1 indicates that the previous block was acllocated */
    toInsert->size = leftovers +1;
    /* set the size in toReturn */
    toReturn->size = size;
    *((int *)(toReturn + toReturn->size - sizeof(int)) )
      = toReturn->size;
    
    
    /* else start at biggest list and chunk off and loop with leftovers
       toInsert->size is even*/
    if (toInsert->size < 512 && ((toInsert->size &~0x1)> 0)) {
      int count = 0;
      int size = toInsert->size &~0x1;
      int i;
      for (i = 5; i>=0; i--){
	if (size >= pow (2, i+4)){
	  
	  toInsert->size = pow(2, i+4);
	  /*  if this is the first block after the one we are to allocate.
	      then we must make it say the prev one is allocated */
	  if (count==0)
	    toInsert->size = toInsert->size + 0x1;
	  /*if end of heap, store size and used (toInsert will be free=0)
	    in end of toInsert*/
	  if ((int)toInsert + (toInsert->size&~0x1)>=(int)dseg_hi+1){
	    q = (int)dseg_hi +1 - 2*sizeof(int);
	    *( (int *) q) = toInsert->size;
	    q = (int)dseg_hi +1 - sizeof(int);
	    *( (int *) q) = 0;
	  }
	  /*if we're not atheend of the heap, store size in last int of
	    toInsert, and used in thenext chunk's sizes */
	  else{
	    q = ((int)toInsert) + (toInsert->size& ~0x1) - sizeof(int);
	    *( (int *) q) = toInsert->size;
	    addressOfNext = (int)(toInsert) + (toInsert->size &~0x1);
	    nextSize = *((int*)addressOfNext);
	    isNextLastOnHeap = addressOfNext + (nextSize&~0x1) >=
	      (int)dseg_hi+1;
	    /*store size in second to last index, not in last */
	    if (isNextLastOnHeap){
	      
	    }
	  }
	  count ++;

	  
	  if (freeArr[i]==NULL){
	    toInsert->prev = NULL;
	    toInsert->next=NULL;
	    freeArr[i] = toInsert;
	    
	  }
	  else{
	    toInsert->prev = NULL;
	    toInsert->next = freeArr[i];
	    if(toInsert->next !=NULL)
	      toInsert->next->prev = toInsert;
	    freeArr[i]= toInsert;
	  }
	  size = size - pow(2, i+4);	  
	}
      }
     return toReturn; 
    }
    
    /* try to pass it off as one chung to big lists */
    if ((toInsert->size&~0x1) >= 512 && (toInsert->size&~0x1) < 2048){
      putOnIthList(toInsert, 6);
      return toReturn;
    }
    if (toInsert->size >= 2048){
      putOnIthList(toInsert, 7);
      return toReturn;
    }
  }
 
  /*else toReturn has no leftovers. we have to 
    store the used bit in the last int of itself if its at the end o'heap.
    if nto we put it in  the last bit of the size int of the on e in
    front of it */
  else{
    int toReturnIsLastOnHeap = (((int)&(*toReturn))+size) >= 
      ((int)dseg_hi+1);
    if (!toReturnIsLastOnHeap){
      int secretAddress=((int)(&(*toReturn)))+toReturn->size - sizeof(int);
      *( (int *) secretAddress) = secretAddress + 0x1;
    }
    else{
      int addressOfNext = ((int)(&(*toReturn))) + toReturn->size;
      *((int*)addressOfNext)  = addressOfNext + 0x1;
    }
  }

  return toReturn;
}


/* mm_malloc will return a pointer to a free block of size 'size'
   we first will check the case where theres a block of size 
   on one of the segregated lists. 
   next, we will assume that we have to break a bigger block, so we 
   look in the lists bigger than size
   finally, we give up and allocate a new page, and then 
   call malloc again with this new allocated memory. we can optimize 
   here later by returning the block of size free and putting the 
   remaining pagesize on the respective freeArr lists.

 */

void *mm_malloc (size_t size)
{
  
  block** freeArr = (block**) dseg_lo;
  int i;

  size = roundPow2(size);
  printf("malloc'ing\n");
  if (size<512){
    int i;
    for (i = 0; i<=5; i++) {
      
      /* we're at the list we want, take a free block if its there*/
      if (freeArr[i]!=NULL && (freeArr[i]->size & ~0x1) == size) { 
	block* toReturn = freeArr[i];
	int isLastOnHeap;
	freeArr[i]=freeArr[i]->next;
	if (freeArr[i]!=NULL)
	  freeArr[i]->prev = NULL;
	
	isLastOnHeap = (int) (((int)(&(*toReturn))) + 
			       (toReturn->size & ~0x1) - 1) 
	  == (int) dseg_hi;
	
	if (isLastOnHeap){
	  formatAsLastOnHeap (toReturn, 1);
	  return toReturn;
	}
	setAsUsed(toReturn);
	return toReturn; 
      }
    }
  }
  /* we deal with list 7 and 8 differently, as they are lists of 
     512-2048, and 2048 +. They are lists of different sizes, 
     in sequential order, so we will browse them to find a large enough 
     block */
  

    if (size < 2048 && freeArr[6]!=NULL){
      block* tester;
      for(tester= freeArr[6]; tester!=NULL; tester=tester->next){
	if (size <= (tester->size & ~0x1)){
	  if (tester->prev==NULL && tester->next !=NULL){
	    freeArr[6] = tester->next;
	    tester->next->prev = NULL;
	  }
	  if (tester->prev ==NULL && tester->next==NULL){
	    freeArr[6] = NULL;
	  }
	  if (tester->prev !=NULL && tester->next !=NULL){
	    tester->prev->next = tester->next;
	    tester->next->prev = tester->prev;
	  }
	  if (tester->prev!=NULL && tester->next == NULL){
	    tester->prev->next = NULL;
	  }
	  return chunkOffAndReformat (tester, size); 
	}
      }
    }
  
    if (freeArr[7]!=NULL){
      block* tester;
      for(tester= freeArr[7]; tester!=NULL; tester=tester->next){
	if (size <= (tester->size & ~0x1)){
	  if (tester->prev==NULL && tester->next !=NULL){
	    freeArr[7] = tester->next;
	    tester->next->prev = NULL;
	  }
	  if (tester->prev ==NULL && tester->next==NULL){
	    freeArr[7] = NULL;
	  }
	  if (tester->prev !=NULL && tester->next !=NULL){
	    tester->prev->next = tester->next;
	    tester->next->prev = tester->prev;
	  }
	  if (tester->prev!=NULL && tester->next == NULL){
	    tester->prev->next = NULL;
	  }
	  /* tester has prevBit Set */
	  return chunkOffAndReformat (tester, size); 
	}
      }
    }
  
  /* finally, if we have not returned yet, we can assume that we need 
     a new page added, and we simply call malloc again.. 
  */
    
    for(i=1; i<=roundPageSize(size); i++){
      printf("heap from %p to %p\n",dseg_lo,dseg_hi);
      if (addPage()==0){
	printf("addPage did not add a page-overflow? ");
        return NULL;
      }
      printf("heap from %p to %p\n\n",dseg_lo,dseg_hi);
    }
    
    return mm_malloc(size);
    
}



/* clears out memory for init */

void rm_r(){
  /* declaration as mm_free is below..maybe put this at the top */
  void mm_free (void *ptr);

  int i;
  block** freeArr = (block**)dseg_lo;

  for (i =0; i<=7; i++){
    block* vodka = freeArr[i];
    while (vodka!=NULL){
      block* skunkBeer;
      skunkBeer = vodka;
      vodka = vodka->next;
      mm_free(skunkBeer);

    }
  }
}

/*
  is the block before LSD free?
 */

int isPrevFree (block* LSD){

    return (!(LSD->size & 0x1));
}

/* is the block after flubber free? 
 */
int isNextFree (block* flubber){
  /*flubbityblubblub = address of next block */
  int flubbityblubblub = ((int)(&(*flubber))) + (flubber->size& ~0x1);
  int isLastOnHeap = flubbityblubblub >= (int) dseg_hi;

  if (isLastOnHeap) {
     return 0;
  } 
  else {
    /*ass = address of next next block) */
    int ass = flubbityblubblub + (*((int*)flubbityblubblub)& ~0x1);
    int isNextLastOnHeap = (ass >= (int) dseg_hi);
    if (isNextLastOnHeap) {
      int doodoo = (int)dseg_hi +1 - sizeof(int);
      return (! (doodoo & 0x1));
      
    } 
    else {

      int nextBlockSize = *((int*)flubbityblubblub);
      return (!(nextBlockSize & 0x1)); 
     }

  }

}

int mm_init (void)
{
  block** freeArr;
  int addressOfTailWord, addressOfTailSize;
  /* if there is existing memory, delete it. */
  if (mem_usage() > 0){
    rm_r();
  }

  mem_sbrk(mem_pagesize());
  freeArr = (block**) dseg_lo;


  /*
    FIX bitch !!
    freeArr[0]->size = 16;
    freeArr[1]->size = 32;
    freeArr[2]->size = 64;
    freeArr[3]->size = 128;
    freeArr[4]->size = 256;
    freeArr[5]->size = 512;
    freeArr[6]->> 512-2048 (each one in order)
    freeArr[7]->. 2048 and beyond...
  */

  /* since nothing is working, we'll just throw a page into the largest
     size segregated list  */

  freeArr[0] = NULL;
  freeArr[1] = NULL;
  freeArr[2] = NULL;
  freeArr[3] = NULL;
  freeArr[4] = NULL;
  freeArr[5] = NULL;
  freeArr[6] = NULL;
  /* the free block is everything past this array (64 bytes)
     up to the end of the array 
  */
  
  freeArr[7] = (block*)(((int)dseg_lo) + 64);
  /* +1 for dseg_hi offset, and to set lowest bit to used */
  freeArr[7]->size = ((int)(dseg_hi-dseg_lo)) + 1 - 64 +1;
  freeArr[7]->prev = NULL;
  freeArr[7]->next = NULL;
  /* tail word is 0, as this is the last block in heap, and its free */
  addressOfTailWord = ((int) dseg_hi) +1 -sizeof(int);
  *((int*)addressOfTailWord) = 0;
  /*store size 2 indices back from end */
  addressOfTailSize = ((int)dseg_hi)+1-2*sizeof(int);
  *((int*)addressOfTailSize) = freeArr[7]->size;

  return 0 ;
}

/* removes vallium from its segregated list, and restores the pointers
   of valliums prev and next block, if they exist. */
void removeFromList (block* vallium){
  if (vallium->prev !=NULL)
    vallium->prev->next = vallium->next;
  if (vallium->next !=NULL)
    vallium->next->prev = vallium->prev;
}


void mm_free (void *ptr){
   block **freeArr =  (block**) dseg_lo;
   block *current = (block *) ptr;

   block *newBlock;
   current->size = *((int*)ptr);

   /* mark the current block as free*/
   setAsFree(current);
   
   /* coalesce with previous block if previous block is free and not NULL;
    * if it's not free, we set the newblock to the current block  
    */

   /* see if we can coalesce with memory before. 
      make sure we're not at begininngn of heap (36 after dseg lo
      because the array is in the first 36 bytes of da heep)
      current->size tells us is previous piece of memory is free. 
      (prevbit trick)
   */

   if (isPrevFree(current)) {
     int q;
     int addressOfSizeOfPrev = ((int)(&(*current))) - sizeof(int);
     int addressOfPrev = ((int)(&(*current))) - 
       *((int*)addressOfSizeOfPrev);
     block* prevBlock = (block*)(addressOfPrev);
     newBlock = prevBlock;
     newBlock->size = (prevBlock->size & ~0x1) + 
       (current->size & ~0x1);
     /*now fix prevBlocks segregated lists (we're removing it)*/
     removeFromList (prevBlock);
     /* store size in end of block */
     q = ((int)(&(*newBlock))) + (newBlock->size) - sizeof(int);
     *( (int *) q) = newBlock->size;
   }
   else newBlock = current;

   /* coalesce with next block if next block is free and exists */
   if (isNextFree(current)){
     int q;
     int addressOfNext = ((int)(&(*current))) + (current->size & ~0x1);
     block* nextBlock = (block*) addressOfNext;
     nextBlock->size = *((int*)addressOfNext);
     newBlock->size = newBlock->size + (nextBlock->size & ~0x1);
     /* store size in end of block */
     q = ((int)(&(*newBlock))) + (newBlock->size) - sizeof(int);
     *( (int *) q) = newBlock->size & ~0x1;;
     removeFromList(nextBlock);
   }

   /* we need to set the used bit of the new block */
   if (!isPrevFree(newBlock))
     newBlock->size = newBlock->size & ~0x1;

   /* 
      insert new block into proper array; 

      start at biggest list and chunk off and loop with leftovers*/
  if (newBlock->size < 512 && newBlock->size> 0) {
    int size = newBlock->size;
    int i;
    int q;
    for (i = 5; i>=0; i--){
      if (size >= pow (2, i+4)){

	newBlock->size = pow(2, i+4);
	/* store size in end of block */
	q = ((int)(&(*newBlock))) + (newBlock->size& ~0x1) - sizeof(int);
	*( (int *) q) = newBlock->size;

	if (freeArr[i]==NULL){
	  newBlock->prev = NULL;
	  newBlock->next=NULL;
	  freeArr[i] = newBlock;
	  
	}
	else{
	  newBlock->prev = NULL;
	  newBlock->next = freeArr[i];
	  if (newBlock->next !=NULL)
	    newBlock->next->prev = newBlock;
	  freeArr[i]= newBlock;
	}
	size = size - pow(2, i+4);	  
      }
    }
    
  }
  /*  try to pass it off to big lists */
  if (newBlock->size >= 512 && newBlock->size <2048){
    putOnIthList(newBlock, 6);
  }
  if (newBlock->size >= 2048){
    putOnIthList(newBlock, 7);
  }

  


}
