#include <stdio.h>
#include <stdlib.h>
#include "atest.h"
#include <limits.h>

/* REB.  Added additional tests to hit switch statement branches */
#define TMPFIX

/* Same code as used in testing L1 submissions.  Main difference
   here is that all functions take two arguments and have arbitrary
   values for arguments.
*/

/*
   Command Line options:
   -v N:  Set verbosity to level N
        0: Only give final scores
        1: Also report individual correctness scores (default)
   -f Name: Check only the named function
   -e N: Limit number of errors to report for single function to N
         (Default unbounded)
*/

static int error_limit = 1000;

static char* test_fname = NULL;

/* Generate test values near "corner cases" */
#define TEST_RANGE 8
#define TEST_COUNT 64

static int random_val(int min, int max)
{
  double weight = rand()/(double) RAND_MAX;
  int result = min * (1-weight) + max * weight;
  return result;
}

static int gen_vals(int test_vals[], int min, int max)
{
  int i;
  int test_count = 0;
  /* If range small enough, then do exhaustively */
  if (max-TEST_COUNT+1 <= min) {
    for (i = min; i <= max; i++)
      test_vals[test_count++] = i;
    return test_count;
  }
  /* Otherwise, need to sample.
     Do so near the boundaries and for a few random cases */
  for (i = 0; i < TEST_RANGE; i++) {
#ifdef TMPFIX
    test_vals[test_count++] = 19+i;
#endif
    test_vals[test_count++] = min+i;
    test_vals[test_count++] = max-i;
    test_vals[test_count++] = (max+min)/2+i;
    test_vals[test_count++] = random_val(min, max);
  }
  return test_count;
}

static int
 test_2_arg(funct_t f, funct_t ft, int arg1, int arg2, char *name, int report)
{
  int r = f(arg1, arg2);
  int rt = ft(arg1, arg2);
  int error = (r != rt);
  if (error && report)
    printf(
   "Test %s(%d[0x%x],%d[0x%x]) failed.\n  Gives %d[0x%x].  Should be %d[0x%x]\n",
   name, arg1, arg1, arg2, arg2, r, r, rt, rt);
  return error;
}


/* Test a function.  Return number of errors */
static int test_function(test_ptr t, int report) {
  int test_vals[2][TEST_COUNT];
  int test_counts[2];
  int errors = 0;
  int i;
  int a1, a2;
  /* Create test set */
  for (i = 0; i < 2; i++) {
    test_counts[i] =
      gen_vals(test_vals[i], LONG_MIN, LONG_MAX);
  }
  for (a1 = 0; a1 < test_counts[0]; a1++) {
    for (a2 = 0; a2 < test_counts[1]; a2++) {
      errors += test_2_arg(t->solution_funct, t->test_funct,
			   test_vals[0][a1], test_vals[1][a2],
			   t->name, report && errors < error_limit);
    }
  }
#ifndef GRADE
  if (report && errors > error_limit)
        printf("... %d total errors for function %s\n",
	       errors, t->name);
#endif
  return errors;
}

/* Run series of tests.  Return number of errors */ 
static int run_tests(int report) {
  int i;
  int errors = 0;
  double points = 0.0;
  double max_points = 0.0;
  for (i = 0; test_set[i].solution_funct; i++) {
    int terrors;
    double tscore;
    double tpoints;
    if (!test_fname || strcmp(test_set[i].name,test_fname) == 0) {
      terrors = test_function(&test_set[i], report);
#ifdef GRADE
      printf("\t%d", terrors);
#endif
      errors += terrors;
      tscore = terrors ? 0.0 : 1.0;
      tpoints = tscore;
      points += tpoints;
      max_points += 1;
      if (report)
	printf("Test %s score: %.2f/%.2f\n",
	       test_set[i].name, tpoints, 1.0);
    }
  }
#ifdef GRADE
  printf("\t%.2f", points);
#else
  printf("Overall Correctness score: %.2f/%.2f\n", points, max_points);
#endif
  return errors;
}



/* Command Line options:
   -v N:  Set verbosity to level N
      0: Only give final scores
      2: Also report individual correctness scores (default)
   -c: Run correctness tests only, not the performance tests
   -f Name: Check only the named function
*/

static void usage(char *cmd) {
  printf("%s [-v 0|1|2] [-c] [-f Name] [-e ELIM]\n", cmd);
  exit(1);
}

extern team_struct team;

int main(int argc, char *argv[])
{
  int i;
  int verbose_level = 1;
  int errors;
  char *cmd = argv[0];
  
#ifdef GRADE
  verbose_level = 0;
  error_limit = 0;
#endif  

  for (i = 1; i < argc; i++) {
    char* arg = argv[i];
    if (arg[0] == '-') {
      switch(arg[1]) {
        char cval;
      case 'v':
	cval = arg[2];
	if (cval == '\0') {
	  if (i < argc-1) {
	    i++;
	    arg = argv[i];
	    cval = arg[0];
	  } else
	    usage(cmd);
	}
	if (cval == '0')
	  verbose_level = 0;
	else if (cval == '1')
	  verbose_level = 1;
	else
	  usage(cmd);
	break;
      case 'f':
	test_fname = arg+2;
	if (*test_fname == '\0') {
	  if (i < argc-1) {
	    i++;
	    test_fname = argv[i];
	  } else
	    usage(cmd);
	}
	break;
      case 'e':
	/* Set error limit */
	arg+=2;
	if (*arg == '\0') {
	  if (i < argc-1) {
	    i++;
	    arg = argv[i];
	  } else
	    usage(cmd);
	}
	error_limit = atoi(arg);
	if (error_limit < 0)
	  usage(cmd);
	break;
      default:
	usage(cmd);
      }
    } else
      usage(cmd);
  }
  if(*team.id1 == '\0') {
    printf("ERROR.  Must fill in team member names!\n");
    exit(0);
  } else if (strcmp(team.id1, "ac00") == 0) {
    printf("ERROR.  Must fill in Andrew ID of team members!\n");
    exit(0);
  } else {
#ifdef GRADE
    printf("\t%s", team.id1);
#else
    printf("Member 1:\t%s\t%s\n", team.name1, team.id1);
#endif
  }
  errors = run_tests(verbose_level > 0);
#ifndef GRADE
  if (errors > 0)
    printf("%d errors encountered.\n", errors);
  else {
    printf("All tests passed.\n");
  }
#endif
#ifdef GRADE
  printf("\n");
#endif
  return 0;
}
