;;; -*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: mcs -*-

;;           Copyright  1990    BY
;;           G M D  
;;           Postfach 1240
;;           D-5205 St. Augustin
;;           FRG

;;; -----------------------------------------------------------------------------------
;;;
;;; description:    The Effective Methods Computation at Load or Compile-File Time.
;;;
;;; notes:          
;;;
;;; contact:        Juergen Kopp, Harry Bretthauer
;;;
;;; history:
;;;          date:      author:             comments:
;;;          23.02.90   Harry Bretthauer    initial version
;;; -----------------------------------------------------------------------------------

(in-package "MCS")

;(export '())

(defgeneric optimize-class-space (class))

;;; -----------------------------------------------------------------------------------
;;; Optimization of classes
;;; -----------------------------------------------------------------------------------

(defmacro optimize-classes (&rest class-names)
  `(progn
     ,@(mapcar 
        #'(lambda (class-name)
            (let ((class (find-class class-name 'signal-error)))
              `(setf (%%class-slot-accessor (find-class ',class-name))
                     (function ,(compute-slot-accessor-lambda 
                                 class (%%class-slots class))))))
        class-names)))

;;; -----------------------------------------------------------------------------------
;;; Optimization of generic functions
;;; -----------------------------------------------------------------------------------

(defmacro optimize-generic-functions (&rest gfn-names)
  `(progn
     ,@(mapcan 
        #'(lambda (gfn-name)
            (let ((gfn (find-gfn gfn-name 'signal-error)))
              (precompute-effective-methods-for gfn)
              `((setf (%%gfn-discriminating-function (find-gfn ',gfn-name))
                     ',(%%gfn-discriminating-function gfn))
                (setf (%%gfn-combined-methods (find-gfn ',gfn-name))
                      ,(make-load-form (%%gfn-combined-methods gfn))))))
        gfn-names)
     ',gfn-names))

(defmacro optimize-all-generic-functions ()
  `(progn
     ,@(let ((result ()))
         (map-gfns 
        #'(lambda (gfn)
            (let ((gfn-name (%%gfn-name gfn)))
              (precompute-effective-methods-for gfn)
              (push
                `(setf (%%gfn-combined-methods (find-gfn ',gfn-name))
                      ,(make-load-form (%%gfn-combined-methods gfn)))
                result))))
       result)))

(defun make-load-form (a-list)
  (labels ((traverse-a-list 
            (list-of-entries)
            (cond
             ((null list-of-entries) ())
             (t `(list ,@(mapcar #'traverse-entry list-of-entries)))))
           (traverse-entry (entry)
                           (cond
                            ((consp entry)
                             
                             `(cons ,(if (%object-p (car entry))
                                      `(find-class ',(%%class-name (car entry)))
                                      ())
                                    ,(traverse-a-list (cdr entry))))
                            (t `(identity ',entry)))))
    (traverse-a-list a-list)))

(defun compute-1-method-gfn-lambda (gfn method)
  ;(declare (ignore methods))
  (let ((lambda-list (%%gfn-lambda-list gfn))
        (signature (%%gfn-signature gfn))
        (class-checkers (get-type-checkers gfn)))
    (let ((all-arguments lambda-list)
          (required-arguments lambda-list))
      (when (mcs-memq '&rest lambda-list)
        (setf all-arguments (mcs-remq '&rest lambda-list))
        (setf required-arguments (butlast lambda-list 2)))
      `(lambda  ,lambda-list
           (declare (optimize (speed 3) (safety 1)))
           (let ()
             (declare (optimize (speed 3) (safety 0)))
             (if (and 
                  ,@(let ((specializers (%%method-specializers method))
                          (expr ()))
                      (dolist (cl signature)
                        (if cl
                          (setf expr (cons `(%subinstance-p
                                             ;(,(pop class-checkers)
                                              ,(pop lambda-list)  ;)
                                             ',(pop specializers))
                                           expr))
                          (progn (pop class-checkers) 
                                 (pop lambda-list)
                                 (pop specializers))))
                      (reverse expr))
                  t)
               (funcall ',(%%method-function method) () ,@all-arguments)
               (no-applicable-methods ',(%%gfn-name gfn) ,@required-arguments)))))))

(defun optimize-1-method-gfn (gfn method)
  (compile (%%gfn-name gfn)
           (compute-1-method-gfn-lambda gfn method)))

(defun optimize-1-method-gfns ()
  (map-gfns #'(lambda (gfn)
                (when (= (length (%%gfn-methods gfn)) 1)
                  (print (%%gfn-name gfn))
                  (optimize-1-method-gfn gfn (car (%%gfn-methods gfn)))
                  ;(remhash (%%gfn-name gfn) *named-gfns*)
                  ))))
(defmacro optimize-class-space-except (&rest class-names)
  `(map-classes #'(lambda (cl)
                   (unless (mcs-memq (%%class-name cl) ',class-names)
                     (optimize-class-space cl)))))

;(defmethod optimize-class-space ((cl class))
;  (setf (%%class-direct-methods cl) ()))
;
;(defmethod optimize-class-space ((cl defined))
;  (call-next-method)
;  (setf (%%class-direct-slots cl) ())
;  (setf (%%class-direct-initargs cl) ()))
;
;(defmethod optimize-class-space ((cl instantiable))
;  (call-next-method)
;  (setf (%%class-effective-methods cl) ()))

; (optimize-1-method-gfns)
;(defclass c0 () ((s0 :accessor s0 :initform 0)))
;(setf i0 (make-instance 'c0))
;(defclass c1 (c0) ())
;(setf i1 (make-instance c1))
;(defmethod f222 ((x c0)) x) (defmethod f2 ((x c0)) x) (remove-gfn 'f2) 
;(f222 i0) (f3 i0) (f2 i1) (trace dynamic-lookup)
;(compute-1-method-gfn-lambda (find-gfn 'f2) (car (%%gfn-methods (find-gfn 'f2))))
;(optimize-1-method-gfn (find-gfn 'f2) (car (%%gfn-methods (find-gfn 'f2))))
#|
(setf c0 (find-class 'c0))
(compile 'f222 
         `(lambda (mcs::x) 
            (declare (optimize (speed 3) (safety 1)))
            (let ((x-cl (if (%object-p x) (mcs%class-of x) (built-in-class-of x)))) 
              (declare (optimize (speed 3) (safety 0))) 
              (if (mcs::mcs-memq ',c0 (%%class-precedence-list x-cl))
                (funcall ',(compile () '(lambda (nnn x)
                                       (declare (optimize (speed 3) (safety 0)))
                                       x))
                         nil mcs::x)
;                x
                (no-applicable-methods 'mcs::f2 mcs::x)))) )
(time (test1 i0 10000))
(defmacro %object-p (x)
  `(and (excl::structurep ,x)
	  (locally
	    (declare (optimize (speed 3) (safety 0)))
	    (eq (svref ,x 0) 'mcs%))))
  
(defmacro %object-p (arg)
  `(and (eq (ccl::%type-of ,arg) 'structure)))
        ;(eq (car (ccl::struct-ref ,arg 0)) 'mcs%)))
(defmacro %object-p (obj)
          `(typep ,obj 'mcs%))
(defun mcs%%-p (x)
  (and (excl::structurep x)
       (locally
	 (declare (optimize (speed 3) (safety 0)))
	 (eq (svref x 0) 'mcs%))))
 (%object-p i0)(ccl:structure-typep i0 'mcs%)
(compile 'mcs%%%slot-value 
         '(lambda (object slot-name)
            (declare (optimize (speed 3) (safety 0)))
            (if (%object-p object)
              (let ((result 
                     (let ((slot-position (%slot-location-of object slot-name 'sl)))
                       (declare (optimize (speed 3) (safety 0)))
                       (if slot-position
                         (mcs%obj-ref object slot-position)
                         (slot-missing (mcs%class-of object) object slot-name 'slot-value))) ))
                (if (eq result '<unbound>) 
                  (slot-unbound (mcs%class-of object) object slot-name)
                  result))
              (slot-missing (built-in-class-of object) object slot-name
                            'slot-value))))
(compile 'f2 
;         `(lambda (mcs::x) 
;            (declare (optimize (speed 3) (safety 1)))
;            (let ((eff-methods
;                   (funcall (%%gfn-discriminating-function ',(find-gfn 'f2))
;                            ',(find-gfn 'f2) mcs::x)))
;              (declare (optimize (speed 3) (safety 0))) 
;              (funcall (car eff-methods) eff-methods x))))
;(optimize-1-method-gfn (find-gfn 's0) (car (%%gfn-methods (find-gfn 's0))))
; (optimize-discriminating-fn (find-gfn 'f2))
(defun test1 (x n)
  (declare (optimize (speed 3) (safety 0)))
  (dotimes (i n)
    (f222 x)
    ;(class-name x)
    ;(s0 x)
   ))
|#
;(time (test1 i0 10000)) (time (test1 class 10000))
;(%subinstance-p x y) (%%gfn-combined-methods (find-gfn 'f2))

(defun optimize-discriminating-fn (gfn)
  (let ((table (%%gfn-combined-methods gfn))
        (lambda-list (%%gfn-lambda-list gfn))
        (signature (%%gfn-signature gfn))
        (class-checkers (get-type-checkers gfn)))
    (let ((all-arguments lambda-list)
          (required-arguments lambda-list))
      (when (mcs-memq '&rest lambda-list)
        (setf all-arguments (mcs-remq '&rest lambda-list))
        (setf required-arguments (butlast lambda-list 2)))
      (setf (%%gfn-discriminating-function gfn)
            (compile ()
                     `(lambda ,(cons '%gfn lambda-list)
                        (declare (optimize (speed 3) (safety 0)))
                        ,(compute-case-lambda table signature required-arguments 
                                              required-arguments
                                              gfn class-checkers)) )
                     ))))

(defun optimize-generic-functions-with-many-methods ()
  (map-gfns #'(lambda (gfn)
                (when (> (length (%%gfn-methods gfn)) 1)
                  (print (%%gfn-name gfn))
                  (optimize-discriminating-fn gfn)))))

;(optimize-generic-functions-with-many-methods)
;(optimize-1-method-gfns)
  
;;; -----------------------------------------------------------------------------------

;(defmacro compute-effective-methods (&rest args)
;  ;; parse: (compute-effective-methods (gf1 c1 c2) (gf2 c1 t))
;  (let (safe-forms)
;    (dolist (arg args)
;      (let ((gfn (find-gfn (first arg)))
;            (specializers (rest arg)))
;        (let ((sorted-applicable-methods
;               (select-applicable-methods gfn specializers)))
;          (if sorted-applicable-methods
;            (push 
;             `(save-effective-method 
;               (find-gfn ',(first arg)) ',specializers
;               ',(compute-effective-method 
;                  gfn specializers (%%gfn-method-combination gfn) 
;                  sorted-applicable-methods))
;             safe-forms)
;            (format t "No applicable methods in ~S for specializers: ~S." 
;                    gfn specializers)) )))
;    `(eval-when (load)
;       ,@safe-forms)))

;(defmacro compute-all-effective-methods (&rest class-names)
;  (let (result)
;    (dolist (class-name class-names)
;      (let ((args (%%class-effective-methods (find-class class-name))))
;        (push `(compute-effective-methods ,@args) result)))
;    `(progn
;       ,@result)))

;;; -----------------------------------------------------------------------------------
;;; Library Functions
;;; -----------------------------------------------------------------------------------

(defun collect-chain (element next-fn)
  " (<element> <next-function>) ==> (<element>*)
    <element> ::= LISP object
    <next-function> ::= function : (<element>) ==> {<element> | nil}
    Example: (collect-chain 1 #'(lambda (x) (if (= x 11) nil (1+ x))))"
  (let ((next-element (funcall next-fn element)))
    (if (not next-element)
      nil
      (cons next-element (collect-chain next-element next-fn)))))

(defun collect-tree (element direct-successors-fn)
  " (<element> <next-function>) ==> (<element>*)
    <element> ::= LISP object
    <next-function> ::= function : (<element>) ==> (<element>*)
    Collects all successors of one element in the tree.
    Example: (collect-tree 1 #'(lambda (x)
                                 (if (> x 11) 
                                    nil 
                                    (list (+ x 2) (+ x 3)))))"
  (let ((next-elements (funcall direct-successors-fn element)))
    (if (not next-elements)
      nil
      (apply #'append next-elements 
             (mapcar #'(lambda (element)
                         (collect-tree element direct-successors-fn))
                     next-elements)))))

(defun collect-acyclic-directed-graph (element direct-successors-fn)
  " (<element> <next-function>) ==> (<element>*)
    <element> ::= LISP object
    <next-function> ::= function : (<element>) ==> (<element>*)
    Collects all successors of one element in an acyclic directed graph.
    Example: (collect-acyclic-directed-graph
               1 
               #'(lambda (x) (if (> x 11) nil (list (+ x 3) (+ x 1)))))"
  (remove-duplicates (collect-tree element direct-successors-fn) :test #'eq))

(defun compute-combinations (&rest lists)
  (labels ((comb-help (r-lists result)
                      (cond 
                       ((null r-lists) result)
                       (t (comb-help (rest r-lists)
                                     (apply #'append
                                            (mapcar #'(lambda (el)
                                                        (mapcar #'(lambda (l)
                                                                    (cons el l))
                                                                result))
                                                    (first r-lists))))))))
    (let ((r-lists (reverse lists)))
      (comb-help (rest r-lists) (mapcar #'list (first r-lists))))))

;;; -----------------------------------------------------------------------------------
;;; Precomputing the Effective Method at any time 
;;; -----------------------------------------------------------------------------------

(defun precompute-effective-method (gfn specializers)
  (declare (optimize (speed 3) (safety 0)))
  (let ((sorted-applicable-methods
         (select-applicable-methods gfn  specializers)))
    (when sorted-applicable-methods
      (save-effective-method 
       gfn specializers
       (compute-effective-method 
        gfn specializers (%%gfn-method-combination gfn) 
        sorted-applicable-methods))) ))

(defun class-subclasses (class)
  (declare (optimize (speed 3) (safety 0)))
  ;  (collect-acyclic-directed-graph class #'class-direct-subclasses)
  (let ((result nil))
    (maphash #'(lambda (key value)
                 (if (mcs-memq class (rest (%%class-precedence-list value)))
                   (push value result)))
             *named-classes*)
    (remove-duplicates result :test #'eq)))

; (length (class-subclasses (find-class 't)))
;(undefmethod class-direct-subclasses ((class class))
;  ;; classes have no slot subclasses 
;  ;; thus, look for direct superclasses of all classes
;  (let ((result nil))
;    (maphash (function (lambda (key value)
;                       (if (mcs-memq class (class-direct-superclasses value))
;                         (push value result))))
;             *named-classes*)
;    result))

(defun compute-effective-specializers (gfn)
  (declare (optimize (speed 3) (safety 0)))
  (let ((methods (generic-function-methods gfn))
        (signature (%%gfn-signature gfn)))
    (let ((result (make-list (length signature))))
      (dolist (method methods)
        (let ((specializers (method-specializers method))
              (pos 0))
          (mapcar #'(lambda (cl sign)
                      (when sign
                        (setf (nth pos result) (cons cl (nth pos result))))
                      (incf pos))
                  specializers signature)))
      (let ((pos 0))
        (dolist (domain result)
          (if domain
            ;; there is need for discrimination over the argument in question:
            (progn
              (setf domain (delete-duplicates domain :test #'eq))
              (setf (nth pos result) domain)
              (dolist (cl domain)
                (nconc domain (class-subclasses cl)))
              (setf domain (delete-duplicates domain :test #'eq))
              (setf (nth pos result)
                    (delete-if #'(lambda (cl)
                                   (%typep cl 'abstract))
                               domain)))
             ;; there is no need for discrimination over the argument in question:
            (setf (nth pos result) (list (find-class 't))))
          (incf pos)))
       ;(print result)
      (apply #'compute-combinations result))))

(defun precompute-effective-methods-for (gfn)
  (declare (optimize (speed 3) (safety 0)))
  ;(print gfn)
  
  (dolist (eff-specializers (compute-effective-specializers gfn))
    (unless (entry-exists-p gfn eff-specializers)
    (precompute-effective-method gfn eff-specializers))))

(defun precompute-all-effective-methods ()
  (declare (optimize (speed 3) (safety 0)))
  (maphash #'(lambda (key val)
               (precompute-effective-methods-for val)
               ;(compute-discriminating-fn val)
               )
           *named-gfns*))

(defun entry-exists-p (gfn eff-specializers)
  (let ((table (%%gfn-combined-methods gfn))
        (relevant-specializers 
           (mcs-remq nil
                     (mapcar #'(lambda (sign cl)
                                 (if sign cl sign))
                             (%%gfn-signature gfn) eff-specializers))))
    (labels ((help-fn (rest-table rest-specializers)
                      (cond
                       ((null rest-table) ())
                       ((null (rest rest-specializers))
                        (cdr (mcs-assq (first rest-specializers) rest-table)))
                        (t (help-fn (cdr (mcs-assq (first rest-specializers)
                                                   rest-table))
                                    (rest rest-specializers))))))
      (help-fn table relevant-specializers))))




;;; eof

