(provide "mswmenus")

;;;;
;;;; Standard Menus for Microsoft Windows Version
;;;;

(setf *file-menu* (send menu-proto :new "&File"))
(send *file-menu* :append-items
      (send menu-item-proto :new "&Load" :action
            #'(lambda ()
                (let ((fname (open-file-dialog)))
                  (if fname (load fname)))))
      (let ((dribble-item (send menu-item-proto :new "&Dribble")))
        (defmeth dribble-item :do-action ()
          (case (send self :mark)
            (nil (let ((df (set-file-dialog "Dribble File Name:")))
                   (when df
                         (dribble df)
                         (send self :mark t))))
            (t (dribble) (send self :mark nil))))
        dribble-item)
      (send dash-item-proto :new)
      (send menu-item-proto :new "E&xit" :action #'msw-exit)
      (send menu-item-proto :new "About XLISP-STAT ..." :action
            #'about-xlisp-stat))
(send *file-menu* :install)

(setf *edit-menu* (send menu-proto :new "&Edit"))
(send *edit-menu* :append-items
      (send menu-item-proto :new "&Undo\tAlt+BkSp" :enabled nil)
      (send dash-item-proto :new)
      (send menu-item-proto :new "Cu&t\tShift+Del" :action #'msw-cut)
      (send menu-item-proto :new "&Copy\tCtrt+Ins" :action #'msw-copy)
      (send menu-item-proto :new "&Paste\tShift+Ins" :action #'msw-paste)
      (send menu-item-proto :new "C&lear\tDel" :action #'msw-clear)
      (send dash-item-proto :new)
      (send menu-item-proto :new "Copy-Paste\tAlt+Ins" :action #'msw-copy-paste))
(send *edit-menu* :install)

      