;;; -*- Mode: LISP;  Syntax: COMMON-LISP; Package: (*SIM-I COMMON-LISP-GLOBAL); Base: 10; Patch-File: T -*-

(in-package '*sim-i :use '(lisp))

;;;> *+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+
;;;> 
;;;> The Thinking Machines *Lisp Simulator is in the public domain.
;;;> You are free to do whatever you like with it, including but
;;;> not limited to distributing, modifying, and copying.

;;;> Bugs, comments and revisions due to porting can be sent to:
;;;> bug-starlisp@think.com.  Other than to Thinking Machines'
;;;> customers, no promise of support is intended or implied.
;;;>
;;;> *+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+

;;; Author:  JP Massar.


(import-then-export '*lisp '*lisp '(load-starsim-patches))

#+(OR LUCID KCL ALLEGRO)
(progn
  (setq *starlisp-simulator-header* "Thinking Machines Starlisp Simulator")
  (setq *starlisp-simulator-version* 19.0)
  (setq *expiration-date* '(1994 12 31))
  )


(defun load-starsim-patches ()
  #+TMC
  (dfs:load-n "brigit:/cm/starlisp/simulator/f19/patches.lisp")
  #-TMC
  (load "/cm/starlisp/simulator/f19/patches")
  )


;;; JP Massar for Chris OConnell from ADS.
;;; Makes pvars print reasonably under Lucid.

#+LUCID
(*proclaim '(special lucid::*defstructs*))
#+LUCID
(setf (gethash '*lisp-i::pvar lucid::*defstructs*)
      (sys::vector-to-structure
       #(defstruct pvar structure nil nil nil nil
	 nil nil *lisp-i::print-pvar nil nil nil 14 nil nil)))



;;; JP Massar.  7/13/89
;;; Made internal type predicates not error out.


(defun boolean-pvarp (arg) (internal-pvarp arg))
(defun front-end-pvarp (arg) (internal-pvarp arg))
(defun signed-pvarp (arg &optional (length '*)) (declare (ignore length)) (internal-pvarp arg))
(defun unsigned-pvarp (arg &optional (length '*)) (declare (ignore length)) (internal-pvarp arg))
(defun float-pvarp (arg &optional (mantissa '*) (exponent '*))
  (declare (ignore mantissa exponent))
  (internal-pvarp arg)
  )
(defun single-float-pvarp (arg) (internal-pvarp arg))
(defun short-float-pvarp (arg) (internal-pvarp arg))
(defun double-float-pvarp (arg) (internal-pvarp arg))
(defun long-float-pvarp (arg) (internal-pvarp arg))
(defun extended-float-pvarp (arg) (internal-pvarp arg))
(defun character-pvarp (arg) (internal-pvarp arg))
(defun string-char-pvarp (arg) (internal-pvarp arg))
(defun general-pvarp (arg) (internal-pvarp arg))
(defun complex-pvarp (arg &optional (mantissa '*) (exponent '*))
  (declare (ignore mantissa exponent))
  (internal-pvarp arg)
  )
(defun single-complex-pvarp (arg) (internal-pvarp arg))
(defun short-complex-pvarp (arg) (internal-pvarp arg))
(defun double-complex-pvarp (arg) (internal-pvarp arg))
(defun long-complex-pvarp (arg) (internal-pvarp arg))
(defun extended-complex-pvarp (arg) (internal-pvarp arg))


(defun unsigned-pvarp-closure (length)
  (declare (ignore length))
  #'(lambda (arg) (internal-pvarp arg))
  )

(defun signed-pvarp-closure (length)
  (declare (ignore length))
  #'(lambda (arg) (internal-pvarp arg))
  )

;;; Functions to toggle scalar promotion

(defun disable-scalar-promotion ()
  (setq *lisp-i::*convert-scalar-args-p* nil))

(defun enable-scalar-promotion ()
  (setq *lisp-i::*convert-scalar-args-p* t))

;;; ===========================================================================

;;; *COLD-BOOT the Simulator to its default configuration
;;; to make sure things are working.


(eval-when (load eval)
  (*cold-boot :initial-dimensions '(8 4))
  )

