;; -*- Mode:Lisp; Syntax:Common-Lisp; Package: (*SIM-I COMMON-LISP-GLOBAL); Muser: yes -*-

(in-package 'user)

(defun last-char-is-newline-p (file)
  (with-open-file (stream file :direction :input)
    (let ((length (file-length stream)))
      (if (zerop length)
	  (return-from last-char-is-newline-p t)
	  (progn
	    (file-position stream (1- length))
	    (let ((char (read-char stream)))
	      (return-from last-char-is-newline-p (eql #\Newline char))
	      ))))))

(defun check-lisp-files-in-directory (directory)
  (let ((pathname-list (directory directory)))
    (mapc
      #'(lambda (path)
	  (when (equalp (pathname-type path) "lisp")
	    (when (not (last-char-is-newline-p path))
	      (print (concatenate 'string (pathname-name path) "." (pathname-type path)))
	      )))
      pathname-list
      ))
  nil
  )
