;;; -*- Mode: LISP;  Syntax: COMMON-LISP; Package: (*LISP-I COMMON-LISP-GLOBAL); Base: 10; Muser: yes; -*-

;;;> *+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+
;;;> Copyright 1986 Thinking Machines Corporation, Inc. of Cambridge, Massachusetts.
;;;> 
;;;> Permission is hereby granted to copy this source onto any machine at a site
;;;> which legitimately has this software, and to execute the resulting object
;;;> code on any machine at a site which legitimately has this software.

;;;> Permission is hereby granted to make such changes as are necessary to port this
;;;> source to a version of Common Lisp running on any machine so long as said changes
;;;> are sent back to Thinking Machines so that they may be incorporated in future
;;;> releases.

;;;> Bugs, comments and revisions due to porting can be sent to:
;;;> bug-starlisp@think.com

;;;> The *Lisp Simulator was written by JP Massar.
;;;> The *Lisp language was designed by Cliff Lasser and Steve Omohundro, with
;;;> help from may others at Thinking Machines Corporation.

;;;> *+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+



;;; This is the external specification for the *LISP Language.  It should be
;;; the very first file loaded for both the hardware and the simulator versions.
;;; It contains declarations for all global variables defined by *LISP.
;;; It exports all the symbols from the *LISP package that should be exported,
;;; except for a few which are simulator or hardware specific.
;;; It creates all the packages that should be created.


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; MAKE SURE COMMON LISP IS BEING USED WHEN THIS FILE IS COMPILED AND/OR LOADED

;;; what a hack!  But I finally found a way to test whether a package is
;;; Zetalisp or Commonlisp without blowing up before the test could be
;;; run...


#+SYMBOLICS
(eval-when (compile load eval)
  (if (not (funcall (intern "FIND-SYMBOL" 'common-lisp-global) "PROVIDE"))
      (ERROR "The *LISP-I package was incorrectly created as a Zetalisp package.
              You probably edited a file with an incorrect Package: attribute.
              The suggested Zmacs attribute list for *LISP files is:
              Syntax: COMMON-LISP; Package: (*LISP COMMON-LISP-GLOBAL);
              This causes the *LISP package to be created if it does not exist,
              and forces it to inherit from Common Lisp, not Zetalisp.
              You will loose horribly if you continue - you MUST boot this machine!!!!

             "
       )))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(in-package '*lisp-i)

;;;; Define the package setup for *LISP

;;;; *LISP-I is where the actual definition of the language is done.

;;;; *LISP is the package seen by users.  It contains exactly
;;;; those symbols defined by the *LISP language, and nothing else.
;;;; All of these symbols are exported from *LISP.
;;;; If a user wishes to define his own package, it must use
;;;; the *LISP package if he wishes to be able to use *LISP.

;;;; *LISP-DEFUN is an internal package wherein the actual function
;;;; definitions of *DEFUN-ed functions are kept (since macros by
;;;; the same name are defined for every *DEFUN-ed function, user
;;;; and system.)

(eval-when (load eval compile)

  (defun check-for-package-and-create (package-name-string &optional (package-use-list nil))
    (if (not (find-package package-name-string))
	(if package-use-list
	    (make-package package-name-string :use package-use-list)
	    (make-package package-name-string)
	    )
	(let ((use-list (package-use-list (find-package package-name-string))))
	  (dolist (p package-use-list)
	    (if (not (member (find-package p) use-list))
		(error "
Package ~A has somehow been created with the wrong
packages in its use list.  It should use packages ~S,
but instead uses packages ~S.
You will induibitably lose...
I suggest rebooting this machine NOW!!!
                   
                     "
		       package-name-string
		       package-use-list
		       use-list
		       ))))
	))

  (check-for-package-and-create "*LISP-I" #+SYMBOLICS '("COMMON-LISP-GLOBAL"))
  (check-for-package-and-create "*LISP" #+SYMBOLICS '("COMMON-LISP-GLOBAL"))
  (check-for-package-and-create "*LISP-DEFUN" #+SYMBOLICS '("COMMON-LISP-GLOBAL"))
  (check-for-package-and-create "*LISP-TESTS" #-SYMBOLICS '("*LISP" "LISP") #+SYMBOLICS '("*LISP" "COMMON-LISP-GLOBAL"))

)

(defvar **lisp-macros*  nil "All macros that *LISP defines")
(defvar **lisp-*defuns* nil "All functions defined by *DEFUN within *LISP")
(defvar **lisp-functions* nil "All functions that *LISP defines")
(defvar **lisp-variables* nil "All variables that *LISP defines")
(defvar **lisp-exported-type-symbols* nil "All symbolic pvar types that *LISP defines")
(defvar **lisp-other-exported-symbols* nil "Any other symbols that *LISP defines")
(defvar *all-exported-symbols* nil "All symbols exported from the *LISP package")


;;; Create all the exportable symbols and export them


(eval-when (compile load eval)
  

(setq **lisp-macros* '(

	*LET *LET* *ALL *WHEN *IF *COND *SET *DEFUN *CASE *ECASE
	*PROCLAIM *DEFVAR WITH-CSS-SAVED DO-FOR-SELECTED-PROCESSORS 
	*SETF ALIAS!! *COMPILE *DEFSTRUCT *FUNCALL *APPLY
	IF!! COND!! CASE!! ECASE!!
	PREF!! PREF-GRID!! PREF-GRID-RELATIVE!!
	*COLD-BOOT *WARM-BOOT
	PRETTY-PRINT-PVAR PPP
	PRETTY-PRINT-PVAR-IN-CURRENTLY-SELECTED-SET PPP-CSS
	WITH-PARIS-FROM-*LISP WITH-*LISP-FROM-PARIS
     ))


(setq **lisp-*defuns* '(
	*INCF *DECF *SUM *LOGIOR *LOGAND *MIN *MAX *AND *OR
	*SORT
	PVAR-TO-ARRAY PVAR-TO-ARRAY-GRID ARRAY-TO-PVAR ARRAY-TO-PVAR-GRID
	*PSET *PSET-GRID *PSET-GRID-RELATIVE
	*MAP 
	*ARRAY-ELEMENT-TYPE *ARRAY-ELEMENT-TYPES
	*ARRAY-RANK *ARRAY-DIMENSION 
	*ARRAY-DIMENSIONS 
	*ARRAY-TOTAL-SIZE 
	*ADJUSTABLE-ARRAY-P
	*ARRAYP *VECTORP 
	*ARRAY-HAS-FILL-POINTER-P 
	))

(setq **lisp-functions* '(

	PVARP DESCRIBE-PVAR 
	PVAR-NAME PVAR-TYPE PVAR-PLIST PVAR-LOCATION
	!! +!! *!! -!! /!! 1+!! 1-!!
	ALLOCATE!! *DEALLOCATE *DEALLOCATE-*DEFVARS
	LOGNOT!! LOGAND!! LOGIOR!! LOGXOR!! LOGEQV!! NOT!! NULL!!
	LOGNAND!! LOGNOR!! LOGANDC1!! LOGANDC2!! LOGORC1!! LOGORC2!!
	BOOLE!! GCD!! LCM!!
	FFLOOR!! FCEILING!! FTRUNCATE!! FROUND!!
	SCALE-FLOAT!! FLOAT-SIGN!!
	LOGTEST!! LOGBITP!! LOGCOUNT!! INTEGER-LENGTH!! MASK-FIELD!!
	AND!! OR!! XOR!!
	EQL!! EQ!! EQUALP!!
	=!! <!! >!! <=!! >=!! /=!!
	NUMBERP!! INTEGERP!! FLOATP!! ZEROP!! ODDP!! EVENP!!
	PLUSP!! MINUSP!!
	SIGNUM!! RANDOM!! ENUMERATE!! ABS!! ROT!!
	SIN!! COS!! TAN!! ATAN!! LOG!! EXP!! EXPT!! ASIN!! ACOS!!
	SINH!! COSH!! TANH!! ASINH!! ACOSH!! ATANH!!
	COMPLEXP!! REALPART!! IMAGPART!! PHASE!! CONJUGATE!!
	COERCE!!
	RANK!! SORT!! SCAN!! SCAN-GRID!! 
	MIN!! MAX!!
	LOAD-BYTE!! DEPOSIT-BYTE!!
	ASH!! MOD!! REM!! FLOAT!! SQRT!! ISQRT!!
	CEILING!! FLOOR!! TRUNCATE!! ROUND!!
	CHARACTERP!! STANDARD-CHAR-P!! GRAPHIC-CHAR-P!! STRING-CHAR-P!!
	ALPHA-CHAR-P!! UPPER-CASE-P!! LOWER-CASE-P!! BOTH-CASE-P!!
	ALPHANUMERICP!!	CHAR-CODE!! CHAR-UPCASE!! CHAR-DOWNCASE!! INT-CHAR!!
	DIGIT-CHAR-P!!
	CHAR=!! CHAR<!!	CHAR>!!	CHAR<=!! CHAR>=!!
	CHAR-EQUAL!! CHAR-LESSP!! CHAR-GREATERP!! CHAR-NOT-LESSP!! CHAR-NOT-GREATERP!!
	PREF PREF-GRID
	CUBE-FROM-GRID-ADDRESS GRID-FROM-CUBE-ADDRESS DIMENSION-SIZE
	SELF-ADDRESS!! SELF-ADDRESS-GRID!!
	CUBE-FROM-GRID-ADDRESS!! GRID-FROM-CUBE-ADDRESS!!
	OFF-GRID-BORDER-P!! OFF-GRID-BORDER-RELATIVE-P!!
	GRID!! GRID-RELATIVE!! GRID
	MAKE-ARRAY!! VECTOR!! TYPED-VECTOR!! AREF!! SVREF!!
	ARRAY-RANK!! ARRAY-DIMENSION!!
	ARRAY-DIMENSIONS!!
	ARRAY-TOTAL-SIZE!!
	ARRAY-IN-BOUNDS-P!! ARRAY-ROW-MAJOR-INDEX!!
	BIT-AND!! BIT-IOR!! BIT-XOR!! BIT-EQV!! BIT-NAND!! BIT-NOR!!
	BIT-ANDC1!! BIT-ANDC2!! BIT-ORC1!! BIT-ORC2!! BIT-NOT!!
	ARRAY-PVAR-P VECTOR-PVAR-P
	ARRAYP!! VECTORP!!
	ARRAY-HAS-FILL-POINTER-P!!
	LIST-OF-ACTIVE-PROCESSORS LOAP
	ADD-INITIALIZATION DELETE-INITIALIZATION
	TEST-*LISP
     ))


(setq **lisp-variables* '(

	T!! NIL!!
	*NUMBER-OF-PROCESSORS-LIMIT* *LOG-NUMBER-OF-PROCESSORS-LIMIT*
        *NUMBER-OF-DIMENSIONS* *CURRENT-CM-CONFIGURATION*
	*BEFORE-*COLD-BOOT-INITIALIZATIONS* *BEFORE-*WARM-BOOT-INITIALIZATIONS*
	*AFTER-*COLD-BOOT-INITIALIZATIONS* *AFTER-*WARM-BOOT-INITIALIZATIONS*
	*PPP-DEFAULT-FORMAT* *PPP-DEFAULT-END* *PPP-DEFAULT-START*
	*PPP-DEFAULT-TITLE* *PPP-DEFAULT-ORDERING* *PPP-DEFAULT-PER-LINE*
	*PPP-DEFAULT-PROCESSOR-LIST* *PPP-DEFAULT-MODE*
	*PPP-DEFAULT-GRID-START* *PPP-DEFAULT-GRID-START*
	*ARRAY-RANK-LIMIT *ARRAY-DIMENSION-LIMIT *ARRAY-TOTAL-SIZE-LIMIT
     ))


(setq **lisp-exported-type-symbols* '(

	PVAR BOOLEAN
        BOOLEAN-PVAR SIGNED-PVAR FIELD-PVAR UNSIGNED-PVAR
	FLOAT-PVAR SINGLE-FLOAT-PVAR DOUBLE-FLOAT-PVAR
	SHORT-FLOAT-PVAR LONG-FLOAT-PVAR NUMBER-PVAR GENERAL-PVAR
	DEFINED-FLOAT SHORT-FLOAT-PVAR SINGLE-FLOAT-PVAR
	DOUBLE-FLOAT-PVAR LONG-FLOAT-PVAR EXTENDED-FLOAT-PVAR
	SHORT-FLOAT-MANTISSA SINGLE-FLOAT-MANTISSA
	DOUBLE-FLOAT-MANTISSA LONG-FLOAT-MANTISSA EXTENDED-FLOAT-MANTISSA
	SHORT-FLOAT-EXPONENT SINGLE-FLOAT-EXPONENT
	DOUBLE-FLOAT-EXPONENT LONG-FLOAT-EXPONENT EXTENDED-FLOAT-EXPONENT

	))


(setq **lisp-other-exported-symbols* '(

	*OPTIMIZE
	COPY!! RETURN-PVAR-P
	*COMPILEP* *WARNING-LEVEL* *INCONSISTENCY-ACTION* *SAFETY*
	*SLC-PRINT-LENGTH* *OPTIMIZE-BINDINGS* *OPTIMIZE-PEEPHOLE*
	*PULL-OUT-SUBEXPRESSIONS* *USE-PARIS-MACROS* *USE-ALWAYS-INSTRUCTIONS*
	*MACHINE-TYPE* *COMPILING*

	))

)

(eval-when (compile load eval)

  ;; the eval is here because KCL does not like
  ;; export statements just anywhere when it is
  ;; compiling...

  (eval
    '(import
       (setq *all-exported-symbols*
	     (append **lisp-macros*
		     **lisp-*defuns*
		     **lisp-functions*
		     **lisp-variables*
		     **lisp-exported-type-symbols*
		     **lisp-other-exported-symbols*
		     ))
       (find-package '*LISP)
       ))
  (eval '(export *all-exported-symbols* '*LISP))
  )

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



  
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;; DECLARATIONS FOR ALL EXTERNAL VARIABLES SPECIFIED BY THE *LISP LANGUAGE


(DEFVAR *CURRENT-CM-CONFIGURATION* NIL "A list of the dimensions of the machine")

(DEFVAR *NUMBER-OF-DIMENSIONS* NIL
  "User visible variable defining the number of dimensions in the CM")

(DEFVAR T!!)
(DEFVAR NIL!!)

(DEFVAR *NUMBER-OF-PROCESSORS-LIMIT* NIL
  "User visible variable defining number of processors available")
(DEFVAR *LOG-NUMBER-OF-PROCESSORS-LIMIT* NIL
  "User visible variable defining logarithm of machine size.")

(DEFVAR *BEFORE-*COLD-BOOT-INITIALIZATIONS*  NIL "These get evaled before each *Cold-Boot")
(DEFVAR *BEFORE-*WARM-BOOT-INITIALIZATIONS*  NIL "These get evaled before each *Warm-Boot")
(DEFVAR *AFTER-*COLD-BOOT-INITIALIZATIONS*  NIL "These get evaled after each *Cold-Boot")
(DEFVAR *AFTER-*WARM-BOOT-INITIALIZATIONS*  NIL "These get evaled after each *Warm-Boot")

(DEFVAR *PPP-DEFAULT-MODE* :cube "Default value for keyword argument :mode to PPP")
(DEFVAR *PPP-DEFAULT-FORMAT* "~S " "Default value for keyword argument :format to PPP")
(DEFVAR *PPP-DEFAULT-PER-LINE* nil "Default value for keyword argument :per-line to PPP")
(DEFVAR *PPP-DEFAULT-TITLE* nil "Default value for keyword argument :title to PPP")
(DEFVAR *PPP-DEFAULT-START* 0 "Default value for keyword argument :start to PPP")
(DEFVAR *PPP-DEFAULT-END* *number-of-processors-limit*
  "Default value for keyword argument :end to PPP")
(DEFVAR *PPP-DEFAULT-GRID-START* nil)
(DEFVAR *PPP-DEFAULT-GRID-END* nil)
(DEFVAR *PPP-DEFAULT-ORDERING* nil)
(DEFVAR *PPP-DEFAULT-PROCESSOR-LIST* nil)

(DEFVAR *ARRAY-RANK-LIMIT nil)
(DEFVAR *ARRAY-TOTAL-SIZE-LIMIT nil)
(DEFVAR *ARRAY-DIMENSION-LIMIT nil)

(DEFVAR *SPEED* 0)
(DEFVAR *SPACE* 0)
(DEFVAR *SAFETY* 0)
(DEFVAR *COMPILATION-SPEED* 0)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;; DEFTYPE DECLARATIONS FOR ALL PVAR TYPES


(eval-when (compile load eval)
(defconstant short-float-mantissa 15)
(defconstant short-float-exponent 8)
(defconstant single-float-mantissa 23)
(defconstant single-float-exponent 8)
(defconstant double-float-mantissa 52)
(defconstant double-float-exponent 11)
(defconstant long-float-mantissa double-float-mantissa) ; maybe use ieee proposed mantissa length.
(defconstant long-float-exponent double-float-exponent)
)


(deftype boolean-pvar ()
  `(pvar boolean))

(deftype signed-pvar (&optional (width 32))  ; * instead of 32 when general pvars. jwm.
  `(pvar (signed-byte ,width)))

(deftype field-pvar (&optional (width 32))
  `(pvar (unsigned-byte ,width)))

(deftype unsigned-pvar (&optional (width 32))
  `(pvar (unsigned-byte ,width)))

(deftype float-pvar (&optional (mantissa SINGLE-FLOAT-MANTISSA) (exponent SINGLE-FLOAT-EXPONENT))
  `(pvar (defined-float ,mantissa ,exponent)))

(deftype short-float-pvar ()
  `(pvar short-float))

(deftype single-float-pvar ()
  `(pvar single-float))

(deftype double-float-pvar ()
  `(pvar double-float))

(deftype long-float-pvar ()
  `(pvar long-float))

(deftype number-pvar ()
  `(pvar number))

(deftype general-pvar ()
  `(pvar t))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;; A FEW MISCELLANEOUS ITEMS


;;;; To conditionalize code, we put the symbols *LISP-SIMULATOR or *LISP-HARDWARE
;;;; onto the *FEATURES* list.  Unfortunately, various implementations have
;;;; decided to do things a bit differently, some using keywords and some not.
;;;; This defines a portable mechanism for adding new features.

(eval-when (compile load eval)
  (defun proper-symbol-for-*features* (x)
    #+(OR SYMBOLICS LUCID EXCL)
    (intern (symbol-name x) (find-package "KEYWORD"))
    #+(OR KCL VAXLISP)
    x
   )
  (defun add-new-feature-to-*features* (x)
    (pushnew (proper-symbol-for-*features* x) *features*)
   ))
