; make-xakcl.lsp         Hiep Huu Nguyen                      27 Aug 92

; Copyright (c) 1992, The University of Texas at Austin.  All rights reserved.
; See the file "copyright" for full copyright statement.


;;this file contains the function make-xakcl which makes xakcl
;;the files that are needed are Xlib.o, Xutil.o Xutil-2.o ...

;;the default is for SUN4:

(defparameter *libs* " -L/lusr/lib/X11 -L/lusr/lib -L/usr/lib -L/usr/lib/X11" )


;;this function links the Xakcl library to akcl
;;use this to create Xakcl.  save the lisp 
;;image with (save "Xakcl")
(defun make-xakcl()
  
  (si::faslink "Xlib.o"  (concatenate 'string "-x " *libs* "  -lX11 -lc"))
  
  (si::faslink "Xutil.o"
	       (concatenate 'string  "Xutil-2.o -x " *libs* "  -lX11 -lc") )
  
  ;;can be combined into one file
  (si::faslink "defentry-events.o"
	       (concatenate 'string   "Events.o -x " *libs* "  -lX11 -lc") )
  
  (si::faslink "Xstruct.o"
	       (concatenate 'string   "XStruct-2.o -x " *libs* "  -lX11 -lc") )

  
  (si::faslink "XStruct-l-3.o"
	       (concatenate 'string  "XStruct-4.o  -x " *libs* "  -lX11 -lc"))
  
  (si::faslink "general.o"
	       (concatenate 'string  "general-c.o -x  " *libs* "  -lX11 -lc"))

  ;;this can be made into a loadable file

  (load "X.o")
  (load "XAtom.o") 
  (load "keysymdef.o") 
  (load "X10.o")
  (save "Xakcl"))


(defun compile-xakcl ()
  (compile-file "Xlib.lsp")
  (compile-file "Xutil.lsp")
  (compile-file "X.lsp")
  (compile-file "XAtom.lsp")
  (compile-file "defentry-events.lsp")
  (compile-file  "Xstruct.lsp")
  (compile-file "XStruct-l-3.lsp") 
  (compile-file "general.lsp")
  (compile-file "keysymdef.lsp")
  (compile-file "X10.lsp")  
  (system "make")
  )
