/*
    instance.c -- CLOS interface.
*/
/*
 *  Copyright (c) 1990, Giuseppe Attardi.
 *
 *  ECoLisp is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  See file '../Copyright' for full details.
 */


#include "config.h"

/******************************* EXPORTS ******************************/

object  Sprint_object;

/******************************* ------- ******************************/


object
allocate_instance(object class, int size)
{	object x = alloc_object(t_instance);
	int i;
	x->in.in_slots = NULL;	/* for GC sake */
	x->in.in_class = class;
	x->in.in_length = size;
	x->in.in_slots = (object *)alloc_relblock(sizeof(object)*size,
						 sizeof(object));
	for (i = 0;  i < size;  i++)
		x->in.in_slots[i] = OBJNULL;
	return(x);
      }

siLallocate_instance(int narg, object class, object size)
{
	check_arg(2);

	if (type_of(class) != t_instance)
	  FEwrong_type_argument(Sinstance, class);

	if (!FIXNUMP(size) || (fix(size) < 0))
	  FEerror("~S is not a non-negative number.", 1, size);
	VALUES(0) = allocate_instance(class, fix(size));
	RETURN(1);
}

siLchange_instance(int narg, object x, object class, object size)
{
	int nslot, i;

	check_arg(3);

	if (type_of(x) != t_instance)
	  FEwrong_type_argument(Sinstance, x);

	if (type_of(class) != t_instance)
	  FEwrong_type_argument(Sinstance, class);

	if (!FIXNUMP(size) || (nslot = fix(size)) < 0)
	  FEerror("~S is not a non-negative number.", 1, size);

	x->in.in_class = class;
	x->in.in_length = nslot;
	x->in.in_slots = (object *)alloc_relblock(sizeof(object)*nslot,
						 sizeof(object));
	for (i = 0;  i < nslot;  i++)
		x->in.in_slots[i] = OBJNULL;
	RETURN(1);
}

siLinstance_class(int narg, object x)
{
	check_arg(1);

	if (type_of(x) != t_instance)
		FEwrong_type_argument(Sinstance, x);
	VALUES(0) = x->in.in_class;
	RETURN(1);
}

siLinstance_class_set(int narg, object x, object y)
{
	check_arg(2);

	if (type_of(x) != t_instance)
		FEwrong_type_argument(Sinstance, x);
	if (type_of(y) != t_instance)
		FEwrong_type_argument(Sinstance, y);
	x->in.in_class = y;
	VALUES(0) = x;
	RETURN(1);
}

object instance_ref(object x, int i)
{
	if (type_of(x) != t_instance)
		FEwrong_type_argument(Sinstance, x);
	if (i >= x->in.in_length || i < 0)
	        FEerror("~S is an illegal slot index1.",1,i);
	return(x->in.in_slots[i]);
}

siLinstance_ref(int narg, object x, object index)
{
	int i;
	check_arg(2);

	if (type_of(x) != t_instance)
		FEwrong_type_argument(Sinstance, x);
	if (!FIXNUMP(index) ||
	    (i = fix(index)) < 0 || i >= x->in.in_length)
		FEerror("~S is an illegal slot index.", 1, index);
	VALUES(0) = x->in.in_slots[i];
	RETURN(1);
}

object instance_set(object x, int i, object v)
{
        if (type_of(x) != t_instance)
                FEwrong_type_argument(Sinstance, x);
	if (i >= x->in.in_length || i < 0)
	        FEerror("~S is an illegal slot index2.", 1, i);
	x->in.in_slots[i] = v;
	return(v);
}

siLinstance_set(int narg, object x, object index, object value)
{
	int i;
	check_arg(3);

	if (type_of(x) != t_instance)
		FEwrong_type_argument(Sinstance, x);
	if (!FIXNUMP(index) ||
	    (i = fix(index)) >= x->in.in_length || i < 0)
		FEerror("~S is an illegal slot index.", 1, index);
	x->in.in_slots[i] = value;
	VALUES(0) = value;
	RETURN(1);
}

siLinstancep(int narg, object x)
{
	check_arg(1);
	VALUES(0) = (type_of(x) == t_instance) ? Ct : Cnil;
	RETURN(1);
}

siLsl_boundp(int narg, object x)
{

	check_arg(1);

	VALUES(0) = (x == OBJNULL) ? Cnil : Ct;
	RETURN(1);
}

siLsl_makunbound(int narg, object x, object index)
{
	int i;
	check_arg(2);

	if (type_of(x) != t_instance)
		FEwrong_type_argument(Sinstance, x);
	if (!FIXNUMP(index) ||
	    (i = fix(index)) >= x->in.in_length || i < 0)
		FEerror("~S is an illegal slot index.", 1, index);
	x->in.in_slots[i] = OBJNULL;
	VALUES(0) = x;
	RETURN(1);
}


init_instance()
{
	Sprint_object
	= make_ordinary("PRINT-OBJECT");
	enter_mark_origin(&Sprint_object);

	make_si_function("ALLOCATE-INSTANCE", siLallocate_instance);
	make_si_function("CHANGE-INSTANCE", siLchange_instance);
	make_si_function("INSTANCE-REF", siLinstance_ref);
	make_si_function("INSTANCE-SET", siLinstance_set);
	make_si_function("INSTANCE-CLASS", siLinstance_class);
	make_si_function("INSTANCE-CLASS-SET", siLinstance_class_set);
	make_si_function("INSTANCEP", siLinstancep);
	make_si_function("SL-BOUNDP", siLsl_boundp);
	make_si_function("SL-MAKUNBOUND", siLsl_makunbound);

}
