/*
    cfun.c -- Compiled functions.
*/
/*
    Copyright (c) 1984, Taiichi Yuasa and Masami Hagiya.
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/


#include "config.h"

#ifdef PDE
extern object Sdefun, Sdefmacro;
#endif PDE

object
make_cfun(int (*self)(), object name, struct codeblock *cblock)
{
	object cf;

	cf = alloc_object(t_cfun);
	cf->cf.cf_self = self;
	cf->cf.cf_name = name;
	cf->cf.cf_block = cblock;
	return(cf);
}

object
make_cclosure(int (*self)(), object env, struct codeblock *block)
{
	object cc;

	cc = alloc_object(t_cclosure);
	cc->cc.cc_self = self;
	cc->cc.cc_env = env;
	cc->cc.cc_block = block;
	return(cc);
}

#ifdef PDE
object siSrecord_fun_entry;

siLrecord_fun_entry() {};

record_fun_entry(object sym, char *entry)
{
    (void)ifuncall(3, siSrecord_fun_entry, sym, MAKE_FIXNUM(entry));
}
#endif PDE

object
MF(object sym, int (*self)(), struct codeblock *block)
{
	object cf;

	if (type_of(sym) != t_symbol)
		not_a_symbol(sym);
	if (SPECIAL(sym) && sym->s.s_mflag)
		sym->s.s_sfdef = NOT_SPECIAL;
	clear_compiler_properties(sym);
#ifdef PDE
	record_source_pathname(sym, Sdefun);
	record_fun_entry(sym, self);
#endif PDE
	cf = alloc_object(t_cfun);
	cf->cf.cf_self = self;
	cf->cf.cf_name = sym;
	cf->cf.cf_block = block;
	sym->s.s_gfdef = cf;
	sym->s.s_mflag = FALSE;
}

/*
 *----------------------------------------------------------------------
 *
 *  MFkey --
 *	in the keyword table of the function, replaces indexes into the VV
 *	vector with the actual symbols present there.
 *
 *  Returns:
 *	the cfun object
 *
 *----------------------------------------------------------------------
 */
init_keywords(int nkey, intUobject *keys, struct codeblock *block)
{ int i; object *VV = block->cd_data->v.v_self;
  for (i = 0; i < nkey; i++)
    keys[i].o = VV[keys[i].i];
}

object
MFkey(object sym, int (*self)(), struct codeblock *block,
      int nkey, intUobject *keys)
{ init_keywords(nkey, keys, block);
  return(MF(sym, self, block));
}

object
MM(object sym, int (*self)(), struct codeblock *block)
{
	object cf;

	if (type_of(sym) != t_symbol)
		not_a_symbol(sym);
	if (SPECIAL(sym) && sym->s.s_mflag)
		sym->s.s_sfdef = NOT_SPECIAL;
	clear_compiler_properties(sym);
#ifdef PDE
	record_source_pathname(sym, Sdefmacro);
#endif PDE
	cf = alloc_object(t_cfun);
	cf->cf.cf_self = self;
	cf->cf.cf_name = sym;
	cf->cf.cf_block = block;
	sym->s.s_gfdef = cf;
	sym->s.s_mflag = TRUE;
}

object
make_function(char *s, int (*f)())
{
	object x;

	x = make_ordinary(s);
	x->s.s_gfdef = make_cfun(f, x, NULL);
	x->s.s_mflag = FALSE;
	return(x);
}

object
make_si_function(char *s, int (*f)())
{
	object x;

	x = make_si_ordinary(s);
	x->s.s_gfdef = make_cfun(f, x, NULL);
	x->s.s_mflag = FALSE;
	return(x);
}

object
make_special_form(char *s, int (*f)())
{
	object x;
	x = make_ordinary(s);
	x->s.s_sfdef = f;
	return(x);
}

siLcompiled_function_name(int narg, object fun)
{
	check_arg(1);

	if (type_of(fun) == t_cfun)
		VALUES(0) = fun->cf.cf_name;
	else if (type_of(fun) == t_cclosure)
		VALUES(0) = Cnil;
	else
		FEerror("~S is not a compiled-function.", 1, fun);
	RETURN(1);
}

init_cfun()
{
	make_si_function("COMPILED-FUNCTION-NAME",
			 siLcompiled_function_name);
#ifdef PDE
	siSrecord_fun_entry
	  = make_si_ordinary("RECORD-FUNCTION-ENTRY");
	make_si_function("RECORD-FUNCTION-ENTRY", siLrecord_fun_entry);
#endif
}
