/*
    backq.c -- Backquote mechanism.
*/
/*
    Copyright (c) 1984, Taiichi Yuasa and Masami Hagiya.
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/

#include "config.h"

/******************************* EXPORTS ******************************/
#ifndef THREADS
int backq_level;
#endif
/******************************* ------- ******************************/

#define	read_char(in)	(*read_ch_fun)(in)

/* #define attach(x)	(*px = CONS(x, *px)) */
#define attach(s)	CDR(x) = CONS(s, CDR(x));

#define	QUOTE	1
#define	EVAL	2
#define	LIST	3
#define	LISTA	4
#define	APPEND	5
#define	NCONC	6

object siScomma;
object siScomma_at;
object siScomma_dot;

object Slist;
object SlistA;
object Sappend;
object Snconc;

object Sapply;
object Svector;

object kwote(x)
object x;
{
	if (type_of(x) == t_symbol &&
	    ((enum stype)x->s.s_stype != stp_constant || x->s.s_dbind != x)
	    || type_of(x) == t_cons || type_of(x) == t_vector)
	   return(CONS(Squote, CONS(x, Cnil)));
	else return(x);
}

/*
	Backq_cdr(&x) puts result into x and returns one of

		QUOTE		the form should be quoted
		EVAL		the form should be evaluated
		LIST		the form should be applied to LIST
		LISTA		the form should be applied to LIST*
		APPEND		the form should be applied to APPEND
		NCONC		the form should be applied to NCONC
*/
int
backq_cdr(px)
object *px;
{
	object x = *px;
	int a, d;

	cs_check(px);

	if (type_of(x) != t_cons)
		return(QUOTE);
	if (CAR(x) == siScomma) {
		*px = CDR(x);
		return(EVAL);
	}
	if (CAR(x) == siScomma_at || CAR(x) == siScomma_dot)
		FEerror(",@ or ,. has appeared in an illegal position.", 0);
	{ object ax, dx;
	  a = backq_car(&CAR(x));
	  d = backq_cdr(&CDR(x));
	  ax = CAR(x); dx = CDR(x);
	  if (d == QUOTE)
		switch (a) {
		case QUOTE:
			return(QUOTE);

		case EVAL:
			if (Null(dx))
				return(LIST);
			if (type_of(dx) == t_cons && Null(CDR(dx))) {
				CDR(x) = CONS(kwote(CAR(dx)), Cnil);
				return(LIST);
			}
			CDR(x) = CONS(kwote(dx), Cnil);
			return(LISTA);

		case APPEND:
		case NCONC:
			if (Null(dx)) {
				*px = ax;
				return(EVAL);
			      }
			CDR(x) = CONS(kwote(dx), Cnil);
			return(a);

		default:
			error("backquote botch");
		}
	  if (d == EVAL)
		switch (a) {
		case QUOTE:
			CAR(x) = kwote(ax);
			CDR(x) = CONS(dx, Cnil);
			return(LISTA);

		case EVAL:
			CDR(x) = CONS(dx, Cnil);
			return(LISTA);

		case APPEND:
		case NCONC:
			CDR(x) = CONS(dx, Cnil);
			return(a);

		default:
			error("backquote botch");
		}
	  if (d == a)
		return(d);
	  switch (d) {
	  case LIST:
		if (a == QUOTE) {
			CAR(x) = kwote(ax);
			return(LIST);
		}
		if (a == EVAL)
			return(LIST);
		attach(Slist);
		break;

	  case LISTA:
		if (a == QUOTE) {
			CAR(x) = kwote(ax);
			return(LISTA);
		}
		if (a == EVAL)
			return(LISTA);
		attach(SlistA);
		break;

	  case APPEND:
		attach(Sappend);
		break;

	  case NCONC:
		attach(Snconc);
		break;

	  default:
		error("backquote botch");
	  }
	  switch (a) {
	  case QUOTE:
		CAR(x) = kwote(ax);
		CDR(x) = CONS(CDR(x), Cnil);
		return(LISTA);

	  case EVAL:
		CDR(x) = CONS(CDR(x), Cnil);
		return(LISTA);

	  case APPEND:
	  case NCONC:
		CDR(x) = CONS(CDR(x), Cnil);
		return(a);

	  default:
		error("backquote botch");
	  }
	}
}

/*
	Backq_car(&x) puts result into x and returns one of

		QUOTE		the form should be quoted
		EVAL		the form should be evaluated
		APPEND		the form should be appended
				into the outer form
		NCONC		the form should be nconc'ed
				into the outer form
*/
int
backq_car(px)
object *px;
{
	object x = *px;
	int d;

	cs_check(px);

	if (type_of(x) != t_cons)
		return(QUOTE);
	if (CAR(x) == siScomma) {
		*px = CDR(x);
		return(EVAL);
	}
	if (CAR(x) == siScomma_at) {
		*px = CDR(x);
		return(APPEND);
	}
	if (CAR(x) == siScomma_dot) {
		*px = CDR(x);
		return(NCONC);
	}
	d = backq_cdr(px);
	switch (d) {
	case QUOTE:
	case EVAL:
		return(d);

	case LIST:
/*		attach(Slist); */
		*px = CONS(Slist, *px);
		break;

	case LISTA:
/*		attach(SlistA); */
		*px = CONS(SlistA, *px);
		break;

	case APPEND:
/*		attach(Sappend); */
		*px = CONS(Sappend, *px);
		break;

	case NCONC:
/*		attach(Snconc); */
		*px = CONS(Snconc, *px);
		break;

	default:
		error("backquote botch");
	}
	return(EVAL);
}

object
backq(x)
object x;
{
	int a;

	a = backq_car(&x);
	if (a == APPEND || a == NCONC)
		FEerror(",@ or ,. has appeared in an illegal position.", 0);
	if (a == QUOTE)
		return(kwote(x));
	return(x);
}

Lcomma_reader(int narg, object in, object c)
{
	object x, y;
	
	check_arg(2);
	if (backq_level <= 0)
		FEerror("A comma has appeared out of a backquote.", 0);
	c = peek_char(FALSE, in);
	if (c == code_char('@')) {
		x = siScomma_at;
		read_char(in);
	} else if (c == code_char('.')) {
		x = siScomma_dot;
		read_char(in);
	} else
		x = siScomma;
	--backq_level;
	y = read_object(in);
	backq_level++;
	VALUES(0) = CONS(x, y);
	RETURN(1);
}

Lbackquote_reader(int narg, object in, object c)
{
	check_arg(2);
	backq_level++;
	in = read_object(in);
	--backq_level;
	VALUES(0) = backq(in);
	RETURN(1);
}

#define	make_cf(f)	make_cfun((f), Cnil, NULL);

init_backq()
{
	object r;

	siScomma = make_si_ordinary(",");
	enter_mark_origin(&siScomma);
	siScomma_at = make_si_ordinary(",@");
	enter_mark_origin(&siScomma_at);
	siScomma_dot = make_si_ordinary(",.");
	enter_mark_origin(&siScomma_dot);

	Slist = make_ordinary("LIST");
	enter_mark_origin(&Slist);
	SlistA = make_ordinary("LIST*");
	enter_mark_origin(&SlistA);
	Sappend = make_ordinary("APPEND");
	enter_mark_origin(&Sappend);
	Snconc = make_ordinary("NCONC");
	enter_mark_origin(&Snconc);

	Sapply = make_ordinary("APPLY");
	enter_mark_origin(&Sapply);
	Svector = make_ordinary("VECTOR");
	enter_mark_origin(&Svector);

	r = standard_readtable;
	r->rt.rt_self['`'].rte_chattrib = cat_terminating;
	r->rt.rt_self['`'].rte_macro = make_cf(Lbackquote_reader);
	r->rt.rt_self[','].rte_chattrib = cat_terminating;
	r->rt.rt_self[','].rte_macro = make_cf(Lcomma_reader);

	backq_level = 0;
}
