
#include <aes.h>
#include <vdi.h>

#define BUSY_BEE 2

#define MIN_WIDTH		100
#define MIN_HEIGHT		8

#define MAXWINDOWS 8

#define WINDOW struct window

/*
   #[ tools.h :
#include "tools.h"
   Useful definitions, include files etc.
*/

/*
   #[ configur.h :
#include "configur.h"
	Figure out whether we are using MPW or LSC.
	We assume that if 'unix' and 'MSDOS' are undefined,
	this is the Macintosh; of the two compilers used there,
	MPW defines 'macintosh', while LSC doesn't.
	For the benefit of portable code we define 'macintosh'
	when we find this is LSC; all LSC or MPW-dependent code
	should test for 'LSC' or 'MPW', while general Mac-specific code
	should test for 'macintosh'.
	In order that this file be re-entrant, we also if LSC is already
	defined.

	Note: on the Atari this works because both MW-C and turbo C take
	the LSC definitions in tools.h
*/

#ifndef unix
#ifndef MSDOS
#ifndef LSC
#ifndef macintosh
#define LSC
#define macintosh
#else
#ifndef MPW
#define MPW
#endif
#endif
#endif
#endif
#endif
/*
   #] configur.h :
*/

/* C library stuff: */

#include <stdio.h> /* Must be before stdwin.h because it defines NULL */
#include <ctype.h>

#ifdef SYSV

#include <string.h>

#else

#ifdef ANSI
#include <string.h>
#else
#include <strings.h>
#endif
#ifndef LSC
#define strchr index
#define strrchr rindex
#endif

#endif

#ifdef ANSI
#include <stdlib.h>
#else
#ifdef THINK_C
void *malloc(), *calloc(), *realloc();
#else
char *malloc(), *calloc(), *realloc();
#endif
int free();
#endif

char *ctime();
#ifndef LSC
long time();
#endif

char *getenv();

#ifdef ANSI
#include <errno.h>
#else
extern int errno;
#endif

#ifndef ANSI
#ifdef NO_MEMCPY
#define memcpy(dest, src, n)	bcopy(src, dest, n)
#define memcmp(a, b, cnt)	bcmp(a, b, cnt)
#else
char *memcpy();
#endif
#endif

/* For getopt: */
extern int optind;
extern char * optarg;

/* Dynamic array macros: */

/*
   #[ l_defs.h :
#include "l_defs.h"
   Generic package to manipulate dynamic arrays represented like
   argc/argv (but not necessarily containing character pointers).
   Operations provided are macros that expand to groups of statements;
   their arguments should be side-effect-free.  The arguments argc and
   argv should be single identifiers, since they are assigned to.
   (L_DECLARE expands to a series of declarations.)

   This code was written because I found myself writing code very
   similar to it times and times over, or, worse, using fixed-length
   arrays out of laziness.  It's slow for large arrays (although this
   could be improved easily by rounding up the sizes passed to
   malloc/realloc), but this shouldn't be a problem for the applications
   I am currently using it for.  It sure helped me write some array
   processing code faster.

   Operations:

   L_DECLARE(argc, argv, type)		declare a list with element type 'type'
   L_INIT(argc, argv)			initialize a list
   L_DEALLOC(argc, argv)		deallocate a list
   L_SETSIZE(argc, argv, type, size)	set list to size 'size'
   L_EXTEND(argc, argv, type, count)	append 'count' unitinialized elements
   L_APPEND(argc, argv, type, elem)	append a given element
   L_REMOVE(argc, argv, type, index)	remove element number 'index'
   L_INSERT(argc, argv, type, index, elem)	insert 'elem' at 'index'
   L_SORT(argc, argv, type, compare)	sort the list ('compare' is a function)

   (There should also be operations to insert in the middle and to
   remove elements.)

   NB: the 'type' argument could be discarded (except for L_DECLARE)
   if we could live with warnings about assignments from malloc/realloc
   to other pointer types.

*/

/* Universal pointer; 'void *' for ANSI C, 'char *' for most others */

#ifdef THINK_C
#define _UNIVPTR void *
#endif

#ifdef __STDC__
#define _UNIVPTR void *
#define GOOD_REALLOC
#endif

#ifndef UNIVPTR
#define _UNIVPTR char *
#endif

#ifdef ANSI
#include <stdlib.h>
#else
extern _UNIVPTR malloc();
extern _UNIVPTR realloc();
#endif

#ifdef GOOD_REALLOC
#define _REALLOC(p, size) realloc(p, size)
#else
#define _REALLOC(p, size) ((p) ? realloc(p, size) : malloc(size))
#endif

#define L_DECLARE(argc, argv, type)	int argc= 0; type *argv= 0

#define L_INIT(argc, argv)		argc= 0; argv= 0

#define L_DEALLOC(argc, argv)		argc= 0; \
					if (argv != 0) { \
						free((char*)argv); \
						argv= 0; \
					}

#define L_SETSIZE(argc, argv, type, size) \
	argv= (type *) _REALLOC((_UNIVPTR) argv, \
		(unsigned) (size) * sizeof(type)); \
	argc= (argv == 0) ? 0 : size

#define L_EXTEND(argc, argv, type, count) \
	L_SETSIZE(argc, argv, type, argc+count)

#define L_APPEND(argc, argv, type, elem) \
	argv= (type *) _REALLOC((_UNIVPTR) argv, \
		(unsigned) (argc+1) * sizeof(type)); \
	if (argv == 0) \
		argc= 0; \
	else \
		argv[argc++]= elem

#define L_REMOVE(argc, argv, type, index) \
	{ \
		int k_; \
		for (k_= index+1; k_ < argc; ++k_) \
			argv[k_-1]= argv[k_]; \
		L_SETSIZE(argc, argv, type, argc-1); \
	}

#define L_INSERT(argc, argv, type, index, item) \
	{ \
		int k_; \
		L_SETSIZE(argc, argv, type, argc+1); \
		for (k_= argc-1; k_ > index; --k_) \
			argv[k_]= argv[k_-1]; \
		argv[index]= item; \
	}

#define L_SORT(argc, argv, type, compare) \
	qsort((_UNIVPTR)argv, argc, sizeof(type), compare)

/*
   #] l_defs.h :
*/

/* Boolean data type: */
#ifndef bool
#define bool int
#endif
#define tbool char	/* Tiny bool, used in structs or arrays */
#define FALSE 0
#define TRUE 1

/* Character shorthands: */
#define EOS '\0'
#define EOL '\n'

/* Copy string to malloc'ed memory: */
char *strdup();
char *strndup();

/* Other useful macros: */

#define CNTRL(x) ((x) & 0x1f) /* Usage: CNTRL('X') */

#define ABS(x) ((x) < 0 ? -(x) : (x))

#ifndef MIN
#define MIN(a, b) ((a) < (b) ? (a) : (b))
#endif
#ifndef MAX
#define MAX(a, b) ((a) > (b) ? (a) : (b))
#endif

#define CLIPMIN(var, min) if ((var) >= (min)) ; else (var)= (min)
#define CLIPMAX(var, max) if ((var) <= (max)) ; else (var)= (max)

/* Memory allocation macros: */

#define ALLOC(type) ((type*) malloc(sizeof(type)))
#define FREE(p) if(p){free((void *)(p)); (p) = 0;}
/* #define FREE(p) (((p) ? free((char*)(p)) : 0), (p)= 0) */

/* Array (re)allocation macros.
   RESIZE yields nonzero if the realloc succeeded. */

#define NALLOC(type, n) ((type*) malloc((unsigned)(n) * sizeof(type)))
#define RESIZE(var, type, n) \
	(var= (type *) realloc((char*)var, (n) * sizeof(type)))
/*
   #] tools.h :
*/

#include "stdwin.h"

struct menubar {
	int	nrmenus ;
	MENU	**menulist ;
} ;

struct ln {
	int	m ;
	int	it ;
} ;

struct w_pile {
	int x;
	int y;
	int w;
	int h;
	int console;
};

extern struct w_pile w_win_pile[];
extern int num_w_pile;

#define BAR	0x0110f0L
#define BOX	0x0ff10f0L
/*	(-1 << 16 | BLACK << 12 | WHITE << 8 | 1 << 7 | 7 << 4 | WHITE)       */

struct key__tab {
	int	id;
	int	item;
} ;

extern struct key__tab keytab[];

extern int	deflocal;
extern struct menubar globmenus;

extern int	barchanged;

extern struct ln m_link[];

extern OBJECT *menu;

#define msec	unsigned long

struct window {
		int 	tag ;			/* 16 bit 'tag' for the user				  */
		int 	handle ;		/* handle to the physical GEM window		  */
		char	*title ;		/* text in title bar of window				  */
		void	(*drawproc)(struct window *, int,int,int,int) ;
								/* pointer to draw procedure				  */
		int 	fulled ;		/* flag indicating zoomed window or not 	  */
		TEXTATTR		attr ;	/* local text attributes of window			  */
		int 	h, v ;			/* position of window upper left corner in scr*/
		int 	width ; 		/* width of window							  */
		int 	height ;		/* height of window 						  */
		int 	orgh, orgv ;	/* position of window upper left corner in doc*/
		int 	doc_width ; 	/* width of document						  */
		int 	doc_height ;	/* height of document						  */
		bool	needupdate ;	/* document needs an update 				  */
		int 	left, top ; 	/* first coordinate of changed rectangle	  */
		int 	right, bottom ; /* second	 "		"	   "	   "		  */
		msec	alarm ; 		/*
								** alarm time in milliseconds relative to last
								** time booted.
								*/
		struct menubar	mbar ;	/* local menus of window					  */
		bool	careton ;		/* show or remove text caret				  */
		int 	caret_h ;		/* horizontal position of caret 			  */
		int 	caret_v ;		/* vertical 	  "    "	"				  */
		int		console ;		/* Indicates if console (no borders)		  */
};

#define TRUE	1
#define FALSE	0

#define DOCTOSCR(win,doc_h,doc_v,scr_h,scr_v) { \
						scr_h = (doc_h) + (win->h - win->orgh) ; \
						scr_v = (doc_v) + (win->v - win->orgv) ; \
/*		wdebug ("  doc win org scr|h %3d %3d %3d %3d|v %3d %3d %3d %3d", \
		doc_h, win->h, win->orgh, scr_h, doc_v, win->v, win->orgv, scr_v) ; \
*/						}
#define SCRTODOC(win,scr_h,scr_v,doc_h,doc_v) { \
						doc_h = (scr_h) - (win->h - win->orgh) ; \
						doc_v = (scr_v) - (win->v - win->orgv) ; \
/*		wdebug ("  scr win org doc|h %3d %3d %3d %3d|v %3d %3d %3d %3d", \
		scr_h, win->h, win->orgh, doc_h, scr_v, win->v, win->orgv, doc_v) ; \
*/						}

#define BAR_HEIGHT		(w_ch_height + 2)

#define DEF_OPT 0xfef
#define CON_OPT 0x000

#define RECT	left, top, right, bottom
#define LEFT	0
#define TOP 	1
#define RIGHT	2
#define BOTTOM	3

#define CLK_TCK 200
#define MSTIME()		(clock () * (1000 / CLK_TCK))

extern WINDOW **winlist;
extern int nrwin;
extern WINDOW *active;

extern int vdi_handle;

extern int w_l_border;
extern int w_t_border;
extern int w_r_border;
extern int w_b_border;

extern int w_ch_width;
extern int w_ch_height;
extern int w_bx_width;
extern int w_bx_height;
extern int chheight;

extern int x_def, y_def, w_def, h_def;

extern int max_width;
extern int max_height;

extern int pix_width;
extern int pix_height;

extern int scr_width;
extern int scr_height;

extern bool mousedown[];
extern bool mouseoff;

extern WINDOW *drawing;

extern TEXTATTR	savetextattr;

extern int extrah;
extern int extrav;

extern int curr_interior;
extern int curr_color;
extern int curr_mode;

extern int w_min_v_pos;

extern w_poll_flag;
extern OBJECT *w_u_about;

typedef struct fontstr {
	int		id;
	int		pointsize;
	char	name[32];
	int		lowascii;
	int		hiascii;
	int		top;
	int		ascent;
	int		half;
	int		decent;
	int		bottom;
	int		widest;
	int		widestcell;
	int		leftoffset;
	int		rightoffset;
	int		thickening;
	int		underline;
	int		lmask;
	int		skewmask;
	int		flags;
	char	*hoffsettable;
	char	*coffsettable;
	char	*fontdata;
	int		totwidth;
	int		pixellines;
	struct fontstr *next;
} *FONT;

typedef struct workparm {
	struct workparm *next;
	FONT font;
} *WORKPARM;

extern WORKPARM vdiworkparams;
extern FONT oldfont;
extern FONT fontbuffer;

void resetfonts(void);
void addtobar(struct menubar *pbar,void *pm);
long mclock(void);
void addtoall(void *pm);
unsigned char **Keytbl(void *,void *,void *);
WINDOW *getwin(int handle);
void setclip(WINDOW *win,int flag,int left,int top,int right,int bottom);
void inVertrect(WINDOW *win,int left,int top,int right,int bottom);
int intersect(int *src,int *dest);
void rectsubt(int *a,int *b,int diff[][],int *nr_diff);
void wgetchange(WINDOW *win,int *pleft,int *ptop,int *pright,int *pbottom);
OBJECT *buildbar(WINDOW *win);
void draWcaret(WINDOW *win);
int vst_effects(int handle,int effect);
OBJECT *str_obj(char *prompt,char *buf,int buflen);
void rmcaret(void);
void showcaret(void);
void delmenubar(void);
int loadfont(char *name, char **oldfont);
void v_mtext(int,int,int,char *,int);
void setkey(int id,int item,int key);
void delofbar(struct menubar *pbar,void *pm);
void setscrollbars(WINDOW *);
void initmbar(WINDOW *);
bool getsrcdiff(WINDOW *win,int left,int top,int right,int bottom,int dh,int dv,int *snit,int diff[][],int *nr_diff);
void scrollby(WINDOW *win,int left,int top,int right,int bottom,int dh,int dv);
void menuupdate(void);
void checksc(EVENT *ep,int key);
void autoscroll(WINDOW *win,int h,int v);
void do_menu(EVENT *ep,int msg_buf[]);
void do_scroll(int msg_buf[]);
void wgetwinorigin(WINDOW *win,int *ph,int *pv);
void _setsize(WINDOW *win,int h,int v,int width,int height);

extern int w_no_erase;
extern void *w_rootmenu;
extern char *w_about;
extern TEDINFO linfi[];
extern int w_def_opt;
extern int w_from_con;
extern int w_min_height;
extern int ClickSpeed;

