#include <time.h>
#include "window.h"

#define DIST_CLICK      5
#define CLICK_TICKS     500L

extern int      vdi_handle ;

extern WINDOW   **winlist ;
extern int      nrwin ;
extern WINDOW   *active ;
static WINDOW   *lactive = (WINDOW *) NULL ;

static EVENT    levent = { WE_NULL } ;

extern void     menuupdate () ;
extern void     do_menu () ;
extern void     do_scroll () ;

static int      mupwaiting = FALSE ;
static msec     prev_tick = 0 ;
static int      prev_state = 0 ;
static int      prev_h = 10 ;
static int      prev_v = 10 ;
static int      nr_clicks = 0 ;
bool    mousedown = FALSE ;

bool    mouseoff = FALSE ;

static int      shape = ARROW ;
static int      oldshape = THIN_CROSS ;

static void     do_timer () ;
static bool     find_update () ;
static void     set_timer () ;
static void     do_keybd () ;
static void     do_button () ;
static void     do_messag () ;
static void     do_redraw () ;
static void     do_topped () ;
static void     do_closed () ;
static void     do_size () ;
static void     do_acces () ;

void
wungetevent (ep)
        EVENT   *ep ;
{
        levent = *ep ;
}

void
wgetevent (ep)
        EVENT   *ep ;
{
        int     which = (MU_TIMER | MU_KEYBD | MU_BUTTON | MU_MESAG | MU_M2) ;
                                        /* Which events are relevant          */
        int     nr_clicks = 1 ;         /* How many clicks are you waiting for*/
        int     what_button = 1 ;       /* Which button are you waiting for   */
        int     button_state ;          /* What button state are you waiting  */
        int     msg_buf[8] ;            /* Buffer for message returned        */
        unsigned int    lowtime ;       /* Low word for timer                 */
        int     hightime ;              /* High word for timer                */
        int     m_x, m_y, m_b, m_k ;    /* integers for Mouse                 */
        Mouse   mevnt_rec = {&m_x, &m_y, &m_b, &m_k} ;
                                        /* Mouse postion when event occured   */
        int     key_pressed ;           /* The key pressed                    */
        int     nr_times ;              /* Nr of times mouse entered state    */
        int     clickinout = 1 ;
        int     wininout = 0 ;
        Rect    clickrect ;
        Rect    winrect ;
        int     dummy = 0 ;
        int     rc ;

        menuupdate () ;

        if (levent.type != WE_NULL) {
                *ep = levent ;
                levent.type = WE_NULL ;
                return ;
        }

        if (mupwaiting) {
                ep->type = WE_MOUSE_UP ;
                ep->window = active ;
                ep->u.where.button = 1 ;
                ep->u.where.h = prev_h ;
                ep->u.where.v = prev_v ;
                ep->u.where.clicks = nr_clicks ;
                mupwaiting = mousedown = FALSE ;
                prev_tick = MSTIME () ;
                return ;
        }

        if (lactive != active && active != NULL) {
                ep->type = WE_ACTIVATE ;
                ep->window = active ;
                lactive = active ;
                wind_set (active->handle, WF_TOP, dummy, dummy, dummy, dummy) ;
                return ;
        }
        else
                lactive = active ;

        ep->type = WE_NULL ;

        do {
                set_timer (ep, &hightime, &lowtime) ;

                if (ep->type == WE_TIMER)
                        return ;

                button_state = 1 - prev_state ;

                if (mousedown) {        /* waiting for button up */
                        which |= MU_M1 ;
                        DOCTOSCR (active, prev_h, prev_v, clickrect.x,
                                                                clickrect.y) ;
                        clickrect.x -= 1 ;
                        clickrect.y -= 1 ;
                        clickrect.w = 3 ;
                        clickrect.h = 3 ;
                }
                else
                        which &= ~MU_M1 ;

                if (active != NULL) {
                        which |= MU_M2 ;

                        winrect.x = active->h ;
                        winrect.y = active->v ;
                        winrect.w = active->width ;
                        winrect.h = active->height ;

                        wininout = shape == THIN_CROSS ;
                }
                else
                        which &= ~MU_M2 ;

                if (shape != oldshape) {
                        oldshape = shape ;
                        graf_mouse (shape, &dummy) ;
                }

                if (mouseoff) {
                        mouseoff = FALSE ;
                        graf_mouse (M_ON, &dummy) ;
                }

                rc = evnt_multi (which,
                                nr_clicks,
                                what_button,
                                button_state,
                                clickinout,
                                clickrect,
                                wininout,
                                winrect,
                                msg_buf,
                                lowtime,
                                hightime,
                                mevnt_rec,
                                &key_pressed,
                                &nr_times) ;

                if (rc & MU_TIMER) {
                        do_timer (ep) ;
                        if (ep->type != WE_NULL)
                                break ;
                }

                if (rc & MU_KEYBD) {
                        do_keybd (ep, key_pressed) ;
                        if (ep->type != WE_NULL)
                                break ;
                }

                if (rc & MU_M1 || rc & MU_BUTTON) {
                        do_button (ep, &mevnt_rec) ;
                        if (ep->type != WE_NULL)
                                break ;
                }

                if (rc & MU_M2) {
                        if (!mousedown) {
                                if (shape == ARROW) {
                                        oldshape = shape ;
                                        shape = THIN_CROSS ;
                                }
                                else {
                                        oldshape = shape ;
                                        shape = ARROW ;
                                }
                        }
                }

                if (rc & MU_MESAG) {
                        do_messag (ep, msg_buf) ;
                }
        } while (ep->type == WE_NULL) ;
}

static WINDOW   *timer_win ;

static void
do_timer (ep)
        EVENT   *ep ;
{
        if (find_update (ep))
                return ;

        if (timer_win == NULL) {
wdebug ("do_timer: timer event with no timer window|or pending updates") ;
                return ;
        }

        ep->type = WE_TIMER ;
        ep->window = timer_win ;
        wsettimer (timer_win, 0) ;
}

static bool
find_update (ep)
        EVENT   *ep ;
{
        int     i ;
        bool    rc = FALSE ;

        if (active != NULL && active->needupdate) {
                rc = TRUE ;

                if (active->drawproc == NULL) {
                        ep->type = WE_DRAW ;
                        ep->window = active ;
                        wgetchange (active, &ep->u.area.left, &ep->u.area.top,
                                        &ep->u.area.right, &ep->u.area.bottom) ;
                        wupdate (ep->window) ;
                        return (rc) ;
                }
                else
                        wupdate (active) ;
        }
        for (i = 0; i < nrwin; i++) {
                if (winlist[i] != active && winlist[i]->needupdate) {
                        rc = TRUE ;

                        if (winlist[i]->drawproc == NULL) {
                                ep->type = WE_DRAW ;
                                ep->window = winlist[i] ;
                                wgetchange (winlist[i], &ep->u.area.left,
                                                        &ep->u.area.top,
                                                        &ep->u.area.right,
                                                        &ep->u.area.bottom) ;
                                wupdate (ep->window) ;
                                return (rc) ;
                        }
                        else
                                wupdate (winlist[i]) ;
                }
        }

        return (rc) ;
}

static void
set_timer (ep, phightime, plowtime)
        EVENT   *ep ;
        int     *phightime ;
        unsigned int    *plowtime ;
{
        msec    currtime ;
        int     i ;
        bool    pend_updates = FALSE ;

        timer_win = NULL ;

        currtime = MSTIME () ;

        for (i = 0 ; i < nrwin ; i++) {
                WINDOW  *cand = winlist[i] ;
                msec    t = cand->alarm ;

                if (t > 0) {
                        if (timer_win == NULL || t < timer_win->alarm)
                                timer_win = cand ;
                }

                if (cand->needupdate)
                        pend_updates = TRUE ;
        }

        if (timer_win != NULL) {
                /* window with alarm set found */

/*              wdebug ("settimer: timer window found") ;
                wdebug ("alarm:%ld|curr:%ld", timer_win->alarm, currtime) ;
*/
                if (timer_win->alarm <= currtime) {
                        /* alarm should go of somewhere in the past.
                        ** return a timer event from this window
                        */
                        ep->type = WE_TIMER ;
                        ep->window = timer_win ;
                        wsettimer (timer_win, 0) ;
                }
                else if (pend_updates == TRUE) {
                        /* There are pendings updates. Set the timer on 1 msec
                        ** to check that there aren't any events waiting.
                        */
                        *phightime = 0 ;
                        *plowtime = 1 ;
                }
                else {
                        /* Set the timer to the alarm time. */
                        *phightime = (timer_win->alarm - currtime) >> 16 ;
                        *plowtime = (timer_win->alarm - currtime) & 0xffff ;
                }
        }
        else if (pend_updates == TRUE) {
                /* There are pendings updates. Set the timer on 1 msec
                ** to check that there aren't any events waiting.
                */
                *phightime = 0 ;
                *plowtime = 1 ;
        }
        else {
                /* No window found with an alarm set */
                *phightime = 0x7fff ;
                *plowtime = 0xffff ;
        }

/*      wdebug ("settimer: h %d l %d", *phightime, *plowtime) ;
*/}

static void
do_keybd (ep, key)
        EVENT   *ep ;
        int     key ;
{
        int     status ;

        vq_key_s (vdi_handle, &status) ;

        if (status & 0x08) {
                checksc (ep, key) ;
                return ;
        }

        if ((key & 0xFF) == 0) {

                /*
                ** 'Special' key: If last  byte is nul then check extract
                ** from the first byte the key number.
                */
                switch (key >> 8) {
                case 0x47 :     /* Clr Home */
                        ep->u.command = WC_CLEAR ;
                        break ;
                case 0x48 :     /* Cursor Up */
                        ep->u.command = WC_UP ;
                        break ;
                case 0x4B :     /* Cursor Left */
                        ep->u.command = WC_LEFT ;
                        break ;
                case 0x4D :     /* Cursor Right */
                        ep->u.command = WC_RIGHT ;
                        break ;
                case 0x50 :     /* Cursor Down */
                        ep->u.command = WC_DOWN ;
                        break ;
                case 0x52 :     /* Insert */
                        ep->u.command = WC_INS ;
                        break ;
                case 0x53 :     /* Delete */
                        ep->u.command = WC_DEL ;
                        break ;
                case 0x61 :     /* Undo */
                        ep->u.command = WC_CANCEL ;
                        break ;
                default :
                        return ;
                }

                ep->type = WE_COMMAND ;
                ep->window = active ;
                return ;
        }

        ep->type = WE_COMMAND ;
        ep->window = active ;

        switch (key & 0xFF) {
                case 0x03 :
                        ep->u.command = WC_CANCEL ;
                        break ;
                case 0x08 :
                        ep->u.command = WC_BACKSPACE ;
                        break ;
                case 0x09 :
                        ep->u.command = WC_TAB ;
                        break ;
                case 0x0A :
                case 0x0D :
                        ep->u.command = WC_RETURN ;
                        break ;
                default :
                        ep->type = WE_CHAR ;
                        ep->window = active ;
                        ep->u.character = key & 0xFF ;
                        break ;
        }
}

static void
do_button (ep, mrec)
        EVENT   *ep ;
        Mouse   *mrec ;
{
        WINDOW  *win = active ;
        msec    tick ;
        int     h ;
        int     v ;
        int     dh ;
        int     dv ;

        if (win == NULL ||
            ((*mrec->x < win->h || *mrec->x > win->h + win->width ||
              *mrec->y < win->v || *mrec->y > win->v + win->height) &&
             !mousedown))
                return ;

        tick = MSTIME () ;
        while (tick < prev_tick)
                prev_tick -= 10*0x8000L ;

        SCRTODOC (win, *mrec->x, *mrec->y, h, v) ;

        dh = h - prev_h ;
        dv = v - prev_v ;

        if (dh*dh+dv*dv > DIST_CLICK*DIST_CLICK) {
                nr_clicks = 0 ;
        }

        if (prev_state == 1) {
                if (!(*mrec->b & 0x01)) {       /* Mouse up event */
                        ep->type = WE_MOUSE_UP ;
                        ep->u.where.button = 1 ;        /* Till now only the
                                                        ** leftmost button is
                                                        ** detected
                                                        */
                        mousedown = FALSE ;
                }
                else {
                        if (nr_clicks > 0 || dh*dh+dv*dv == 0)
                                return ;
                        else {
                                if (*mrec->x < win->h ||
                                    *mrec->x > win->h + win->width ||
                                    *mrec->y < win->v ||
                                    *mrec->y > win->v + win->height)
                                        autoscroll (win, *mrec->x, *mrec->y) ;

                                ep->type = WE_MOUSE_MOVE ;
                                ep->u.where.button = 1 ;
                        }
                }
        }
        else {
                if (!(*mrec->b & 0x01))
                        mupwaiting = TRUE ;

                if (tick - prev_tick <= CLICK_TICKS)
                        ++nr_clicks ;
                else
                        nr_clicks = 1 ;

                ep->type = WE_MOUSE_DOWN ;
                ep->u.where.button = 1 ;
                mousedown = TRUE ;
        }

        ep->window = win ;
        ep->u.where.h = prev_h = h ;
        ep->u.where.v = prev_v = v ;
        ep->u.where.clicks = nr_clicks ;

        prev_tick = tick ;
        prev_state = *mrec->b & 0x01 ;
}

static void
do_messag (ep, msg_buf)
        EVENT   *ep ;
        int     msg_buf[8] ;
{
        switch (msg_buf[0]) {
                case MN_SELECTED :
/*                      wdebug ("Menu selected") ;
*/                      do_menu(ep, msg_buf) ;
                        break ;
                case WM_REDRAW :
/*                      wdebug ("Redraw wanted") ;
*/                      do_redraw (msg_buf) ;
                        break ;
                case WM_TOPPED :
/*                      wdebug ("New active window") ;
*/                      do_topped (ep, msg_buf) ;
                        break ;
                case WM_CLOSED :
/*                      wdebug ("Window closed") ;
*/                      do_closed (ep, msg_buf) ;
                        break ;
                case WM_FULLED :
                case WM_SIZED :
                case WM_MOVED :
/*                      wdebug ("Window position changed") ;
*/                      do_size (ep, msg_buf) ;
                        break ;
                case WM_ARROWED :
                case WM_HSLID :
                case WM_VSLID :
/*                      wdebug ("Window scrolled") ;
*/                      do_scroll (msg_buf) ;
                        break ;
        }
}

static void
do_redraw (msg_buf)
        int     msg_buf[8] ;
{
        WINDOW  *win ;
        int     changed[4] ;
        int     work[4] ;

        win = getwin (msg_buf[3]) ;

        if (win == NULL) {
                wdebug ("do_redraw: window %d doesn't belong to me", msg_buf[3]) ;
                return ;
        }

        SCRTODOC (win, msg_buf[4], msg_buf[5], changed[0], changed[1]) ;

        changed[2] = changed[0] + msg_buf[6] ;
        changed[3] = changed[1] + msg_buf[7] ;

        wgetwinorigin (win, &work[0], &work[1]) ;
        wgetwinsize (win, &work[2], &work[3]) ;

        work[2] += work[0] ;
        work[3] += work[1] ;

        if (!intersect (work, changed))
                return ;

        wchange (win, changed[0], changed[1], changed[2], changed[3]) ;
}

static void
do_topped (ep, msg_buf)
        EVENT   *ep ;
        int     msg_buf[8] ;
{
        WINDOW  *win = getwin (msg_buf[3]) ;
        int     dummy = 0 ;

        if (win == NULL) {
                wdebug ("do_topped: window doesn't belong to me") ;
                return ;
        }

        ep->type = WE_ACTIVATE ;
        ep->window = win ;
        wsetactive (win) ;
        lactive = active ;
}

static void
do_closed (ep, msg_buf)
        EVENT   *ep ;
        int     msg_buf[8] ;
{
        WINDOW  *win = getwin (msg_buf[3]) ;

        if (win == NULL) {
                wdebug ("do_closed: window doesn't belong to me") ;
                return ;
        }

        ep->type = WE_COMMAND ;
        ep->window = win ;
        ep->u.command = WC_CLOSE ;
}

static void
do_size (ep, msg_buf)
        EVENT   *ep ;
        int     msg_buf[8] ;
{
        WINDOW  *win = getwin (msg_buf[3]) ;
        int     orgh = win->orgh ;
        int     orgv = win->orgv ;
        int     h ;
        int     v ;
        int     width ;
        int     height ;

        if (win == NULL) {
                wdebug ("do_sized: window doesn't belong to me") ;
                return ;
        }

        if (msg_buf[0] == WM_FULLED) {
                if (win->fulled) {
                        wind_get (win->handle, WF_PREVXYWH, &h, &v, &width,
                                                                &height) ;
                        win->fulled = FALSE ;
                }
                else {
                        wind_get (win->handle, WF_FULLXYWH, &h, &v, &width,
                                                                &height) ;
                        win->fulled = TRUE ;
                }
        }
        else {
                h       = msg_buf[4] ;
                v       = msg_buf[5] ;
                width   = msg_buf[6] ;
                height  = msg_buf[7] ;
                win->fulled = FALSE ;
        }

        if (!wind_set (win->handle, WF_CURRXYWH, h, v, width, height)) {
                wdebug ("do_sized: wind_set") ;
                return ;
        }
        _setsize (win, h, v, width, height) ;

        if (win->orgh + win->width > win->doc_width + 10)
                orgh = win->doc_width - win->width + 10 ;

        if (win->orgv + win->height > win->doc_height + wlineheight ())
                orgv = win->doc_height - win->height + wlineheight () ;

        wsetorigin (win, orgh, orgv) ;
        setscrollbars (win) ;

        if (msg_buf[0] != WM_MOVED) {
                ep->type = WE_SIZE ;
                ep->window = win ;
        }

        {
                int x, y, w, he ;

                wind_get (win->handle, WF_CURRXYWH, &x, &y, &w, &he) ;
                if (x != h)
                        wdebug ("x %d %d", h, x) ;
                if (y != v)
                        wdebug ("y %d %d", v, y) ;
                if (w != width)
                        wdebug ("w %d %d", width, w) ;
                if (he != height)
                        wdebug ("h %d %d", height, he) ;
        }
}
