/*
	Figure out whether we are using MPW or LSC.
	We assume that if 'unix' and 'MSDOS' are undefined,
	this is the Macintosh; of the two compilers used there,
	MPW defines 'macintosh', while LSC doesn't.
	For the benefit of portable code we define 'macintosh'
	when we find this is LSC; all LSC or MPW-dependent code
	should test for 'LSC' or 'MPW', while general Mac-specific code
	should test for 'macintosh'.
	In order that this file be re-entrant, we also if LSC is already
	defined.

	Note: on the Atari this works because both MW-C and turbo C take
	the LSC definitions in tools.h
*/

#ifndef unix
#ifndef MSDOS
#ifndef LSC
#ifndef macintosh
#define LSC
#define macintosh
#else
#ifndef MPW
#define MPW
#endif
#endif
#endif
#endif
#endif
