#------------------------------------------------------------------------------
#  Projekt : CLICC - a Common Lisp to C Compiler
#            -----------------------------------
# Function : Generates executable file from C file wich was generated by clicc.
#            Needs parameter SOURCE = <name> and
#            optionally OPTIMIZE = <-{O | g}>.
#            Uses Environment variable CLICCROOT and CROSS386.
#            Called by clicc/bin/cl and clicc/bin/clg.
#
#  $Source: /home3/apply/public/clicc-0.6.2a/lib/RCS/makefile.cl386,v $
#  $Author: hk $
#  $Revision: 1.8 $
#  $Date: 1993/11/18 16:22:23 $
#------------------------------------------------------------------------------

MODULES =
LIBRARIES =
OPTIMIZE = -O# alternative to -O is -g
CFLAGS	= -I$(CLICCROOT)/lib $(OPTIMIZE)
CC	= $(CROSS386)/gcc

ifeq ($(findstring -g,$(OPTIMIZE)), -g)
 RTC	= $(CLICCROOT)/lib/rtc-g.a386
 RTL	= $(CLICCROOT)/lib/rtl-g.a386
 START	= $(CLICCROOT)/lib/main-g.o386
else
 RTC	= $(CLICCROOT)/lib/rtc.a386
 RTL	= $(CLICCROOT)/lib/rtl.a386
 START	= $(CLICCROOT)/lib/main.o386
endif

OMODULES = $(MODULES:%.c=%.o386)
OBJECT = $(SOURCE:%.c=%.o386)
PROGRAM= $(SOURCE:%.c=%.386)

#.KEEP_STATE:

%.o386: %.c
	$(COMPILE.c) $< $(OUTPUT_OPTION)

$(PROGRAM): $(OBJECT) $(RTL) $(RTC) $(START) $(OMODULES)
	$(LINK.c) -o $@ $(START) $(OBJECT) $(OMODULES) \
	$(RTL) $(RTC) $(RTL) $(LIBRARIES) -lm
