/* Header File for Font Handling
 * This file is part of YY-server of YYonX (1.3 Distribution)
 * $Id: yyfont.h,v 3.0 1992/10/08 04:59:44 keisuke Exp $
 */

/****************************************************************************
%%%COPYRIGHT%%%
;;; Authors:
;;;   Version 1.0 90/08/26 by Keisuke 'Keiko' Tanaka
;;;				(keisuke@csrl.aoyama.ac.jp)
;;;   Version 2.0 90/08/27 by Keisuke 'Keiko' Tanaka
;;;			Page Mode Territory is supported
;;;   Version 2.2 90/11/05 by Keisuke 'Keiko' Tanaka
;;;			Copyright Notice is rewritten
;;;
****************************************************************************/

/****************************************************************************
  $Revision: 3.0 $ Written by Keisuke 'Keiko' Tanaka
  $Date: 1992/10/08 04:59:44 $
****************************************************************************/

struct _yy_char_info {
    int ciAscent;
    int ciDescent;
    int ciHeight;
    int ciWidth;
    int ciRBearing;
    int ciLBearing;
} ;
typedef struct _yy_char_info	YYCHAR;

struct _yy_font_x_table {
    struct _yy_font_x_info {
	Font fxFontID;
	char *fxFontName;
	YYCHAR fxMaxBound;
	YYCHAR fxMinBound;
	XFontStruct *fxFontStruct;
    } fxFontInfo;
    struct _yy_font_x_table *fxNext;
} ;
typedef struct _yy_font_x_table	yy_font_x_table;
typedef struct _yy_font_x_info	YYXFONT;

struct _yy_font_table {
    struct _yy_font_info {
	bool fiLoaded;
	int fiFID;
	char *fiFontName;
	YYCHAR fiMaxBound;
	YYCHAR fiMinBound;
	YYXFONT *fiSingle;
	YYXFONT *fiDouble;
    } yfFontInfo;
    struct _yy_font_table *yfNext;
} ;

#define MAXB1ASCENT(yfont)	((yfont)->fiSingle->fxMaxBound.ciAscent)
#define MAXB2ASCENT(yfont)	((yfont)->fiDouble->fxMaxBound.ciAscent)
#define MAXB1DESCENT(yfont)	((yfont)->fiSingle->fxMaxBound.ciDescent)
#define MAXB2DESCENT(yfont)	((yfont)->fiDouble->fxMaxBound.ciDescent)

struct _text_box_entry {
    int x, y;	/* Left Top */
    int w, h;	/* Width and Height */
} ;
typedef struct _text_box_entry	TEXTBOX;

extern YYFONT *call_font();
extern TEXTBOX *YYTextSize();
extern int YYTextWidth();
extern void do_draw_text_on_page();

/*
 * Local variables:
 * eval: (set-kanji-fileio-code 'EUC)
 * end:
 */
