/****************************************************************************
%%%COPYRIGHT%%%
;;; Authors:
;;;   Version 1.0 92/03/17 by Takashi Kosaka
;;;			Copyright Notice is rewritten
;;;
****************************************************************************/

/****************************************************************************
  $Revision: 3.1 $ Written by Takashi Kosaka
  $Date: 1992/10/27 08:10:20 $
****************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include <X11/cursorfont.h>
#include "yydefs.h"
#include "yypacket.h"
#include "sched.h"
#include "xwindow.h"
#include "territory.h"

/**********************************************************************
 ***  ΥեδؿѤؿ
 **********************************************************************/
static void splite_remove_objects();


#ifdef BUGBUGSPLITE
/* bool rect_in(tr1, tr2)
 *
 * ƥȥ tr1  tr2 δ֤˽Ťʤ꤬ TRUE ֤
 * Ǥʤ FALSE ֤
 */
#define RECT_INX(t1,t2)	\
    (MAX((t1)->teX,(t2)->teX)<=MIN(RECT_RIGHT(t1),RECT_RIGHT(t2)))
#define RECT_INY(t1,t2)	\
    (MAX((t1)->teY,(t2)->teY)<=MIN(RECT_BOTTOM(t1),RECT_BOTTOM(t2)))
#define RECT_IN(t1,t2)	((RECT_INX((t1),(t2)))&&(RECT_INY((t1),(t2))))

static bool rect_in(tr1,tr2)
    register TERRITORY *tr1,*tr2;
{
    if ((MAX(tr1->teX,tr2->teX)) > (MIN(RECT_RIGHT(tr1),RECT_RIGHT(tr2))))
	return FALSE;
    if ((MAX(tr1->teY,tr2->teY)) > (MIN(RECT_BOTTOM(tr1),RECT_BOTTOM(tr2))))
	return FALSE;
    return TRUE;
}

/* DSΰäƤ1Ǥʤ0
 *
 * ¸߰յ狼ʤ....
 */
static bool real_rect_in(d,s)
    TERRITORY *d, *s;
{
    return (rect_in(d,s) || rect_in(s,d));
}
#endif /*BUGBUGSPLITE*/


/**********************************************************************
 *****
 *****  ץ饤ȽѥΤδؿ
 *****
 **********************************************************************/

static struct splite_draw_cont *alloc_new_draw_cont(sptab)
    TERRITORY_SPLITE *sptab;
{
    register TERRITORY_SPLITE *newtab;
    struct splite_draw_cont *p;
    register int loop;

    newtab = (TERRITORY_SPLITE *)memALLOC(sizeof(TERRITORY_SPLITE));
    newtab->spNextFolder = sptab->spNextFolder;
    sptab->spNextFolder = newtab;

    /* newtab  SPLITECTRLALLOCNUM Ŀ Free 
     * ץ饤ΰ */
    newtab->spDraw = newtab->spTopCont = p = (struct splite_draw_cont *)
	memCALLOC(SPLITECTRLALLOCNUM, sizeof(struct splite_draw_cont));
    bzero(p, SPLITECTRLALLOCNUM*sizeof(struct splite_draw_cont));
    for (loop = SPLITECTRLALLOCNUM-1; loop > 0; p++, loop--) {
	p->scNext = (p+1);
	p->scCtrl = newtab;
    }
    p->scCtrl = newtab;
    p->scNext = (struct splite_draw_cont *)NULL;

    /* Free ƬѲǽΰȤ֤ */
    p = newtab->spDraw;
    newtab->spDraw = p->scNext;
    newtab->spActNum++;
    return p;
}


/* struct splite_draw_cont *alloc_splite_cont(ch, tr)
 *
 * ƥȥ tr оݤȤ륹ץ饤ΰƤ
 */
static struct splite_draw_cont *alloc_splite_cont(sptab)
    TERRITORY_SPLITE *sptab;
{	
    struct splite_draw_cont *spc;

    DebugSetFunc("splite", "alloc_splite_cont");

    spc = (struct splite_draw_cont *)NULL;
    /* ˳ƤƤ襷󥹤¸ߤ
     *   Clear 줿ΤСļФ
     */
    if (sptab->spDraw != (struct splite_draw_cont *)NULL) {
      if (sptab->spLastCont == (struct splite_draw_cont *)NULL) {
	    spc = sptab->spDraw;
	    sptab->spDraw = spc->scNext;
	    if (spc->scNext == (struct splite_draw_cont *)NULL)
		sptab->spTailCont = (struct splite_draw_cont *)NULL;
	    else
		spc->scNext->scStat |= STSPLITE_CLEAR;
	    spc->scNext = (struct splite_draw_cont *)NULL;
	    spc->scFuncTab = (struct splite_func_tab *)NULL;
	    spc->scStat = 0;
	    goto found;
	}
        if (spc != (struct splite_draw_cont *)NULL)
	  goto found; /*???????*/
	if (sptab->spLastCont->scNext != (struct splite_draw_cont *)NULL) {
	    spc = sptab->spLastCont->scNext;
	    sptab->spLastCont->scNext = spc->scNext;
	    if (spc->scNext == (struct splite_draw_cont *)NULL)
		sptab->spTailCont = sptab->spLastCont;
	    else
		spc->scNext->scStat |= STSPLITE_CLEAR;
	    spc->scNext = (struct splite_draw_cont *)NULL;
	    spc->scStat = 0;
	    if (spc->scFuncTab != (struct splite_func_tab *)NULL &&
		spc->scFreeFunc)
		(*spc->scFreeFunc)(spc);
	    spc->scFuncTab = (struct splite_func_tab *)NULL;
	    goto found;
	}
    }

    /* Free ΰäƤФ줫ĻȤ */
    if (sptab->spNextFolder != (TERRITORY_SPLITE *)NULL) {
	register TERRITORY_SPLITE *p = sptab->spNextFolder;
	for ( ; p != (TERRITORY_SPLITE *)NULL; p = p->spNextFolder)
	    if ((spc = p->spDraw) != (struct splite_draw_cont *)NULL) {
		p->spDraw = p->spDraw->scNext;
		p->spActNum++;
		break;
	    }
    }
    if (spc == (struct splite_draw_cont *)NULL &&
	(spc = alloc_new_draw_cont(sptab)) == (struct splite_draw_cont *)NULL)
	return spc; /* ֤󤢤ʤ */
 found:
    DebugPrint1(9, "Allocate Splite Draw Control Entry %x\n", spc);
    DebugEndFunc("splite", "alloc_splite_cont");
    return spc;
}

/* void free_splite_cont(tr, spc)
 *
 * tr ˳ƤƤ륹ץ饤ΰ֤ˤ
 *
 * :
 *  ΨɤʤΤǤδؿϸƤ֤٤ǤϤʤ
 *  ޤȤн褹 destroy_all_splite_cont(tr) Ȥ٤Ǥ
 */
static struct splite_draw_cont *free_splite_cont(tr, spc)
    TERRITORY *tr; /*ץ饤ȥƥȥ*/
    register struct splite_draw_cont *spc; /* о */
{
    register struct splite_draw_cont *prev, *cur;
    TERRITORY_SPLITE *sptab = GetSpliteTerritoryEnt(tr);
    DebugSetFunc("splite", "free_splite_cont");
    cur = sptab->spDraw;
    prev = (struct splite_draw_cont *)NULL;
    while (cur != (struct splite_draw_cont *)NULL && cur != spc)
	cur = (prev=cur)->scNext;
    if (cur != (struct splite_draw_cont *)NULL) {
	/* prev μ cur μ */
	if (prev != (struct splite_draw_cont *)NULL)
	    prev->scNext = cur->scNext;
	else
	    sptab->spDraw = cur->scNext;
	/* б֥å Free ä */
	cur->scNext = cur->scCtrl->spDraw;
	cur->scCtrl->spDraw = cur;
	cur->scCtrl->spActNum--;
	/* ϥˤʤä free ... */
	/* spc ΰγ */
	if (spc->scFuncTab != (struct splite_func_tab *)NULL &&
	    spc->scFreeFunc)
	    (*spc->scFreeFunc)(spc);
	if (spc->scGC != (GC)NULL) XFreeGC(spc->scGC);
	spc->scFuncTab = (struct splite_func_tab *)NULL;
	spc->scDisp = (Display *)NULL;
	spc->scGC = (GC)NULL;
    }
    DebugEndFunc("splite", "free_splite_cont");
    /*NoReturnValue*/
}

/* void destroy_all_splite_cont(tr)
 *
 * tr ˳ƤƤ륹ץ饤ΰ򤹤٤
 *  ºݤ˲
 */
static void destroy_all_splite_cont(tr)
    TERRITORY *tr; /*ץ饤ȥƥȥ*/
{
    TERRITORY_SPLITE *sptab = GetSpliteTerritoryEnt(tr);
    register TERRITORY_SPLITE *p, *n;
    register struct splite_draw_cont *spc;

    DebugSetFunc("splite", "destroy_all_splite_cont");
    /* 襷󥹤Ƥΰ */
    spc = sptab->spDraw;
    for ( ; spc != (struct splite_draw_cont *)NULL; spc = spc->scNext) {
	if (spc->scGC != (GC)NULL) XFreeGC(spc->scDisp, spc->scGC);
	if (spc->scFreeFunc) (*spc->scFreeFunc)(spc);
    }

    /*  sptab äƤΰޤȤƲ */
    sptab->spDraw = (struct splite_draw_cont *)NULL;
    for (p = sptab->spNextFolder; p != (TERRITORY_SPLITE *)NULL; ) {
	n = p->spNextFolder;
	memFREE((char *)p->spTopCont);
	memFREE((char *)p);
	p = n;
    }
    sptab->spNextFolder = (TERRITORY_SPLITE *)NULL;
    sptab->spDraw = sptab->spLastGC = sptab->spLastCont = sptab->spTailCont
	= (struct splite_draw_cont *)NULL;
    DebugEndFunc("splite", "destroy_all_splite_cont");
    /*NoReturnValue*/
}


/**********************************************************************
 *****
 *****
 *****
 **********************************************************************/

/* ॢȤǸƤФؿ
 *  ͽ󤵤Ƥ륯ꥢ»ܤ
 */
static void yy_splite_clear_timer(ch, myself, id, type, flag, tp, delay)
    yy_comm_channel *ch;
    void (*myself)();
    int id;
    int type;
    int flag;
    struct timeval *tp;
    long delay;
{
    register TERRITORY *tr;
    tr = search_territory(id);
    if (!NULLTERRITORY(tr) && tr->teTRType == TR_SPLITE) {
	register TERRITORY_SPLITE *sp = GetSpliteTerritoryEnt(tr);
	if (sp->spClrRect.w != 0 && sp->spClrRect.h != 0) {
	    (void)splite_remove_objects(ch, tr);
	    ch->ccXNeedFlush = TRUE;
	}
    }
    /*NoReturnValue*/
}

/* ॢȤǸƤФؿ
 *  ץ饤ȥƥȥ襷󥹤ϿƤ
 *  Fix ƤʤΤФ Fix 
 *  Ԥʤ
 */
static void yy_splite_draw_timer(ch, myself, id, type, flag, tp, delay)
    yy_comm_channel *ch;
    void (*myself)();
    int id, type, flag;
    struct timeval *tp;
    long delay;
{
    register TERRITORY *tr;
    tr = search_territory(id);
#ifdef DEBUG
    printf("Zoooooon\n");
#endif
    if (!NULLTERRITORY(tr) && tr->teTRType == TR_SPLITE) {
	register TERRITORY_SPLITE *sp = GetSpliteTerritoryEnt(tr);	
	(void)splite_remove_objects(ch, tr);
	if (sp->spLastGC != (struct splite_draw_cont *)NULL &&
	    !(sp->spLastGC->scStat & STSPLITE_FIXED) &&
	    !(sp->spLastGC->scStat & STSPLITE_CLEAR) &&
	    sp->spLastGC->scFixRedrawFunc) {
	    (*sp->spLastGC->scFixRedrawFunc)(sp->spLastGC, tr);
	    /* ڤ򵯤Ƥ顢˼ºݤ X Protocol 
	     *  ѥåȤФޤǤ˻֤
	     *  ɽΥǥ쥤礭ʤäƤޤΤ
	     *  ŪʥѥåФ򤹤 */
	    sync_x_server(XPRIVATE(ch));
	    /*ch->ccXNeedFlush = TRUE;*/
	}
    }
}



/* void append_splite_draw_cont(sp, spc)
 *
 * ΰ sp 襷󥹤κǸդä
 */
static void append_splite_draw_cont(ch, tr, sp, spc)
    yy_comm_channel *ch;
    TERRITORY *tr;
    TERRITORY_SPLITE *sp;
    struct splite_draw_cont *spc;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY_X_ENTRY *tx = GetTerritoryXEntry(tr);

    DebugSetFunc("splite", "append_splite_draw_cont");
    /* ॢȤǼʬȤľؿꤵƤ
     *  */
    yysched_delque(ch, tr->teID, YYSCHED_TYPE_SPLITE_DRAW, (-1));

    if (sp->spDraw == (struct splite_draw_cont *)NULL) {
	/* Υץ饤ȤǤϡޤäϿǤ
	 */
	spc->scGC = XCreateGC(xp->xDisp, tx->txPixmap, 0L, 0);
	XCopyGC(xp->xDisp, tx->txGC, ~0L, spc->scGC);
	spc->scStat = 0;
	sp->spDraw = sp->spLastCont = sp->spLastGC = sp->spTailCont = spc;
	spc->scNext = (struct splite_draw_cont *)NULL;
	/* Ǥޤ */
    } else {
	/* Υץ饤ȥƥȥϲϿ줿襷󥹤
	 *  ¸ߤ */
	if (sp->spLastCont != (struct splite_draw_cont *)NULL &&
	    spc->scCheckFunc && (*spc->scCheckFunc)(spc,sp)) {
	    /* Ʊ°ǤΤǤΥȥΥȥ礵
	     */
	    if (spc->scGC != (GC)NULL) XFreeGC(xp->xDisp, spc->scGC);
	    spc->scGC = (GC)NULL;
	    spc->scStat = STSPLITE_COMPACT;
	} else {
	    /* °ۤʤΤǸߤ tr  GC  spc  GC Ȥ
	     * ¸ sp->cpLastGC Ф fix_and_redraw ȯ
	     */
	    void (*func)();
	    DebugPrint1(5, "Will Append New Object on SPLITE#%d\n", tr->teID);
	    if (spc->scGC == (GC)NULL)
		spc->scGC = XCreateGC(xp->xDisp, tx->txPixmap, 0L, 0);
	    XCopyGC(xp->xDisp, tx->txGC, ~0L, spc->scGC);
	    spc->scStat = 0;
	    /* Fix and Redraw
	     *  ꥢʤ餳Ԥʤ
	     */
	    (void)splite_remove_objects(ch, tr);
	    if (sp->spLastGC != (struct splite_draw_cont *)NULL &&
		!(sp->spLastGC->scStat & STSPLITE_FIXED) &&
		(func = sp->spLastGC->scFixRedrawFunc))
		(*func)(sp->spLastGC, tr);
	    /* spc  LastGC ȥˤʤ */
	    sp->spLastGC = spc;
	}
	/* spc  sp κǸͭ³Ȥ
	 */
	if (sp->spLastCont != (struct splite_draw_cont *)NULL) {
	    spc->scNext = sp->spLastCont->scNext;
	    sp->spLastCont->scNext = spc;
	} else {
	    spc->scNext = sp->spDraw;
	    sp->spDraw = spc;
	}
	sp->spLastCont = spc;
	if (spc->scNext == (struct splite_draw_cont *)NULL)
	    sp->spTailCont = spc;
	else
	    spc->scNext->scStat |= STSPLITE_CLEAR;
    }

    /* ॢȤǼʬȤľؿɬ */
    yysched_addque(ch, yy_splite_draw_timer, tr->teID,
		   YYSCHED_TYPE_SPLITE_DRAW, 0, NULL, 50);
    DebugEndFunc("splite", "append_splite_draw_cont");
}    



/**********************************************************************
 *****
 *****  ץ饤ȥƥȥؿ
 *****
 **********************************************************************/

/**************************************************
 *  
 **************************************************/
static void splite_draw_point(spc, sp_tr, dst, offset)
    struct splite_draw_cont *spc;
    TERRITORY *sp_tr;
    Drawable dst;
    YYRectangle *offset;
{
    register int x, y;
    DebugSetFunc("splite", "splite_draw_point");
    DebugPrint8(9, "Point at (%d,%d) on SPLITE (%d,%d)[%d,%d] - [%d,%d]\n",
		spc->scPointX, spc->scPointY,
		sp_tr->teX, sp_tr->teY, sp_tr->teWidth, sp_tr->teHeight,
		offset->x, offset->y);
    XDrawPoint(spc->scDisp, dst, spc->scGC,
	       spc->scPointX + sp_tr->teX - offset->x,
	       spc->scPointY + sp_tr->teY - offset->y);
    DebugEndFunc("splite", "splite_draw_point");
}

static void splite_free_draw_point(spc)
    struct splite_draw_cont *spc;
{
    if (spc->scXArgs.uPoints != (XPoint *)NULL) {
	memFREE((char *)(spc->scXArgs.uPoints));
	spc->scXArgs.uPoints = (XPoint *)NULL;
	spc->scXArgs2.uPoints = (XPoint *)NULL;
    }
    spc->scXArgNum = spc->scXArgMax = 0;
    /*NoReturnValue*/
}

static void splite_fix_draw_point(spc, sp_tr)
    struct splite_draw_cont *spc;
    TERRITORY *sp_tr;
{
    spc->scStat |= STSPLITE_FIXED;
}

static void splite_fix_and_draw_point(spc, sp_tr)
    struct splite_draw_cont *spc;
    TERRITORY *sp_tr;
{
    TERRITORY *parent = sp_tr->teParent;
    YYRectangle off;
    spc->scStat |= STSPLITE_FIXED;
    off.x = off.y = 0;
    if(IsVisibleTerritory(parent))
	(void)splite_draw_point(spc, sp_tr, XEntry(parent)->txWindow, &off);
}


static struct splite_func_tab splite_draw_point_funcs = {
    splite_draw_point,			/*void (*fFunc)();*/
    splite_free_draw_point,		/*void (*fFreeFunc)();*/
    NULL,				/*bool (*fCheckFunc)();*/
    splite_fix_draw_point,		/*void (*fFixFunc)();*/
    splite_fix_and_draw_point,		/*void (*fFixRedrawFunc)();*/
} ;

void make_splite_draw_point(ch, tr, x, y)
    yy_comm_channel *ch;
    TERRITORY *tr;	/* ץ饤ȥƥȥ */
    int x,y;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY_SPLITE *sp = GetSpliteTerritoryEnt(tr);	
    struct splite_draw_cont *spc;

    /* ΰƤ */
    spc = alloc_splite_cont(sp);
    if (spc->scFuncTab != (struct splite_func_tab *)NULL &&
	spc->scFuncTab != &splite_draw_point_funcs &&
	spc->scFreeFunc)
	(*spc->scFreeFunc)(spc);
    spc->scDisp = xp->xDisp;
    spc->scPointX = x;
    spc->scPointY = y;
    spc->scFuncTab = &splite_draw_point_funcs;
    (void)append_splite_draw_cont(ch, tr, sp, spc);
}

/**************************************************
 *  
 **************************************************/
static void splite_draw_line(spc, sp_tr, dst, offset)
    struct splite_draw_cont *spc;
    TERRITORY *sp_tr;
    Drawable dst;
    YYRectangle *offset;
{
    register int x, y;
    DebugSetFunc("splite", "splite_draw_line");
    DebugPrint8(9, "Line from (%d,%d) to (%d,%d) on SPLITE (%d,%d)[%d,%d]\n",
		spc->scSegmentX1, spc->scSegmentY1,
		spc->scSegmentX2, spc->scSegmentY2,
		sp_tr->teX, sp_tr->teY, sp_tr->teWidth, sp_tr->teHeight);
    DebugPrint2(8, "> Draw Line with offset (%d,%d)\n", offset->x, offset->y);

    if (spc->scXArgNum > 0) {
	register int dx = sp_tr->teX - offset->x;
	register int dy = sp_tr->teY - offset->y;
	register XSegment *seg;
	register int loop = spc->scXArgNum;

	DebugPrint1(9, "> Draw %d segments\n", spc->scXArgNum);
	seg = spc->scXArgs2.uSegments;
	if (spc->scXArgs.uSegments->x1 + dx != seg->x1 ||
	    spc->scXArgs.uSegments->y1 + dy != seg->y1) {
	    memcpy(seg, spc->scXArgs.uSegments, loop*sizeof(XSegment));
	    for (seg = spc->scXArgs2.uSegments; loop-- > 0; seg++) {
		seg->x1 += dx; seg->y1 += dy;
		seg->x2 += dx; seg->y2 += dy;
	    }
	}
	XDrawSegments(spc->scDisp, dst, spc->scGC,
		      spc->scXArgs2.uSegments, spc->scXArgNum);
    } else {
	XDrawLine(spc->scDisp, dst, spc->scGC,
		  spc->scSegmentX1 + sp_tr->teX - offset->x,
		  spc->scSegmentY1 + sp_tr->teY - offset->y,
		  spc->scSegmentX2 + sp_tr->teX - offset->x,
		  spc->scSegmentY2 + sp_tr->teY - offset->y);
    }
    DebugEndFunc("splite", "splite_draw_line");
}

static void splite_free_draw_line(spc)
    struct splite_draw_cont *spc;
{
    if (spc->scXArgs.uSegments != (XSegment *)NULL) {
	memFREE((char *)(spc->scXArgs.uSegments));
	spc->scXArgs.uSegments = (XSegment *)NULL;
	spc->scXArgs2.uSegments = (XSegment *)NULL;
    }
    bzero(&spc->scModeEnt.uLineAttr, sizeof(YYGCONTEXT));
    spc->scXArgNum = spc->scXArgMax = 0;
    /*NoReturnValue*/
}

static bool splite_check_draw_line(new_spc, sp)
    register struct splite_draw_cont *new_spc;
    register TERRITORY_SPLITE *sp;
{

    if (sp->spLastGC->scStat & STSPLITE_FIXED)
	return FALSE;
    if (new_spc->scFuncTab != sp->spLastGC->scFuncTab)
	return FALSE;
    if (memcmp(&new_spc->scModeEnt.uLineAttr,
	       &sp->spLastGC->scModeEnt.uLineAttr,
	       sizeof(YYGCONTEXT)) != 0)
	return FALSE;
    if (new_spc->scModeEnt.uLineAttr.ygDash != 0)
	return FALSE;
    return TRUE;
}


static void splite_fix_draw_line(spc, sp_tr)
    struct splite_draw_cont *spc;
    TERRITORY *sp_tr;
{
    /* sp_tr  spc 餢Ȥ fix 
     *  1) Ŀ
     *  2) θĿ XSegment  calloc 
     *  3) 򤽤 calloc 
     * âspc ñȤǤʤ̵̤ʤΤǲ⤷ʤ
     */
    if (spc->scNext != (struct splite_draw_cont *)NULL) {
	register int num;
	register struct splite_draw_cont *p;
	register XSegment *seg;
	/* Ŀη */
	num = 0;
	for (p = spc; p != (struct splite_draw_cont *)NULL; p = p->scNext) {
	    if (p->scStat & STSPLITE_CLEAR) break;
	    num++;
	}
	if (spc->scXArgMax < num) {
	    if (spc->scXArgs.uSegments != (XSegment *)NULL)
		memFREE((char *)spc->scXArgs.uSegments);
	    spc->scXArgs.uSegments
		= (XSegment *)memCALLOC((num<<1), sizeof(XSegment));
	    spc->scXArgMax = num;
	}
	spc->scXArgNum = num;
	seg = spc->scXArgs.uSegments;
	for (p = spc; num > 0; p = p->scNext, num--, seg++) {
	    memcpy(seg, &p->scArgs.uArgSegment, sizeof(XSegment));
	}
	spc->scXArgs2.uSegments = seg;
    } else {
	spc->scXArgs.uSegments = spc->scXArgs2.uSegments = (XSegment *)NULL;
	spc->scXArgNum = spc->scXArgMax = 0;
    }
    spc->scStat |= STSPLITE_FIXED;
}

static void splite_fix_and_draw_line(spc, sp_tr)
    struct splite_draw_cont *spc;
    TERRITORY *sp_tr;
{
    TERRITORY *parent = sp_tr->teParent;
    YYRectangle off;

    off.x = off.y = 0;
    splite_fix_draw_line(spc, sp_tr);
    if(IsVisibleTerritory(parent))
	(void)splite_draw_line(spc, sp_tr, XEntry(parent)->txWindow, &off);
}

static struct splite_func_tab splite_draw_line_funcs = {
    splite_draw_line,			/*void (*fFunc)();*/
    splite_free_draw_line,		/*void (*fFreeFunc)();*/
    splite_check_draw_line,		/*bool (*fCheckFunc)();*/
    splite_fix_draw_line,		/*void (*fFixFunc)();*/
    splite_fix_and_draw_line,		/*void (*fFixRedrawFunc)();*/
} ;

void make_splite_draw_line(ch, tr, x1, y1, x2, y2, gcon)
    yy_comm_channel *ch;
    TERRITORY *tr;	/* ץ饤ȥƥȥ */
    int x1,y1,x2,y2;
    YYGCONTEXT *gcon;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY_SPLITE *sp = GetSpliteTerritoryEnt(tr);	
    struct splite_draw_cont *spc;


    DebugSetFunc("splite", "make_splite_draw_line");
    /* ΰƤ */
    spc = alloc_splite_cont(sp);
    if (spc->scFuncTab != (struct splite_func_tab *)NULL &&
	spc->scFuncTab != &splite_draw_point_funcs &&
	spc->scFreeFunc)
	(*spc->scFreeFunc)(spc);
    else
	bzero(&spc->scModeEnt.uLineAttr, sizeof(YYGCONTEXT));
    spc->scDisp = xp->xDisp;
    spc->scSegmentX1 = x1;
    spc->scSegmentY1 = y1;
    spc->scSegmentX2 = x2;
    spc->scSegmentY2 = y2;
    memcpy(&spc->scModeEnt.uLineAttr, gcon, sizeof(YYGCONTEXT));
    spc->scFuncTab = &splite_draw_line_funcs;
    (void)append_splite_draw_cont(ch, tr, sp, spc);
    DebugEndFunc("splite", "make_splite_draw_line");
}

/**************************************************
 *  ͳѷ
 **************************************************/
static void splite_draw_rectangle(spc, sp_tr, dst, offset)
    struct splite_draw_cont *spc;
    TERRITORY *sp_tr;
    Drawable dst;
    YYRectangle *offset;
{
    register int x, y;
    DebugSetFunc("splite", "splite_draw_rectangle");
    XDrawRectangle(spc->scDisp, dst, spc->scGC,
		   spc->scRectangleX + sp_tr->teX - offset->x,
		   spc->scRectangleY + sp_tr->teY - offset->y,
		   spc->scRectangleW, spc->scRectangleH);
    DebugSetFunc("splite", "splite_draw_rectangle");
}

static void splite_draw_filled_rectangle(spc, sp_tr, dst, offset)
    struct splite_draw_cont *spc;
    TERRITORY *sp_tr;
    Drawable dst;
    YYRectangle *offset;
{
    register int x, y;
    DebugSetFunc("splite", "splite_draw_rectangle");
    XFillRectangle(spc->scDisp, dst, spc->scGC,
		   spc->scRectangleX + sp_tr->teX - offset->x,
		   spc->scRectangleY + sp_tr->teY - offset->y,
		   spc->scRectangleW, spc->scRectangleH);
    DebugSetFunc("splite", "splite_draw_rectangle");
}

static void splite_free_draw_rectangle(spc)
    struct splite_draw_cont *spc;
{
    spc->scXArgNum = spc->scXArgMax = 0;
    /*NoReturnValue*/
}

static void splite_fix_draw_rectangle(spc, sp_tr)
    struct splite_draw_cont *spc;
    TERRITORY *sp_tr;
{
    spc->scStat |= STSPLITE_FIXED;
}

static void splite_fix_and_draw_rectangle(spc, sp_tr)
    struct splite_draw_cont *spc;
    TERRITORY *sp_tr;
{
    TERRITORY *parent = sp_tr->teParent;
    YYRectangle off;
    spc->scStat |= STSPLITE_FIXED;
    off.x = off.y = 0;
    if(IsVisibleTerritory(parent))
	(void)(*spc->scFunc)(spc, sp_tr, XEntry(parent)->txWindow, &off);
}


static struct splite_func_tab splite_draw_rectangle_funcs = {
    splite_draw_rectangle,		/*void (*fFunc)();*/
    splite_free_draw_rectangle,		/*void (*fFreeFunc)();*/
    NULL,				/*bool (*fCheckFunc)();*/
    splite_fix_draw_rectangle,		/*void (*fFixFunc)();*/
    splite_fix_and_draw_rectangle,	/*void (*fFixRedrawFunc)();*/
} ;

static struct splite_func_tab splite_draw_filled_rectangle_funcs = {
    splite_draw_filled_rectangle,	/*void (*fFunc)();*/
    splite_free_draw_rectangle,		/*void (*fFreeFunc)();*/
    NULL,				/*bool (*fCheckFunc)();*/
    splite_fix_draw_rectangle,		/*void (*fFixFunc)();*/
    splite_fix_and_draw_rectangle,	/*void (*fFixRedrawFunc)();*/
} ;

void make_splite_draw_rectangle(ch, tr, x, y, w, h, mode)
    yy_comm_channel *ch;
    TERRITORY *tr;	/* ץ饤ȥƥȥ */
    int x, y, w, h, mode;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY_SPLITE *sp = GetSpliteTerritoryEnt(tr);	
    struct splite_draw_cont *spc;

    /* ΰƤ */
    spc = alloc_splite_cont(sp);
    if (spc->scFuncTab != (struct splite_func_tab *)NULL &&
	spc->scFuncTab != &splite_draw_rectangle_funcs &&
	spc->scFuncTab != &splite_draw_filled_rectangle_funcs &&
	spc->scFreeFunc)
	(*spc->scFreeFunc)(spc);
    spc->scDisp = xp->xDisp;
    spc->scRectangleX = x;
    spc->scRectangleY = y;
    spc->scRectangleW = w;
    spc->scRectangleH = h;
    spc->scFuncTab = (mode? &splite_draw_filled_rectangle_funcs:
		      &splite_draw_rectangle_funcs);
    (void)append_splite_draw_cont(ch, tr, sp, spc);
}

/**************************************************
 *  ݥꥴ
 **************************************************/
static void splite_draw_polygon(spc, sp_tr, dst, offset)
    struct splite_draw_cont *spc;
    TERRITORY *sp_tr;
    Drawable dst;
    YYRectangle *offset;
{
    register int dx = sp_tr->teX - offset->x;
    register int dy = sp_tr->teY - offset->y;
    register XPoint *p;
    register int loop = spc->scXArgNum;

    DebugSetFunc("splite", "splite_draw_polygon");
    DebugPrint1(9, "> Draw %d Points\n", spc->scXArgNum);
    memcpy(spc->scXArgs2.uPoints, spc->scXArgs.uPoints, loop*sizeof(XPoint));
    for (p = spc->scXArgs2.uPoints; loop-- > 0; p++) {
	p->x += dx; p->y += dy;
    }
    XDrawLines(spc->scDisp, dst, spc->scGC, spc->scXArgs2.uPoints,
	       spc->scXArgNum, CoordModeOrigin);
    DebugSetFunc("splite", "splite_draw_polygon");
}

static void splite_draw_filled_polygon(spc, sp_tr, dst, offset)
    struct splite_draw_cont *spc;
    TERRITORY *sp_tr;
    Drawable dst;
    YYRectangle *offset;
{
    register int dx = sp_tr->teX - offset->x;
    register int dy = sp_tr->teY - offset->y;
    register XPoint *p;
    register int loop = spc->scXArgNum;

    DebugSetFunc("splite", "splite_filled_polygon");
    DebugPrint1(9, "> Draw %d Points\n", spc->scXArgNum);
    memcpy(spc->scXArgs2.uPoints, spc->scXArgs.uPoints, loop*sizeof(XPoint));
    for (p = spc->scXArgs2.uPoints; loop-- > 0; p++) {
	p->x += dx; p->y += dy;
    }
    XFillPolygon(spc->scDisp, dst, spc->scGC, spc->scXArgs2.uPoints,
		 spc->scXArgNum, Complex, CoordModeOrigin);
    DebugSetFunc("splite", "splite_draw_polygon");
}

static void splite_draw_fill_inner_polygon(spc, sp_tr, dst, offset)
    struct splite_draw_cont *spc;
    TERRITORY *sp_tr;
    Drawable dst;
    YYRectangle *offset;
{
    register int dx = sp_tr->teX - offset->x;
    register int dy = sp_tr->teY - offset->y;
    register XPoint *p;
    register int loop = spc->scXArgNum;
    Pixmap wkpix;
    GC wkgc;
    XGCValues gcv;


    DebugSetFunc("splite", "splite_filled_polygon");
    DebugPrint1(9, "> Draw %d Points\n", spc->scXArgNum);
    memcpy(spc->scXArgs2.uPoints, spc->scXArgs.uPoints, loop*sizeof(XPoint));
    for (p = spc->scXArgs2.uPoints; loop-- > 0; p++) {
	p->x += dx; p->y += dy;
    }

    /* ޥѥ wkpix ˤȤꡢ뤿
     *  GC  wlgc Ȥ
     */
    wkpix = XCreatePixmap(spc->scDisp, dst,
			  sp_tr->teWidth, sp_tr->teHeight, 1);
    wkgc = XCreateGC(spc->scDisp, wkpix, 0, 0);
    XSetForeground(spc->scDisp, wkgc, 0);
    XFillRectangle(spc->scDisp, wkpix, wkgc,
		   0, 0, sp_tr->teWidth, sp_tr->teHeight);
    /* 1  FILL, 0 ǳ褹 */
    gcv.function = GXcopy;
    gcv.line_style = LineSolid;
    gcv.line_width = 0;
    gcv.fill_style = FillSolid;
    gcv.foreground = 1;
    gcv.background = 0;
    XChangeGC(spc->scDisp, wkgc,
	      (GCFunction|GCLineStyle|GCLineWidth|GCFillStyle|
	       GCForeground|GCBackground), &gcv);
    XFillPolygon(spc->scDisp, wkpix, wkgc, spc->scXArgs.uPoints,
		 spc->scXArgNum, Complex, CoordModeOrigin);
    gcv.line_width = spc->scLineWidth;
    gcv.foreground = 0;
    XChangeGC(spc->scDisp, wkgc, (GCLineWidth|GCForeground), &gcv);
    XDrawLines(spc->scDisp, wkpix, wkgc, spc->scXArgs.uPoints,
		 spc->scXArgNum, CoordModeOrigin);
    /*
     * wkpix ˥ޥѥƤ
     * ޥȤ FillPolygon Ԥʤ
     */
    XSetClipMask(spc->scDisp, spc->scGC, wkpix);
    XSetClipOrigin(spc->scDisp, spc->scGC, dx, dy);
    XFillPolygon(spc->scDisp, dst, spc->scGC, spc->scXArgs2.uPoints,
		 spc->scXArgNum, Complex, CoordModeOrigin);
    XSetClipMask(spc->scDisp, spc->scGC, None);
    XFreePixmap(spc->scDisp, wkpix);
    XFreeGC(spc->scDisp, wkgc);
    DebugSetFunc("splite", "splite_draw_polygon");
}

static void splite_free_draw_polygon(spc)
    struct splite_draw_cont *spc;
{
    if (spc->scXArgs.uPoints != (XPoint *)NULL) {
	memFREE((char *)(spc->scXArgs.uPoints));
	spc->scXArgs.uPoints = spc->scXArgs2.uPoints = (XPoint *)NULL;
    }
    spc->scXArgNum = spc->scXArgMax = 0;
    bzero(&spc->scModeEnt.uLineAttr, sizeof(YYGCONTEXT));
    /*NoReturnValue*/
}

static void splite_fix_draw_polygon(spc, sp_tr)
    struct splite_draw_cont *spc;
    TERRITORY *sp_tr;
{
    spc->scStat |= STSPLITE_FIXED;
}

static void splite_fix_and_draw_polygon(spc, sp_tr)
    struct splite_draw_cont *spc;
    TERRITORY *sp_tr;
{
    TERRITORY *parent = sp_tr->teParent;
    YYRectangle off;
    spc->scStat |= STSPLITE_FIXED;
    off.x = off.y = 0;
    if(IsVisibleTerritory(parent))
	(void)(*spc->scFunc)(spc, sp_tr, XEntry(parent)->txWindow, &off);
}


static struct splite_func_tab splite_draw_polygon_funcs = {
    splite_draw_polygon,		/*void (*fFunc)();*/
    splite_free_draw_polygon,		/*void (*fFreeFunc)();*/
    NULL,				/*bool (*fCheckFunc)();*/
    splite_fix_draw_polygon,		/*void (*fFixFunc)();*/
    splite_fix_and_draw_polygon,	/*void (*fFixRedrawFunc)();*/
} ;

static struct splite_func_tab splite_draw_filled_polygon_funcs = {
    splite_draw_filled_polygon,		/*void (*fFunc)();*/
    splite_free_draw_polygon,		/*void (*fFreeFunc)();*/
    NULL,				/*bool (*fCheckFunc)();*/
    splite_fix_draw_polygon,		/*void (*fFixFunc)();*/
    splite_fix_and_draw_polygon,	/*void (*fFixRedrawFunc)();*/
} ;

static struct splite_func_tab splite_draw_fill_inner_polygon_funcs = {
    splite_draw_fill_inner_polygon,		/*void (*fFunc)();*/
    splite_free_draw_polygon,		/*void (*fFreeFunc)();*/
    NULL,				/*bool (*fCheckFunc)();*/
    splite_fix_draw_polygon,		/*void (*fFixFunc)();*/
    splite_fix_and_draw_polygon,	/*void (*fFixRedrawFunc)();*/
} ;

void make_splite_draw_polygon(ch, tr, no, points, mode, gcon)
    yy_comm_channel *ch;
    TERRITORY *tr;	/* ץ饤ȥƥȥ */
    int no;
    XPoint *points;
    int mode;
    YYGCONTEXT *gcon;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY_SPLITE *sp = GetSpliteTerritoryEnt(tr);	
    struct splite_draw_cont *spc;

    /* ΰƤ */
    spc = alloc_splite_cont(sp);
    if (spc->scFuncTab != (struct splite_func_tab *)NULL &&
	spc->scFreeFunc)
	(*spc->scFreeFunc)(spc);
    spc->scDisp = xp->xDisp;
    spc->scXArgs.uPoints = (XPoint *)memCALLOC((no<<1), sizeof(XPoint));
    spc->scXArgNum = spc->scXArgMax = no;
    memcpy(spc->scXArgs.uPoints, points, no*sizeof(XPoint));
    spc->scXArgs2.uPoints = spc->scXArgs.uPoints + no;
    if (mode > 1) {
	spc->scFuncTab = &splite_draw_fill_inner_polygon_funcs;
	spc->scLineWidth = gcon->ygLineWidth;
    } else
	spc->scFuncTab = (mode? &splite_draw_filled_polygon_funcs:
		      &splite_draw_polygon_funcs);
    (void)append_splite_draw_cont(ch, tr, sp, spc);
}

/**************************************************
 *  ߸̡ߤ
 **************************************************/
static void splite_draw_arc(spc, sp_tr, dst, offset)
    struct splite_draw_cont *spc;
    TERRITORY *sp_tr;
    Drawable dst;
    YYRectangle *offset;
{
    register int dx = sp_tr->teX - offset->x;
    register int dy = sp_tr->teY - offset->y;
    register XPoint *p;
    register int loop = spc->scXArgNum;

    DebugSetFunc("splite", "splite_draw_arc");
    XDrawArc(spc->scDisp, dst, spc->scGC,
	     spc->scArcX + sp_tr->teX - offset->x,
	     spc->scArcY + sp_tr->teY - offset->y,
	     spc->scArcW, spc->scArcH, spc->scArcA1, spc->scArcA2);
    DebugSetFunc("splite", "splite_draw_arc");
}

static void splite_draw_filled_arc(spc, sp_tr, dst, offset)
    struct splite_draw_cont *spc;
    TERRITORY *sp_tr;
    Drawable dst;
    YYRectangle *offset;
{
    DebugSetFunc("splite", "splite_filled_arc");
    XFillArc(spc->scDisp, dst, spc->scGC,
	     spc->scArcX + sp_tr->teX - offset->x,
	     spc->scArcY + sp_tr->teY - offset->y,
	     spc->scArcW, spc->scArcH, spc->scArcA1, spc->scArcA2);
    DebugSetFunc("splite", "splite_filled_arc");
}

static void splite_free_draw_arc(spc)
    struct splite_draw_cont *spc;
{
    spc->scXArgNum = spc->scXArgMax = 0;
    /*NoReturnValue*/
}

static void splite_fix_draw_arc(spc, sp_tr)
    struct splite_draw_cont *spc;
    TERRITORY *sp_tr;
{
    spc->scStat |= STSPLITE_FIXED;
}

static void splite_fix_and_draw_arc(spc, sp_tr)
    struct splite_draw_cont *spc;
    TERRITORY *sp_tr;
{
    TERRITORY *parent = sp_tr->teParent;
    YYRectangle off;
    spc->scStat |= STSPLITE_FIXED;
    off.x = off.y = 0;
    if(IsVisibleTerritory(parent))
	(void)(*spc->scFunc)(spc, sp_tr, XEntry(parent)->txWindow, &off);
}


static struct splite_func_tab splite_draw_arc_funcs = {
    splite_draw_arc,		/*void (*fFunc)();*/
    splite_free_draw_arc,		/*void (*fFreeFunc)();*/
    NULL,				/*bool (*fCheckFunc)();*/
    splite_fix_draw_arc,		/*void (*fFixFunc)();*/
    splite_fix_and_draw_arc,	/*void (*fFixRedrawFunc)();*/
} ;

static struct splite_func_tab splite_draw_filled_arc_funcs = {
    splite_draw_filled_arc,		/*void (*fFunc)();*/
    splite_free_draw_arc,		/*void (*fFreeFunc)();*/
    NULL,				/*bool (*fCheckFunc)();*/
    splite_fix_draw_arc,		/*void (*fFixFunc)();*/
    splite_fix_and_draw_arc,	/*void (*fFixRedrawFunc)();*/
} ;

void make_splite_draw_arc(ch, tr, x, y, w, h, a1, a2, mode)
    yy_comm_channel *ch;
    TERRITORY *tr;	/* ץ饤ȥƥȥ */
    int x, y, w, h, a1, a2, mode;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY_SPLITE *sp = GetSpliteTerritoryEnt(tr);	
    struct splite_draw_cont *spc;

    /* ΰƤ */
    spc = alloc_splite_cont(sp);
    if (spc->scFuncTab != (struct splite_func_tab *)NULL &&
	spc->scFreeFunc)
	(*spc->scFreeFunc)(spc);
    spc->scDisp = xp->xDisp;
    spc->scArcX = x; spc->scArcY = y;
    spc->scArcW = w; spc->scArcH = h;
    spc->scArcA1 = a1; spc->scArcA2 = a2;
    spc->scFuncTab = (mode? &splite_draw_filled_arc_funcs:
		      &splite_draw_arc_funcs);
    (void)append_splite_draw_cont(ch, tr, sp, spc);
}




/**************************************************
 *  ʸ
 **************************************************/

#ifdef BUGBUGSPLITE
/* DSӤDκɸϤXORζ */
get_rect_exor(d,s,dx,dy,dw,dh,sx,sy)
    TERRITORY *d,*s;
    int *dx,*dy,*dw,*dh,*sx,*sy;
{
    if(rect_in(d,s)) {
	if( d->teX <= s->teX && d->teX + d->teWidth >= s->teX ) {
	    *dx = s->teX - d->teX;
	    *sx = 0;
	    *dw = MIN(d->teWidth - *dx , s->teWidth);
	}
	else if ( d->teX <= s->teX + s->teWidth &&
		 d->teX + d->teWidth >= s->teX + s->teWidth) {
	    *dx = 0;
	    *sx = d->teX - s->teX;
	    *dw = MIN(s->teWidth - *sx,d->teWidth);
	} else {
	    *dx = 0;
	    *sx = d->teX - s->teX;
	    *dw = d->teWidth;
	}
	if(d->teY <= s->teY && d->teY + d->teHeight >= s->teY) {
	    *dy = s->teY - d->teY;
	    *sy = 0;
	    *dh = MIN(s->teHeight,d->teHeight - *dy);
	}
	else if (d->teY <= s->teY + s->teHeight &&
		 d->teY + d->teHeight >= s->teY + s->teHeight) {
	    *dy = 0;
	    *sy = d->teY - s->teY;
	    *dh = MIN(d->teHeight,s->teHeight - *sy);
	} else {
	    *dy = 0;
	    *sy = d->teY - s->teY;
	    *dh = d->teHeight;
	}
    } else {
	if( rect_in(s,d) ) {
	    get_rect_exor(s,d,sx,sy,dw,dh,dx,dy);
	}
    }
}
#endif /*BUGBUGSPLITE*/

void splite_draw_string(spc, sp_tr, dst, offset)
    struct splite_draw_cont *spc;
    TERRITORY *sp_tr;
    Drawable dst;
    YYRectangle *offset;
{
    TERRITORY_SPLITE *sp = GetSpliteTerritoryEnt(sp_tr);

    DebugSetFunc("splite", "splite_draw_string");
    DebugPrint2(8, "Draw String with offset (%d,%d)\n",
		(offset? offset->x: 0), (offset? offset->y: 0));
    if (offset != (YYRectangle *)NULL && (offset->x != 0 || offset->y != 0)) {
	/* եåȤΤʤν
	 *  ޥ StringPix ꤷԤʤ
	 *   StringPix  Drawable dst ˥ԡ뤳ȤǹԤʤ
	 */
	XSetClipMask(spc->scDisp, spc->scGC, spc->scStringPix);
	XSetClipOrigin(spc->scDisp, spc->scGC,
		       sp_tr->teX-offset->x, sp_tr->teY-offset->y);
	XCopyPlane(spc->scDisp, spc->scStringPix, dst, spc->scGC,
		   0, 0, sp_tr->teWidth, sp_tr->teHeight,
		   sp_tr->teX-offset->x, sp_tr->teY-offset->y, 1);
	XSetClipMask(spc->scDisp, spc->scGC, None);
	DebugPrint6(8, "> String Pixmap (%d,%d)[%d,%d] - (%d,%d)\n",
		    sp_tr->teX, sp_tr->teY, sp_tr->teWidth, sp_tr->teHeight,
		    offset->x, offset->y);
#ifdef BUGBUGSPLITE
	int x,y,*top;
	top = draw->args;
	Disp = (Display *)*top++;
	TERRITORY_SPLITE *tosp = GetSpliteTerritoryEnt(to_splite_tr);
	if (tosp->draw) {
	    TERRITORY_X_ENTRY *tx = GetTerritoryXEntry(to_splite_tr);
	    if(! temp_gc) {
		temp_gc =  XCreateGC(Disp,tx->txPixmap,0L,0);
	    }
	    XCopyGC(Disp,tosp->draw->sp_gc,GCForeground,temp_gc);
	    XCopyGC(Disp,draw->sp_gc,GCForeground,
		    tosp->draw->sp_gc);
	    get_rect_exor(splite_tr,to_splite_tr,&dx,&dy,&dw,&dh,&sx,&sy);
	    XSetClipMask(Disp,tosp->draw->sp_gc,draw->string_pix);
	    XSetClipOrigin(Disp,tosp->draw->sp_gc,sx - dx,sy - dy);
	    
	    /* ޥ򥻥åȤ */
	    XCopyPlane(Disp,draw->string_pix,to,
		       tosp->draw->sp_gc,dx,dy,dw,dh,sx,sy,1);
	    XSetClipMask(Disp,tosp->draw->sp_gc,None);
	    XCopyGC(Disp,temp_gc,GCForeground,tosp->draw->sp_gc);
	}
#endif /*BUGBUGSPLITE*/
    } else {
	/* եåȤΤʤν
	 *  ޥ StringPix ꤷԤʤ
	 *   StringPix  Drawable dst ˥ԡ뤳ȤǹԤʤ
	 */
	XSetClipMask(spc->scDisp, spc->scGC, spc->scStringPix);
	XSetClipOrigin(spc->scDisp, spc->scGC, sp_tr->teX, sp_tr->teY);
	XCopyPlane(spc->scDisp, spc->scStringPix, dst, spc->scGC,
		   0, 0, sp_tr->teWidth, sp_tr->teHeight,
		   sp_tr->teX, sp_tr->teY, 1);
	XSetClipMask(spc->scDisp, spc->scGC, None);
	DebugPrint4(8, "> String Pixmap (%d,%d)[%d,%d]\n",
		    sp_tr->teX, sp_tr->teY, sp_tr->teWidth, sp_tr->teHeight);
    }
    DebugEndFunc("splite", "splite_draw_string");
}

static void splite_fix_draw_string(spc, sp_tr)
    struct splite_draw_cont *spc;
    TERRITORY *sp_tr;
{
    spc->scStat |= STSPLITE_FIXED;
}

static void splite_fix_and_draw_string(spc, sp_tr)
    struct splite_draw_cont *spc;
    TERRITORY *sp_tr;
{
    TERRITORY *parent = sp_tr->teParent;
    YYRectangle off;
    spc->scStat |= STSPLITE_FIXED;
    off.x = off.y = 0;
    if(IsVisibleTerritory(parent))
	(void)(*spc->scFunc)(spc, sp_tr, XEntry(parent)->txWindow, &off);
}

static struct splite_func_tab splite_draw_string_funcs = {
    splite_draw_string,			/*void (*fFunc)();*/
    NULL, /*splite_free_draw_point,		/*void (*fFreeFunc)();*/
    NULL,				/*bool (*fCheckFunc)();*/
    splite_fix_draw_string,		/*void (*fFixFunc)();*/
    splite_fix_and_draw_string,		/*void (*fFixRedrawFunc)();*/
} ;


/* ʸ⡼ɤ襷󥹤֤ */
struct splite_draw_cont *get_string_draw_sp(tr)
    TERRITORY *tr;
{
    TERRITORY_SPLITE *sp = GetSpliteTerritoryEnt(tr);
    register struct splite_draw_cont *spc = sp->spDraw;
    
    for ( ; spc != (struct splite_draw_cont *)NULL; spc = spc->scNext) {
	if (spc->scStat & STSPLITE_CLEAR) {
	    spc = (struct splite_draw_cont *)NULL; break;
	}
	if (spc->scFuncTab == &splite_draw_string_funcs) break;
    }
    return spc;
}


/* ʸ襷󥹤Ͽ
 */
void make_splite_draw_string_init(ch,tr)
    yy_comm_channel *ch;
    TERRITORY *tr;
{
    x_private *xp = XPRIVATE(ch);
    struct splite_draw_cont *spc;


    TERRITORY_X_ENTRY *tx = GetTerritoryXEntry(tr);
    TERRITORY_SPLITE *sp = GetSpliteTerritoryEnt(tr);	
    struct splite_draw_cont *now,*temp;
    int *arg,*top;
    
    DebugSetFunc("splite", "make_splite_draw_string_init");
    if ((spc = get_string_draw_sp(tr)) == (struct splite_draw_cont *)NULL) {
	/* ˳դ
	 */
	spc = alloc_splite_cont(sp);
	if (spc->scFuncTab != (struct splite_func_tab *)NULL) {
	    if (spc->scFuncTab == &splite_draw_string_funcs) {
		if (spc->scStringPix != (Pixmap)NULL) {
		    XFreePixmap(xp->xDisp, spc->scStringPix);
		    spc->scStringPix = (Pixmap)NULL;
		}
	    } else {
		if (spc->scFreeFunc) (*spc->scFreeFunc)(spc);
		spc->scStringGC = (GC)NULL;
	    }
	} else {
	    bzero(&spc->scModeEnt.uStringAttr,
		  sizeof(struct splite_string_ent));
	}
	spc->scDisp = xp->xDisp;
	spc->scStringPix = XCreatePixmap(xp->xDisp, tx->txWindow,
					 tr->teWidth, tr->teHeight, 1);
	if (spc->scStringGC == (GC)NULL)
	    spc->scStringGC = XCreateGC(xp->xDisp, spc->scStringPix, 0, 0);
	XSetFunction(xp->xDisp, spc->scStringGC, GXcopy);
	XSetForeground(xp->xDisp, spc->scStringGC, 0);
	XFillRectangle(xp->xDisp, spc->scStringPix, spc->scStringGC,
		       0, 0, tr->teWidth, tr->teHeight);
	XSetForeground(xp->xDisp, spc->scStringGC, 1);
	XSetBackground(xp->xDisp, spc->scStringGC, 0);
	spc->scFuncTab = &splite_draw_string_funcs;
	(void)append_splite_draw_cont(ch, tr, sp, spc);
    }
    DebugEndFunc("splite", "make_splite_draw_string_init");
}


/**********************************************************************
 *****
 *****  ץ饤ȥƥȥФ Redraw ʤ
 *****
 **********************************************************************/



/* void put_objects_on_splite(sp_tr, dst, offset)
 *
 * ץ饤ȥƥȥ sp_tr ϿƤ
 *  襷󥹤 Drawable dst ФŬ
 *  κݤ offset ꤵƤФθ
 *
 */
void put_objects_on_splite(sp_tr, dst, offset)
    TERRITORY *sp_tr;		/* 襷󥹤ĥץ饤ȥƥȥ */
    Drawable dst;		/* оݥɥ֥ */
    YYRectangle *offset;	/* offset */
{
    register TERRITORY_SPLITE *sp = GetSpliteTerritoryEnt(sp_tr);
    bool have_off;
    YYRectangle dummy;

    DebugSetFunc("splite", "put_objects_on_splite");
    if (!(have_off = (offset != (YYRectangle *)NULL))) {
	dummy.x = dummy.y = 0; offset = &dummy;
    }
    if (sp->spDraw != (struct splite_draw_cont *)NULL) {
	register struct splite_draw_cont *p;

	/* 襷󥹤 fix Ƥʤ
	 *  fix  */
	if (sp->spLastGC != (struct splite_draw_cont *)NULL &&
	    !(sp->spLastGC->scStat & STSPLITE_FIXED)) {
	    void (*func)();
	    func = (have_off? sp->spLastGC->scFixRedrawFunc:
		    sp->spLastGC->scFixFunc);
	    if (func) (*func)(sp->spLastGC, sp_tr);
	}

	/* 襷󥹳ƹ dst ФŬ
	 *  襷󥹤 Clear ƤФǽλ
	 */
	p = sp->spDraw;
	for ( ; p != (struct splite_draw_cont *)NULL; p = p->scNext) {
	    if (p->scStat & STSPLITE_CLEAR) break;
	    if (!(p->scStat & STSPLITE_COMPACT))
		(*p->scFunc)(p, sp_tr, dst, offset);
	}
    }
    DebugEndFunc("splite", "put_objects_on_splite");
    /*NoReturnValue*/
}

/* ƥȥ tr ΰΰͳѷ rect ˤ TRUE
 *  ʤ FALSE ֤
 */
#define RECT_RIGHT(r)	((r)->x+(r)->w)
#define TR_RIGHT(tr)	((tr)->teX+(tr)->teWidth)
#define RECT_BOTTOM(r)	((r)->y+(r)->h)
#define TR_BOTTOM(tr)	((tr)->teY+(tr)->teHeight)

static bool yy_rect_and(rect, tr)
    YYRectangle *rect;
    TERRITORY *tr;
{
#ifdef WHATWHAT
    if (tr->teX > rect->x + rect->w)
	return FALSE;
    if (rect->x > tr->teX + tr->teWidth)
	return FALSE;
    if (tr->teY > rect->y + rect->h)
	return FALSE;
    if (rect->y > tr->teY + tr->teHeight)
	return FALSE;
#endif
    return TRUE;
}
    

/* ץ饤ȥƥȥ tr Ф CLEAR ưͽäƤ
 *  ¹Ԥ
 *
 * sp->scClrRect ꥢоݤݻƤ
 *
 * ư
 *  1) ƤΥƥȥθطʤȤ tr  Pixmap 
 *  2)  Pixmap  tr ƱΥץ饤ȥƥȥ
 *      ʪŤͤƤ
 *  3) ƤΥƥȥ Window  Pixmap Ƥ᤹
 */
static void splite_remove_objects(ch, tr)
    yy_comm_channel *ch;
    TERRITORY *tr;	/*  ץ饤ȥƥȥ */
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *parent, *ctr;
    TERRITORY_X_ENTRY *tx, *parent_tx;
    TERRITORY_SPLITE *sp = GetSpliteTerritoryEnt(tr);
    YYRectangle *crect = &sp->spClrRect;
    XRectangle xrect;
    GC gc;
    int src_x, src_y, dst_x, dst_y, width, height;

    DebugSetFunc("splite", "splite_remove_objects");
    yysched_delque(ch, tr->teID, YYSCHED_TYPE_SPLITE_CLEAR, (-1));

    /* оݤȤʤʤå
     */
    if((parent = GetParentTerritory(tr)) == (TERRITORY *)NULL ||
       !IsDrawableTerritory(parent) || !IsVisibleTerritory(parent) ||
       crect->w == 0 || crect->h == 0) 
	goto finish_clear;

    /* ƤΥƥȥ꤫ ClrRect ΰ Pixmap 
     */
    src_x = crect->x; src_y = crect->y;
    width = crect->w; height = crect->h; 
    DebugPrint4(5, "Remove Splite Objects on (0,0)[%d,%d] - Win (%d,%d)\n",
		width, height, src_x, src_y);

    tx = GetTerritoryXEntry(tr);
    parent_tx = GetTerritoryXEntry(parent);
    gc = XEntry(parent)->txGC;
    XSetFunction(xp->xDisp, gc, GXcopy);
#ifdef BUGBUGSPLITE
    xrect.x = xrect.y = 0;
    xrect.width = tr->teWidth; xrect.height = tr->teHeight;
    XSetClipRectangles(xp->xDisp, parent_tx->txGC, 0, 0, &xrect, 1, YXBanded);
#endif
    XCopyArea(xp->xDisp, parent_tx->txPixmap, tx->txPixmap, gc,
	      src_x, src_y, width, height, 0, 0);

    /* Ʒ (src_x,src_y)[width,height] ΰȽŤʤ
     *  ʬľ褹
     *  κݤ ClrRect 򥪥եåȤȤƤ
     */
    ctr = parent->teChildren;
    while (ctr != (TERRITORY *)NULL && ctr->teNextGen != (TERRITORY *)NULL)
	ctr = ctr->teNextGen;
    for ( ; ctr != (TERRITORY *)NULL; ctr = ctr->tePrevGen) {
	if (ctr->teTRType == TR_SPLITE && IsVisibleTerritory(ctr) &&
	    yy_rect_and(crect, ctr))
	    put_objects_on_splite(ctr, tx->txPixmap, crect);
    }

    /* ƤΥƥȥΤ Window ˳᤹ */
#ifdef BUGBUGSPLITE
    xrect.x = xrect.y = 0;
    xrect.width = width; xrect.height = height;
    XSetClipRectangles(xp->xDisp, parent_tx->txGC, src_x, src_y,
		       &xrect, 1, YXBanded);
#endif
    XSetFunction(xp->xDisp, gc, GXcopy);
    XCopyArea(xp->xDisp, tx->txPixmap, parent_tx->txWindow, gc,
	      0, 0, width, height, src_x, src_y);
    /*****
     ***** XSetForeground(xp->xDisp, gc, 1);
     ***** XFillRectangle(xp->xDisp, parent_tx->txWindow, gc,
     ***** src_x, src_y, width, height);
     *****/
    ch->ccXNeedFlush = TRUE;
    bzero((char *)crect, sizeof(YYRectangle));

 finish_clear:
    DebugEndFunc("splite", "splite_remove_objects");
    /*NoReturnValue*/
}    


/*
 *
 * ץ饤ȥƥȥ tr ξʪ򤹤٤Ʋ̤ä
 * ̤äǤäơ襷󥹤ΤΤݻ
 */
void delete_objects_on_splite(ch, tr)
    yy_comm_channel *ch;
    TERRITORY *tr;
{
    TERRITORY_SPLITE *sp = GetSpliteTerritoryEnt(tr);
    bool visible = IsVisibleTerritory(tr);

    DebugSetFunc("splite", "delete_objects_on_splite");
    /* Ǥ˥ꥢΰ褬ꤵƤΤǤ
     *  ޤ¹Ԥ
     */
    if (sp->spClrRect.w != 0 && sp->spClrRect.h != 0)
	splite_remove_objects(ch, tr);

    /* ƥȥ tr ΰ֤礭򤽤ΤޤޥꥢΰȤ
     *  ꥢ¹Ԥ
     */
    sp->spClrRect.x = tr->teX; sp->spClrRect.y = tr->teY;
    sp->spClrRect.w = tr->teWidth; sp->spClrRect.h = tr->teHeight;
    tr->teVisible = 0;	/* Visible äʤ褵Ƥޤ */
    (void)splite_remove_objects(ch, tr);
    tr->teVisible = (visible? 1: 0);
    DebugEndFunc("splite", "delete_objects_on_splite");
    /*NoReturnValue*/
}


/*
 * ץ饤ȥƥȥ tr 襷󥹤򥯥ꥢ
 * ̾Τβä
 *
 */
void clear_splite_territory(ch,tr)
    yy_comm_channel *ch;
    TERRITORY *tr;
{
    (void)delete_objects_on_splite(ch, tr);
    (void)destroy_all_splite_cont(tr);
}

/*
 * ץ饤ȥƥȥ襷󥹤Ф
 * ꥢ֤ˤ
 *
 * ºݤΥꥢȤϹԤʤʤ褬Ϥ
 * ꥢԤʤ
 */
void set_clear_on_splite(ch, tr)
    yy_comm_channel *ch;
    TERRITORY *tr;
{
    TERRITORY_SPLITE *sp = GetSpliteTerritoryEnt(tr);
    DebugSetFunc("splite", "set_clear_on_splite");
    if (sp->spLastCont != (struct splite_draw_cont *)NULL) {
	sp->spDraw->scStat |= STSPLITE_CLEAR;
	sp->spClrRect.x = tr->teX; sp->spClrRect.y = tr->teY;
	sp->spClrRect.w = tr->teWidth; sp->spClrRect.h = tr->teHeight;
	sp->spLastCont = sp->spLastGC = (struct splite_draw_cont *)NULL;
	DebugPrint4(9, "Clear on Splite (%d,%d)[%d,%d]\n",
		    sp->spClrRect.x, sp->spClrRect.y,
		    sp->spClrRect.w, sp->spClrRect.h);
	/*(void)splite_remove_objects(ch, tr);*/
	yysched_addque(ch, yy_splite_clear_timer, tr->teID,
		       YYSCHED_TYPE_SPLITE_CLEAR, 0, NULL, 500);
    }
    DebugEndFunc("splite", "set_clear_on_splite");
}

/*
 *
 * ǽʥƥȥ tr Τ Window Ф
 *  Υƥȥ tr λҶΥץ饤ȥƥȥʪ򤹤٤
 *  褹
 */
void redraw_splite_territory(tr)
    register TERRITORY *tr;	/* Ƥˤʤƥȥ */ 
{
    DebugSetFunc("splite", "redraw_splite_territory");
    if(IsDrawableTerritory(tr) && IsVisibleTerritory(tr)) {
	register Window win = XEntry(tr)->txWindow;
	register TERRITORY *ctr = tr->teChildren;
	XRectangle xrect;
	xrect.x = xrect.y = 0;

	while (ctr != (TERRITORY *)NULL && ctr->teNextGen != (TERRITORY *)NULL)
	    ctr = ctr->teNextGen;
	for ( ; ctr != (TERRITORY *)NULL; ctr = ctr->tePrevGen) {
	    if (ctr->teTRType == TR_SPLITE && IsVisibleTerritory(ctr))
		(void)put_objects_on_splite(ctr, win, &xrect);
	}
    }
    DebugEndFunc("splite", "redraw_splite_territory");
    /*NoReturnValue*/
}

/**********************************************************************
 **********************************************************************/

/*
 * Local variables:
 * eval: (set-kanji-fileio-code 'EUC)
 * end:
 */
