/* Support Character Input on Page Territory
 * This file is part of YY-server of YYonX (1.3 Distribution)
 * $Id: edit_kana.c,v 3.0 1992/10/08 04:59:44 keisuke Exp $
 */

#ifndef lint
static char *RcsId =
    "$Id: edit_kana.c,v 3.0 1992/10/08 04:59:44 keisuke Exp $";
#endif

/****************************************************************************
%%%COPYRIGHT%%%
;;; Authors:
;;;   Version 1.0 90/06/07 by Keisuke 'Keiko' Tanaka
;;;				(keisuke@csrl.aoyama.ac.jp)
;;;
****************************************************************************/

/****************************************************************************
  $Revision: 3.0 $ Written by Keisuke 'Keiko' Tanaka
  $Date: 1992/10/08 04:59:44 $
****************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include "yydefs.h"
#include "yypacket.h"
#include "xwindow.h"
#include "territory.h"

#ifdef WNNKINPUT
#include <wnn/rk_spclval.h>
#include <wnn/jllib.h>

static u_char kana_keyin_buffer[128];
int kana_keyin_depth = 0;

void push_kana_keyinput(leng, ptr)
    int leng;
    u_char *ptr;
{
    DebugSetFunc("kanainput", "push_kana_keyinput");
    while (leng-- > 0) {
	kana_keyin_buffer[kana_keyin_depth++] = *(ptr+leng);
    }
    DebugEndFunc("kanainput", "push_kana_keyinput");
    /*NoReturnValue*/
}

int pop_kana_keyinput()
{
    register int ret = EOF;
    DebugSetFunc("kanainput", "pop_kana_keyinput");
    if (kana_keyin_depth > 0)
	ret = kana_keyin_buffer[--kana_keyin_depth];
    DebugEndFunc("kanainput", "pop_kana_keyinput");
    return ret;
}


/**********************************************************************
 ***
 ***/

static void kana_beginning_of_fence(ch, tr, leng, ptr)
    yy_comm_channel *ch;
    TERRITORY *tr;
    int leng;
    u_char *ptr;
{
    TERRITORY *input_tr = tr->teModeEnt.tPageControl.pcInputTerritory;
    TERRITORY_PAGE *input_pg = &input_tr->teModeEnt.tPageControl;
    register int col;
    register int nc =
	total_nchar_in_line_buffer(input_pg->pcKanaInputPlane.curLineTop);

    DebugSetFunc("kanainput", "kana_beginning_of_fence");
    if (nc == 0) {
	unget_keyin_on_input_territory(YYIN_ASCII, leng, ptr);
    } else if ((col = input_pg->pcKanaInputPlane.curCol) > 0) {
	DebugPrint1(9, " Col on KanaInputPlane = %d\n", col);
	move_char_cursor_on_page(&input_pg->pcPagePlane, -col, 0);
	move_char_cursor_on_page(&input_pg->pcKanaInputPlane, -col, 0);
    }
    DebugEndFunc("kanainput", "kana_beginning_of_fence");
    /*NoReturnValue*/
}

static void kana_end_of_fence(ch, tr, leng, ptr)
    yy_comm_channel *ch;
    TERRITORY *tr;
    int leng;
    u_char *ptr;
{
    TERRITORY *input_tr = tr->teModeEnt.tPageControl.pcInputTerritory;
    TERRITORY_PAGE *input_pg = &input_tr->teModeEnt.tPageControl;
    register int col = input_pg->pcKanaInputPlane.curCol;
    register int nc =
	total_nchar_in_line_buffer(input_pg->pcKanaInputPlane.curLineTop);

    DebugSetFunc("kanainput", "kana_end_of_fence");
    DebugPrint2(9, " EndOfFence on %d <%d>\n", col, nc);
    if (nc == 0) {
	unget_keyin_on_input_territory(YYIN_ASCII, leng, ptr);
    } else if (nc > col) {
	move_char_cursor_on_page(&input_pg->pcPagePlane, (nc-col), 0);
	move_char_cursor_on_page(&input_pg->pcKanaInputPlane, (nc-col), 0);
    }
    DebugEndFunc("kanainput", "kana_end_of_fence");
    /*NoReturnValue*/
}

static void kana_forward_char(ch, tr, leng, ptr)
    yy_comm_channel *ch;
    TERRITORY *tr;
    int leng;
    u_char *ptr;
{
    TERRITORY *input_tr = tr->teModeEnt.tPageControl.pcInputTerritory;
    TERRITORY_PAGE *input_pg = &input_tr->teModeEnt.tPageControl;
    register int col = input_pg->pcKanaInputPlane.curCol;
    register int nc =
	total_nchar_in_line_buffer(input_pg->pcKanaInputPlane.curLineTop);

    DebugSetFunc("kanainput", "kana_forward_char");
    DebugPrint2(9, " ForwardChar on %d <%d>\n", col, nc);
    if (nc == 0) {
	unget_keyin_on_input_territory(YYIN_ASCII, leng, ptr);
    } else if (nc > col) {
	move_char_cursor_on_page(&input_pg->pcPagePlane, 1, 0);
	move_char_cursor_on_page(&input_pg->pcKanaInputPlane, 1, 0);
    }
    DebugEndFunc("kanainput", "kana_forward_char");
    /*NoReturnValue*/
}

static void kana_backward_char(ch, tr, leng, ptr)
    yy_comm_channel *ch;
    TERRITORY *tr;
    int leng;
    u_char *ptr;
{
    TERRITORY *input_tr = tr->teModeEnt.tPageControl.pcInputTerritory;
    TERRITORY_PAGE *input_pg = &input_tr->teModeEnt.tPageControl;
    register int col = input_pg->pcKanaInputPlane.curCol;
    register int nc =
	total_nchar_in_line_buffer(input_pg->pcKanaInputPlane.curLineTop);

    DebugSetFunc("kanainput", "kana_backward_char");
    DebugPrint1(9, " BackwardChar on %d\n", col);
    if (nc == 0) {
	unget_keyin_on_input_territory(YYIN_ASCII, leng, ptr);
    } else if (col > 0) {
	move_char_cursor_on_page(&input_pg->pcPagePlane, (-1), 0);
	move_char_cursor_on_page(&input_pg->pcKanaInputPlane, (-1), 0);
    }
    DebugEndFunc("kanainput", "kana_backward_char");
    /*NoReturnValue*/
}

static void kana_delete_char(ch, tr, leng, ptr)
    yy_comm_channel *ch;
    TERRITORY *tr;
    int leng;
    u_char *ptr;
{
    TERRITORY *input_tr = tr->teModeEnt.tPageControl.pcInputTerritory;
    TERRITORY_PAGE *input_pg = &input_tr->teModeEnt.tPageControl;
    register int col = input_pg->pcKanaInputPlane.curCol;
    register int nc =
	total_nchar_in_line_buffer(input_pg->pcKanaInputPlane.curLineTop);

    DebugSetFunc("kanainput", "kana_delete_char");
    DebugPrint2(9, " DelteChar on %d <%d>\n", col, nc);
    if (nc == 0) {
	unget_keyin_on_input_territory(YYIN_ASCII, leng, ptr);
    } else if (nc > col) {
	if (nc > 1) {
	    delete_string_on_page(&input_pg->pcPagePlane, 1);
	} else { /* ե󥹤Ʊ˾õ */
	    move_char_cursor_on_page(&input_pg->pcPagePlane, (-1), 0);
	    delete_string_on_page(&input_pg->pcPagePlane, 3);
	}
	delete_string_on_page(&input_pg->pcKanaInputPlane, 1);
	redraw_page_plane(ch, input_tr, &input_pg->pcPagePlane);
    }
    DebugEndFunc("kanainput", "kana_delete_char");
    /*NoReturnValue*/
}

static void kana_delete_backward_char(ch, tr, leng, ptr)
    yy_comm_channel *ch;
    TERRITORY *tr;
    int leng;
    u_char *ptr;
{
    TERRITORY *input_tr = tr->teModeEnt.tPageControl.pcInputTerritory;
    TERRITORY_PAGE *input_pg = &input_tr->teModeEnt.tPageControl;
    register int col = input_pg->pcKanaInputPlane.curCol;
    register int nc =
	total_nchar_in_line_buffer(input_pg->pcKanaInputPlane.curLineTop);

    DebugSetFunc("kanainput", "kana_delete_backward_char");
    DebugPrint2(9, " DelteBackwardChar on %d <%d>\n", col, nc);
    if (nc == 0) {
	unget_keyin_on_input_territory(YYIN_ASCII, leng, ptr);
    } else if (col > 0) {
	if (nc > 1) {
	    move_char_cursor_on_page(&input_pg->pcPagePlane, (-1), 0);
	    delete_string_on_page(&input_pg->pcPagePlane, 1);
	} else {
	    move_char_cursor_on_page(&input_pg->pcPagePlane, (-2), 0);
	    delete_string_on_page(&input_pg->pcPagePlane, 3);
	}
	move_char_cursor_on_page(&input_pg->pcKanaInputPlane, (-1), 0);
	delete_string_on_page(&input_pg->pcKanaInputPlane, 1);
	redraw_page_plane(ch, input_tr, &input_pg->pcPagePlane);
    }
    DebugEndFunc("kanainput", "kana_delete_backward_char");
    /*NoReturnValue*/
}

static void kana_kill_line(ch, tr, leng, ptr)
    yy_comm_channel *ch;
    TERRITORY *tr;
    int leng;
    u_char *ptr;
{
    TERRITORY *input_tr = tr->teModeEnt.tPageControl.pcInputTerritory;
    TERRITORY_PAGE *input_pg = &input_tr->teModeEnt.tPageControl;
    register int col = input_pg->pcKanaInputPlane.curCol;
    register int nc =
	total_nchar_in_line_buffer(input_pg->pcKanaInputPlane.curLineTop);

    DebugSetFunc("kanainput", "kana_kill_line");
    if (nc == 0) {
	unget_keyin_on_input_territory(YYIN_ASCII, leng, ptr);
    } else if (nc > col) {
	if (col > 0) {
	    delete_string_on_page(&input_pg->pcPagePlane, (nc-col));
	} else {
	    move_char_cursor_on_page(&input_pg->pcPagePlane, (-1), 0);
	    delete_string_on_page(&input_pg->pcPagePlane, (nc-col)+2);
	}
	delete_string_on_page(&input_pg->pcKanaInputPlane, (nc-col));
	redraw_page_plane(ch, input_tr, &input_pg->pcPagePlane);
    }
    DebugEndFunc("kanainput", "kana_kill_line");
    /*NoReturnValue*/
}

static void kana_input_kakutei(ch, tr, leng, ptr)
    yy_comm_channel *ch;
    TERRITORY *tr;
    int leng;
    u_char *ptr;
{
    TERRITORY *input_tr = tr->teModeEnt.tPageControl.pcInputTerritory;
    TERRITORY_PAGE *input_pg = &input_tr->teModeEnt.tPageControl;
    register int col = input_pg->pcKanaInputPlane.curCol;
    register int nc =
	total_nchar_in_line_buffer(input_pg->pcKanaInputPlane.curLineTop);
    u_char buf[32];

    DebugSetFunc("kanainput", "kana_input_kakutei");
    if (nc == 0) {
	/*ϤʤƤʤ --> Ϥ̵뤹*/
	unget_keyin_on_input_territory(YYIN_ASCII, leng, ptr);
	DebugEndFunc("kanainput", "kana_input_kakutei");
	return /*NoReturnValue*/;
    }
    /* ɽΰξõ */
    move_char_cursor_on_page(&input_pg->pcPagePlane, -(col+1), 0);
    delete_string_on_page(&input_pg->pcPagePlane, nc+2);
    /* pcKanaInputPlane ŬʸĥФ
     * pcPagePlane  pcInputPlane  */
    move_char_cursor_on_page(&input_pg->pcKanaInputPlane, -col, 0);
    while (nc > 0) {
	register int free = MIN((sizeof(buf)>>1),nc);
	register int leng, n;
	leng = get_string_on_page(&input_pg->pcKanaInputPlane, free, buf);
	insert_string_on_page(&input_pg->pcPagePlane,
			      GETPAGEFID(input_pg), leng, buf);
	insert_string_on_page(&input_pg->pcInputPlane,
			      GETPAGEFID(input_pg), leng, buf);
	nc -= (n = JEUC_StrNChar(leng, buf));
	move_char_cursor_on_page(&input_pg->pcKanaInputPlane, n, 0);
    }
    redraw_page_plane(ch, input_tr, &input_pg->pcPagePlane);
    /* pcKanaInputPlane κ */
    destroy_page_plane(&input_pg->pcKanaInputPlane);
    init_page_plane(&input_pg->pcKanaInputPlane, GETPAGEFID(input_pg),
		    4, "    ");
    locate_char_cursor_on_page(&input_pg->pcKanaInputPlane, 0, 0);
    /**/
    DebugEndFunc("kanainput", "kana_input_kakutei");
    /*NoReturnValue*/
}

static void kana_stop_kana_input(ch, tr, leng, ptr)
    yy_comm_channel *ch;
    TERRITORY *tr;
    int leng;
    u_char *ptr;
{
    TERRITORY *input_tr = tr->teModeEnt.tPageControl.pcInputTerritory;
    TERRITORY_PAGE *input_pg = &input_tr->teModeEnt.tPageControl;
    register int col = input_pg->pcKanaInputPlane.curCol;
    register int nc =
	total_nchar_in_line_buffer(input_pg->pcKanaInputPlane.curLineTop);
    DebugSetFunc("kanainput", "kana_stop_kana_input");
    if (nc == 0) {
	input_pg->pcOperationMode &= ~PAGEOP_INPUTMODE;
	input_pg->pcOperationMode |= YYIN_ASCII;
    }
    DebugEndFunc("kanainput", "kana_stop_kana_input");
    /*NoReturnValue*/
}

extern void kanji_henkan();

YYEDITFUNCLIST YYKanaInputEditFuncList[] = {
{ "beginning-of-fence", kana_beginning_of_fence },
{ "end-of-fence", kana_end_of_fence },
{ "backward-char", kana_backward_char },
{ "forward-char", kana_forward_char },
{ "delete-char", kana_delete_char },
{ "delete-backward-char", kana_delete_backward_char },
{ "kill-line", kana_kill_line },
{ "kana-kakutei", kana_input_kakutei },
{ "henkan", kanji_henkan },
{ "kanji-henkan", kanji_henkan },
{ "stop-kana-input", kana_stop_kana_input },
{ NULL, NULL}
} ;

#endif /*WNNKINPUT*/
/*
 * Local variables:
 * eval: (set-kanji-fileio-code 'EUC)
 * end:
 */

