/* Command Dispatch Routine for YY-server
 * This file is part of YY-server of YYonX (1.3 Distribution)
 * $Id: dispatch.c,v 3.0 1992/10/08 04:59:44 keisuke Exp $
 */

#ifndef lint
static char *RcsId =
    "$Id: dispatch.c,v 3.0 1992/10/08 04:59:44 keisuke Exp $";
#endif

/****************************************************************************
%%%COPYRIGHT%%%
;;; Authors:
;;;   Version 1.0 90/02/26 by Keisuke 'Keiko' Tanaka
;;;				(keisuke@csrl.aoyama.ac.jp)
;;;   Version 2.0 90/08/27 by Keisuke 'Keiko' Tanaka
;;;			Page Mode Territory is supported
;;;   Version 2.4 90/11/05 by Keisuke 'Keiko' Tanaka
;;;			Copyright Notice is rewritten
;;;   Version 2.9 91/01/25 by Keisuke 'Keiko' Tanaka
;;;			Add functions for frame-animation and image handling
;;;
****************************************************************************/

/****************************************************************************
  $Revision: 3.0 $ Written by Keisuke 'Keiko' Tanaka
  $Date: 1992/10/08 04:59:44 $
****************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include "yydefs.h"
#include "yypacket.h"

/*
 * Dispatch Command
 */

struct _yy_command_table {
    int comComNumber;
    yy_packet *(*comFunc)();
    char *comLabel;
    int comTimeFlag;
} ;

struct _yy_command_search_table {
    int csMinNumber;
    int csMaxNumber;
    struct _yy_command_table *csTable;
    int csTableSize;
    char *csLabel;
} ;
typedef struct _yy_command_table yy_command_table;
typedef struct _yy_command_search_table yy_command_search_table;

extern yy_packet *yycom_init();
extern yy_packet *yycom_create_territory();
extern yy_packet *yycom_display_territory();
extern yy_packet *yycom_move_territory();
extern yy_packet *yycom_resize_territory();
extern yy_packet *yycom_destroy_territory();
extern yy_packet *yycom_reparent_territory();
extern yy_packet *yycom_raise_territory();
extern yy_packet *yycom_lower_territory();
extern yy_packet *yycom_load_font();
extern yy_packet *yycom_draw_point();
extern yy_packet *yycom_draw_line();
extern yy_packet *yycom_draw_circle();
extern yy_packet *yycom_draw_lines();
extern yy_packet *yycom_draw_polygon();
extern yy_packet *yycom_fill_inner_polygon();
extern yy_packet *yycom_draw_arc();
extern yy_packet *yycom_draw_rectangle();
extern yy_packet *yycom_fill_polygon();
extern yy_packet *yycom_fill_rectangle();
extern yy_packet *yycom_fill_circle();
extern yy_packet *yycom_fill_arc();
extern yy_packet *yycom_draw_text();
extern yy_packet *yycom_clear_territory();
extern yy_packet *yycom_draw_background();
extern yy_packet *yycom_create_bitmap();
extern yy_packet *yycom_operate_bitblt();
extern yy_packet *yycom_save_picture();
extern yy_packet *yycom_load_picture();
extern yy_packet *yycom_translate_picture();
extern yy_packet *yycom_rotate_picture();
extern yy_packet *yycom_get_image();
extern yy_packet *yycom_put_image();
extern yy_packet *yycom_draw_oval();
extern yy_packet *yycom_fill_oval();
extern yy_packet *yycom_draw_vtext();
extern yy_packet *yycom_draw_rtext();
extern yy_packet *yycom_query_color();
extern yy_packet *yycom_get_color_numrgb();
extern yy_packet *yycom_change_color_rgb();
extern yy_packet *yycom_free_color();
extern yy_packet *yycom_get_color_value();
extern yy_packet *yycom_define_animation_frame();
extern yy_packet *yycom_start_animation();
extern yy_packet *yycom_stop_animation();
extern yy_packet *yycom_destroy_animation_frame();
extern yy_packet *yycom_put_animation_frame();
extern yy_packet *yycom_select_territory();
extern yy_packet *yycom_set_event_mask();
extern yy_packet *yycom_mask_event();
#ifndef NOIPAPATCH
extern yy_packet *yycom_request_motion(); /* Added by T.Kosaka */
#endif /*!NOIPAPATCH*/
extern yy_packet *yycom_create_cursor_territory();
extern yy_packet *yycom_move_cursor_hotspot();
extern yy_packet *yycom_change_cursor_bitmap();
extern yy_packet *yycom_move_cursor();
extern yy_packet *yycom_destroy_cursor();
extern yy_packet *yycom_get_cursur_position();
extern yy_packet *yycom_display_cursor();
extern yy_packet *yycom_set_page_attribute();
extern yy_packet *yycom_move_page_territory();
extern yy_packet *yycom_start_input();
extern yy_packet *yycom_abort_input();
extern yy_packet *yycom_draw_text_on_page();
extern yy_packet *yycom_get_position_on_page();
#ifdef DEBUG_COM
extern yy_packet *yycom_debug_do_input();
extern yy_packet *yycom_debug_reset_timer();
extern yy_packet *yycom_debug_set_timer();
extern yy_packet *yycom_debug_show_table();
extern yy_packet *yycom_debug_list_color();
extern yy_packet *yycom_debug_list_territory();
#endif /*DEBUG_COM*/

static yy_command_table InitCommandTable[] = {
{ YYCOMMAND_INIT, yycom_init, "Initialize-Yy", FALSE},
} ;

static yy_command_table ControlCommandTable[] = {
{ YYCOMMAND_CREATE_TERRITORY, yycom_create_territory,
      "Create Terrytory", FALSE},
{ YYCOMMAND_DISPLAY_TERRITORY, yycom_display_territory,
      "Display Terrytory", FALSE},
{ YYCOMMAND_MOVE_TERRITORY, yycom_move_territory,
      "Move Terrytory", FALSE},
{ YYCOMMAND_RESIZE_TERRITORY, yycom_resize_territory,
      "Resize Territory", FALSE},
{ YYCOMMAND_DESTROY_TERRITORY, yycom_destroy_territory,
      "Destroy Territory", FALSE},
{ YYCOMMAND_REPARENT_TERRITORY, yycom_reparent_territory,
      "Reparent Territory", FALSE},
{ YYCOMMAND_RAISE_TERRITORY, yycom_raise_territory,
      "Raise Territory", FALSE},
{ YYCOMMAND_LOWER_TERRITORY, yycom_lower_territory,
      "Lower Territory", FALSE},
} ;

static yy_command_table FontCommandTable[] = {
{ YYCOMMAND_LOAD_FONT, yycom_load_font,
      "Load Font", FALSE},
} ;

static yy_command_table DrawCommandTable[] = {
{ YYCOMMAND_DRAW_POINT, yycom_draw_point,
      "Draw Point", FALSE},
{ YYCOMMAND_DRAW_LINE, yycom_draw_line,
      "Draw Line", FALSE},
{ YYCOMMAND_DRAW_CIRCLE, yycom_draw_circle,
      "Draw Circle", FALSE},
{ YYCOMMAND_DRAW_LINES, yycom_draw_lines,
      "Draw Lines", FALSE},
{ YYCOMMAND_DRAW_POLYGON, yycom_draw_polygon,
      "Draw Polygon", FALSE},
{ YYCOMMAND_DRAW_ARC, yycom_draw_arc,
      "Draw Arc", FALSE},
{ YYCOMMAND_DRAW_RECTANGLE, yycom_draw_rectangle,
      "Draw Rectangle", FALSE},
} ;

static yy_command_table FillCommandTable[] = {
{ YYCOMMAND_FILL_POLYGON, yycom_fill_polygon,
      "Fill Polygon", FALSE},
{ YYCOMMAND_FILL_RECTANGLE, yycom_fill_rectangle,
      "Fill Rectangle", FALSE},
{ YYCOMMAND_FILL_CIRCLE, yycom_fill_circle,
      "Fill Circle", FALSE},
{ YYCOMMAND_FILL_ARC, yycom_fill_arc,
      "Fill Arc", FALSE},
} ;

static yy_command_table TextCommandTable[] = {
{ YYCOMMAND_DRAW_TEXT, yycom_draw_text,
      "Draw Text", FALSE},
} ;

static yy_command_table BitmapCommandTable[] = {
{ YYCOMMAND_CLEAR_TERRITORY, yycom_clear_territory,
      "Clear Territory", FALSE},
{ YYCOMMAND_DRAW_BACKGROUND, yycom_draw_background,
      "Draw Background", FALSE},
{ YYCOMMAND_CREATE_BITMAP, yycom_create_bitmap,
      "Create Bitmap", FALSE},
{ YYCOMMAND_OPERATE_BITBLT, yycom_operate_bitblt,
      "Operate Bitblt", FALSE},
{ YYCOMMAND_SAVE_PICTURE, yycom_save_picture,
      "Save Picture", FALSE},
{ YYCOMMAND_LOAD_PICTURE, yycom_load_picture,
      "Load Picture", FALSE},
{ YYCOMMAND_TRANSLATE_PICTURE, yycom_translate_picture,
      "Translate Picture", FALSE},
{ YYCOMMAND_ROTATE_PICTURE, yycom_rotate_picture,
      "Rotate Picture", FALSE},
} ;

static yy_command_table SpecialDrawCommandTable[] = {
{ YYCOMMAND_DRAW_OVAL, yycom_draw_oval,
      "Draw Oval", FALSE},
{ YYCOMMAND_FILL_OVAL, yycom_fill_oval,
      "Fill Oval", FALSE},
{ YYCOMMAND_DRAW_VTEXT, yycom_draw_vtext,
      "Draw Text", FALSE},
{ YYCOMMAND_DRAW_RTEXT, yycom_draw_rtext,
      "Draw Text", FALSE},
} ;

static yy_command_table ColorCommandTable [] = {
{ YYCOMMAND_QUERY_COLOR, yycom_query_color,
      "Query Color", FALSE},
{ YYCOMMAND_GET_COLOR_NUMRGB, yycom_get_color_numrgb,
      "Get Color Value and RGB", FALSE },
{ YYCOMMAND_CHANGE_COLOR_RGB, yycom_change_color_rgb,
      "Change Color RGB", FALSE },
{ YYCOMMAND_FREE_COLOR, yycom_free_color,
      "Destroy Color", FALSE },
{ YYCOMMAND_GET_COLOR_VALUE, yycom_get_color_value,
      "Get Color Value for a Point", FALSE },
} ;

static yy_command_table AnimationCommandTable [] = {
{ YYCOMMAND_DEFINE_ANIMATION_FRAME, yycom_define_animation_frame,
      "Define Animation Frame", FALSE},
{ YYCOMMAND_START_ANIMATION, yycom_start_animation,
      "Start Animation", FALSE},
{ YYCOMMAND_STOP_ANIMATION, yycom_stop_animation,
      "Stop Animation", FALSE},
{ YYCOMMAND_DESTROY_ANIMATION_FRAME, yycom_destroy_animation_frame,
      "Destroy Animation Frame", FALSE},
{ YYCOMMAND_PUT_ANIMATION_FRAME, yycom_put_animation_frame,
      "Put Animation Frame", FALSE},
} ;

static yy_command_table ImageCommandTable [] = {
{ YYCOMMAND_GET_IMAGE, yycom_get_image,
      "Get Image", FALSE},
{ YYCOMMAND_PUT_IMAGE, yycom_put_image,
      "Put Image", FALSE},
} ;

static yy_command_table EventCommandTable [] = {
{ YYCOMMAND_SELECT_TERRITORY, yycom_select_territory,
      "Select Territory", FALSE},
{ YYCOMMAND_SET_EVENT_MASK, yycom_set_event_mask,
      "Set Event Mask", FALSE},
{ YYCOMMAND_MASK_EVENT, yycom_mask_event,
      "Mask Event", FALSE},
{ YYCOMMAND_REQUEST_MOTION, yycom_request_motion,
      "Request Motion Event", FALSE},
} ;

static yy_command_table PageCommandTable[] = {
{ YYCOMMAND_SET_PAGE_ATTRIBUTE, yycom_set_page_attribute,
      "Set Page Attribute", FALSE},
{ YYCOMMAND_MOVE_PAGE_TERRITORY, yycom_move_page_territory,
      "Move Page Territory", FALSE},
{ YYCOMMAND_START_INPUT, yycom_start_input,
      "Start Input", FALSE},
{ YYCOMMAND_ABORT_INPUT, yycom_abort_input,
      "Abort Input", FALSE},
{ YYCOMMAND_DRAW_TEXT_ON_PAGE, yycom_draw_text_on_page,
      "Draw Text on Page", FALSE},
{ YYCOMMAND_GET_POSITION_ON_PAGE, yycom_get_position_on_page,
      "Get Position on Page", FALSE},
} ;

static yy_command_table CursorCommandTable[] = {
{ YYCOMMAND_CREATE_CURSOR_TERRITORY, yycom_create_cursor_territory,
      "Create Cursor Territory", FALSE},
{ YYCOMMAND_MOVE_CURSOR_HOTSPOT, yycom_move_cursor_hotspot,
      "Move Cursor Hotspot", FALSE},
{ YYCOMMAND_CHANGE_CURSOR_BITMAP, yycom_change_cursor_bitmap,
      "Change Cursor Bitmap", FALSE},
{ YYCOMMAND_MOVE_CURSOR, yycom_move_cursor,
      "Move Cursor", FALSE},
{ YYCOMMAND_DESTROY_CURSOR, yycom_destroy_cursor,
      "Destroy Cursor", FALSE},
{ YYCOMMAND_GET_CURSUR_POSITION, yycom_get_cursur_position,
      "Get Cursur Position", FALSE},
{ YYCOMMAND_DISPLAY_CURSOR, yycom_display_cursor,
      "Display Cursor", FALSE},
{ YYCOMMAND_FILL_INNER_POLYGON, yycom_fill_inner_polygon,
      "Display Cursor", FALSE},
} ;

#ifdef DEBUG_COM
static yy_command_table DebugCommandTable[] = {
{ YYCOMMAND_DEBUG_DO_INPUT, yycom_debug_do_input,
      "Do INPUT", FALSE},
{ YYCOMMAND_DEBUG_RESET_TIMER, yycom_debug_reset_timer,
      "Reset Timer", FALSE},
{ YYCOMMAND_DEBUG_SET_TIMER, yycom_debug_set_timer,
      "Set Timer", FALSE},
{ YYCOMMAND_DEBUG_SHOW_TABLE, yycom_debug_show_table,
      "Show Debug Table", FALSE},
{ YYCOMMAND_DEBUG_LIST_COLOR, yycom_debug_list_color,
      "List Color", FALSE},
{ YYCOMMAND_DEBUG_LIST_TERRITORY, yycom_debug_list_territory,
      "List Territory", FALSE},
} ;
#endif /*DEBUG_COM*/

#define SIZE(table)	(sizeof(table)/sizeof(yy_command_table))

static yy_command_search_table SearchTable[] = {
{ YYCOMMAND_INIT, YYCOMMAND_INIT, InitCommandTable, SIZE(InitCommandTable),
      "initialize-command" },
{ -1, -1, ControlCommandTable, SIZE(ControlCommandTable),
      "territory-control-command" },
{ -1, -1, FontCommandTable, SIZE(FontCommandTable), "font-command"},
{ -1, -1, DrawCommandTable, SIZE(DrawCommandTable), "draw-command"},
{ -1, -1, FillCommandTable, SIZE(FillCommandTable), "fill-command"},
{ -1, -1, TextCommandTable, SIZE(TextCommandTable), "text-command"},
{ -1, -1, BitmapCommandTable, SIZE(BitmapCommandTable), "bitmap-command"},
{ -1, -1, SpecialDrawCommandTable, SIZE(SpecialDrawCommandTable),
      "special-draw-command"},
{ -1, -1, ColorCommandTable, SIZE(ColorCommandTable), "color-command"},
{ -1, -1,  AnimationCommandTable, SIZE(AnimationCommandTable),
  "animation-command"},
{ -1, -1, ImageCommandTable, SIZE(ImageCommandTable), "image-command"},
{ -1, -1, EventCommandTable, SIZE(EventCommandTable), "event-command"},
{ -1, -1, PageCommandTable, SIZE(PageCommandTable), "page-command"},
{ -1, -1, CursorCommandTable, SIZE(CursorCommandTable), "cursor-command"},
#ifdef DEBUG_COM
{ -1, -1, DebugCommandTable, SIZE(DebugCommandTable), "debug-command"},
#endif /*DEBUG_COM*/
} ;

void fix_command_search_table()
{
    yy_command_search_table *cs;
    int size = sizeof(SearchTable)/sizeof(yy_command_search_table);

    DebugSetFunc("command_dispatch", "fix_command_search_table");
    for (cs = SearchTable; size-- > 0; cs++) {
	yy_command_table *ct = cs->csTable;
	register int loop = cs->csTableSize;
	register int min = ct->comComNumber;
	register int max = ct->comComNumber;
	DebugPrint3(5, "Checking '%s' (%d entries) - %d\n",
		    cs->csLabel, cs->csTableSize, size);
	DebugPrint2(6, " Command(%d): '%s'\n", ct->comComNumber, ct->comLabel);
	for (ct++, loop--; loop-- > 0; ct++) {
	    DebugPrint2(6, " Command(%d): '%s'\n",
			ct->comComNumber, ct->comLabel);
	    min = MIN(min, ct->comComNumber);
	    max = MAX(max, ct->comComNumber);
	}
	cs->csMinNumber = min;
	cs->csMaxNumber = max;
	DebugPrint2(5, " MIN=%d, MAX=%d\n", min, max);
    }
    DebugEndFunc("command_dispatch", "fix_command_search_table");
}

static yy_command_table *search_command_table(command)
    int command;
{
    register yy_command_search_table *cs;
    register yy_command_table *ct;
    int tbl_size = sizeof(SearchTable)/sizeof(yy_command_search_table);

    DebugSetFunc("command_dispatch", "search_command_table");
    DebugPrint1(1, "Command #%d\n", command);
    for (cs = SearchTable; tbl_size > 0; cs++, tbl_size--) {
	if (command >= cs->csMinNumber && command <= cs->csMaxNumber) {
	    register l = cs->csTableSize;
	    for (ct = cs->csTable; l > 0 && ct->comComNumber != command; ct++)
		l--;
	    if (l > 0) {
		DebugPrint2(2, " -> '%s' in '%s'\n",
			    ct->comLabel, cs->csLabel);
		break;
	    }
	}
    }
    DebugEndFunc("command_dispatch", "search_command_table");
    return (tbl_size > 0? ct: (yy_command_table *)NULL);
}

dispatch_command(channel, pkt)
    yy_comm_channel *channel;
    yy_packet *pkt;
{
    int command;
    yy_command_table *ct;

    DebugSetFunc("command_dispatch", "dispatch_command");
    command = pkt->pktCommand;
    if ((ct = search_command_table(command)) != (yy_command_table *)NULL) {
	yy_packet *repl;
#ifdef DEBUG
	struct timeval start, stop, period;
	if (ct->comTimeFlag)
	    gettimeofday(&start, NULL);
#endif
	repl = (*ct->comFunc)(channel, pkt);
	sync_packet(channel, command, repl);
#ifdef DEBUG
	if (ct->comTimeFlag) {
	    gettimeofday(&stop, NULL);
	    timevalsub(&stop, &start, &period);
	    timevaladd(&channel->ccDBTimer, &period);
	}
#endif
    } else {
	DebugPrint0(2, " -> Unknown Command\n");
    }
    remove_yy_packet(pkt);
    DebugEndFunc("command_dispatch", "dispatch_command");
}

#ifdef DEBUG_COM
yy_packet *yycom_debug_set_timer(CH, pkt)
    yy_comm_channel *CH;
    yy_packet *pkt;
{
    yy_command_search_table *cs = SearchTable;
    int size = sizeof(SearchTable)/sizeof(yy_command_table);
    int operation;
    int com;
    DebugSetFunc("debug", "yycom_debug_set_timer");
    com = read_packet_entry_integer(pkt);
    operation = read_packet_entry_integer(pkt);
    for ( ; size-- > 0; cs++)
	if (com >= cs->csMinNumber && com <= cs->csMaxNumber) {
	    register yy_command_table *ct = cs->csTable;
	    register loop = cs->csTableSize;
	    for ( ; loop-- > 0; ct++) {
		if (ct->comComNumber == com) {
		    ct->comTimeFlag = (operation != 0);
		    DebugEndFunc("debug", "yycom_debug_set_timer");
		    return (yy_packet *)NULL;
		}
	    }
	    break;
	}
    DebugEndFunc("debug", "yycom_debug_set_timer");
    return (yy_packet *)NULL;
}

yy_packet *yycom_debug_reset_timer(CH, pkt)
    yy_comm_channel *CH;
    yy_packet *pkt;
{
    DebugSetFunc("debug", "yycom_debug_reset_timer");
    CH->ccDBTimer.tv_sec = 0;
    CH->ccDBTimer.tv_usec = 0;
    DebugEndFunc("debug", "yycom_debug_reset_timer");
    return (yy_packet *)NULL;
}

timevalsub(a, b, c)
	struct timeval *a, *b, *c;
{
	c->tv_sec = a->tv_sec - b->tv_sec;
	if ((c->tv_usec = a->tv_usec - b->tv_usec) < 0) {
		c->tv_sec--;
		c->tv_usec += 1000000;
	}
}

timevaladd(a, b)
	struct timeval *a, *b;
{
	a->tv_sec += b->tv_sec;
	a->tv_usec += b->tv_usec;
	if (a->tv_usec > 1000000) {
		a->tv_sec++;
		a->tv_usec -= 1000000;
	}
}
#endif /*DEBUG_COM*/

/*
 * Local variables:
 * eval: (set-kanji-fileio-code 'EUC)
 * end:
 */
