/*
 */

#ifndef lint
static char *RcsId =
    "$Id: com_page.c,v 3.0 1992/10/08 04:59:44 keisuke Exp $" ;
#endif

/****************************************************************************
%%%COPYRIGHT%%%
****************************************************************************/

/****************************************************************************
#
# $Revision: 3.0 $ Written by Keisuke 'Keiko' Tanaka
#			$Date: 1992/10/08 04:59:44 $
# Log:
#  Version 1.0 is written by Keisuke 'Keiko' Tanaka
#		recieved_line		(keisuke@csrl.aoyama.ac.jp)
# 
****************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include "yydefs.h"
#include "yypacket.h"
#include "xwindow.h"
#include "territory.h"
#include "yyfont.h"


/*
 * Page Mode Territory
 */
#define YYPAGE_DRAWCURSOR	01

#define SWAP(a1,a2)		{ register int t; t = a1; a1 = a2; a2 = t; }

#define copy_string_box(sb1,sb2)	(memcpy(sb1,sb2,sizeof(STRINGBOX)))

static void fix_location_of_territory();

/* union_string_box(sb1, sb2, sb3)
 *
 * Ĥ StringBox sb1  sb2 ˴ޤޤ StringBox 
 * Ƥ sb3 ꤹ
 * sb1 뤤 sb2  sb3 Ʊΰ򼨤ƤƤ
 * ʤ
 */
static STRINGBOX *union_string_box(sb1, sb2, sb3)
    STRINGBOX *sb1, *sb2, *sb3;
{
    if (sb1->w == 0 && sb1->h == 0) {
	copy_string_box(sb3, sb2);
    } else if (sb2->w == 0 && sb2->h == 0) {
	copy_string_box(sb3, sb1);
    } else {
	STRINGBOX wk1, wk2;
	copy_string_box(&wk1, sb1);
	copy_string_box(&wk2, sb2);
	sb3->x = MIN(wk1.x, wk2.x);
	sb3->y = MIN(wk1.y, wk2.y);
	sb3->w = MAX((wk1.x+wk1.w), (wk2.x+wk2.w)) - sb3->x;
	sb3->h = MAX((wk1.y+wk1.h), (wk2.y+wk2.h)) - sb3->y;
    }
    return sb3;
}

/* get_string_box_one_char(ch, base_x, base_y, fid, ptr)
 *
 * ١饤ɸ (base_x,base_y) ˥ե fid  ptr 
 * Ϥޤʸ֤ StringBox ƤΰؤΥݥ󥿤
 * ֤
 *
 * BUG:
 *  ֤ StringBox ΰΰ˳ݤΤ
 *  θƤӽФѹ
 */
STRINGBOX *get_string_box_one_char(ch, base_x, base_y, fid, ptr)
    yy_comm_channel *ch;
    int base_x, base_y;	/* ١ɸ */
    int fid;		/* եID */
    u_char *ptr;
{
    static STRINGBOX sbox;
    TEXTBOX *tb;
    tb = YYTextSize(ch, fid, 0/*TXTDIR_H*/, JEUC_Bytes(ptr), ptr,
		    base_x, base_y);
    sbox.x = tb->x;
    sbox.y = tb->y;
    sbox.w = tb->w;
    sbox.h = tb->h;
    return &sbox;
}

/*
 *
 * ltop ϤޤԤ col_s  col_e ޤǤʸ
 * BOX ΰơ sbox  UNION ꤹ
 * col_s ΰ֤ʸ¸ߤʤ cbox ˲ꤵ
 * ʤ col_s ΰ֤˥ǥեʸ֤
 * ꤷƤ BOX ΰ cbox ꤹ (UNION ǤϤʤ)
 *
 * BUG:
 *  col_s ʸ֤ƤʤϡιԤκǸʸ
 *  ˥ǥեʸ֤Ȥꤹ
 *  ʤºݤ col_s ʸ֤ΰȤϰ֤
 *  ǽ
 *
 *  ltop  NULL ǤȤ col οǤȤ
 *  θƤʤ
 */
static void get_string_box_in_line(ch, plane, ltop, col_s, col_e, sbox, cbox)
    yy_comm_channel *ch;
    PAGEPLANE *plane;
    PAGELINE *ltop;
    int col_s, col_e;
    STRINGBOX *sbox, *cbox;
{
    register int col = col_s;
    register int moji = col_e - col_s; /* ʸ */
    PAGELINE *cur, *last;

    DebugSetFunc("page", "get_string_box_in_line");
    DebugPrint2(5, "StringBox in Line from %d to %d\n", col_s, col_e);
    /* col_s ʸޤ LineBuffer  cur 
     * ³ = äƤΤϡLineBuffer Ūʸ
     * ǽ뤳ȤθƤΤȤǤ
     * Υ롼פä̤Ȥ cur  NULL ˤʤä餽
     * col_s ˤʸ¸ߤʤȤ̣ޤ
     */
    cur = last = ltop;
    while (cur != (PAGELINE *)NULL && col >= cur->nchar) {
	col -= cur->nchar;
	cur = (last=cur)->nextBuf;
    }

    if (cur != (PAGELINE *)NULL) {
	register int base_x, base_y;
	register u_char *ptr;

	/* ptr  col_s ʸؤ褦ˤ
	 *  (col_s ʸɬ cur ˤ)
	 */
	base_x = cur->baseX; base_y = cur->baseY; ptr = cur->buffer;
	while (col-- > 0) {
	    register int b = JEUC_Bytes(ptr);
	    register STRINGBOX *sb;
	    sb = get_string_box_one_char(ch,base_x,base_y,cur->fontID,ptr);
	    base_x += sb->w; ptr += b;
	}
	/* ptr ΰ֤ moji ʬ StringBox  sbox  UNION Ƥ
	 */
	while (moji > 0 && cur != (PAGELINE *)NULL) {
	    register int b = JEUC_Bytes(ptr);
	    register STRINGBOX *sb;
	    sb = get_string_box_one_char(ch,base_x,base_y,cur->fontID,ptr);
	    union_string_box(sbox, sb, sbox);
	    base_x += sb->w; ptr += b; moji--;
	    if (ptr - cur->buffer >= cur->leng) {
		if ((cur = cur->nextBuf) != (PAGELINE *)NULL) {
		    base_x = cur->baseX; base_y = cur->baseY;
		    ptr = cur->buffer;
		}
	    }
	}
	DebugPrint6(5, "StringBox in Line from %d to %d -> (%d,%d)[%d,%d]\n",
		    col_s, col_e, sbox->x, sbox->y, sbox->w, sbox->h);
    } else if (cbox->w == 0 && cbox->h == 0) {
	/* col_s ʸ¸ߤcbox ͤꤹɬפ
	 * last κǸʸΤȤ˥ǥեʸ¸ߤꤹ
	 */
	register int base_x, base_y;
	register u_char *ptr;
	register STRINGBOX *sb;
	col = last->nchar;
	base_x = last->baseX; base_y = last->baseY; ptr = last->buffer;
	while (col-- > 0) {
	    register int b = JEUC_Bytes(ptr);
	    register STRINGBOX *sb;
	    sb = get_string_box_one_char(ch,base_x,base_y,last->fontID,ptr);
	    base_x += sb->w; ptr += b;
	}
	/* (bose_x,base_y) ΰ֤˥ǥեʸ¸ߤ */
	sb = get_string_box_one_char(ch,base_x,base_y,
				     plane->defCharFont,plane->defCharStr);
	copy_string_box(cbox,sb);
	DebugPrint5(5, "No Character on Column %d -> (%d,%d)[%d,%d]\n",
		    col_s, cbox->x, cbox->y, cbox->w, cbox->h);
    }
    DebugEndFunc("page", "get_string_box_in_line");
    /*NoReturnValue*/
}


/*
 *
 * PagePlane  <col1,row1>  <col2,row2> ޤǤʸΤ
 * Window ΰ(BOX)
 *
 * BUG:
 *  <col2,row2> ¸ߤʸΤΤϴޤޤʤ
 *  <col1,row1>  <col2,row2> ǤʤФʤʤ
 *
 *  <col1,row1>  <col2,row2> δ֤ʸޤäƤʤ
 *  ˤϡ<col1,row1> ΰ֤¸ߤǥեʸ
 *   BOX 
 *  뤤ϡ<col1,row1>  <col2,row2> δ֤椫ʸ
 *  ֤Ƥʤϡ֤Ƥ BOX ֤
 *
 *  ֤ StringBox ΰΰ˳ݤ
 *  θƤӽФѹ
 */
STRINGBOX *get_string_box(ch, plane, col1, row1, col2, row2)
    yy_comm_channel *ch;
    PAGEPLANE *plane;
    int col1, row1, col2, row2;
{
    static STRINGBOX sbox;	/* ǽŪ BOX ΰ */
    STRINGBOX cbox;		/* ǥեȥʸΰ򼨤 */
    int col, row;
    STRINGBOX wk1, wk2;
    PAGELINE *ltop, *last;


    DebugSetFunc("page", "get_string_box");
    sbox.x = sbox.y = sbox.w = sbox.h = 0;
    cbox.x = cbox.y = cbox.w = cbox.h = 0;

    /* <col1,row1> ¸ߤϤιԤιƬ PageLine  pl 
     */
    ltop = last = plane->curLineTop;
    row = row1 - plane->curRow;
    if (row > 0) {
	/* Ԥ CuuentLine ¸ߤ
	 * row1 ¸ߤʤ֤ؤ֤θ
	 */
	for ( ; row > 0 ; row--)
	    if ((ltop = (last=ltop)->nextLine) == (PAGELINE *)NULL) break;
    } else if (row < 0) /* Ԥϸ߹Ԥˤ */
	while (row++ > 0 && ltop != (PAGELINE *)NULL)
	    ltop = (last=ltop)->prevLine;

    /* λ
     *  row1 ߹ԤޤƤǤʤ row  0 Ǥ
     *   ltop  row1 ιԤƬ򼨤Ȥˤʤ
     *  row1 ߹Ԥ⤢Ȥξϡrow  0 Ǥʤ
     *   ϰۤʤ롥
     *   0 ξ硤ltop  row1 Ƭؤ
     *   0 礭硤ltop  NULLlast ¸ߤǸιԤƬؤ
     */
    if (row == 0) {
	/* ̾ν
	 *  ltop  row1 ƬʤΤǤ row2 ޤǤ BOX ȤäƤ
	 */
	for (col = col1; row1 <= row2 && ltop != (PAGELINE *)NULL;
	     row1++, col = 0, ltop = ltop->nextLine) {
	    register int col_e;
	    col_e = ((row1 == row2)? col2: total_nchar_in_line_buffer(ltop));
	    get_string_box_in_line(ch, plane, ltop, col, col_e, &sbox, &cbox);
	}
	if (sbox.w == 0 && sbox.h == 0) copy_string_box(&sbox, &cbox);
	DebugPrint4(4, "Get StringBox for String -> (%d,%d)[%d,%d]\n",
		    sbox.x, sbox.y, sbox.w, sbox.h);
    } else if (last != (PAGELINE *)NULL) {
	/* row1  PageLine ʤ
	 * last ¸ߤǸιԤ򼨤ƤΤ
	 * κǸʸ֤֤μιԤƬ
	 * ǥեʸ뤬¸ߤȲꤷ
	 * ʸ BOX ΰ
	 */
	register int col_e;
	register STRINGBOX *sb;
	col_e = total_nchar_in_line_buffer(last);
	get_string_box_in_line(ch, plane, last, col_e, col_e+1, &sbox, &cbox);
	sb = get_string_box_one_char(ch, 0, cbox.y+cbox.h,
				     plane->defCharFont, plane->defCharStr);
	copy_string_box(&sbox,sb);
	DebugPrint4(4, "No PageLine -> (%d,%d)[%d,%d]\n",
		    sbox.x, sbox.y, sbox.w, sbox.h);
    } else {
	/* curLineTop Τ¸ߤʤ
	 *  (ܼŪˤꤨʤȤǤϤ뤬)
	 * ʸɸ <0,0> ΰ֤˥ǥեʸ
	 * ¸ߤꤷƤ BOX ΰ֤
	 */
	register STRINGBOX *sb;
	sb = get_string_box_one_char(ch, 0, 0,
				     plane->defCharFont, plane->defCharStr);
	copy_string_box(&sbox,sb);
	sbox.x = sbox.y = 0;
	DebugPrint4(4, "No Current PageLine -> (%d,%d)[%d,%d]\n",
		    sbox.x, sbox.y, sbox.w, sbox.h);
    }
    DebugPrint8(4, "StringBox from <%d,%d> to <%d,%d> -> (%d,%d)[%d,%d]\n",
		col1, row1, col2, row2, sbox.x, sbox.y, sbox.w, sbox.h);
    DebugEndFunc("page", "get_string_box");
    return &sbox;
}



/**********************************************************************
 *****  ɽδϢ
 **********************************************************************/

void clear_page_territory_window(ch, tr, x, y)
    yy_comm_channel *ch;
    TERRITORY *tr;
    int x, y;		/* Ȥʤ١ɸ */
{
    TERRITORY_PAGE *pg = &tr->teModeEnt.tPageControl;
    GC wgc;
    Pixmap wpix;
    XGCValues gcv;
    x_private *xp = XPRIVATE(ch);
    TERRITORY_X_ENTRY *tx = GetTerritoryXEntry(tr);
    DebugSetFunc("page", "clear_page_territory_window");
    DebugPrint2(5, " Clear Page from (%d,%d)\n", x, y);
    wpix = XCreatePixmap(xp->xDisp, tx->txWindow, tr->teWidth, tr->teHeight,
			 DefaultDepth(xp->xDisp, xp->xScreen));
    gcv.function = GXcopy;
    wgc = XCreateGC(xp->xDisp, tx->txWindow, GCFunction, &gcv);
    XCopyGC(xp->xDisp, tx->txGC, (GCForeground|GCBackground), wgc);
    clear_pixmap(xp, wpix, wgc, tr->teWidth, tr->teHeight,
		 &tx->txBackGroundColor);
    XCopyArea(xp->xDisp, wpix, tx->txPixmap, wgc,
	      0, 0, tr->teWidth-x, pg->pcHeadOffset+pg->pcTailOffset,
	      x, y-pg->pcHeadOffset);
    XCopyArea(xp->xDisp, wpix, tx->txPixmap, wgc,
	      0, 0, tr->teWidth, tr->teHeight-y-pg->pcTailOffset,
	      0, y+pg->pcTailOffset);
    if (IsVisibleTerritory(tr)) {
	XCopyArea(xp->xDisp, wpix, tx->txWindow, wgc,
		  0, 0, tr->teWidth-x, pg->pcHeadOffset+pg->pcTailOffset,
		  x, y-pg->pcHeadOffset);
	XCopyArea(xp->xDisp, wpix, tx->txWindow, wgc,
		  0, 0, tr->teWidth, tr->teHeight-y-pg->pcTailOffset,
		  0, y+pg->pcTailOffset);
    }
    XFreeGC(xp->xDisp, wgc);
    XFreePixmap(xp->xDisp, wpix);
    DebugEndFunc("page", "clear_page_territory_window");
}


static void expand_page_territory(ch, tr, height)
    yy_comm_channel *ch;
    TERRITORY *tr;
    int height;
{
    TERRITORY *pt;
    TERRITORY_PAGE *pg = &tr->teModeEnt.tPageControl;
    TERRITORY_PAGE *parent_pg;

    int new_y;

    DebugSetFunc("page", "expand_page_territory");
    /* ˰ưɬפ뤫ɤȽ */
    pt = GetParentTerritory(tr);
    parent_pg = &pt->teModeEnt.tPageControl;
    if (tr != parent_pg->pcInputTerritory) {
	/*  PageMode Territory ΤΤư */
	new_y = (tr->teY+height>pt->teHeight? (pt->teHeight-height): tr->teY);
	resize_territory(ch, tr, tr->teX, new_y, tr->teWidth, height, 0, 0);
	if (pg->pcOperationMode & PAGEOP_NEEDRESIZEINFO) {
	    yy_packet *event;
	    /* ѥѥåȤ */
	    event = ALLOC_EVENTPACKET(YYCOMMAND_CHANGE_PAGE_SIZE);
	    append_packet_entry_integer(event, tr->teID);
	    append_packet_entry_integer(event, tr->teX);
	    append_packet_entry_integer(event, tr->teY);
	    append_packet_entry_integer(event, tr->teWidth);
	    append_packet_entry_integer(event, tr->teHeight);
	    put_packet_on_sendq(QUE(ch), event);
	}
    } else {
	/* ΥƥȥѤǤΤ
	 * ƤΥƥȥưȤˤäƴŪư */
	/* ޤΥƥȥΥ(ΰ֤)ѹ */
	resize_territory(ch, tr, tr->teX, tr->teY, tr->teWidth, height, 0, 0);
	/* ƤΥƥȥưǥѤ */
	expand_page_territory(ch, pt, MAX(pt->teHeight,(tr->teY+height)));
    }
    DebugEndFunc("page", "expand_page_territory");
    /*NoReturnValue*/
}
    
/* redraw_page_plane(ch, tr, plane)
 *
 * ڡ⡼ɥƥȥ plane ǼڡƤ
 * 褹
 */
void redraw_page_plane(ch, tr, plane)
    yy_comm_channel *ch;
    TERRITORY *tr;
    PAGEPLANE *plane;
{
    TERRITORY_PAGE *pg = &tr->teModeEnt.tPageControl;
    PAGELINE *ltop;
    bool dirty = FALSE;
    int x, y;
    DebugSetFunc("page", "redraw_page_plane");
    /* ltop ˤ PagePlane ƬԤ */
    ltop = plane->curLineTop;
    while (ltop->prevLine != (PAGELINE *)NULL) ltop = ltop->prevLine;

    for (x = 0, y = pg->pcHeadOffset;
	 ltop != (PAGELINE *)NULL ; ltop = ltop->nextLine) {
	PAGELINE *cur = ltop;
	for (cur = ltop; cur != (PAGELINE *)NULL; cur = cur->nextBuf) {
	    u_char *ptr = cur->buffer;
	    int nchar;
	    int fid = cur->fontID;
	    if (cur->leng == 0) {
		cur->baseX = cur->endX = x; cur->baseY = cur->endY = y;
		DebugPrint2(4, "Redraw PageLine on (%d,%d)\n", x, y);
		continue;
	    }
	    if (!dirty && !cur->dirty) {
		x = cur->endX; y = cur->endY;
		continue;
	    }
	    if (!dirty) {
		/* (x,y)ʸΥƥȥ̤򥯥ꥢ */
		clear_page_territory_window(ch, tr, x, y);
		dirty = TRUE;
	    }
	    cur->dirty = FALSE;
	    cur->baseX = x; cur->baseY = y;
	    /*  LineBuffer Ƥ (x,y) ľ */
	    for (nchar = cur->nchar; nchar > 0; nchar--) {
		/* ptr ΰʸ (x,y) 񤤤˥ƥȥ
		 * Ϥ߽Фʤʤ餽Τޤ褹
		 * Ǥʤ LineSkip ư
		 * LineSkip ưʸƥȥ
		 * ǼǤʤХƥȥĥ
		 */
		STRINGBOX *sb;
		int bytes = JEUC_Bytes(ptr);
		sb = get_string_box_one_char(ch, x, y, fid, ptr);
		if (x + sb->w <= tr->teWidth) {
		    if (y + pg->pcTailOffset > tr->teHeight)
			expand_page_territory(ch, tr, y+pg->pcTailOffset);
		    do_draw_text_on_page(ch, tr, x, y, fid, bytes, ptr);
		} else {
		    /* ιԤˤ */
		    if (ptr > cur->buffer) {
			crack_line_buffer(plane, cur, ptr);
			cur->endX = x; cur->endY = y;
			cur = cur->nextBuf;
			cur->dirty = FALSE;
			ptr = cur->buffer;
			/*nchar = cur->nchar - 1;*/
		    }
		    cur->baseX = x = 0;
		    y += pg->pcLineSkip; cur->baseY = y;
		    if (y + pg->pcTailOffset > tr->teHeight)
			expand_page_territory(ch, tr, y+pg->pcTailOffset);
		    do_draw_text_on_page(ch, tr, x, y, fid, bytes, ptr);
		}
		x += sb->w;
		ptr += bytes;
	    }
	    cur->endX = x; cur->endY = y;
	}
	/*
	 * ltop ιԤʸʸʤǡʸ
	 * ֤줿ȲꤷƤ줬ƥȥϤ߽ФΤǤ
	 * ƥȥĥ
	 */
	if (ltop->baseX == x && ltop->baseY == y &&
	    y + pg->pcTailOffset > tr->teHeight)
	    expand_page_territory(ch, tr, y+pg->pcTailOffset);
	x = 0; y += pg->pcLineSkip;
	DebugPrint2(4, "Redraw Next PageLine on (%d,%d)\n", x, y);
    }
    DebugPrint2(4, "End of Redraw on (%d,%d)\n", x, y);
    DebugEndFunc("page", "redraw_page_plane");
    /*NoReturnValue*/
}


/*
 * ڡ˥֤
 * ֤ˤΰ֤̾ˤʤȽǤǤˤ
 * ɽƤȤߤʤ褦˥ƥȥư
 */
void put_char_cursor_on_page(ch, tr)
    yy_comm_channel *ch;
    TERRITORY *tr;	/* Page Mode Υƥȥ */
{
    TERRITORY *parent;
    TERRITORY_PAGE *pg = &tr->teModeEnt.tPageControl;
    int col = GETPAGECOL(pg);
    int row = GETPAGEROW(pg);
    STRINGBOX *sb;
    DebugSetFunc("page", "put_char_cursor_on_page");

    /* ʸ */
    sb = get_string_box(ch, &pg->pcPagePlane, col, row, (col+1), row);
    DebugPrint5(6, " Put Character Cursor on (%d,%d)[%d,%d] on TR#%d\n",
		sb->x, sb->y, sb->w, sb->h, tr->teID);
    if (sb->w > 0 && sb->h > 0) {
	x_private *xp = XPRIVATE(ch);
	TERRITORY_X_ENTRY *tx = GetTerritoryXEntry(tr);
	XSetFunction(xp->xDisp, tx->txGC, GXxor);
	XFillRectangle(xp->xDisp, tx->txPixmap, tx->txGC,
		       sb->x, sb->y, sb->w, sb->h);
	if (IsVisibleTerritory(tr))
	    XFillRectangle(xp->xDisp, tx->txWindow, tx->txGC,
			   sb->x, sb->y, sb->w, sb->h);
	XSetFunction(xp->xDisp, tx->txGC, GXcopy);


	/* ʸ뤬̾ǸʤȽǤǤν
	 */
	if ((parent = GetParentTerritory(tr)) == NULL ||
	    tr != parent->teModeEnt.tPageControl.pcInputTerritory) {
	    fix_location_of_territory(ch, tr, sb->x, sb->y, sb->w, sb->h);
	} else {
	    fix_location_of_territory(ch, parent, tr->teX+sb->x, tr->teY+sb->y,
				      sb->w, sb->h);
	}
    }

    DebugEndFunc("page", "put_char_cursor_on_page");
    /*NoReturnValue*/
}

/*
 * ƥȥ tr  (x,y)[w,h] ΰ褬ɽǤ褦
 * tr ΰ֤Ĵ
 */
static void fix_location_of_territory(ch, tr, x, y, w, h) 
    yy_comm_channel *ch;
    TERRITORY *tr;
    int x, y, w, h;
{
    int dx, dy;
    int off_x, off_y;
    TERRITORY *t, *p;

    DebugSetFunc("page", "fix_location_of_territory");
    DebugPrint4(9, "Fix Location for (%d,%d)[%d,%d]\n", x, y, w, h);
    dx = dy = off_x = off_y = 0;
    for (t = tr; t != (TERRITORY *)NULL &&
	 (p = GetParentTerritory(t)) != (TERRITORY *)NULL; t = p) {
	DebugPrint2(9, " <ORIGIN (%d,%d)\n", t->teX, t->teY);
	/* X  */
	dx += t->teX;
	if (x + off_x + dx < 0) {
	    off_x = - (x + dx);
	} else if (x + w + dx + off_x > p->teWidth) {
	    off_x = p->teWidth - (x + w + dx);
	}
	/* Y  */
	dy += t->teY;
	if (y + off_y + dy < 0) {
	    DebugPrint2(9, " OFFSET = - (Y(%d)+DY(%d))\n", y, dy);
	    off_y = - (y + dy);
	} else if (y + h + dy + off_y > p->teHeight) {
	    DebugPrint4(9, " OFFSET = H(%d) - (Y(%d)+H(%d)+DY(%d))\n",
			p->teHeight, y, h, dy);
	    off_y = p->teHeight - (y + h + dy);
	}
	DebugPrint2(9, " OFFSET X=%d, Y=%d\n", off_x, off_y);
    }
    if (off_x != 0 || off_y != 0) {
	DebugPrint1(9, "Move Territory#%d\n", tr->teID);
	move_territory(ch, tr, tr->teX+off_x, tr->teY+off_y);
    }
    DebugEndFunc("page", "fix_location_of_territory");
    /*NoReturnValue*/
}    
    





/***************************************************************************
 * Commands on Page Mode Territory
 ***************************************************************************/

void clear_page_territory(ch, tr, color)
    yy_comm_channel *ch;
    TERRITORY *tr;
    x_color color;
{
    TERRITORY_PAGE *pg = GetPageTerritoryEnt(tr);
    int fid;
    DebugSetFunc("page", "clear_page_territory");
    DebugPrint1(1, "Clear Page TR#%d\n", tr->teID);
    fid = pg->pcPagePlane.defCharFont;
    destroy_page_plane(&pg->pcPagePlane);
    init_page_plane(&pg->pcPagePlane, fid, 4, "    ");
    /* pg->pcInputTerritory  non-NULL ʤ餳˲ */
#ifdef KINPUT
    destroy_page_plane(&pg->pcKInputPlane);
    init_page_plane(&pg->pcKInputPlane, fid, 4, "    ");
#endif /*KINPUT*/
    DebugEndFunc("page", "clear_page_territory");
    /*NoReturnValue*/
}


/* set_page_attribute(tr,font,skip,dirction,coordinate,x,y) */
/***************************************************************************
 ***** Command 80
 *****
 *****  Set attribute of Page-Mode_Territory
 *****
 ***************************************************************************/
yy_packet *yycom_set_page_attribute(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch); /* ź䤬ɲ */
    TERRITORY_X_ENTRY *tx;        /* ź䤬ɲ */
    TERRITORY *tr;
    TERRITORY_PAGE *pg;
	PAGEPLANE *plane;
    int fid;
    YYFONT *font;
    int err_code = YYNOERROR;
    yy_packet *repl;
    int dir, coor;
    int col, row;

    DebugSetFunc("page", "yycom_set_page_attribute");
    /* бƥȥ֥åμ */
    tr = search_territory(read_packet_entry_integer(pkt));
    if (tr == (TERRITORY *)NULL || tr->teTRType != TR_PAGE) {
	DebugPrint0(1, " No Territory\n");
	err_code = YYERROR_NOTERRITORY; goto send_reply;
    }
    DebugPrint1(5, " Page Territory#%d\n", tr->teID);
    /* ΥƥȥΥڡȥ֥å PagePlane  */
    pg = &tr->teModeEnt.tPageControl;
    fid = read_packet_entry_integer(pkt);
    init_page_plane(&pg->pcPagePlane, fid, 4, "    ");
    if ((font = call_font(ch, fid)) == (YYFONT *)NULL) {
	DebugPrint1(1, "No Font (#%d)\n", fid);
	err_code = YYERROR_NOFONT; goto send_reply;
    }
    pg->pcHeadOffset = MAX(MAXB1ASCENT(font), MAXB2ASCENT(font));
    pg->pcTailOffset = MAX(MAXB1DESCENT(font), MAXB2DESCENT(font));
    pg->pcLineSkip = read_packet_entry_integer(pkt);
    DebugPrint4(6, " Font #%d, Line Skip: %d, Offset: [%d,%d]\n",
		fid, pg->pcLineSkip, pg->pcHeadOffset, pg->pcTailOffset);

    /* ڡȸ¸ܤꤹ */
    dir = read_packet_entry_integer(pkt);
    coor = read_packet_entry_integer(pkt);
    if (dir == 0) {
	if (coor == 0) {
	    /* Horizontal Mode (Coodinate: LeftTop) */
	} else {
	    /* Horizontal Mode (Coodinate: LeftBottom) */
	}
    } else {
	if (coor == 0) {
	    /* Vertical Mode (Coodinate: LeftTop) */
	} else {
	    /* Vertical Mode (Coodinate: LeftBottom) */
	}
    }
    /* ɸƤΰ֤ʸꤹ */
    col = read_packet_entry_integer(pkt);
    row = read_packet_entry_integer(pkt);

    locate_char_cursor_on_page(&pg->pcPagePlane,col,row);
    DebugPrint2(6, " Cursor: <%d,%d>\n", col, row);
    /* 顼ֹ  add 1992 6/12 ź䤬ɲ */
    tx = GetTerritoryXEntry(tr);
    change_gc(xp->xDisp, tx->txGC,pkt,YYGC_COLOR,(YYGC *)NULL,
	      (YYGCONTEXT *)NULL);

    /* Ĥιܤν */
    pg->pcOperationMode = PAGEOP_NEEDRESIZEINFO;
    pg->pcInputTerritory = (TERRITORY *)NULL;
#ifdef KINPUT
    init_page_plane(&pg->pcKInputPlane, fid, 4, "    ");
#endif /*KINPUT*/
    /* ɽ³ԤʤȤΤľ */
    redraw_page_plane(ch, tr, &pg->pcPagePlane);

 send_reply:
    if (err_code == YYNOERROR) {
	repl = ALLOC_ACKPACKET(pkt);
	append_packet_entry_integer(repl, tr->teID);
    } else {
        repl = ALLOC_ERRPACKET(pkt);
        SETYYERRORCODE(repl, 0); SETYYERRORCODE(repl, err_code);
    }
    DebugEndFunc("page", "yycom_set_page_attribute");
    return repl;
}

/***************************************************************************
 ***** Command 81
 *****
 *****  Change Location of Page-Mode_Territory
 *****
 ***************************************************************************/

yy_packet *yycom_move_page_territory(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    TERRITORY *tr;
    TERRITORY_PAGE *pg;
    int err_code = YYNOERROR;
    yy_packet *repl = (yy_packet *)NULL;
    int mode, col, row;
    DebugSetFunc("page", "yycom_move_page_territory");
    /* бƥȥ֥åμ */
    if ((tr = catch_territory(pkt, TR_PAGE, &repl)) == (TERRITORY *)NULL) {
	DebugPrint0(1, " No Territory\n");
	err_code = YYERROR_NOTERRITORY; goto send_reply;
    }
    pg = &tr->teModeEnt.tPageControl;

    /* ڡ⡼ɥƥȥ꼫Ȥΰư */
    col = read_packet_entry_integer(pkt);
    row = read_packet_entry_integer(pkt);
    mode = read_packet_entry_integer(pkt);
    DebugPrint3(5, " Move Page Mode Territory to <%d,%d> (Mode:%d)\n",
		col, row, mode);
    /* ʸΰư */
    col = read_packet_entry_integer(pkt);
    row = read_packet_entry_integer(pkt);
    mode = read_packet_entry_integer(pkt);
    DebugPrint3(5, " Move Character-Cursor to <%d,%d> (Mode:%d)\n",
		col, row, mode);
    if (mode == 1)
	locate_char_cursor_on_page(&pg->pcPagePlane, col, row);
    else if (mode == 2)
	move_char_cursor_on_page(&pg->pcPagePlane, col, row);
 send_reply:
    if (err_code != YYNOERROR && repl == (yy_packet *)NULL) {
	repl = ALLOC_ERRPACKET(pkt);
	SETYYERRORCODE(repl, err_code);
    }
    DebugEndFunc("page", "yycom_move_page_territory");
    return repl;
}

/***************************************************************************
 ***** Command 82
 *****
 *****  Start Input Procedure on Page-Mode_Territory
 *****
 *****  start_input(tr, col, row, mode, semi-terminate, terminate, interrupt)
 *****
 ***************************************************************************/

/* set_user_input_edit_func(pkt, func, pg)
 *
 * YY-packet pkt ʸơˤäԽؿ func 
 * ƤӽФ褦 TerritoryPage pg Υ桼ԽؿꥹȤɲä
 */
static YYEDITFUNC *set_user_input_edit_func(pkt, func, pg)
    yy_packet *pkt;
    void (*func)();
    TERRITORY_PAGE *pg;
{
    char buf[16]; int leng;
    if ((leng = read_packet_entry_integer(pkt)) > 0) {
	read_packet_entry_string(pkt, leng, buf);
	pg->pcUserEditFuncTab =
	    add_input_edit_func_entry(pg->pcUserEditFuncTab, leng, buf, func);
    } else
	read_packet_entry_integer(pkt); /* ߡ */
    /*NoReturnValue*/
}

static void input_null_func()
{
    DebugSetFunc("page", "input_null_func");
    DebugEndFunc("page", "input_null_func");
    /*NoReturnValue*/
}

extern void input_terminate_keyin();
extern void input_send_keyin_status();

yy_packet *yycom_start_input(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    TERRITORY *tr;
    TERRITORY_PAGE *pg;
    int err_code = YYNOERROR;
    yy_packet *repl = (yy_packet *)NULL;
    int col, row, mode;

    DebugSetFunc("page", "yycom_start_input");
    /* бƥȥ֥åμ */
    if ((tr = catch_territory(pkt, TR_PAGE, &repl)) == (TERRITORY *)NULL) {
	DebugPrint0(1, " No Territory\n");
	err_code = YYERROR_NOTERRITORY; goto send_reply;
    }
    pg = &tr->teModeEnt.tPageControl;
    if (pg->pcInputTerritory != (TERRITORY *)NULL) {
	DebugPrint1(1, " Territory#%d is InputEditingMode\n", tr->teID);
	err_code = YYERROR_NOTERRITORY; goto send_reply;
    }
    /* Ƽμ */
    col = read_packet_entry_integer(pkt);
    row = read_packet_entry_integer(pkt);
    mode = read_packet_entry_integer(pkt);
    /* mode ǤϽѥƥȥ */
    DebugPrint3(3, "Create Input Territory on <%d,%d> of Page#%d\n",
		col, row, tr->teID);
    pg->pcInputTerritory = create_input_territory(ch, tr, col, row, mode);
    if (pg->pcInputTerritory == (TERRITORY *)NULL) {
	DebugPrint1(1, " Can't Create Input Territory on Territory#%d\n",
		    tr->teID);
	err_code = YYERROR_NOTERRITORY; goto send_reply;
    }

    /* ѥƥȥ꤬ Y ɸˤơݰ֤ˤΤǤ
     * ١ȤʤäƤƥȥ򲼤˲ */
    if (tr->teY + pg->pcInputTerritory->teY < 0) {
	DebugPrint0(9, "Page Territory - Scroll Up \n");
	move_territory(ch, tr, tr->teX, -pg->pcInputTerritory->teY);
    } else {
	TERRITORY *parent = GetParentTerritory(tr);
	register int lb_y =
	    tr->teY+pg->pcInputTerritory->teY+pg->pcInputTerritory->teHeight;
	DebugPrint1(9, "LeftBottom Y=%d\n", lb_y);
	if (parent != (TERRITORY *)NULL && lb_y > parent->teHeight) {
	    DebugPrint1(9, "Height of Parent Territory =%d\n",
			parent->teHeight);
	    move_territory(ch, tr, tr->teX, tr->teY-lb_y+parent->teHeight);
	}
    }

    /* ϴؿƤӽФ */
    set_user_input_edit_func(pkt, input_send_keyin_status, pg);
    set_user_input_edit_func(pkt, input_terminate_keyin, pg);
    set_user_input_edit_func(pkt, input_terminate_keyin, pg);
 send_reply:
    if (err_code != YYNOERROR && repl == (yy_packet *)NULL) {
		repl = ALLOC_ERRPACKET(pkt);
		SETYYERRORCODE(repl, err_code);
    }
    DebugEndFunc("page", "yycom_start_input");
    return repl;
}


/***************************************************************************
 ***** Command 83
 *****
 *****  Abort Input Procedure on Page-Mode_Territory
 *****
 ***************************************************************************/

yy_packet *yycom_abort_input(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    TERRITORY *tr;
    TERRITORY_PAGE *pg;
    TERRITORY *input_tr;
    TERRITORY_PAGE *input_pg;
    int err_code = YYNOERROR;
    yy_packet *repl = (yy_packet *)NULL;

    DebugSetFunc("page", "yycom_abort_input");
    /* бƥȥ֥åμ */
    if ((tr = catch_territory(pkt, TR_PAGE, &repl)) == (TERRITORY *)NULL) {
	DebugPrint0(1, " No Territory\n");
	err_code = YYERROR_NOTERRITORY; goto send_reply;
    }
    pg = &tr->teModeEnt.tPageControl;
    if ((input_tr = pg->pcInputTerritory) == (TERRITORY *)NULL) {
	err_code = YYERROR_NOTERRITORY; goto send_reply;
    }
    input_pg = &input_tr->teModeEnt.tPageControl;
    abort_input_procedure(ch, tr);
    /* ΰ˲ */
    destroy_page_plane(&input_pg->pcPagePlane);
    destroy_page_plane(&input_pg->pcInputPlane);
#ifdef KINPUT
    destroy_page_plane(&input_pg->pcKanaInputPlane);
#endif /*KINPUT*/
    destroy_territory(ch, input_tr, TRUE);
    pg->pcInputTerritory = (TERRITORY *)NULL;
 send_reply:
    if (err_code != YYNOERROR && repl == (yy_packet *)NULL) {
	repl = ALLOC_ERRPACKET(pkt);
	SETYYERRORCODE(repl, err_code);
    }
    DebugEndFunc("page", "yycom_abort_input");
    return repl;
}

/***************************************************************************
 ***** Command 84
 *****
 *****  Draw Text on Page-Mode_Territory
 *****
 *****  draw_text_on_page(tr,op,color,fid,leng,str)
 *****
 ***************************************************************************/

yy_packet *yycom_draw_text_on_page(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    TERRITORY *tr;
    TERRITORY_PAGE *pg;
    int fid;	/* եֹ */
    int err_code = YYNOERROR;
    yy_packet *repl = (yy_packet *)NULL;
    STRINGBOX *sb;
    int leng, offset;
    u_char buf[128];
    int col1, row1;
    int col2, row2;

    DebugSetFunc("page", "yycom_draw_text_on_page");
    /* бƥȥ֥åμ */
    if ((tr = catch_territory(pkt, TR_PAGE, &repl)) == (TERRITORY *)NULL) {
	DebugPrint0(1, " No Territory\n");
	err_code = YYERROR_NOTERRITORY; goto send_reply;
    }
    pg = &tr->teModeEnt.tPageControl;
    /* GC ѹ */
    change_gc(XPRIVATE(ch)->xDisp, XEntry(tr)->txGC, pkt,
	      (YYGC_OPERATION|YYGC_COLOR), (YYGC *)NULL, (YYGCONTEXT *)NULL);
    if ((fid = read_packet_entry_integer(pkt)) == 0)
	fid = pg->pcPagePlane.defCharFont;
    DebugPrint2(5, " Draw Text with Font ID#%d on TR#%d\n", fid, tr->teID);

    /* ʸǽ񤭹 */
    leng = read_packet_entry_integer(pkt);
    offset = 0;
    col1 = GETPAGECOL(pg); row1 = GETPAGEROW(pg);
    while (leng > 0) {
	register int rlen = MIN(leng, sizeof(buf));
	register int nchar, wlen;
	read_packet_entry_string(pkt, rlen, &buf[offset]);
	leng -= rlen;		/* ѥåȤ˻ĤХȿ */
	rlen += offset;		/* buf ͭʥХȿ */
	/* buf ʸϥޥХȥɤڤǽ
	 *  nchar  wlen  buf ͭʸȥХȿ */
	nchar = JEUC_StrNChar(rlen, buf);
	wlen = JEUC_StrLen(nchar, buf);
	overwrite_string_on_page(&pg->pcPagePlane, fid, wlen, buf);
	/* buf ڤˤʤäƤ륳ɤ buf Ƭ˰ư */
	if ((offset = (rlen - wlen)) > 0) memcpy(buf, &buf[wlen], offset);
    }
    col2 = GETPAGECOL(pg); row2 = GETPAGEROW(pg);
    redraw_page_plane(ch, tr, &pg->pcPagePlane);
    sb = get_string_box(ch, &pg->pcPagePlane, col1, row1, col2, row2);
    DebugPrint4(6, " (P84) Draw Text in Box (%d,%d)<%d,%d>\n",
		sb->x, sb->y, sb->w, sb->h);

    /* Client ֤ѥåȤκ */
    repl = ALLOC_ACKPACKET(pkt);
    append_packet_entry_integer(repl,sb->x);
    append_packet_entry_integer(repl,sb->y);
    append_packet_entry_integer(repl,sb->w);
    append_packet_entry_integer(repl,sb->h);
    append_packet_entry_integer(repl,col2);
    append_packet_entry_integer(repl,row2);
 send_reply:
    if (err_code != YYNOERROR && repl == (yy_packet *)NULL) {
	repl = ALLOC_ERRPACKET(pkt);
	SETYYERRORCODE(repl, err_code);
    }
    DebugEndFunc("page", "yycom_draw_text_on_page");
    return repl;
}

/***************************************************************************
 ***** Command 85
 *****
 *****  Get Pixel Position from (column,line) pair
 *****
 ***************************************************************************/

yy_packet *yycom_get_position_on_page(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    TERRITORY *tr;
    TERRITORY_PAGE *pg;
    int err_code = YYNOERROR;
    yy_packet *repl = (yy_packet *)NULL;
    int col, row;
    STRINGBOX *sb;
    DebugSetFunc("page", "yycom_get_position_on_page");
    if ((tr = catch_territory(pkt, TR_PAGE, &repl)) == (TERRITORY *)NULL) {
	DebugPrint0(1, " No Territory\n");
	err_code = YYERROR_NOTERRITORY; goto send_reply;
    }
    pg = &tr->teModeEnt.tPageControl;
    col = read_packet_entry_integer(pkt);
    row = read_packet_entry_integer(pkt);
    sb = get_string_box(ch, &pg->pcPagePlane, col, row, col+1, row);
    DebugPrint6(6, " Character on <%d,%d> -> Box (%d,%d)<%d,%d>\n",
		col, row, sb->x, sb->y, sb->w, sb->h);
    /* Client ֤ѥåȤκ */
    repl = ALLOC_ACKPACKET(pkt);
    append_packet_entry_integer(repl,sb->x);
    append_packet_entry_integer(repl,sb->y);
    append_packet_entry_integer(repl,sb->w);
    append_packet_entry_integer(repl,sb->h);
    DebugPrint4(6, " (P85) Text in Box (%d,%d)<%d,%d>\n",
		sb->x, sb->y, sb->w, sb->h);
 send_reply:
    if (err_code != YYNOERROR && repl == (yy_packet *)NULL) {
	repl = ALLOC_ERRPACKET(pkt);
	SETYYERRORCODE(repl, err_code);
    }
    DebugEndFunc("page", "yycom_get_position_on_page");
    return repl;
}

/*
 * Local variables:
 * eval: (set-kanji-fileio-code 'EUC)
 * end:
 */
