;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; $@F~NO$K4X$9$k%U%!%$%k(J
;;; yy-input-stream-class.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.3.1 91/11/28 by t.kosaka (kosaka@csrl.aoyama.ac.jp)

(in-package :yy)

;;; $@%$%Y%s%H$N?F%/%i%9(J
(defclass yy-event () 
  ((territory-no :initform 0 :reader territory-no 
		 :initarg :territory-no)
   (event-mask :initform #b00000000000000000000000000000000
               :accessor event-mask  :initarg :event-mask)))

 ;;;$@%-!<%\!<%I%$%Y%s%H%/%i%9(J
(defclass yy-keybord-event (yy-event)
  ((event-string :initform "" :accessor event-string
		 :initarg :event-string :type string)))

;;; $@%^%&%9!"3d$j9~$_%-!<%$%Y%s%H(J
(defclass yy-interrupt-event (yy-event)
  ((event-position :initform (make-position)
		   :type position
		   :accessor event-position :initarg :event-position)))


;;; $@%F%j%H%j!<$NBg$-$5JQ99%$%Y%s%H(J
(defclass yy-resize-event (yy-event)
   ((event-region :initform (make-region)
   		  :type region
   		  :accessor event-region :initarg :event-region)))

;;; $@%$%Y%s%H%a%=%C%I%_%-%7%s(J
(defclass event-method-mixin ()
   ;;; $@%$%Y%s%H%^%9%/(J
  ((event-mask :initarg :event-mask
	       :initform #b00000000000000000000000000000000)

   ;;; $@%\%?%s$,2!2<$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(J
   (button-down1 :initarg :button-1  :initform nil
			:accessor button1-method)

   ;;; $@:8%\%?%s$,2!2<$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(J
   (left-button-down-1 :initarg :left-button-down-1
		     :initform nil :accessor left-button-down-1-method)

   ;;; $@Cf%\%?%s$,2!2<$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(J
   (middle-button-down-1 :initarg :middle-button-down-1
		     :initform nil :accessor middle-button-down-1-method)

   ;;; $@1&%\%?%s$,2!2<$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(J
   (right-button-down-1 :initarg :right-button-down-1
		     :initform nil :accessor right-button-down-1-method)

   ;;; $@%\%?%s$,N%$5$l$?;~5/F0$9$k%a%=%C%I(J
   (button-up :initarg :button-up :initform nil
	      :accessor button-up-method)

   ;;; $@:8%\%?%s$,N%$5$l$?;~5/F0$9$k%a%=%C%I(J
   (left-button-up :initarg :left-button-up
		     :initform nil :accessor left-button-up-method)

   ;;; $@Cf%\%?%s$,N%$5$l$?;~5/F0$9$k%a%=%C%I(J
   (middle-button-up :initarg :middle-button-up
		     :initform nil :accessor middle-button-up-method)

   ;;; $@1&%\%?%s$,N%$5$l$?;~5/F0$9$k%a%=%C%I(J
   (right-button-up :initarg :right-button-up
		     :initform nil :accessor right-button-up-method)

   ;;; $@%\%?%s$,%@%V%k%/%j%C%/$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(J
   (button-down2 :initarg :button-2  :initform nil
			:accessor button2-method)	

   ;;; $@:8%\%?%s$,%@%V%k%/%j%C%/$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(J
   (left-button-down-2 :initarg :left-button-down-2
		     :initform nil :accessor left-button-down-2-method)

   ;;; $@Cf%\%?%s$,%@%V%k%/%j%C%/$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(J
   (middle-button-down-2 :initarg :middle-button-down-2
		     :initform nil :accessor middle-button-down-2-method)

   ;;; $@1&%\%?%s$,%@%V%k%/%j%C%/$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(J
   (right-button-down-2 :initarg :right-button-down-2
		     :initform nil :accessor right-button-down-2-method)

   ;;; $@%^%&%9%+!<%=%k$,F0$/$3$H$K$h$j5/F0$9$k%a%=%C%I(J
   (move-mouse-cursor :initarg :move-mouse-cursor
		     :initform nil :accessor move-mouse-cursor-method)

   ;;; $@%^%&%9%+!<%=%k$,F~$C$?;~$K5/F0$9$k%a%=%C%I(J
   (mouse-cursor-in :initarg :mouse-cursor-in
		     :initform nil :accessor mouse-cursor-in-method)

   ;;; $@%^%&%9%+!<%=%k$,=P$?;~$K5/F0$9$k%a%=%C%I(J
   (mouse-cursor-out :initarg :mouse-cursor-out
		     :initform nil :accessor mouse-cursor-out-method)

   ;;; $@%^%&%9%+!<%=%k$,$"$kNN0h$G(JN$@%_%jICDd;_$7$?;~$K5/F0$9$k%a%=%C%I(J
   (mouse-cursor-wait :initarg :mouse-cursor-wait
		     :initform nil :accessor mouse-cursor-wait-method)

   ;;; $@3d$j9~$_%-!<$,2!2<$5$l$?;~$K5/F0$5$l$k%a%=%C%I(J
   (interrupt-key :initarg :interrupt-key
		     :initform nil :accessor interrupt-key-method)))




