;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; $@%&%#%s%I%&$NItIJ$N%a%=%C%I4XO"(J
;;; window-parts-method.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University and CSK Corp.
;;;
;;;             All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in
;;; supporting documentation, and that the names of Aoyama Gakuin and CSK
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification.
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors: 
;;;           Version2.0   91/02/28 T.Kosaka

;;; $@%&%#%s%I%&$NItIJ$N%a%=%C%I4XO"(J

(in-package :yy)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@%&%#%s%I%&$NItIJ4XO"%a%=%C%I(J   ;;;
;;;          Version 2.0           ;;;              
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; title-bar-region $@$N(Jsetf$@%a%=%C%I(J
;;; $@%?%H%k%P!<$N%5%$%:JQ99(J
;;; (setf title-bar-region) region window
;;; ARG.
;;;         region    = $@?7$7$$%j!<%8%g%s(J
;;;         window    = $@%&%#%s%I%&%9%H%j!<%`(J
(defmethod (setf title-bar-region) ((region region) (window window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (set-title-bar-region (window-title-bar window) region)
  (redisplay-title-bar (window-title-bar window)))

;;; $@%?%$%H%k%P!<J8;zNs%"%/%;%9(J
;;; title-bar-string window
;;;ARG.
;;;             window = $@%&%#%s%I%&%9%H%j!<%`(J
(defgeneric title-bar-string (window)
  (:method ((window window-stream))
	   (slot-value (window-title-bar window) 'title-bar-string))
  (:method ((window NULL))
	   nil))

;;; $@%?%$%H%k%P!<J8;zNs$NJQ99(J
;;; (setf title-bar-string) string window
;;; ARG.
;;;          string   = $@?7$7$$J8;zNs(J
;;;          window   = $@%&%#%s%I%&%9%H%j!<%`(J
(defgeneric (setf title-bar-string) (string window)
  (:method (string (window window-stream))
	   (setf (slot-value (window-title-bar window) 'title-bar-string)
	     string)
	   (redisplay-title-bar (window-title-bar window)))
  (:method (string (window NULL))
#-:PCL
   (declare (ignore string))
	   (values)))
	   

;;; $@%?%$%H%k%P!<%U%)%s%H$N%"%/%;%9%a%=%C%I(J
;;; title-bar-font window
;;; ARG.
;;;                window   =  $@%&%#%s%I%&%9%H%j!<%`(J
(defgeneric title-bar-font (window)
  (:method ((window window-stream))
    (slot-value (window-title-bar window) 'title-font))
  (:method ((window NULL))
	   NIL))

;;; $@%?%$%H%k%P!<%U%)%s%H$NJQ99%a%=%C%I(J
;;; (setf title-bar-font) new-font window
;;; ARG.
;;;                new-font = $@?7$7$$%U%)%s%H(J
;;;                window   =  $@%&%#%s%I%&%9%H%j!<%`(J
(defgeneric (setf title-bar-font) (font window)
  (:method ((font text-font) (window window-stream))
    (let ((title-bar (window-title-bar window)))
      (setf (slot-value title-bar 'title-font) font
	    (region-height title-bar) (font-kanji-height font))
      (set-window-component-size window)
      (redisplay-window window)))
  (:method (font (window NULL))
#-:PCL
  (declare (ignore font))
	   NIL))

;;;$@%?%$%H%k%P!<I=<($N;2>H$NAm>N4X?t(J
;;; title-bar-visible window 
;;; ARG.
;;;          window   =  $@%&%#%s%I%&%9%H%j!<%`(J
(defgeneric title-bar-visible (window)
  (:method ((window window-stream))
	   (draw-piece-visible (window-title-bar window)))
  (:method ((window NULL))
	   NIL))

;;;$@%?%$%H%k%P!<I=<(>uBV$NJQ99$NAm>N4X?t(J
;;; (setf title-bar-visible) value window
;;; ARG.
;;;             value  =  T or NIL T: $@I=<((J NIL: $@HsI=<((J
;;;             window = $@%&%#%s%I%&%9%H%j!<%`(J
(defgeneric (setf title-bar-visible) (val window)
  (:method (val (window window-stream))
    (let ((title (window-title-bar window)))
	   (setf (draw-piece-visible title) val)))
  (:method (val (window NULL))
#-:PCL
  (declare (ignore val))
       nil))
	   
;;; $@%?%$%H%k%P!<$N?'$N;2>H$NAm>N4X?t(J
;;; title-bar-color window
;;; ARG.
;;;            window   =  $@%&%#%s%I%&%9%H%j!<%`(J
(defgeneric title-bar-color (window)
  (:method   ((window window-stream))
	     (slot-value (window-title-bar window) 'title-bar-color))
  (:method ((window NULL))
	   (values)))

;;; $@%?%$%H%k%P!<$N?'$NJQ99$NAm>N4X?t(J
;;; (setf title-bar-color) new-color window
;;; ARG.
;;;                new-color = $@?7$7$$%+%i!<$N%$%s%9%?%s%9(J
;;;                window    = $@%&%#%s%I%&%9%H%j!<%`(J
(defgeneric (setf title-bar-color) (new-color window)
  (:method  ((new-color color) (window window-stream))
	    (setf (slot-value (window-title-bar window) 'title-bar-color)
	      new-color)
	    (redisplay-title-bar (window-title-bar window)))
  (:method (new-color (window NULL))
#-:PCL
  (declare (ignore new-color))
	   (values)))


;;; world-region $@$N(Jset$@%a%=%C%I(J
;;; $@%o!<%k%I%5%$%:$NJQ99(J
;;; (setf world-region) region window
;;; ARG.
;;;             region      = $@?7$7$$%j!<%8%g%s(J
;;;             window      = $@%&%#%s%I%&%9%H%j!<%`(J
(defmethod (setf world-region) ((region region) (window window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (set-world-region-internal region window))

(defun set-world-region-internal (region window)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((v nil) (h nil))
    (multiple-value-setq (v h)
      (resize-world region window))
    (setf 
	(world-height (window-vertical-scroll-bar window))
      (region-height window)
      (world-width (window-horizontal-scroll-bar window))
      (region-width window))
;    (format t "v ~a h ~a~%" v h)

    (if v
	(redisplay-vertical-scroll (window-vertical-scroll-bar window)))     

    (if h
	(redisplay-horizontal-scroll (window-horizontal-scroll-bar window)))
    ))


;;; frame$@$NBg$-$5JQ99%a%=%C%I(J
;;; (serf frame-region) region window
;;; ARG.
;;;            region   = $@?7$7$$%j!<%8%g%s(J
;;;            window   = $@%&%#%s%I%&%9%H%j!<%`(J
(defmethod (setf frame-region) ((region region) (window window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (set-frame-region (window-frame window) region)

  (with-region-slots 
   (width height) (window-frame window)
   (setf (frame-height (window-vertical-scroll-bar window))
     height
     
     (frame-width (window-horizontal-scroll-bar window))
     width)))

;;;$@=D%9%/%m!<%k%P!<$NI=<($N;2>H$NAm>N4X?t(J
;;; vertiacl-scroll-visible window 
;;; ARG.
;;;          window   =  $@%&%#%s%I%&%9%H%j!<%`(J
(defgeneric vertiacl-scroll-visible (window)
  (:method ((window window-stream))
	   (draw-piece-visible (window-vertical-scroll-bar window)))
  (:method ((window NULL))
	   NIL))

;;;$@=D%9%/%m!<%k%P!<$NI=<(>uBV$NJQ99$NAm>N4X?t(J
;;; (setf vertiacl-scroll-visible) value window
;;; ARG.
;;;             value  =  T or NIL T: $@I=<((J NIL: $@HsI=<((J
;;;             window = $@%&%#%s%I%&%9%H%j!<%`(J
(defgeneric (setf vertiacl-scroll-visible) (val window)
  (:method (val (window window-stream))
    (let ((scroll (window-vertical-scroll-bar window)))
	   (setf (draw-piece-visible scroll) val)))
  (:method (val (window NULL))
#-:PCL
   (declare (ignore val))
       nil))

;;; $@=DJ}8~%9%/%m!<%k%P!<$N%j!<%8%g%sJQ99$NAm>N4X?t(J
;;; (set vertical-scroll-region) new-region window
;;; ARG.
;;;                new-region = $@?7$7$$%j!<%8%g%s(J
;;;                window     = $@%&%#%s%I%&%9%H%j!<%`(J
(defmethod (setf vertical-scroll-region) ((new-region region) (window window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (set-scroll-region (vertical-scroll-region window)  new-region )
  (redisplay-vertical-scroll (vertical-scroll-region window))
  )

;;;$@2#%9%/%m!<%k%P!<$NI=<($N;2>H$NAm>N4X?t(J
;;; horizontal-scroll-visible window 
;;; ARG.
;;;          window   =  $@%&%#%s%I%&%9%H%j!<%`(J
(defgeneric horizontal-scroll-visible (window)
  (:method ((window window-stream))
	   (draw-piece-visible (window-horizontal-scroll-bar window)))
  (:method ((window NULL))
	   NIL))

;;;$@2#%9%/%m!<%k%P!<$NI=<(>uBV$NJQ99$NAm>N4X?t(J
;;; (setf horizontal-scroll-visible) value window
;;; ARG.
;;;             value  =  T or NIL T: $@I=<((J NIL: $@HsI=<((J
;;;             window = $@%&%#%s%I%&%9%H%j!<%`(J
(defgeneric (setf horizontal-scroll-visible) (val window)
  (:method (val (window window-stream))
    (let ((scroll (window-horizontal-scroll-bar window)))
	   (setf (draw-piece-visible scroll) val)))
  (:method (val (window NULL))
#-:PCL
   (declare (ignore val))
       nil))

;;; $@2#J}8~%9%/%m!<%k%P!<$N%j!<%8%g%sJQ99$NAm>N4X?t(J
;;; (set horizontal-scroll-region) new-region window
;;; ARG.
;;;                new-region = $@?7$7$$%j!<%8%g%s(J
;;;                window     = $@%&%#%s%I%&%9%H%j!<%`(J
(defmethod (setf horizontal-scroll-region) ((new-region region) (window window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (set-scroll-region (horizontal-scroll-region window) new-region)
  (redisplay-horizontal-scroll (horizontal-scroll-region window))
  )

;;; X$@%*%U%;%C%H$N;2>H(J
;;; world-x-offset window
;;; ARG.    window = $@%&%#%s%I%&(J
(defgeneric world-x-offset (window)
  (:method ((window window-stream))
	(slot-value window 'world-x-offset))
  (:method ((window NULL))
	   0))

;;; X$@%*%U%;%C%HJQ99(J $@@dBPJQ99%a%=%C%I(J
;;; (setf world-x-offset) new-value window
;;; ARG.
;;;          new-value   = $@%*%U%;%C%H$N?7$7$$CM(J
;;;          window      = $@%&%#%s%I%&%9%H%j!<%`(J
(defgeneric (setf world-x-offset) (new-v window)
  (:method (new-v (window window-stream))
	   (set-world-x-offset new-v window)
	   (set-horizontal-world-x-offset 
	    (window-horizontal-scroll-bar window) new-v)
	   (redisplay-horizontal-scroll (window-horizontal-scroll-bar window)))
  (:method (new-v (window NULL))
#-:PCL
   (declare (ignore new-v))
     (values)))

;;; X$@%*%U%;%C%HJQ99(J $@AjBPJQ99(J
;;; add-x-offset window value
;;; ARG.
;;;              window   =   $@%&%#%s%I%&%9%H%j!<%`(J
;;;              value    =   $@2C;;CM(J
(defgeneric add-x-offset (window vlaue)
  (:method ((window window-stream) value)
     (let ((x (add-x-offset-world window value)))
       (set-horizontal-world-x-offset 
	   (window-horizontal-scroll-bar window) x)
       (redisplay-horizontal-scroll (window-horizontal-scroll-bar window))))

  (:method ((window NULL) value)
#-:PCL
   (declare (ignore value))
	   (values)))

;;; Y$@%*%U%;%C%H$N;2>H(J
;;; world-y-offset window
;;; ARG.    window = $@%&%#%s%I%&(J
(defgeneric world-y-offset (window)
  (:method ((window window-stream))
	(slot-value window 'world-y-offset))
  (:method ((window NULL))
	   0))

;;; Y$@%*%U%;%C%HJQ99(J $@@dBPJQ99%a%=%C%I(J
;;; (setf world-x-offset) new-value window
;;; ARG.
;;;          new-value   = $@%*%U%;%C%H$N?7$7$$CM(J
;;;          window      = $@%&%#%s%I%&%9%H%j!<%`(J
(defgeneric (setf world-y-offset) (new-v window)
  (:method (new-v (window window-stream))
	   (set-world-y-offset new-v window)
	   (set-vertical-world-y-offset 
	    (window-vertical-scroll-bar window) new-v)
	   (redisplay-vertical-scroll (window-vertical-scroll-bar window)))
  (:method (new-v (window NULL))
#-:PCL
   (declare (ignore new-v))
     (values)))

;;; Y$@%*%U%;%C%HJQ99(J $@AjBPJQ99(J
;;; add-y-offset window value
;;; ARG.
;;;              window   =   $@%&%#%s%I%&%9%H%j!<%`(J
;;;              value    =   $@2C;;CM(J
(defgeneric add-y-offset (window vlaue)
  (:method ((window window-stream) value)
     (let ((y (add-y-offset-world window value)))
       (set-vertical-world-y-offset 
	(window-vertical-scroll-bar window) y)
       (redisplay-vertical-scroll (window-vertical-scroll-bar window))))

  (:method ((window NULL) value)
#-:PCL
  (declare (ignore value))
	   (values)))

;;; XY$@%*%U%;%C%H$NJQ99(J $@@dBPJQ99(J
;;; change-world-xy-offset window x y
;;; ARG.
;;;         window   =  $@%&%#%s%I%&%9%H%j!<%`(J
;;;         x y      =  $@0LCV(J
(defgeneric change-world-xy-offset (window x y)
  (:method ((window window-stream) (x integer) (y integer))
      (let ((x-offset (slot-value window 'world-x-offset))
	    (y-offset (slot-value window 'world-y-offset)))
	(multiple-value-bind (xx yy)
	  (change-world-xy-offset-internal window x y)

	  (set-vertical-world-y-offset 
	   (window-vertical-scroll-bar window) yy)
	  (set-horizontal-world-x-offset
	   (window-horizontal-scroll-bar window) xx)
	  (if (/= x-offset x)
	      (redisplay-horizontal-scroll 
	                  (window-horizontal-scroll-bar window)))
	  (if (/= y-offset y)
	      (redisplay-vertical-scroll (window-vertical-scroll-bar window)))
	  )))

  (:method ((window window-stream) (x integer) (y NULL))
    (setf (slot-value window 'world-x-offset) x))
  (:method ((window window-stream) (x NULL) (y integer))
    (setf (slot-value window 'world-y-offset) y))
  (:method ((window window-stream) x y)
#-:PCL
   (declare (ignore x y))
   (values))
  (:method ((window NULL) x y)
#-:PCL
   (declare (ignore x y))
    (values)))
	  
				
;;; $@:BI87OI=<(%(%j%"$N0LCVJQ99(J
;;; (setf coordinate-area-bottom) region window
;;; ARG.
;;;                region     = $@?7$7$$%j!<%8%g%s(J
;;;                window     = $@%&%#%s%I%&%9%H%j!<%`(J
(defmethod (setf coordinate-area-bottom) (new-bottom (window window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (set-coordinate-area-region (setf (region-bottom 
				     (window-coordinate-area window)) 
				    new-bottom)
			      (window-coordinate-area window))
  (redisplay-coordinate-area (window-coordinate-area window))
  )

;;; $@%&%#%s%I%&$N:FI=<((J
;;; redisplay-window window
;;; ARG.
;;;         window  = $@%&%#%s%I%&%9%H%j!<%`(J
(defmethod redisplay-window ((window window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (default-redisplay-window window))

(defun default-redisplay-window (window)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (redisplay-title-bar (window-title-bar window))
  (redisplay-horizontal-scroll (window-horizontal-scroll-bar window))
  (redisplay-vertical-scroll (window-vertical-scroll-bar window))
  (redisplay-coordinate-area (window-coordinate-area window))
  (redisplay-border window))


;;;$@%\!<%@!<I=<(>uBV$NJQ99(J after$@%a%=%C%I(J
;;; (setf border-visible) new window
;;; ARG.
;;;           new    =  T or NIL -> T:$@I=<((J NIL:$@HsI=<((J
;;;           window =  $@%&%#%s%I%&%9%H%j!<%`(J
(defmethod (setf border-visible) :after (new (window window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if new
      (setf (real-border-belt window) 0))
  (setf (real-border-belt window) (border-belt window))
  (set-window-component-size window)
  (redisplay-window window))


;;; $@%\!<%@!<$NI}JQ99%a%=%C%I(J after$@%a%=%C%I(J
;;; (setf border-belt) new-v window
;;; ARG.
;;;          new-v  =  $@%\!<%@$NI}(J
;;;          window = $@%&%#%s%I%&%9%H%j!<%`(J
(defmethod (setf border-belt) :after (new-v (window window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (setf (slot-value window 'border-belt) new-v)
  (if (border-visible window)
    (setf (real-border-belt window) new-v))
  (set-window-component-size window)
  (redisplay-window window))

;;; $@%\!<%@$N?'$NJQ99%a%=%C%I(J after $@%a%=%C%I(J
;;; (setf border-color) color window
;;; ARG.
;;;         color     =    $@?7$7$$%+%i!<(J
;;;         window    =    $@%&%#%s%I%&%9%H%j!<%`(J
(defmethod (setf border-color) :after ((color color) (window window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (redisplay-border window))


;;; $@%\!<%@$N:FI=<((J
;;; redisplay-border window
;;; ARG.
;;;           window   =  $@%&%#%s%I%&%9%H%j!<%`(J
(defmethod redisplay-border ((window window-stream))
  (declare (special *white-color*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
    (let* ((region (window-region window))
	 (belt (real-border-belt window))
	 (width (region-width region))
	 (height (region-height region)))
      (draw-piece-color window *white-color*)
      (draw-piece-rectangle window   0  ;;; (floor (/ belt 2))
			             0  ;;; (floor (/ belt 2))
			  width height :color (border-color window)
			  :line-width belt)))

;;; $@%&%#%s%I%&$N%?%$%H%k%P!<$rJQ99$9$k%a%=%C%I(Jafter
;;; (setf window-title-bar) new-title-bar window
;;; ARG.
;;;            new-title-bar  =  $@%?%$%H%k!<%P!<%$%s%9%?%s%9(J
;;;            window         =  $@%&%#%s%I%&(J
(defmethod (setf window-title-bar) :after ((title title-bar)
					   (window window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (set-window-component-size window)
  (redisplay-window window))

;;; $@%&%#%s%I%&$N2#%9%/%m!<%k%P!<$rJQ99$9$k%a%=%C%I(Jafter
;;; (setf window-horizontal-scroll-bar) new-val window
;;; ARG.
;;;           new-val   = $@2#%9%/%m!<%k%P!<%$%s%9%?%s%9(J
;;;           window    = $@%&%#%s%I%&(J
(defmethod (setf window-horizontal-scroll-bar) :after 
                    ((new-val horizontal-scroll-bar) (window window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (set-window-component-size window)
  (redisplay-window window))

;;; $@%&%#%s%I%&$N=D%9%/%m!<%k%P!<$rJQ99$9$k%a%=%C%I(Jafter
;;; (setf window-vertiacal-scroll-bar) new-val window
;;; ARG.
;;;           new-val   = $@=D%9%/%m!<%k%P!<%$%s%9%?%s%9(J
;;;           window    = $@%&%#%s%I%&(J
(defmethod (setf window-vertical-scroll-bar) :after 
                    ((new-val vertical-scroll-bar) (window window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (set-window-component-size window)
  (redisplay-window window))

			
;;; $@%&%#%s%I%&$N3F9=@.MWAG$N%5%$%:$N7W;;$H@_Dj(J
;;; set-window-component-size window
;;; ARG.
;;;         window   =  $@%&%#%s%I%&%9%H%j!<%`(J
(defun set-window-component-size (window)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))

  (let* ((region1 (work-region1 window))
		 (title (window-title-bar window))
		 (width (region-width (window-region window)))
		 (height (region-height (window-region window)))
		 (coordinate (window-coordinate-area window))
		 (hscroll (window-horizontal-scroll-bar window))
		 (vscroll (window-vertical-scroll-bar window))
		 (frame (window-frame window))
		 (region-list nil)
		 (alrady-list (list title coordinate hscroll vscroll frame)))

	;; $@%&%#%s%I%&$NBg$-$5$r@_Dj$9$k!#(J
	(with-region-slots
	 (left bottom (widht1 width) (height1 height)) region1
	 (setf left 0 bottom 0
		   widht1 width height1 height))

    (if title ;;; $@%?%$%H%k%P!<$,$"$k(J
		(when (draw-piece-visible title)
			  (push 
			   (set-title-bar-region 
				title (compute-window-parts title region1 region-list))
			   region-list)))
			  
    (if coordinate  ;; $@:BI87OI=<(%(%j%"$,$"$k(J
		(when (draw-piece-visible coordinate)
			  (push (set-coordinate-area-region 
					 coordinate (compute-window-parts 
								 coordinate region1 region-list))
					region-list)))

    (if hscroll ;; $@2#%9%/%m!<%k%P!<$,$"$k(J
		(when (draw-piece-visible hscroll)
			  (push (set-scroll-region 
					 hscroll (compute-window-parts
							  hscroll region1 region-list))
					region-list)))
								  
    (if vscroll 		;; $@=D%9%/%m!<%k%P!<$,$"$k(J
		(when (draw-piece-visible vscroll)
			  (push (set-scroll-region 
					 vscroll (compute-window-parts
							  vscroll region1 region-list))
					region-list)))

	(if frame   ;; $@%U%l!<%`$,$"$k(J
		(when (frame-visible frame)
			  (push (setf (frame-region window)
					 (compute-window-parts
					  frame region1 region-list))
					region-list)))

	;; $@B>$N%&%#%s%I%&%Q!<%D$N7W;;$HBg$-$5JQ99(J
	(dolist (item (remove-if
				   #'(lambda (x) (member x alrady-list))
				   (window-parts-list window)))
			(push (set-window-parts-region
				   item (compute-window-parts
						 item region1 region-list))
				  region-list))
    ))
    
;;; $@%&%#%s%I%&$NBg$-$5JQ99(J
;;; (setf window-region) new-region window
;;; ARG.
;;;               new-region     =   $@?7$7$$%j!<%8%g%s(J
;;;               window         =   $@%&%#%s%I%&%9%H%j!<%`(J
(defmethod (setf window-region) ((new-region region) (window window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((region (window-region window))
		 (parent (parent-window window))
		 (tno (territory window))
		 (start-x (if parent (world-x-start parent) 0))
		 (start-y (if parent (world-y-start parent) 0)))

    ;; $@0l<!E*$KHsIA2h(J
    (yy-protocol-2 tno 0)
	
    ;;; $@F1$8%j!<%8%g%s$G$J$$(J
    (unless (eq region new-region)
	    (set-region region new-region))

     ;;; $@3F9=@.MWAG$NBg$-$5$N:F7W;;(J
    (set-window-component-size window)

     ;;; $@<B:]$N0\F0$HJQ99(J
    (with-region-slots
     (left bottom width height) region
     (yy-protocol-4 tno (+ left start-x)
		   (+ (with-translate-coordinate-stream bottom  parent)
		      start-y)
		   width height))

	;;; $@I=<(>uBV$N=$@5(J
    (if (and (eq (window-status window) :window)
	     (window-visible window))
	(yy-protocol-2 tno 1))
    )
  (redisplay-window window)
)

;;; $@%&%#%s%I%&%9%H%j!<%`$r:n$k(J
;;; $@$3$N4X?t$O!"A4$F$N%&%#%s%I%&$N9=@.MWAG$r$b$C$?>l9g$G$"$k!#(J
;;; $@;XDj$7$?%&%#%s%I%&$NBg$-$5$G!"3F9=@.MWAG$N7W;;$,$J$5$l$k(J
;;; $@MxMQ<T$,Dj5A$7$?%&%#%s%I%&%9%H%j!<%`$r@8@.$9$k>l9g$O!"(J
;;; initialize-instance$@$N(Jafter$@%a%=%C%I$r;XDj$9$k!#(J
;;; make-window-stream &rest rest &key (left 0) (bottom 0) width
;;;                    height (right 0) (top 0) (parent *root-window*)
;;;                    (title-font *default-font*) (title-string "")
;;;                    (border-belt 1) (visible T)
;;;                    (page-mode nil) (border-visible t) (title-bar-visible t)
;;;                    (vertical-scroll-visible T) (horizontal-scroll-visible t)
;;;                    (font *DEFAULT-FONT*) (coordinate :left-top) 
;;;                    (output-direction :horizontal) (coordinate-area-visible T)
;;; ARG.
;;;  rest                      = $@MxMQ<T$,%&%#%s%I%&$rDj5A$7$?;~$N=i4|2=0z?t$N%j%9%H(J
;;;  left                      = $@?F%&%#%s%I%&$+$i$N:8C<(J
;;;  bottom                    = $@?F%&%#%s%I%&$+$i$N(J0$@$K6a$$2<C<(J
;;;  width                     = $@I}(J
;;;  height                    = $@9b$5(J
;;;  right                     = $@?F%&%#%s%I%&$+$i$N1&C<(J
;;;  top                       = $@?F%&%#%s%I%&$+$i$N(J0$@$+$i1s$$>eC<(J
;;;  parent                    = $@?F%&%#%s%I%&(J
;;;  title-font               = $@%?%$%H%k$rI=<($9$k;~$N%U%)%s%H(J
;;;  title-string             = $@%?%$%H%k$NJ8;zNs(J
;;;  border-belt               = $@%\!<%@$NI}(J
;;;  visible                   = $@%&%#%s%I%&$rI=<($9$k$+H]$+(J(T->$@I=<((J)
;;;  page-mode                 = $@%&%#%s%I%&$N%b!<%I$N;XDj(J(T->$@%Z!<%8%b!<%I(J)
;;;  border-visible            = $@%&%#%s%I%&$N%\!<%@$rI=<($9$k$+H]$+(J(T->$@I=<((J)
;;;  title-bar-visible         = $@%?%$%H%k%P!<$rI=<($9$k$+H]$+(J(T->$@I=<((J)
;;;  vertical-scroll-visible   = $@=DJ}8~%9%/%m!<%k%P!<$rI=<($9$k$+H]$+(J(T->$@I=<((J)
;;;  horizontal-scroll-visible = $@2#J}8~%9%/%m!<%k%P!<$rI=<($9$k$+H]$+(J(T->$@I=<((J)
;;;  font                      = $@%&%#%s%I%&%9%H%j!<%`$N%F%-%9%HI=<($N%U%)%s%H(J
;;;  coordinate                = $@:BI87O$NA*Br(J(:left-top->$@:8>e6y(J :left-bottom->$@1&2<6y(J)
;;;  output-direction          = $@%F%-%9%H$NI=<(J}8~(J(:horizontal->$@2#(J :vertical->$@=D(J)
;;;  coordinate-area-visible   = $@:BI87OI=<(%(%j%"$rI=<($9$k$+H]$+(J(T->$@I=<((J)
(defun make-window-stream 
  (&key (left 0) (top 0) width height (bottom 0) (right 0)
	 (parent *ROOT-WINDOW*) (title-font *DEFAULT-FONT*) (title-string "")
	 (border-belt 1) (visible T) (page-mode nil) (border-visible t)
	 (title-bar-visible t) (vertical-scroll-visible T) 
	 (horizontal-scroll-visible t) (font *DEFAULT-FONT*) 
	 (coordinate :left-top)
	 (output-direction :horizontal) (coordinate-area-visible T))
	 
    (let ((region (make-region :left left :bottom bottom :top top :right right
			     :width width :height height)))
    
    ;;; $@%Z!<%8%b!<%I$+$I$&$+(J
    (if page-mode
	(apply #'make-instance 'page-window-stream
	       (list :window-region region
	       :window-frame 'window-frame
	       :title-bar 'title-bar
	       :horizontal-scroll-bar 'horizontal-scroll-bar
	       :translate-coordinate coordinate
	       :vertical-scroll-bar 'vertical-scroll-bar
	       :coordinate-area 'coordinate-area
	       :title-bar-font title-font
	       :parent-window parent
	       :title-bar-string title-string
	       :border-belt border-belt :visible visible
	       :window-icon 'icon
	       :border-visible border-visible
	       :horizontal-scroll-bar 'horizontal-scroll-bar
	       :title-bar-visible title-bar-visible
	       :vertical-scroll-bar 'vertical-scroll-bar
	       :vertical-scroll-visible vertical-scroll-visible
	       :horizontal-scroll-visible horizontal-scroll-visible
	       :font font
	       :line-feed (font-kanji-height font)
	       :coordinate-area 'coordinate-area
	       :coordinate coordinate :output-direction output-direction
	       :coordinate-area-visible coordinate-area-visible))

      (apply #'make-instance 'viewport-window-stream
     	       (list :window-region region
	       :window-frame 'window-frame
	       :title-bar 'title-bar
	       :horizontal-scroll-bar 'horizontal-scroll-bar
	       :vertical-scroll-bar 'vertical-scroll-bar
	       :coordinate-area 'coordinate-area
	       :translate-coordinate coordinate
	       :title-bar-font title-font
	       :parent-window parent
	       :title-bar-string title-string
	       :border-belt border-belt :visible visible
	       :window-icon 'icon
	       :border-visible border-visible
	       :title-bar-visible title-bar-visible
	       :vertical-scroll-visible vertical-scroll-visible
	       :horizontal-scroll-visible horizontal-scroll-visible
	       :font font
	       :line-feed (font-kanji-height font)
	       :coordinate-area 'coordinate-area
	       :coordinate coordinate :output-direction output-direction
	       :coordinate-area-visible coordinate-area-visible))

    )))


;;; $@%&%#%s%I%&%9%H%j!<%`$N%$%s%9%?%s%9$r:n$k(J
;;; $@$3$N4X?t$O!"MxMQ<T$,Dj5A$7$?%&%#%s%I%&!"%?%$%H%k%P!<!"%"%$%3%s(J
;;; $@%9%/%m!<%k%P!<!"%U%l!<%`!":BI87OI=<(%(%j%"$G(J
;;; $@%&%#%s%I%&%9%H%j!<%`$r@8@.$9$k!#(J
;;; $@3F9=@.MWAG$NL>A0$,;XDj$5$l$F$$$J$1$l$P!"%U%l!<%`$H%"%$%3%s(J
;;; $@=|$$$F@8@.$7$J$$!#(J
;;; $@3FItIJ$N%/%i%9$O!"3F!9$N%/%i%9$r7Q>5$7$FDj5A$7$J$1$l$P$J$i$J$$(J
;;; make-window-instance window-class-name &rest args &key
;;;        (left-margin nil) (right-margin nil) (top-margin nil)
;;;        (bottom-margin nil) (text-font *default-font*)
;;;        (line-feed (font-kanji-height *default-font*))
;;;        (output-direction :horizontal) (visible t)
;;;        (window-region (make-region :left 0 :bottom 0 :width 0 :height 0))
;;;        (parent-window *root-window*)
;;;        (border-belt 1) (border-visible t) (border-color *black-color*)
;;;        (title-bar 'title-bar) (title-font *default-font*) 
;;;        (title-bar-string "") (title-bar-visible T) 
;;;        (title-bar-color *black-color*)
;;;        (horizontal-scroll-bar 'horizontal-scroll-bar) 
;;;        (scroll-bar-color *black-color*)
;;;        (horizontal-scroll-visible T) 
;;;        (vertical-scroll-bar 'vertical-scroll-bar) 
;;;        (scroll-bar-color *black-color*)
;;;        (vertical-scroll-visible T) 
;;;        (coordinate-area 'coordinate-area)
;;;        (coordinate-area-color *black-color*)
;;;        (coordinate-area-visible T)
;;;        (window-icon nil)
;;;        (frame nil)
;;; ARG.
;;;   window-class-name        =  $@MxMQ<TDj5A$N%&%#%s%I%&$N%/%i%9L>(J
;;;   args                     =  $@MxMQ<T$,Dj5A$7$?;~$K8F$P$l$k%-!<%o!<%I0z?t(J
;;;   left-margin              =  $@:8%^!<%8%s!J%F%-%9%HMQ!K(J
;;;   right-margin             =  $@1&%^!<%8%s!J%F%-%9%HMQ!K(J
;;;   top-margin               =  $@>eC<%^!<%8%s!J%F%-%9%HMQ!K(J
;;;   bottom-margin            =  $@2<C<%^!<%8%s!J%F%-%9%HMQ!K(J
;;;   text-font                =  $@%U%)%s%H!J%9%H%j!<%`$K=q$+$l$k!K(J
;;;   line-feed                =  $@2~9TI}(J
;;;   visible                  =  $@%&%#%s%I%&$rI=<($9$k$+H]$+(J(T-> $@I=<((J)
;;;   output-direction         =  $@J8;zNs$N=PNOJ}8~(J
;;;                               :horizontal or :vertical
;;;   translate-coordinate     =  $@:BI87O(J :left-top or :left-bottom
;;;   window-region            =  $@%&%#%s%I%&$NBg$-$5$H0LCV(J      
;;;   parent-window            =  $@?F%&%#%s%I%&(J
;;;   border-belt              =  $@%\!<%@I}(J
;;;   border-visible           =  $@%\!<%@$rI=<($9$k$+H]$+(J(T-> $@I=<((J)
;;;   border-color             =  $@%\!<%@$N?'(J (NIL $@"M(J $@:n$i$J$$(J)
;;;   title-bar                =  $@MxMQ<T$,Dj5A$7$?%/%i%9L>(J
;;;                               $@%G%U%)%k%H$O%7%9%F%`Ds6!(J
;;;   title-font              =  $@%?%$%H%k%P!<$N%U%)%s%H(J
;;;   title-bar-string         =  $@%?%$%H%k%P!<$NJ8;zNs(J
;;;   title-bar-visible        =  $@%?%$%H%k%P!<$r8+$;$k$+H]$+(J(T->$@I=<((J)
;;;   title-bar-color          =  $@%?%$%H%k%P!<$N?'(J
;;;   horizontal-scroll-bar    =  $@MxMQ<T$,Dj5A$7$?%/%i%9L>(J
;;;                               $@%G%U%)%k%H$O%7%9%F%`Ds6!(J
;;;   scroll-bar-color         =  $@2#J}8~%9%/%m!<%k%P!<$N?'(J
;;;   horizontal-scroll-visible=  $@%9%/%m!<%k%P!<$r8+$;$k$+H]$+(J(T->$@I=<((J)
;;;   vertical-scroll-bar      =  $@MxMQ<T$,Dj5A$7$?%/%i%9L>(J
;;;                               $@%G%U%)%k%H$O%7%9%F%`Ds6!(J
;;;   scroll-bar-color         =  $@=DJ}8~$N%9%/%m!<%k%P!<$N?'(J
;;;   vertical-scroll-visible  =  $@%9%/%m!<%k%P!<$r8+$;$k$+H]$+(J(T->$@I=<((J)
;;;   coordinate-area           =  $@MxMQ<T$,Dj5A$7$?%/%i%9L>(J
;;;                               $@%G%U%)%k%H$O%7%9%F%`Ds6!(J
;;;   coordinate-area-color     =  $@:BI87OI=<(%(%j%"$N?'(J
;;;   coordinate-area-visible   =  $@:BI87OI=<(%(%j%"$r8+$;$k$+H]$+(J(T->$@I=<((J)
;;;   window-icon              =  $@%&%#%s%I%&$N%"%$%3%s(J
;;;   frame                    =  $@%&%#%s%I%&$N%U%l!<%`(J
(defun make-window-instance (window-class-name &rest args &key
	(left-margin nil) (right-margin nil) (top-margin nil)
        (bottom-margin nil) (text-font *default-font*)
        (line-feed (font-kanji-height *default-font*))
        (output-direction :horizontal)
	(translate-coordinate :left-top)
        (window-region (make-region :left 0 :bottom 0 :width 10 :height 10))
        (parent-window *root-window*)
        (border-belt 1) (border-visible t) (border-color *black-color*)
        (title-bar 'title-bar) (title-font *default-font*) 
        (title-bar-string "") (title-bar-visible T) 
        (title-bar-color *black-color*)
        (horizontal-scroll-bar 'horizontal-scroll-bar) 
        (scroll-bar-color *black-color*)
        (horizontal-scroll-visible T) 
	(visible T)
        (vertical-scroll-bar 'vertical-scroll-bar) 
        (vertical-scroll-visible T) 
        (coordinate-area 'coordinate-area)
        (coordinate-area-color *black-color*)
        (coordinate-area-visible T)
	(frame 'window-frame)
        (window-icon nil) &allow-other-keys)
  (declare (special *DEFAULT-FONT* *black-color* *root-window*))
  (apply #'make-instance window-class-name 
    (make-arg-list (list 
		 :left-margin left-margin 
		 :right-margin right-margin
		 :top-margin  top-margin 
		 :bottom-margin bottom-margin
		 :text-font text-font
		 :line-feed line-feed
		 :output-direction output-direction
		 :translate-coordinate translate-coordinate
		 :window-region window-region
		 :visible visible
		 :parent-window parent-window
		 :border-belt border-belt
		 :border-visible  border-visible 
		 :border-color  border-color 
		 :title-bar title-bar 
		 :title-font title-font
		 :title-bar-string title-bar-string
		 :title-bar-visible title-bar-visible
		 :title-bar-color  title-bar-color 
		 :horizontal-scroll-bar horizontal-scroll-bar
		 :scroll-bar-color  scroll-bar-color 
		 :horizontal-scroll-visible  horizontal-scroll-visible 
		 :vertical-scroll-bar  vertical-scroll-bar 
		 :scroll-bar-color scroll-bar-color 
		 :vertical-scroll-visible vertical-scroll-visible
		 :coordinate-area coordinate-area
		 :coordinate-area-color coordinate-area-color 
		 :coordinate-area-visible coordinate-area-visible 
		 :frame frame
		 :window-icon window-icon) args))
  )


;;; make-arg-list 
(defun make-arg-list (default-list arg-list)
  (let ((flg t)
	(ret  (do ((def default-list (cddr def)))
		  ((null def) default-list)
		(do ((arg arg-list (cddr arg)))
		    ((null arg))
		  (if (eq (car def) (car arg))
		      (return (setf (second def) (second arg)
				    arg (cddr arg))))
		  ))))
    (do ((arg arg-list (cddr arg)))
	((null arg) default-list)
      (setf flg t)
      (do ((def ret (cddr def)))
	  ((null def))
	(if (eq (car def) (car arg))
	    (return (setf flg nil
			  ret (cddr ret)))))

      (if flg 
	  (progn 
	    (push (car arg) (cdr (last default-list)))
	    (push (second arg) (cdr (last default-list)))))
      )))

