;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; ƥӷ˥᡼μ¸
;;; This file is EUC code.
;;; tv-window.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;	      All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.3 91/11/19 by t.kosaka
;;;

;;;  ʲΥ᥽åɤؿ饹ϡɥΩ夬äƤ

(in-package :yy)

(defvar *bitmaps-directory-pathname*
	#+symbolics
  "local:>yy>bitmaps>"
  #-symbolics
  "/home/kosaka/bitmaps/"
  "Bitmaps directory name
Type must use string, don't use pathname")


;;; ƥʤκɽ
(defmethod redispay-tv-parts ((ob tv-parts))
  (let ((width (region-width 
				(window-region (parts-stream ob)))))
	(with-real-object
	 (ob)
	 (setf (region-left ob) (- width (window-from-right ob)
							   (region-width ob)))
	 )
	))

;;; ͥɽ
(defmethod display-chanel ((ob display-chanel) chanel)
  (draw-piece-put-image ob 0 0 (nth (- chanel 1)
									(chanel-image-list ob))))

;;; ͥɽä
(defmethod black-chanel ((ob display-chanel))
  (declare (special *black-color*))
  (draw-piece-color ob *black-color*))

;;; ͥɽ
(defun make-display-chanel (window-stream form-right)
  (with-region-slots 
   (width height) (window-region window-stream)
   (let* ((image-width 24)
		  (image-height 32)
		  (ins (make-instance 'display-chanel
							 :left (- width form-right image-width)
							 :bottom (- height image-height 10)
							 :width image-width
							 :height image-height
							 :window-form-right form-right
							 :draw-piece-visible T
							 :object-parent window-stream
							 :parts-stream window-stream)))
	 ;;; ϡ
	 (black-chanel ins)
	 
	 ;;; ᡼եɤ
	 (with-slots 
	  (chanel-image-list) ins
	  (push (load-yy-bitmap "c4-yy") chanel-image-list)
	  (push (load-yy-bitmap "c3-yy") chanel-image-list)
	  (push (load-yy-bitmap "c2-yy") chanel-image-list)
	  (push (load-yy-bitmap "c1-yy") chanel-image-list))
	 ins)))

;;; ƥӥå
(defun make-tv-switch (class-name window-stream 
								  push-button-image normal-button-image
								  form-right)
  (with-region-slots 
   (width height) (window-region window-stream)
   (let* ((image-width (image-width push-button-image))
		  (image-height (image-height push-button-image))
		  (ins (make-instance class-name
							 :left (- width form-right image-width)
							 :bottom (- height image-height 10)
							 :width image-width
							 :height image-height
							 :window-form-right form-right
							 :draw-piece-visible T
							 :object-parent window-stream
							 :parts-stream window-stream
							 :push-button-image push-button-image
							 :normal-button-image normal-button-image)))
	 (draw-piece-put-image ins 0 0 normal-button-image)
	 (with-event-object 
	  (ins)
	  (setf (button1-method ins) 'tv-switch-push
			(get 'tv-switch-push 'single-process) t
			(button-up-method ins) `tv-switch-relase
			(get `tv-switch-relase 'single-process) t
			(slot-value ins 'event-mask)
			(logior *mouse-button-down-1* *mouse-button-up*))
	  
	  ins))))

;;; ƥӥåΥܥ᥽å
;;; 
(defmethod tv-switch-push ((ob tv-switch) event)
  (declare (ignore event)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (push-button-image) ob
   (draw-piece-put-image ob 0 0 push-button-image)
   (tv-switch-exec ob)))

;;; ƥӥåΥܥ᥽å
;;; ꡼
(defmethod tv-switch-relase ((ob tv-switch) event)
  (declare (ignore event)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (normal-button-image) ob
   (draw-piece-put-image ob 0 0 normal-button-image)))

;;; ƥӥåON/OFF
(defmethod tv-switch-exec ((ob tv-on-off-switch))
  (with-slots
   (tv-status parts-stream) ob
   (if (eq tv-status :on)
	   (progn (setf tv-status :off
					(tv-on-off parts-stream) :off)
			  (stop-tv-program parts-stream))
	 (progn 
	   (setf tv-status :on
			 (tv-on-off parts-stream) :on)
	   (start-tv-program parts-stream))
	 )))
  
;;; ƥӥͥѹ
(defmethod tv-switch-exec ((ob chanel-switch))
  (with-slots 
   (chanel-display function parts-stream) ob
   (when (eq (tv-on-off parts-stream) :on)
		 (change-tv-chanel parts-stream function)
		 (display-chanel chanel-display 
						 (current-chanel parts-stream)))))


#|
;;; ƥӤ®٤򤢤
;;;
;;; ź䤵󤬺꤫ǽФƤޤäΤ
;;; ĤäѶϫޤȤ...
;;;
(defmethod tv-switch-exec ((ob speed-up-switch))
  (with-slots 
   (chanel-display function parts-stream) ob
   (when (eq (tv-on-off parts-stream) :on)
|#

;;; ƥӥɥ
(defun make-tv-window ()
  (let* ((region (get-box-region (make-region :left 0 :bottom 0
											  :width 236
											  :height 266)))
		 (window (make-window-instance 
				  'tv-window
				  :window-region region
				  :title-bar 'switch-title-bar
				  :title-bar-string "˥᡼ ƥ"
				  :frame-keyword '(:small-size-top 70)
				  :vertical-scroll-bar nil
				  :horizontal-scroll-bar nil
				  :coordinate-area nil
				  :window-frame 'lisp-listener-frame)))
	(with-slots 
	 (tv-program-list) window
	 (push (make-animation-window "tanaka-"
									  3 
									   (make-region :width 216 
													:height 163)
									   214 161 :scroll nil
									   :parent window) tv-program-list)
	 (deactivate (car tv-program-list))

	 (push (make-animation-window "kosaka-"
									   8 
									   (make-region :width 216 
													:height 163)
									   214 161 :scroll nil
									   :parent window) tv-program-list)
	 (deactivate (car tv-program-list))

	 (push (make-animation-window "aoyama-"
								   18 
								  (make-region :width 216 
											   :height 163)
									   214 161 :scroll nil
									   :parent window) tv-program-list)
	 (deactivate (car tv-program-list))

	 (push (make-animation-window "ootha-"
									   5
									   (make-region :width 216 
													:height 163)
									   214 161 :scroll nil
									   :parent window) tv-program-list)
	 (deactivate (car tv-program-list))

	 window)))


;;; ƥӥɥκɽ
;;; ܥ󥪥֥Ȥ
(defmethod redisplay-window  ((window tv-window))
  (declare (special *black-color* *white-color*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))

  (default-redisplay-window window)

  (with-slots 
   (tv-chanel-switch-list tv-chanel-display) window
   (if (null tv-chanel-switch-list)
	   ;;; ͥ䥹å
	   (let ((chanel-d
				(make-display-chanel window 130)))
		 (push (make-tv-switch
				'tv-on-off-switch window
				(load-yy-bitmap "on-b-yy")
				(load-yy-bitmap "on-a-yy")
				10) tv-chanel-switch-list)

		 (push (make-tv-switch 
				'chanel-down-switch window
				(load-yy-bitmap "sita-b-yy")
				(load-yy-bitmap "sita-a-yy")
				50) tv-chanel-switch-list)

		 (setf (chanel-display (car tv-chanel-switch-list))
								chanel-d)
		 (push (make-tv-switch 
				'chanel-up-switch window
				(load-yy-bitmap "ue-b-yy")
				(load-yy-bitmap "ue-a-yy")
				90) tv-chanel-switch-list)

		 ;;; ..ź䤵ϤǽƤޤäΤ..
		 ;;; ɤʤƤͤ!!
#|
		 (push (make-tv-switch 
				'speed-up-switch window
				(load-yy-bitmap "kousoku-yy.lisp")
				(load-yy-bitmap "kousoku-a-yy.lisp")
				140) tv-chanel-switch-list)
|#

		 (setf (chanel-display (car tv-chanel-switch-list))
							   chanel-d)
		 (setf tv-chanel-display  chanel-d))
	 ;;; ɽ
	 (progn
        ;;; åκɽ
	   (dolist (switch tv-chanel-switch-list)
				(redispay-tv-parts switch))
	   ;;; ͥκɽ
	   (redispay-tv-parts tv-chanel-display)))
   ))


;;;ƥӥץμ¹
(defmethod start-tv-program ((ob tv-window))
  (with-slots 
   (current-chanel tv-program-list tv-chanel-display) ob
   ;;; ͥɽ
   (display-chanel tv-chanel-display current-chanel)
   ;;; ɽ
   (activate (nth (- current-chanel 1) tv-program-list))
   ;;; ˥᡼γ
   (run-animation (animation-frame (nth (- current-chanel 1)
										tv-program-list))
				  :speed 13))
  )

;;; ƥӥץ
(defmethod stop-tv-program ((ob tv-window))
  (with-slots
   (current-chanel tv-program-list tv-chanel-display) ob
   ;;; ˥᡼
   (stop-animation (animation-frame (nth (- current-chanel 1)
                                        tv-program-list)))
   ;;; ƥӥץɽƤ륦ɥä
   (deactivate (nth (- current-chanel 1) tv-program-list))
   ;;; ͥɽä
   (black-chanel tv-chanel-display)))

;;; ƥӤΥͥѹ
;;; functionϡ#'1+ #'1-ꤹ
(defmethod change-tv-chanel ((ob tv-window) function)
  (with-slots
   (current-chanel tv-program-list) ob
   ;;; ߼¹ԤƤƥӥץߤȾõ
   (stop-animation (animation-frame (nth (- current-chanel 1)
                                        tv-program-list)))
   (deactivate (nth (- current-chanel 1) tv-program-list))
   ;;; ͥѹ
   (setf current-chanel 
		 (tv-chanel-change current-chanel function tv-program-list))
   ;;; ɽȼ¹
   (activate (nth (- current-chanel 1) tv-program-list))
   (run-animation (animation-frame (nth (- current-chanel 1)
                                        tv-program-list))
                  :speed 13)
   ))

;;; ƥӥͥѹ
(defun tv-chanel-change (current-chanel func tv-program-list)
  (let ((max-program (length tv-program-list))
		(new-chanel (funcall func current-chanel)))
	(if (> new-chanel max-program)
		1
	  (if (< new-chanel 1)
		  max-program
		new-chanel))))

;;; End of file
;;; Local variables:
;;; eval: (set-kanji-fileio-code 'EUC)
;;; end:
