;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; $@%F%l%S7?%"%K%a!<%7%g%s$N<B83(J
;;; This file is EUC code.
;;; tv-window.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;	      All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.3 91/11/19 by t.kosaka
;;;

;;;  $@0J2<$N%a%=%C%I$d4X?t!"%/%i%9$O!"%&%#%s%I%&$,N)$A>e$,$C$F$+$i%m!<%I(J

(in-package :yy)

(eval-when (compile load)

;;; $@%F%l%S$N%9%$%C%A4X78$NItIJ(J
(defclass tv-parts ()
  ((window-form-right :initform 40 :initarg :window-form-left
					 :accessor window-from-right)
   (parts-stream :initarg :parts-stream :initform nil
				 :accessor parts-stream)))

;;; $@%F%l%S$N%9%$%C%A(J
(defclass tv-switch (event-drawable-piece tv-parts)
  ((push-button-image :initform nil :initarg :push-button-image
					  :accessor push-button-image)
   (normal-button-image :initform nil :initarg :normal-button-image
						:accessor normal-button-image)))

;;; $@%F%l%S$N%A%c%s%M%k%9%$%C%A(J
(defclass chanel-switch (tv-switch)
  ((chanel-display :initform nil :initarg chanel-display
				   :accessor chanel-display)))

;;; $@%F%l%S$N%A%c%s%M%k$r$"$2$k%9%$%C%A(J
(defclass chanel-up-switch (chanel-switch)
  ((function :initform #'1+ )))

;;; $@%F%l%S$N%A%c%s%M%k$r$5$2$k%9%$%C%A(J
(defclass chanel-down-switch (chanel-switch)
  ((function :initform #'1-)))

;;; $@%F%l%S$N(JON/OFF$@%9%$%C%A(J
(defclass tv-on-off-switch (tv-switch)
  ;;; $@$3$N%9%$%C%A$O!"%H%0%k$G$"$k!#(J
  ((tv-status :initform :off :accessor tv-status)))

;;; $@%F%l%S$NB.EY$r$"$2$k(J
(defclass speed-up-switch (tv-switch)
  ())
  
;;; $@%A%c%s%M%kI=<(%/%i%9(J
(defclass display-chanel (piece-region tv-parts)
  ((chanel-image-list :initform nil :accessor chanel-image-list)))
)

(eval-when (compile load)
;;; $@%F%l%S7?%&%#%s%I%&$NDj5A(J
(defclass tv-window (lisp-listener)
  ((current-chanel :initform 1 :accessor current-chanel)
   (tv-program-list :initform nil :accessor tv-program-list)
   (tv-chanel-switch-list :initform nil :accessor tv-chanel-switch-list)
   (tv-chanel-display :initarg :tv-chanel-display :initform nil
					  :accessor tv-chanel-display)
   (tv-on-off :initform :off :accessor tv-on-off)
   ))

;;; $@%F%l%S7?%&%#%s%I%&$N%U%l!<%`$NDj5A(J
(defclass tv-frame (lisp-listener-frame)
  ())
)
