;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; text-font.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka

;;
;; YY$@%&%#%s%I%&%7%9%F%`$N%U%)%s%H4XO"$rDj5A$9$k!#(J
;;               1990.2.20  $@8E:d(J
;;; Version 1.0   Coded by t.kosaka 1990-2-20
;;; Chnage LOG    string-display-region-yoko is for LT LB coodinate 1990-8-24
;;;               string-display-region-tata is for LT LB coodinate 1990-8-24
;;;               Add ICS for string-display-region****
;;;		  font-string-length is added Symbolics code

(in-package :yy)


;;; Font$@$N(Jinternal$@@8@.4X?t(J
(defun make-internal-font (&key kanji-width kanji-height kanji-base-line)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((font (make-instance 'text-font :kanji-width kanji-width
                             :kanji-height kanji-height
                             :kanji-base-line kanji-base-line))
	(ascii-font (make-array 256 :element-type t)))

    (dotimes (i 256)
      (setf (elt ascii-font i)  (make-instance 'font-character)))

    (setf (slot-value font 'ascii-font) ascii-font)

    font))

;;; $@%U%)%s%H$N%m!<%I4X?t(J
(defun load-font (&key (font-name ""))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if (zerop (length font-name))
      (error "The argument ~a is not correct." font-name)
    (let ((font (make-internal-font)))
      ;;; $@%W%m%H%3%k$r8F$S=P$9(J
      (if (yy-protocol-10 font-name font) 
	  font
	(error "Sorry, Can not load ~a font" font-name)))))

;;; Font character $@$N%;%C%H4X?t(J
(defmethod set-font-char ((font text-font) (char character) 
		  (width integer) (height integer) 
			  (base-line integer))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((font-char (aref (slot-value font 'ascii-font) (char-code char))))
    (setf (slot-value font-char 'character-width) width
	  (slot-value font-char 'character-height) height
	  (slot-value font-char 'character-base-line) base-line)))


;;; Font $@$NI=<(4X?t(J
(defmethod print-object ((font text-font) stream)
  (format stream "\<#Fontname ~a >" (slot-value font 'font-name)))

;;; $@%F%-%9%H%U%)%s%H$N%"%/%;%C%9%a%=%C%I(J font-name
(defmethod font-name ((font text-font))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (slot-value font 'font-name))

;;; $@%F%-%9%H%U%)%s%H%-%c%i%/%?$N%"%/%;%9%a%=%C%I(J character-width
(defmethod character-width ((font text-font) (charcter character))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (slot-value (aref (slot-value font 'ascii-font) (char-code charcter)) 
	      'character-width))

;;; $@%F%-%9%H%U%)%s%H%-%c%i%/%?$N%"%/%;%9%a%=%C%I(J character-height
(defmethod character-height ((font text-font) (charcter character))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (slot-value (aref (slot-value font 'ascii-font) (char-code charcter)) 
	      'character-height))

;;; $@%F%-%9%H%U%)%s%H%-%c%i%/%?$N%"%/%;%9%a%=%C%I(J character-base-line
(defmethod character-base-line ((font text-font) (charcter character))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (slot-value (aref (slot-value font 'ascii-font) (char-code charcter)) 
	      'character-base-line))


;;;$@0u;z>e$NJ8;zNs$ND9$5$r5a$a$k%a%=%C%I(J
#+(not ICS)
(defmethod font-string-length  ((font text-font) (string string))
  ;;; $@$3$N%a%=%C%I$O!"(Jinternational character set$@$K$J$C$F$$$J$$(J
  ;;; LISP$@$G!"2TF/$9$k(J
  (declare 
   #-CMU
   (inline length >= + /)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((t-length 0) )
    (dotimes (i (length string))
	(if (>= (char-code (char string i)) #xA1)
	    ;;; $@4A;z$N>l9g(J
	    (setf t-length (+ t-length (round 
     			      (/ (font-kanji-width font) 2))))
            ;;; $@1Q;z$N>l9g(J
	    (setf t-length (+ t-length
			      (character-width font (char string i))))))
    t-length))

#+ICS
(defmethod font-string-length  ((font text-font) (string string))
  (declare 
   #-CMU
   (inline >= +)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
    (let ((t-length 0) )
    (dotimes (i (length string))
	(if (>= (char-code (char string i)) #xA1)
	    ;;; $@4A;z$N>l9g(J
	    (setf t-length (+ t-length (font-kanji-width font)))
            ;;; $@1Q;z$N>l9g(J
	    (setf t-length (+ t-length
			      (character-width font (char string i))))))
    t-length))

;;; $@%j!<%8%g%s$K(Joffet$@$r2C$($k!#(J
(defun add-offset-region (region hor ver)
  (with-region-slots
   (left bottom right top) region
   (setf left (- left hor)
		 bottom (- bottom ver)
		 right (+ right hor)
		 top (+ top (round (/ ver 2))))
   ))


;;;$@0u;z>e$NJ8;zNs$NBg$-$5$r5a$a$k$+$s$9$&(J $@2#=q$-MQ(J
;;;$@;XDj$5$l$?0LCV$+$i=q$-;O$a$?;~$N(Jregion$@$r5a$a$k(J
;;;$@2~9TJ8;z(J#\Newline$@$d(J#\Return$@$,$"$l$P9MN8$9$k(J
;;;$@2~9T$^$G$NJ8;zNs%j%9%H$b!"$b$H$a$k(J
;;; $@La$jCM$O!"(J
;;; (region end-x end-y (start-x start-y "$@J8;zNs(J1" end-x end-y)
;;;                     (start-x start-y "$@J8;zNs(J2" end-x end-y))
(defun string-display-region-yoko (region stream string x y)
  (declare  (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (left-margin) stream
   (if (null left-margin) ;; $@%^!<%8%s$H%H%i%s%1%$%H$r=hM}$7$J$$(J
	   (string-display-region-yoko-internal-no region stream string x y)
	 ;; $@%^!<%8%s$H%H%i%s%1%$%H$r=hM}$9$k(J
	 (string-display-region-yoko-internal region stream string x y))))

;;; $@$"$k0LCV$N%U%)%s%H$NCf1{$rJV$9!JI}!K(J
(defun font-half-width (x font)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (round (+ x (/ (font-kanji-width font) 2))))

;;; $@$"$k0LCV$N%U%)%s%H$NCf1{$*JV$9!J9b$5!K(J
;;; Y$@$O%Y!<%9%i%$%s$K$"$k$b$N$H$9$k(J
(defun font-half-height (y font)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
	(- (+ y (- (font-kanji-height font)
               (font-kanji-base-line font)))
       (round (/ (font-kanji-height font) 2))))

;;; $@2~9T;~$KNN0h$N@_Dj$r9T$J$&(J
(defun line-feed-op (start-x start-y end-x end-y stream region)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-translate-transform-xy
   ((nx ny) stream start-x start-y)
   (with-translate-transform-xy
	((nnx nny) stream end-x end-y)

	;; $@:GBg:G>.$NNN0h@_Dj(J
	(with-region-slots
	 (left bottom top right) region
	 (setf left (min left nx nnx)
		   bottom (min bottom ny nny)
		   top (max top ny nny)
		   right (max right nx nnx)))
	(values nx ny nnx nny))))

;;; $@%^!<%8%s$H%H%i%s%1%$%H=hM}$r$7$J$$(J
;;; $@La$jCM$O!"(J
;;; (region end-x end-y (start-x start-y "$@J8;zNs(J1" end-x end-y)
;;;                     (start-x start-y "$@J8;zNs(J2" end-x end-y))
(defun string-display-region-yoko-internal-no  (region stream string x y)
  (declare 
   #-CMU
   (inline + max min >= incf -)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (font line-feed) stream

   (let* ((nowx x) (nowy y) (endx x) (endy y)
		  (moji-list (coerce string 'list))
		  (xy-list nil) (ch #\a) (start 0) (end 0)
		  (font-width (font-kanji-width font)))

	 ;; $@IA2h%j!<%8%g%s$N=i4|@_Dj(J
	 (with-region-slots
	  (left bottom top right) region
	  (setf left MOST-POSITIVE-FIXNUM bottom MOST-POSITIVE-FIXNUM
			right most-negative-fixnum top most-negative-fixnum))

	 ;; $@J8;zNs$ND9$5$^$G7+$jJV$9(J
	 (do 
	  ((moji moji-list (cdr moji)))
	  ((null moji))
			 
	  ;; $@0lJ8;z%+%&%s%H%"%C%W(J
	  (incf end)

	  ;;  $@0lJ8;z<h$j=P$9(J
	  (setf ch (take-out-car-moji moji))

	  (cond
	   ((>= (char-code ch) #xA1) ;; $@4A;z$N>l9g(J
		(incf endx font-width)
		
#+(not ICS)
		(setf moji (cdr moji))
		
		(incf end))

	   ((or (= (char-code ch) 10) ;; $@2~9TJ8;z(J
			(= (char-code ch) 13))
		(multiple-value-bind
		 (sx sy ex ey)
		 (line-feed-op nowx nowy endx endy stream region)
		 (push 
		  (list sx sy
				(subseq string start (- end 1))
				 ex ey) xy-list))

		(setf nowx 0  nowy (+ nowy line-feed)
			  endx nowx endy nowy
			  start end
			  end start)
		)
		
	   (t ;;; $@1Q;z$N>l9g(J
		(incf endx (character-width font ch)))
	   )
	  )
	 (unless 
	  (or (= (char-code ch) 10)
		  (= (char-code ch) 13))
	  ;; $@=*N;$,2~9TJ8;z$G$J$$(J
	  (multiple-value-bind
	   (sx sy ex ey)
	   (line-feed-op nowx nowy endx endy stream region)
	   (push 
		(list sx sy
			  (subseq string start end)
			  ex ey) xy-list))
	  )
	 ;;; $@5a$^$C$?%j!<%8%g%s$r3HBg$9$k(J
	 (add-offset-region region 2 (font-kanji-height font))
	 (push endy xy-list)
	 (push endx xy-list)
	 (push region xy-list)
	)
  ))

;;; $@%^!<%8%s=hM}$H%H%i%s%1%$%H=hM}$r$9$k(J
;;; $@La$jCM$O!"(J
;;; (region end-x end-y (start-x start-y "$@J8;zNs(J1" end-x end-y)
;;;                     (start-x start-y "$@J8;zNs(J2" end-x end-y))
;;; $@2sE>9TNs$,$+$1$i$l$F$$$k>l9g$O!"%^!<%8%s$KBP$7$F$b(J
;;; $@2sE>9TNs$,$+$+$i$l$k!#(J
(defun string-display-region-yoko-internal (region stream string x y)
  (declare 
   #-CMU
   (inline >= max min + -)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots
   ((left-m left-margin) 
	(right-m right-margin) font line-feed truncate-width) stream
   (let* ((moji-list (coerce string 'list))
		  (nowx x) (nowy y) (endx x) (endy y)
		  (xy-list nil) (start 0) (end 0)
		  (font-width (font-kanji-width font))
		  (truncate-flg nil)
		  (ch #\a))

	 ;; $@IA2h%j!<%8%g%s$N=i4|@_Dj(J
	 (with-region-slots
	  (left bottom top right) region
	  (setf left MOST-POSITIVE-FIXNUM bottom MOST-POSITIVE-FIXNUM
			right most-negative-fixnum top most-negative-fixnum))
	
     ;;; $@J8;z$r7W;;(J
	 (do ((char-list moji-list (cdr char-list)))
		 ((null char-list))

		 ;; $@0lJ8;z%+%&%s%H%"%C%W(J
		 (incf end)
		 ;;  $@0lJ8;z<h$j=P$9(J
		 (setf ch (take-out-car-moji char-list))

		;; $@%H%i%s%1%$%H=hM}(J
		(if (and truncate-flg (/= 10 (char-code ch))
				 (/= 13 (char-code ch)))
			(incf start)
		  (setf truncate-flg nil))

		(cond 		;; $@J8;z$NH=CG(J
		 ((>= (char-code ch) #xA1) 		 ;; $@4A;z$N>l9g(J
		  (incf endx font-width)
		  (when (>= endx right-m)  ;; $@%^!<%8%s$r1[$($?(J
				(decf endx font-width)
				(if (null truncate-width)
					(progn
					  (multiple-value-bind
					   (sx sy ex ey)
					   (line-feed-op nowx nowy endx endy stream region)
					   (push 
						(list sx sy
							  (subseq string start (- end 1))
							  ex ey) xy-list))
					  (push ch char-list)
					  (setf nowx left-m  nowy (+ nowy line-feed) endx nowx 
							endy nowy start (- end 1) end start))
				  (setf truncate-flg T)))

 #+(not ICS)
  		    (setf char-list (cdr char-list)
				  end (1+ end))
			)
		 ((or (= (char-code ch) 10)  ;;; $@2~9T=hM}(J
			   (= (char-code ch) 13))
		  (multiple-value-bind
		   (sx sy ex ey)
		   (line-feed-op nowx nowy endx endy stream region)
		   (push 
			(list sx sy
				  (subseq string start (- end 1))
				  ex ey) xy-list))

		  (setf nowx left-m nowy (+ nowy line-feed)	endx nowx endy nowy
				start end end start)
		  )
		 (t ;; $@1Q;z$N>l9g(J
		  (incf endx (character-width font ch))
 		  (when (>= endx right-m)                ;; $@%^!<%8%s$r1[$($?(J
				(decf endx (character-width font ch))
				(if (null truncate-width)
					(progn 
					  (multiple-value-bind
					   (sx sy ex ey)
					   (line-feed-op nowx nowy endx endy stream region)
					   (push 
						(list sx sy
							  (subseq string start (- end 1))
							  ex ey) xy-list))
					  (push ch char-list)
					  (setf nowx left-m  nowy (+ nowy line-feed) endx nowx 
							endy nowy start (- end 1) end start)
					  )
				  (setf truncate-flg T))
				))
		 )
		)
	(unless 
	 (or (= (char-code ch) 10)
		 (= (char-code ch) 13))
	 ;; $@=*N;$,2~9TJ8;z$G$J$$(J
	  (multiple-value-bind
	   (sx sy ex ey)
	   (line-feed-op nowx nowy endx endy stream region)
	   (push 
		(list sx sy
			  (subseq string start end)
			  ex ey) xy-list))
	  )
	 ;;; $@5a$^$C$?%j!<%8%g%s$r3HBg$9$k(J
	 (add-offset-region region 2 (font-kanji-height font))
	 (push endy xy-list)
	 (push endx xy-list)
	 (push region xy-list)
	)
  ))


;;; $@=D=q$-;~$N2~9T=hM}$r$9$k(J
;;; $@=D=q$-=hM}$N>l9g$O!"2sE>9TNs$rL5;k$9$k!#(J
(defun line-feed-op-tate (start-x start-y end-x end-y region)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
	;; $@:GBg:G>.$NNN0h@_Dj(J
  (with-region-slots
   (left bottom top right) region
   (setf left (min left start-x end-x)
		 bottom (min bottom start-y end-y)
		 top (max top start-y end-y)
		 right (max right start-x end-x)))
  (values start-x start-y end-x end-y))


;;;$@0u;z>e$NJ8;zNs$NBg$-$5$r5a$a$k4X?t(J  $@2#=q$-MQ(J
;;;$@;XDj$5$l$?0LCV$+$i=q$-;O$a$?;~$N(Jregion$@$r5a$a$k(J
;;;$@2~9TJ8;z(J#\Newline$@$d(J#\Return$@$,$"$l$P9MN8$9$k(J
;;;$@2~9T$^$G$NJ8;zNs%j%9%H$b!"$b$H$a$k(J
;;; x,y$@$O!":BI8JQ49$r9T$J$C$?CM$r@_Dj$9$k!#(J
(defun string-display-region-tate (region stream string x y)
  (declare  (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (top-margin) stream
   (if (null top-margin) ;; $@%^!<%8%s$H%H%i%s%1%$%H$r=hM}$7$J$$(J
	   (string-display-region-tate-internal-no region stream string x y)
	 ;; $@%^!<%8%s$H%H%i%s%1%$%H$r=hM}$9$k(J
	 (string-display-region-internal-tate region stream string x y))))


;;; $@0u;z>e$NJ8;zNs$NBg$-$5$r5a$a$k4X?t$O=D=q$-MQ(J
;;; $@%^!<%8%s=hM}$H%H%i%s%1%$%H=hM}$r$7$J$$(J
;;; $@La$jCM$O!"(J
;;; (region end-x end-y (start-x start-y "$@J8;zNs(J1" end-x end-y)
;;;                     (start-x start-y "$@J8;zNs(J2" end-x end-y))
;;; $@=D=q$-J8;zNs$N>l9g$O!"2sE>9TNs$r$+$1$J$$!#(J
(defun string-display-region-tate-internal-no (region stream string x y)
  (declare 
   #-CMU
   (inline + max min >= incf -)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (font line-feed) stream
   (let*((nowx x) (nowy (with-translate-coordinate-stream y stream))
		 (endx x) (endy nowy)
		 (moji-list (coerce string 'list))
		 (xy-list nil) (ch #\a)	(start 0) (end 0)
		 (font-height (font-kanji-height font)))

	 ;; $@IA2h%j!<%8%g%s$N=i4|@_Dj(J
	 (with-region-slots
	  (left bottom top right) region
	  (setf left MOST-POSITIVE-FIXNUM bottom MOST-POSITIVE-FIXNUM
			right most-negative-fixnum top most-negative-fixnum))

	 ;; $@J8;zNs$ND9$5$^$G7+$jJV$9(J
	 (do 
	  ((moji moji-list (cdr moji)))
	  ((null moji))
			 
	  ;; $@0lJ8;z%+%&%s%H%"%C%W(J
	  (incf end)

	  ;;  $@0lJ8;z<h$j=P$9(J
	  (setf ch (take-out-car-moji moji))

	  (cond
	   ((>= (char-code ch) #xA1) ;; $@4A;z$N>l9g(J
		(incf endy font-height)
#+(not ICS)
		(setf moji (cdr moji))
		(incf end))
	   ((or (= (char-code ch) 10) ;; $@2~9TJ8;z(J
			(= (char-code ch) 13))
		(multiple-value-bind
		 (sx sy ex ey)
		 (line-feed-op-tate nowx nowy endx endy  region)
		 (push 
		  (list sx sy
				(subseq string start (- end 1))
				 ex ey) xy-list))

		(setf nowx (- nowx line-feed)  nowy 0
			  endx nowx endy nowy start end  end start)
		)
		
	   (t ;;; $@1Q;z$N>l9g(J
		(incf endy (character-width font ch)))
	   )
	  )
	 (unless 
	  (or (= (char-code ch) 10)
		  (= (char-code ch) 13))
	  ;; $@=*N;$,2~9TJ8;z$G$J$$(J
	  (multiple-value-bind
	   (sx sy ex ey)
	   (line-feed-op-tate nowx nowy endx endy region)
	   (push 
		(list sx sy
			  (subseq string start end)
			  ex ey) xy-list))
	  )
	 ;;; $@5a$^$C$?%j!<%8%g%s$r3HBg$9$k(J
	 (add-offset-region region (font-kanji-width font) font-height)
	 (push endy xy-list)
	 (push endx xy-list)
	 (push region xy-list)
	)
  ))

;;;
;;;$@;XDj$5$l$?0LCV$+$i=q$-;O$a$?;~$N(Jregion$@$r5a$a$k(J
;;;$@2~9TJ8;z(J#\Newline$@$d(J#\Return$@$,$"$l$P9MN8$9$k(J
;;;$@2~9T;~$N2sE>9TNs$O!"9MN8$9$k!#(J
;;; $@La$jCM$O!"(J
;;; (region end-x end-y (start-x start-y "$@J8;zNs(J1" end-x end-y)
;;;                     (start-x start-y "$@J8;zNs(J2" end-x end-y))
;;; $@=D=q$-J8;zNs$N>l9g$O!"2sE>9TNs$r$+$1$J$$!#(J
(defun string-display-region-internal-tate (region stream string x y)
  (declare 
   #-CMU
   (inline max min + - <= >=)
   (ignore coodinate)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots
   (font line-feed  (top-m top-margin) 
		 (bottom-m bottom-margin) truncate-height) stream
   (let*((nowx x) (nowy (with-translate-coordinate-stream y stream))
		 (endx x) (endy nowy)
		 (moji-list (coerce string 'list))
		 (xy-list nil) (ch #\a)	(start 0) (end 0)
		 (truncate-flg nil)
		 (font-height (font-kanji-height font)))

	 ;; $@IA2h%j!<%8%g%s$N=i4|@_Dj(J
	 (with-region-slots
	  (left bottom top right) region
	  (setf left MOST-POSITIVE-FIXNUM bottom MOST-POSITIVE-FIXNUM
			right most-negative-fixnum top most-negative-fixnum))

	 ;; $@J8;zNs$ND9$5$^$G7+$jJV$9(J
	 (do ((char-list moji-list (cdr char-list)))
		 ((null char-list))

		 ;; $@0lJ8;z%+%&%s%H%"%C%W(J
		 (incf end)
		 ;;  $@0lJ8;z<h$j=P$9(J
		 (setf ch (take-out-car-moji char-list))

		;; $@%H%i%s%1%$%H=hM}(J
		(if (and truncate-flg (/= 10 (char-code ch))
				 (/= 13 (char-code ch)))
			(incf start)
		  (setf truncate-flg nil))

		(cond 		;; $@J8;z$NH=CG(J
		 ((>= (char-code ch) #xA1) 		 ;; $@4A;z$N>l9g(J
		  (incf endy font-height)
		  (when (>= endy top-m)  ;; $@%^!<%8%s$r1[$($?(J
				(decf endy font-height)
				(if (null truncate-height)
					(progn
					  (multiple-value-bind
					   (sx sy ex ey)
					   (line-feed-op-tate nowx nowy endx endy region)
					   (push 
						(list sx sy
							  (subseq string start (- end 1))
							  ex ey) xy-list))
					  (push ch char-list)
					  (setf nowx (- nowx line-feed)	nowy bottom-m 
							endx nowx endy nowy start (- end 1) end start))
				  (setf truncate-flg T)))

#+(not ICS)
  		    (setf char-list (cdr char-list)
				  end (1+ end))
			)
		 ((or (= (char-code ch) 10)  ;;; $@2~9T=hM}(J
			   (= (char-code ch) 13))
		  (multiple-value-bind
		   (sx sy ex ey)
		   (line-feed-op-tate nowx nowy endx endy region)
		   (push 
			(list sx sy
				  (subseq string start (- end 1))
				  ex ey) xy-list))

		  (setf nowx (- nowx line-feed) nowy bottom-m endx nowx endy nowy
				start end end start)
		  )
		 (t ;; $@1Q;z$N>l9g(J
		  (incf endy (character-height font ch))
 		  (when (>= endy top-m)                ;; $@%^!<%8%s$r1[$($?(J
				(decf endy (character-width font ch))
				(if (null truncate-height)
					(progn 
					  (multiple-value-bind
					   (sx sy ex ey)
					   (line-feed-op-tate nowx nowy endx endy region)
					   (push 
						(list sx sy
							  (subseq string start (- end 1))
							  ex ey) xy-list))
					  (push ch char-list)
					  (setf nowx (- nowx line-feed) nowy bottom-m endx nowx 
							endy nowy start (- end 1) end start)
					  )
				  (setf truncate-flg T))
				))
		 )
		)
	(unless 
	 (or (= (char-code ch) 10)
		 (= (char-code ch) 13))
	 ;; $@=*N;$,2~9TJ8;z$G$J$$(J
	  (multiple-value-bind
	   (sx sy ex ey)
	   (line-feed-op-tate nowx nowy endx endy region)
	   (push 
		(list sx sy
			  (subseq string start end)
			  ex ey) xy-list))
	  )
	 ;;; $@5a$^$C$?%j!<%8%g%s$r3HBg$9$k(J
	 (add-offset-region region (font-kanji-width font)
						font-height)
	 (push endy xy-list)
	 (push endx xy-list)
	 (push region xy-list)
	)
  ))

			  
;;; $@:BI87O$r9MN8$7$?%U%)%s%H$N%Y!<%9%i%$%s$+$i$N%H%C%W$rJV$9(J
;;; $@:8>e:BI87O(J
(defmethod font-top ((font text-font)
		     (char character)
		     (coodinate translate-coordinate-left-top))
  (declare 
   #-CMU
   (inline -)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (- (character-height font char)
     (character-base-line font char)))

;;; $@:BI87O$r9MN8$7$?%U%)%s%H$N%Y!<%9%i%$%s$+$i$N%H%C%W$rJV$9(J
;;; $@:82<:BI87O(J
(defmethod font-top ((font text-font)
		     (char character)
		     (coodinate translate-coordinate-left-bottom))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (character-base-line font char))


;;; $@:BI87O$r9MN8$7$?%U%)%s%H$N%Y!<%9%i%$%s$+$i$N%\%H%`$rJV$9(J
;;; $@:8>e:BI87O(J
(defmethod font-bottom ((font text-font)
		     (char character)
		     (coodinate translate-coordinate-left-top))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (character-base-line font char))


;;; $@:BI87O$r9MN8$7$?%U%)%s%H$N%Y!<%9%i%$%s$+$i$N%\%H%`$rJV$9(J
;;; $@:82<:BI87O(J
(defmethod font-bottom ((font text-font)
		     (char character)
		     (coodinate translate-coordinate-left-bottom))
  (declare 
   #-CMU
   (inline -)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (- (character-height font char)
     (character-base-line font char)))


;;; $@:BI87O$r9MN8$7$?%U%)%s%H$N%Y!<%9%i%$%s$+$i$N%H%C%W$rJV$9(J
;;; $@:8>e:BI87O(J
(defmethod font-kanji-top ((font text-font)
		     (coodinate translate-coordinate-left-top))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (- (font-kanji-height font)
     (font-kanji-base-line font )))

;;; $@:BI87O$r9MN8$7$?%U%)%s%H$N%Y!<%9%i%$%s$+$i$N%H%C%W$rJV$9(J
;;; $@:82<:BI87O(J
(defmethod font-kanji-top ((font text-font)
		     (coodinate translate-coordinate-left-bottom))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (font-kanji-base-line font ))


;;; $@:BI87O$r9MN8$7$?%U%)%s%H$N%Y!<%9%i%$%s$+$i$N%\%H%`$rJV$9(J
;;; $@:8>e:BI87O(J
(defmethod font-kanji-bottom ((font text-font)
		     (coodinate translate-coordinate-left-top))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (font-kanji-base-line font))


;;; $@:BI87O$r9MN8$7$?%U%)%s%H$N%Y!<%9%i%$%s$+$i$N%\%H%`$rJV$9(J
;;; $@:82<:BI87O(J
(defmethod font-kanji-bottom ((font text-font)
		     (coodinate translate-coordinate-left-bottom))
  (declare 
   #-CMU
   (inline -)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (- (font-kanji-height font)
     (font-kanji-base-line font)))

;;; End of file
