;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; С¸ʬ
;;; server-dependent.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka

;;; С¸ʬ
;;; 2/27 1990 ź
;;; Version 1.0   Coded by t.kosaka 1990-2-27

(in-package :yy )

(defvar *TOP-COLOR-TABEL* nil)
(defvar *DEMO-WINDOW1* nil)
(defvar *DEMO-WINDOW2* nil)
(defvar *DEMO-WINDOW3* nil)


;;; YYСȤ³򼨤¤
(defvar *SERVER-COMMUNICATION* (make-yy-server-connection))

;(initial-yy-internal :x-server-name "aoyama:0" )

;;;YYΥ˥饤ؿΥ󥿡ʥ
;;; δؿϡޥץĶǵưƤϤʤʤ
(defun initialize-yy (&key (version 1)
		      (release 1)
		      (responce 20)
		      (ntime 100)
		      (x-server-name "")
		      (server-name "")
		      (x 0)
		      (y 0)
		      (width 1100)
		      (height 800)
		      (network 
			#-:SYMBOLICS
			nil
			#+:SYMBOLICS
			T)
		      (domain-no 0))
  #-CMU
  (declare (special *SERVER-COMMUNICATION* *YY-MAGIC-NO* 
		    *DEFAULT-FONT* *territory-lisp-object*
		    *event-packet-struct*
		    *BLACK-COLOR-NO*
		    *BLACK-COLOR*
		    *WHITE-COLOR*
		    *ROOT-TERRITORY-NO* *ROOT-WINDOW* 
		    *LISP-LISTENER* *MAX-RECEIPT-TIME* 
		    *current-lisp*
		    *event-loop-process*
		    *YY-INITIAL-PROCESS*
		    *NO-CLIP-TERRITORY1*
		    *NO-CLIP-TERRITORY2*
		    *NO-CLIP-TERRITORY3*
		    *NO-CLIP-TERRITORY4*
			*henkan-window*
		    *IMAGE-AND-FILE-LIST*
		    *WAIT-TAG-AND-FUNCTION-LIST*
		    *YY-PROCESS-TABLE*
		    *SEND* *header* *header2*
		    *RECEIPT-TIME* *max-receive-size* *max-message-size* 
		    *receive* *send-receive* *YY-VERSION-DATE* 
		    *GET-POSITION-MOUSE-CURSOR* 
		    *red*
		    *pop-up-menu-window* *icon-pop-up-menu-window*)
	   (function MAKE-TIME-TITLE-WINDOW () T)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
;;; Сν
  (format t "~a ~%" *YY-VERSION-DATE*)
  (setf *top-color-tabel* NIL
	*red* nil)
;;; ߤΥץǼ
  (setf *yy-initial-process* (current-process))
;;; ⤷ŤΤ³Ƥ顢
						;(c_close)

  (setf  *SYSTEM-MOUSE-STATE* (make-mouse-state)
	 *SYSTEM-INTERRUPT-EVENT* (make-instance 'yy-interrupt-event)
	 *event-loop-process* nil
	 *current-lisp* (current-process))
  
  (setf *ROOT-TERRITORY-NO* -1 *ROOT-WINDOW* nil
	*LISP-LISTENER* nil 	*territory-lisp-object* nil
	;; following values must be reset	*no-clip-territory1* nil
	*no-clip-territory2* nil	*no-clip-territory3* nil
	*no-clip-territory4* nil	*image-and-file-list* nil
	*wait-tag-and-function-list* nil 
	*yy-process-table* (list *yy-initial-process*))

   ;;; YYСȤ³
  (if network
      (setf *max-message-size*
	    (c_setup_server 1 (make-array-string server-name) 
			    domain-no (make-array-string "")
			    (make-array-string "")))
	(setf *max-message-size*
	    (c_setup_server 0 
						(make-array-string server-name) domain-no 
			    (make-array-string "") (make-array-string ""))))

  (setf *max-receive-size* *max-message-size*)

  ;;; ѥåȥХåե
  (setf *send* (list (make-packet))
        *receive* (make-packet  *max-receive-size*)
		*send-receive* (list (make-packet *max-receive-size*))
		*header* (make-packet 2)
		*header2* (make-packet 2))
  ;;; ǡ
  (setf (event-packet-data *event-packet-struct*) *receive*)

  ;;; XСȤ³
  (unless
    (yy-protocol-0 *yy-magic-no* version release responce ntime x-server-name
		   *SERVER-COMMUNICATION*)
    (error "Set Up connection"))
   ;;; ǥեȥեȤΥ a14
  (setf *DEFAULT-FONT* (load-font :font-name "a14"))
   ;;; եȤΥ
  ;; (setf *SMALL-FONT* (load-font :font-name "5x8"))

   ;;; 顼ơ֥ν
  (setf *all-colors* nil)
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;; YY Υǥեȿ ;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  (make-yy-default-color)



  ;;; 롼ȥƥȥ
  (setf *ROOT-TERRITORY-NO* (make-territory :x x :y y :width width 
					    :height height
					    :parent 0 :drawable nil))
  ;;; ǥեȤΥ᡼
  (make-defalut-images)
  ;;; 롼ȥɥ
  (setf *ROOT-WINDOW* (make-window-instance 'viewport-window-stream
					    :window-region (make-region :width width
									:height height)
					    :border-visible nil
						:title-bar nil :horizontal-scroll-bar nil
					    :vertical-scroll-bar nil :coordinate-area nil))

  ;;; ǥեȤΥޥ
  (change-mouse-cursor (make-default-mosue-cursor))

  ;;; get positionѥޥ
  ;;  (setf *GET-POSITION-MOUSE-CURSOR* (make-get-position-mouse-cursor))
  ;;; ɥѤΥݥåץåץ˥
  (setf *pop-up-menu-window* (default-window-pop-up-menu))
  ;;; ޥ᥽åɤ̵
  (disnable-event *pop-up-menu-window* *mouse-right-1*)
  (setf *icon-pop-up-menu-window* (default-icon-pop-up-menu))
  (disnable-event *icon-pop-up-menu-window* *mouse-right-1*)

  (setf *prompt-window* 
		(make-window-instance  'viewport-window-stream
		 :window-region 
		 (make-region :left 0 :bottom 
					  (- height (font-kanji-height *default-font*) 5)
					  :width width  
					  :height (+ (font-kanji-height *default-font*) 3))
		 :title-bar nil	 :vertical-scroll-bar nil
		 :horizontal-scroll-bar nil :coordinate-area nil))

  (setq *lisp-listener*
		(make-window-instance 
		 'lisp-listener :window-region 
		 (make-region :left 10 :bottom 10
					  :width 400 :height 250)
		 :title-bar-string "Lisp Listener" :title-bar 'switch-title-bar
		 :window-frame 'lisp-listener-frame))

  ;;; Ѵɥ
  (setf *henkan-window*
		(make-window-instance 
		 'page-window-stream
		 :window-region 
		 (make-region :left 0 :bottom 
					  (- height (* 3 (font-kanji-height *default-font*)))
					  :width width  
					  :height (+ (font-kanji-height *default-font*) 3))
		 :visible nil :title-bar nil :vertical-scroll-bar nil
		 :horizontal-scroll-bar nil :coordinate-area nil))
  
  ;;; ץꥱܥå
  (init-application-box)
  (make-instance 'application :function-name 'make-test-window
				 :application-title "եåƥ")
  (make-instance 'application :function-name 'init-vtr
				 :application-title "ƥդӥǥ")
  (make-instance 'application :function-name 'make-yylogo-window
				 :application-title "YYΥ˥᡼")
;  (make-instance 'application :function-name 'make-tv-window
	;			 :application-title "˥᡼ƥ")
  #-SYMBOLICS
  (make-instance 'application :function-name 'init-cg
				 :application-title "3CGƥ")
  
  ;;;ѤΥϥɥ顼
  (start-event-loop)
  )

;;; GEO 
(defun init-cg ()
  (load (format nil "~asystem.lisp" user::*CG-FILES*)))

;;; YYߤ
#+(or LUCID EXCL)
(defun stop-yy ()
  ;;; ϥץξ
  (if  *event-loop-process*
      (killed-process *event-loop-process*))
  (c_close))
  

;;; ǡΥå
(defun swap-byte (data)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((ret-data #x00)
		(temp #x01))
	(dotimes (i 8)
			 (setf temp #x01)
			 (when (logbitp i data)
				 (setf temp (ash temp (- 7 i))
					   ret-data (logior temp ret-data))))
	ret-data))

;;; XbitmapǺäӥåȥޥåפΥꥹȤ
;;; ᡼ˤ
(defun make-tv-image (w h bitmap-array-data)
  (let* ((width (ceiling (/ w 8)))
		 (array (make-array (list h width)
							 :element-type '(unsigned-byte 8)))
		 (list-d bitmap-array-data))
	(dotimes (j h)
			 (dotimes (i width)
					  (setf (aref array j i)
							(swap-byte (car list-d))
							list-d (cdr list-d))))
	(make-image-from-array array)))

;;; ӥåȥޥåפե뤫ɤ
;;; ӥåȥޥåפηϡ
;;; (width height #x00 #x01 .... )
(defun load-yy-bitmap (file-name)
  (let ((bitmap-list nil))
	(with-open-file 
	 (stream file-name)
	 (setf bitmap-list (read stream))
	 (make-tv-image (car bitmap-list) (second bitmap-list)
					(cddr bitmap-list)))))


(defun make-defalut-images ()
  (setq *image-yy* 
    (make-image-from-array (make-array 
			    '(12 2)
			    :element-type '(unsigned-byte 8)
			    :initial-contents 
			    '((#x0 #x0) (#x7F #xFE) (#x4 #x3E)
			      (#x4E #x3E) (#X64 #x60) (#x70 #x32)
			      (#x71 #X86) (#x79 #XCE) (#x7B #xCE)
			      (#x73 #x9E) (#X61 #xE)  (#x0 #x0)))))

  (setq *left-bottom* 
#|
		(make-tv-image 
		 8 8 
		 '(#x06 #x0f #x06 #x06 #x46 #xfe #xfe #x40))
|#
		(make-image-from-array
		      (make-array 
		       '(9 2)
		       :element-type '(unsigned-byte 8)
		       :initial-contents
		       '((#x30 #x00) (#x70 #x00)
			 (#xF8 #x00) (#x20 #x00)
			 (#x23 #x00) (#x23 #x00)
			 (#x3f #x80) (#x03 #x00)
			 (#x02 #x00))))
		)


  (setq *left-top* 
#|
		(make-tv-image 
		 8 8 
		 '(#x00 #x40 #xfc #xfc #x4c #x0c #x1e #x0c)))
|#

   (make-image-from-array
	   (make-array
		'(9 2)
		:element-type '(unsigned-byte 8)
		:initial-contents
		'((#x02 #x00) (#x03 #x00)
		  (#x3f #x80) (#x23 #x00)
		  (#x22 #x00) (#x20 #x00)
		  (#xf8 #x00) (#x70 #x00)
		  (#x20 #x00)))))

  (setq *hidari* (make-image-from-array
		  (make-array
		  '(9 1)
		  :element-type '(unsigned-byte 8)
		  :initial-contents
		  '((#x08) (#x18) (#x38) (#x78) (#xF8)
		    (#x78) (#x38) (#x18) (#x08)))))

  (setq *migi* (make-image-from-array
		(make-array
                  '(9 1)
                  :element-type '(unsigned-byte 8)
                  :initial-contents
		  '((#x80) (#xc0) (#xe0) (#xf0) (#xf8)
		    (#xf0) (#xe0) (#xc0) (#x80)))))

  (setq *ue* (make-image-from-array
	      (make-array
                  '(5 2)
                  :element-type '(unsigned-byte 8)
                  :initial-contents
		  '((#x08 #x00) (#x1c #x00) (#x3e #x00)
		    (#x7F #x00) (#xFF #x80)))))

  (setq *sita* (make-image-from-array
		(make-array
                  '(5 2)
                  :element-type '(unsigned-byte 8)
                  :initial-contents
		  `((#xFF #x80) (#x7F #x00) (#x3e #x00)
		    (#x1c #x00) (#x08 #x00)))))

  (let ((bitmap-list '(16 16  #xaa #xaa #x55 #x55 #xaa #xaa #x55 #x55 
					   #xaa #xaa #x55 #x55 #xaa #xaa #x55 #x55 #xaa 
					   #xaa #x55 #x55 #xaa #xaa #x55 #x55 #xaa #xaa 
					   #x55 #x55 #xaa #xaa #x55 #x55)))

	(setf *MARK-PAT-NO*
		  (bitmap-territory-no 
		   (make-bitmap 16 16 
						:image (make-tv-image (car bitmap-list) 
											  (second bitmap-list)
											  (cddr bitmap-list)))))
	))

;;; ǥեȤΥޥ
(defun make-default-mosue-cursor ()
  (let ((im-list
		 '(#x00 #x00 #x0c #x00 #x38 #x00 #xf8 #x01 #xf0 #x0f #xf0 #x1f
				#xe0 #x07 #xe0 #x03 #xc0 #x07 #xc0 #x0c #x80 #x18 #x80 #x36
				#x00 #x14 #x00 #xbc #x00 #x68 #x00 #x2c)))
  (make-mouse-cursor 
   16 16 (make-bitmap 16 16
					  :image (make-tv-image 16 16 
											im-list))
					  :x-hotspot 0 :y-hotspot 0)))

;;; ȥСκɽ᥽å after᥽å
(defmethod redisplay-title-bar :after ((title switch-title-bar))
  #-CMU
  (declare (special *mouse-button-down-1* *default-font* *image-yy*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))

  (if (null (switch title))
    (let ((ob (make-instance 'switch
    		     :object-parent title
		     :draw-piece-visible T
    		     :switch-stream (object-parent title)
    			 :bottom 1 :left (- (region-width title) 18)
			 :width 18 :height (- (region-height title) 2))))
      (with-event-object (ob)
		 (setf (button1-method ob) 'icon-exec
		       (get 'icon-exec 'single-process) t
	    	   (slot-value ob 'event-mask) *mouse-button-down-1*))

      (setf (switch title) ob)
      (draw-piece-put-image ob 1 0 *image-yy*))

    (let ((region (switch title)))
      (with-real-object (region)
			(setf (region-left region) 
			  (- (region-width title) 18)
			  (region-width region) 18))
			  
      (draw-piece-put-image region 1 0 *image-yy*))
    ))
		

;;; 
(defmethod icon-exec ((ob switch) state)
  #-CMU
  (declare (ignore state)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (shrink (switch-stream ob)))



(defmethod compute-window-parts ((frame lisp-listener-frame) region
								 other-regions)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))

  ;; ǽ̾Υե졼η׻򤹤
  (default-compute-frame frame region other-regions)

  ;;; small-sizeɥåȾ
  (with-slots 
   (small-size-left small-size-top small-size-right small-size-bottom) 
   frame
   (with-region-slots
	(left bottom right top) frame
	(incf left small-size-left)
	(incf bottom small-size-bottom)
	(decf right small-size-right)
	(decf top small-size-top)
	)
  (setf (listener-width frame) (region-width frame)
		(listener-height frame) (region-height frame)))
  frame
  )

;;; ɽ
(defmethod redisplay-window ((window lisp-listener))
  #-CMU
  (declare (special *SCROLL-BAR-BELT* *default-font* *black-color*
                     *white-color*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((region (window-frame window))
		 (width (region-width region))
		 (height (region-height region)))
	
	;; ǥեȤκɽԤʤ
	(default-redisplay-window window)

    (draw-piece-color window *black-color*)
	(with-slots 
	 (small-size-left small-size-bottom) region
	 (with-region-slots 
	  (left bottom right top) region
	  (draw-piece-filled-rectangle window 
								   left 
								   (- bottom (- small-size-bottom 5)) width
								   (+ height 20)
								   :color *white-color*)
	  (draw-piece-filled-rectangle window (- left (- small-size-left 5)) 
								   bottom
								   (+ width 20) height :color *white-color*)

	  (draw-piece-filled-circle window left bottom 10 *white-color*)
	  (draw-piece-filled-circle window left top 10 *white-color*)
	  (draw-piece-filled-circle window right top 10 *white-color*)
	  (draw-piece-filled-circle window right bottom 10 *white-color*))
	 )))
     
#+Symbolics
(defun reset-yy-internal ()
  (progn (close yy::*fd2* :abort t)
	 (close yy::*fd1* :abort t)
	 (dolist (process YY::*YY-PROCESS-TABLE*)
	   (unless (eq process YY::*YY-INITIAL-PROCESS*)
	     (KILLED-PROCESS process)))
	 ))

;;; ʸ򥢥졼ˤ롣
#+(or Lucid EXCL)
(defun make-array-string (string)
  (let* ((len (+ (real-length string) 1))
		 (array (make-array len :element-type '(unsigned-byte 8)))
		 (code 0)
		 (ii 0))
	 
    (dotimes (i (length string))
			 (setf code (char-code (char string i)))
			 (if (> code #xA1)
				 (setf (aref array ii) (ash code -8)
					   (aref array (incf ii)) (logand #xFF code))
			   (setf (aref array ii) code))
			 (incf ii))
    (setf (aref array ii) 0)
    array))

#+(or Symbolics CMU)
(defun make-array-string (string)
  string)

;;;;;;;; ץꥱܥå ;;;;;;;;;;;;;;

;;; ޥ᥽å
(defun application-box-in (window state)
  (declare (ignore state)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots
   (accept-time) window
   (if accept-time
	   (terminate-accept window))
   (setf accept-time t)
   (let ((ob (accept 'application window)))
	 (when ob
		   (setf accept-time nil)
		   (draw-prompt 
			(format nil "~aμ¹Ԥ򤷤ޤ" (application-title ob)))
		   (apply (function-name ob)
				  (function-args ob))))))

(defun application-box-out (window state)
  (declare (ignore state)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots
   (accept-time) window
   (if accept-time
	   (terminate-accept window))
   (setf accept-time nil)))


(defun init-application-box ()
  (declare (special *application-box*))
  (let ((window (make-window-instance 'application-box
									  :title-bar 'switch-title-bar
									  :title-bar-string
									  "Ͽץꥱ"
									  :window-region
									  (make-region :left 10 :bottom 300
												   :width 190 :height 120))))
	(set-window-method window 'application-box-in 
					   :event-mask *mouse-in*)
	(set-window-method window 'application-box-out
					   :event-mask *mouse-out*)
	(setf (get 'application-box-in 'signle-process) T
		  (get 'application-box-out 'signle-process) T)
	(setf *application-box* window
		  (stream-line-feed window) 20)
	window))

;;; ǥեȤο
(defun make-yy-default-color ()
  (declare 
   (special *BLACK-COLOR* *WHITE-COLOR* transparent* 
			*red-color* *blue-color* *green-color*
			*yellow-color* *brown-color* *purple-color*
			*orange-color* *SkyBlue-color* *YellowGreen-color*))
  ;;; Υ顼
  (setf *BLACK-COLOR* (make-color :red 0 :green 0 :blue 0)
	*BLACK-COLOR-NO* (color-no *BLACK-COLOR*)
	(color-no :black) (color-no *BLACK-COLOR*))
   ;;; Υ顼
  (setf  *WHITE-COLOR* (make-color :red 65535 :green 65535 :blue 65535)
		 (color-no :white) (color-no *WHITE-COLOR*))
  ;;; Ʃ
  (setf *transparent* (make-instance 'color :color-no -1
				     :red-no -1 :green-no -1 :blue-no -1)
		(color-no :transparent) (color-no *transparent*))
  ;; 顼 
  (setf *red-color* (make-x-color :red 255 :green 0 :blue 0)
		(color-no :red) (color-no *red-color*))
  ;; 顼  
  (setf *blue-color* (make-x-color :red 0 :green 0 :blue 255)
		(color-no :blue) (color-no *blue-color*))
  ;; 顼 
  (setf *green-color* (make-x-color :red 0 :green 255 :blue 0)
		(color-no :green) (color-no *green-color*))
  ;; 顼 
  (setf *yellow-color* (make-x-color :red 255 :green 255 :blue 0)
		(color-no :yellow) (color-no *yellow-color*))
  ;; 顼 㿧
  (setf *brown-color* (make-x-color :red 205 :green 51 :blue 51)
		(color-no :brown) (color-no *brown-color*))
  ;; 顼 
  (setf *purple-color* (make-x-color :red 155 :green 48 :blue 255)
		(color-no :purple) (color-no *purple-color*))
  ;; 顼 
  (setf *orange-color* (make-x-color :red 205 :green 133 :blue 0)
		(color-no :orange) (color-no *orange-color*))
  ;; 顼 忧
  (setf *SkyBlue-color* (make-x-color :red 135 :green 206 :blue 255)
		(color-no :SkyBlue) (color-no *SkyBlue-color*))
  ;; 顼 
  (setf *YellowGreen-color* (make-x-color :red 154 :green 205 :blue 50)
		(color-no :YellowGreen) (color-no *YellowGreen-color*))
  )

;;; End of file