/* File is prtclif.c */
/**
*** Copyright (c) 1990,1991 Aoyama Gakuin University
***
***            All Right Reserved
***
*** Permission to use, copy, modify, and distribute this software
*** and its documentation for any purpose and without fee is hereby granted,
*** provided that the above copyright notice appear in all copies and that
*** both that copyright notice and this permission notice appear in
*** supporting documentation, and that the name of Aoyama Gakuin
*** not be used in advertising or publicity pertaining to distribution of
*** the software without specific, written prior permission.
***
*** This software is made available AS IS, and Aoyama Gakuin make no
*** warranty about the software, its performance or its conformity to
*** any specification.
***
*** Any person obtaining a copy of this software is requested to send
*** their name and post office or electronic mail address to:
***    YY Coordinator
***    CSRL, Information Science Research Center
***    Aoyama Gakuin University
***    4-4-25 Shibuya, Shibuya-ku Tokyo, JAPAN 150
***    (yy-coordinator@csrl.aoyama.ac.jp)
***
*** Written By Yukio Ohta 1990.03.02
***      under supervision of Masayuki Ida
***
*** change log
*** Version 1.21 Add close function   By T.kosaka
*** Version 1.4  Modify    By T.kosaka  1991 12/25
**/


#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/time.h>
#include <signal.h>
#include <unistd.h>
#include <fcntl.h>

#ifdef old
#define YYPROTO_UNIX_DIR        "/tmp/.YY."
#define YYPROTO_UNIX_PORT       "/tmp/.YY." 
#else
#define YYPROTO_UNIX_DIR        "/tmp/.YY-unix" 
#define YYPROTO_UNIX_PORT       "YY"  
#endif

#define YYPROTO_INET_PORT               6750
#define YYMAGIC                         14876


int fd1 = NULL;
int fd2 = NULL;

struct yy_message {
	unsigned int data;
	};

/*
	c_init
	$@=i4|2=(J
*/

/* CMU $@MQ$N(J */
csetupserver(network,hostname,dnumber,user_name,passwd)
int network;
unsigned char *hostname;
int dnumber;
unsigned char *user_name,*passwd;
{
	int ret;
	ret = c_setup_server(network,hostname,dnumber,user_name,passwd);
	return(ret);
}

c_setup_server(network,hostname,dnumber,user_name,passwd)
int network;
unsigned char *hostname;
int dnumber;
unsigned char *user_name,*passwd;
{
	int data,no,nn,len,port,send;
	unsigned int first[1024];

	/* $@=i4|@_Dj%W%m%H%3%k(J */
	first[0] = YYMAGIC;
	first[1] = 0;
	first[2] = 0;
	first[4] = 256;
	no = strlen(user_name);
	first[5] = no;
/*	printf("User name length %d\n",no); */
	if(no) {
			strcpy(&first[6],user_name);
			nn = (no + 3) / 4 + 6;
	} else {
			nn = 6;
	}
	no = strlen(passwd);
	first[nn] = no;
/*	printf("Passwd length %d\n",no); */

	if( no ) {
			strcpy(&first[nn],passwd);
			nn += (no + 3) / 4;
	} else {
			nn = 7;
	}
	first[3] = nn;

/*	printf("Send packet block %d\n",nn); */

	/* $@%A%'%C%/(J $@%M%C%H%o!<%/(J */
	if( network ) {
		/* $@%M%C%H%o!<%/(J */
		fd1 = get_inet_domain(hostname,dnumber,0);
	}
	else {
		fd1 = get_unix_domain(YYPROTO_UNIX_DIR,YYPROTO_UNIX_PORT,dnumber);
	}
	send = 0;

	/* $@=i4|%Q%1%C%H$rAw?.(J */
	send_to_first(fd1,first,nn * 4);

	for(no = 0 ; no < 1024 ; no++ ) {
		first[no] = 0x00000000;
	}
	/* $@%9!<%Q!<(JYY$@%5!<%P$+$i$N<u?.(J */
	read_from_first(fd1,first,12);

	len = first[2];
	read_from_first(fd1,first + 3,len * 4 - 12);
	debung_first(first);
	if(first[6] != 0 ) {
		/* $@?7$7$$%]!<%H$r3+$/(J */
		close(fd1);
		no = (first[6] + 3) / 4 + 7;

		if(first[7]) {
			/* $@$3$H$J$k%[%9%HL>(J */
			fd1 = get_inet_domain(&first[7],-1,first[no +1] >> (4 - first[no]) * 8);
		} else {
			fd1 = get_inet_domain(hostname,-1,first[no +1] >> (4 - first[no]) * 8);
		}
		no += (first[no] + 3) / 4;
		nn = no;
		nn += (first[no] + 3) / 4;
		if( first[no] ) {
			if( first[no + 1] ) {
				/* $@0[$J$k%[%9%HL>(J */
				fd2 = get_inet_domain(first[no+1],-1,
						      first[nn+ 1] >> (4 - first[nn]) * 8);
			} else {
				fd2 = get_inet_domain(hostname,-1,
						      first[nn+ 1] >> (4 - first[nn]) * 8);
			}
			
		} else {
			fd2 = get_unix_domain(&first[no+1],"",0);
		}
				
	} else {
		if(first[8]) {
			nn = (first[8] + 3) / 4 + 9;
			if( first[9] ) {
				/* $@0[$J$k%[%9%H(J */
				fd2 = get_inet_domain(first[9],-1,
						      first[nn+1] >> (4 - first[nn]) * 8);
			} else {
				fd2 = get_inet_domain(hostname,-1,
						      first[nn+1] >> (4 - first[nn]) * 8);
			}
		}
		else {
			fd2 = get_unix_domain(&first[10],"",0);
	    }
    }
	return(first[3]);
}

send_to_first(fd,buf,byte_len)
int fd,byte_len;
unsigned char *buf;
{
	int sended_byte;
	int byte;
	sended_byte = 0;
	while(sended_byte != byte_len) {
		if((byte = write(fd,buf + sended_byte,byte_len - sended_byte)) <= 0)
				continue;
		sended_byte += byte;

    }
}

read_from_first(fd,buf,byte_len)
int fd,byte_len;
unsigned char *buf;
{
	int readed_byte;
	int byte;
	readed_byte = 0;
	
	while(readed_byte != byte_len) {
		if((byte = read(fd,buf + readed_byte,byte_len - readed_byte)) <= 0)
				continue;
		readed_byte += byte;
    }
}

debung_first(packet)
unsigned int packet[];
{
		int no,len;

		no = 0;
		printf("[0]Sikibetusi %d [1]Version %d\n",packet[0],packet[1]);
		len = packet[2];
		printf("[2]Paket Length %d\n",len);
		printf("[3]Kettei packet len %d\n",packet[3]);
        printf("[4]Server ID %d\n",packet[4]);
		printf("[5]Server User ID %d\n",packet[5]);
		len = packet[6];
		printf("[6]Server Host name length: %d\n", len);
		no += (len + 3) / 4 + 7;
		if( len ) {
				 printf("[7]Server Host name: %s\n",&packet[7]);
		 }
		len = packet[no++];

		printf("[%d]Port name length: %d\n",no -1 ,len);
		if(len) {
				printf("[%d]Port name: %d\n",no,packet[no]);
		}
		no += (len + 3) / 4;		
		len = packet[no++];
		printf("[%d]Event server host name length: %d\n",no - 1,len);
		if(len) {
				printf("[%d]Event server host name: %d\n",no,packet[no]);
		}
		no += (len + 3) / 4;

		len = packet[no++];
		printf("[%d]Event Port name length: %d\n",no -1,len);
		if(len) {
			printf("[%d]Evnet Port name: %d\n",no,packet[no] >> (4 - len) * 8);
		}
}

/* $@%3%M%/%7%g%s(J */
int get_unix_domain(dir,name,no)
char *dir,*name;
int no;
{
        int sock;
        struct sockaddr_un addr;

        bzero((char *)&addr, sizeof(addr));
        addr.sun_family = PF_UNIX;
		/* OLD one */
#ifdef old
		sprintf(addr.sun_path, "%s%d", YYPROTO_UNIX_PORT, no);
#else
		/* New one */
		if( *name ) {
				sprintf(addr.sun_path, "%s/%s", dir,name);
		} else {
				sprintf(addr.sun_path, "%s", dir);
		}
#endif
        if ((sock = socket(PF_UNIX, SOCK_STREAM, 0)) < 0) {
                perror("socket");
				exit(0);
        }
        if (connect(sock, &addr, sizeof(addr)) < 0) {
                perror("connect");
				exit(0);
        }
        fprintf(stderr, "Connect on %d/INET\n", sock);
        return sock;
}

int get_inet_domain(host, no,port)
        char *host;
        int no;
	int port;
{
        int sock;
        struct sockaddr_in addr;
        /* struct hostent *hp; */

        bzero((char *)&addr, sizeof(addr));

	if (isdigit(host[0])) {
		unsigned long a;
		a = inet_addr(host);
		addr.sin_family = PF_INET;
		bcopy((char *)&a, &addr.sin_addr, sizeof(a));
	} else {
		struct hostent *hp;
		if ((hp = gethostbyname(host)) == (struct hostent *)NULL) {
			fprintf(stderr, "Unknown host %s\n", host);
			return -1;
		}
		addr.sin_family = hp->h_addrtype;
		bcopy(*hp->h_addr_list, &addr.sin_addr, hp->h_length);
	 }
	if( no < 0 ) {
		addr.sin_port = htons(port);
	} else {
		addr.sin_port = htons(YYPROTO_INET_PORT+no);
	}

        if ((sock = socket(PF_INET, SOCK_STREAM, 0)) < 0) {
                perror("socket");
				exit(0);
        }
        if (connect(sock, &addr, sizeof(addr)) < 0) {
                perror("connect");
				exit(0);
        }
/*        fprintf(stderr, "Connect on %d/INET\n", sock); */
        return sock;
}


/* CMU $@MQ(J */
cwriteinternal (pack, lng)
unsigned char *pack;
long int  lng;
{
	c_write_internal (pack, lng);
}

/*
	c_write
	$@=q$-9~$_(J
	pack = $@%Q%1%C%H(J
	lng  = $@%Q%1%C%HD9(J
*/
c_write_internal (pack, lng)
unsigned char *pack;
long int  lng;
{
	int byte,ret,offset;
	offset = 0;
	byte = sizeof(struct yy_message)*lng;
	while (byte) {
		if((ret = write(fd1,pack + offset,byte)) > 0) {
			offset += ret;
			byte -= ret;
		}
	}
}

/*
	c_read1
	$@FI$_9~$_(J
	retpack = $@La$j%Q%1%C%H(J
	retlng  = $@La$j%Q%1%C%HD9(J
*/
/* CMU $@MQ(J */
cread1internal(retpack, retlng)
unsigned char *retpack;
long int  retlng;
{
	c_read1_internal(retpack, retlng);
}

c_read1_no_wait (retpack, retlng)
unsigned char *retpack;
long int  retlng;
{
	fd_set re,wr;
	int nfd,ret;
	struct timeval set_time;

	FD_ZERO(&wr);
	FD_ZERO(&re);

	nfd = fd1 + 1;
	set_time.tv_sec = 0;
	set_time.tv_usec = 100;
	
	FD_SET(fd1,&re);
	ret = select(nfd,&re,&wr,&wr,&set_time);

	if( ret != -1 ){
		if(FD_ISSET(fd1,&re)) {
			c_read1_internal(retpack, retlng);
			return(1);
		}
		else {
			return(0);
		}
	}
	else {
		return(0);
	}
}

c_read1_internal(retpack, retlng)
unsigned char *retpack;
long int  retlng;
{
	int byte;
	int ret;
	
	byte = 0;

	while(byte != retlng * 4) {
		if((ret = read(fd1, (retpack + byte),
			    sizeof(struct yy_message) * retlng - byte)) > 0) {
			byte += ret;
		}
	}
/* 	dump_pacet("Input",retpack,retlng);*/
}

/*
	c_read2
	$@FI$_9~$_(J
	retpack = $@%Q%1%C%H%G!<%?(J
	retlng  = $@%Q%1%C%H$N%P%$%H?t(J
*/
/* CMU $@MQ(J  $@%Q%1%C%H$r0l$D$E$DFI$`(J */
cread2(retpack, retlng,current)
unsigned char *retpack;
long int  retlng,current;
{
	int now,cur,len;
	now = 0;
	while(now != 4) {
		if((cur = read(fd2,retpack + now, 4)) >= 0) {
			if( cur == 0 ) {
				exit(0);
			}
			now += cur;
		}
	}
	len = 0x00FFFFFF & (retpack[1] | retpack[2] | retpack[3]);

	while(now != len * 4) {
		if((cur = read(fd2,retpack + now,len * 4 -  now)) >= 0) {
			if( cur == 0 ) {
				exit(0);
			}
			now += cur;
		}
	}
	return(now);
}

c_read2 (retpack, retlng,current)
unsigned char *retpack;
long int  retlng,current;
{
	int ret;
	ret = read(fd2,retpack + current,retlng);
	if ( ret == 0 ) {
		printf("I am going to down\n");
		exit(0);
	}

	return(ret);
}

/*
	c_access
	struct yy_message $@$N(J no$@HVL\$NMWAG$r<h$j=P$7JV5Q$9$k(J
	retpack = $@%Q%1%C%H(J
	no      = $@%Q%1%C%HHV9f(J
*/
/* CMU $@MQ(J */
int caccess (retpack,no)
unsigned char *retpack;
long int no;
{
	int ret;
	ret = c_access (retpack,no);
	return(ret);
}

int c_access (retpack,no)
unsigned char *retpack;
long int no;
{
	struct yy_message *yy_mes;
	
	yy_mes = (struct yy_message *)retpack;
	return((int)yy_mes[no].data);
}

/* CMU$@MQ(J */
cstore (pack, no, new)
unsigned char *pack;
unsigned int  no, new;
{
	c_store (pack, no, new);
}

c_store (pack, no, new)
unsigned char *pack;
unsigned int  no, new;
{
	struct yy_message *yy_mes;

	yy_mes = (struct yy_message *)pack;
	yy_mes[no].data = new;
}

/* CMU$@MQ(J*/
cstore2 (pack, no, new)
unsigned char *pack;
int  no, new;
{
	c_store2 (pack, no, new);
}

c_store2 (pack, no, new)
unsigned char *pack;
int  no, new;
{
	struct yy_message *yy_mes;

	yy_mes = (struct yy_message *)pack;
	yy_mes[no].data = new;
}
/* CUM$@MQ(J */
cstoremul(pack,no,d1,d2,d3,d4,d5,d6,d7,d8,d9,d10)
unsigned char *pack;
int no,d1,d2,d3,d4,d5,d6,d7,d8,d9,d10;
{
	c_store_mul(pack,no,d1,d2,d3,d4,d5,d6,d7,d8,d9,d10);
}

c_store_mul(pack,no,d1,d2,d3,d4,d5,d6,d7,d8,d9,d10)
unsigned char *pack;
int no,d1,d2,d3,d4,d5,d6,d7,d8,d9,d10;
{
	struct yy_message *yy_mes;
	yy_mes = (struct yy_message *)pack;
	yy_mes[no].data = d1;
	yy_mes[no+1].data = d2;	yy_mes[no+2].data = d3;
	yy_mes[no+3].data = d4;	yy_mes[no+4].data = d5;
	yy_mes[no+5].data = d6;	yy_mes[no+6].data = d7;
	yy_mes[no+7].data = d8;	yy_mes[no+8].data = d9;
	yy_mes[no+9].data = d10;
}

c_store_string(pack,no,data,start,length)
unsigned char *pack,*data;
int no,start,length;
{
	struct yy_message *yy_mes;
	yy_mes = (struct yy_message *)pack;

/* 	strncpy((char *)&yy_mes[no].data,data + start,length); */
	byte_copy((unsigned char *)&yy_mes[no].data,data + start,length);

	return(length);
}

/* This is for image */
c_store_vector(pack,no,data,start,length)
unsigned char *pack,*data;
int no,start,length;
{
	struct yy_message *yy_mes;
	unsigned int *image;
	yy_mes = (struct yy_message *)pack;

	byte_copy((unsigned char *)&yy_mes[no].data,data + start,length);

	return(length);
}

byte_copy(data1,data2,len)
unsigned char *data1,*data2;
int len;
{
	while(len) {
	    *data1++ = *data2++;
            len--;
    }
}

c_store_string_ics(pack,no,data,start,length)
unsigned char *pack,*data;
int no,start,length;
{
	struct yy_message *yy_mes;
	
	yy_mes = (struct yy_message *)pack;
	
	return(strncpy_ics((char *)&yy_mes[no].data,data + start,length));
}

strncpy_ics(data1,data2,len)
unsigned char *data1,*data2;
int len;
{
	int i;
	i = 0;
	while(len) {
		if( *data2 ) {
/* printf("%x\n",*data2); */
			*data1++ = *data2;
			len--;
		}
		data2++;
		i++;
	}
	return(i);
}
			

debug_packet(pack,ret)
struct yy_message *pack;
int ret;
{
	int i;

	for( i = 0 ; i < ret ; i++) {
		printf("%d     %d\n",i,pack[i].data);
	}
}

/* c_close */
c_close ()
{
   if( fd1 )
   {
	   close(fd1);
	   fd1 = 0;
   }

   if( fd2 )
   {
	   close(fd2);
	   fd2 = 0;
   }
}

/* $@F~NOMQ(JFD$@$rF@$k(J */
socket_i_fd()
{
	return(fd2);
}

unixselection (time)
int time;
{
	return( unix_selection (time));
}

/* EXCL $@$H(J CMU$@@lMQ(J */
unix_selection (time)
int time;
{
		fd_set re,wr;
		int nfd,ret;
		struct timeval set_time;

		FD_ZERO(&wr);
		FD_ZERO(&re);

		nfd = fd2 + 1;
		set_time.tv_sec = 0;
		set_time.tv_usec = time;

		FD_SET(fd2,&re);
		ret = select(nfd,&re,&wr,&wr,&set_time);

		if( ret != -1 ){
				if(FD_ISSET(fd2,&re)) {
/*						printf("ret %d set %b\n",ret,FD_ISSET(fd2,&re)); */
						return(1);
				}
				else {
						return(0);
				}
		}
		else {
				return(0);
		}
}

alamsetup(cl)
int cl;
{
    struct itimerval value;

    if( cl ) {
		/* value.it_interval.tv_sec = 0;
        value.it_interval.tv_usec = 50000; */

		value.it_interval.tv_sec = 0;
        value.it_interval.tv_usec = 0; 

        value.it_value.tv_sec = 0;
        value.it_value.tv_usec = 50000;

		while(!gettimer()) {
			setitimer (ITIMER_REAL,&value,NULL);
		}
		
    }
    else {
        value.it_value.tv_sec = 0;
        value.it_value.tv_usec = 0;
        setitimer (ITIMER_REAL,&value,NULL);
    }
}

gettimer()
{
    struct itimerval value;
	getitimer(ITIMER_REAL,&value);
/*
	printf("tv_sec %d  tv_usec %d \n",value.it_value.tv_sec,
		   value.it_value.tv_usec);
*/
	if(value.it_value.tv_usec != 0) {
		return(1);
	}
	else {
		return(0);
	}
}

dump_pacet(mes,yy_mes,len)
char *mes;
struct yy_message *yy_mes;
int len;
{
	int i;
	int data;
	unsigned char data1;
	unsigned char data2;
	unsigned char data3;
	unsigned char data4;

	printf("%s ***************************\n",mes);
	for(i = 0 ; i < len ; i++ ) {
		data = yy_mes[i].data;
		data1 = (0xFF000000 & data) >> 24;
		data2 = (0x00FF0000 & data) >> 16;
		data3 = (0x0000FF00 & data) >> 8;
		data4 =  0x000000FF & data;
		printf("No %d: %d %c %c %c %c\n",i,data,data1,data2,data3,data4);
	}
}

			   


