;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; presentation-method.lisp
;;; This file is EUC CODE
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;             All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification.
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;;ץ쥼ơΥ᥽åɴϢ  
;;; Authors:
;;;   version 1.4 92/03/04 by t.kosaka

(in-package :yy)

(defmethod print-object ((present display-yy-presentation) stream)
  (with-region-slots
   (left bottom width height) present
   (format stream "\#<Present:[~a] Left:~a Bottom:~a width:~a height:~a>"
		   (display-presented-instance present) left bottom width height)))

(defun make-class-type-list1 (type-list object)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if (and (listp type-list)
	   (or (eq (car type-list) 'or)
	       (eq (car type-list) 'and)
	       (eq (car type-list) 'not)))
      (list (mapcan #'(lambda (x)
			(make-class-type-list1 x object))
		    type-list))
    (progn
      (cond 
       ((symbolp type-list)
	(if (get type-list 'present-class)
	    (let ((my-type
		   (mapcan #'(lambda(z)
			       (list z))
			   (get type-list 'present-class))))
	      (list (push 'or  my-type)))
	  (list type-list)))
       ((keywordp (second type-list))
	(let ((slot-name 
	       (read-from-string 
		(string-trim '(#\:) 
			     (format nil "~a" (second type-list))))))
	  #-ALLEGRO-V4.1
	  (if (slot-exists-p object slot-name)
	      (if (listp (cddr type-list))
		  (if (presentation-classp (slot-value object slot-name)
					   (car (cddr type-list)))
		      (list T)
		    (list nil)))
	    (if (typep (slot-value object slot-name)
		       (cddr type-list))
		(list T)
	      (list nil)))
	  #+ALLEGRO-V4.1
	  (if (ignore-errors (slot-exists-p object slot-name))
	      (if (listp (cddr type-list))
		  (if (presentation-classp (slot-value object slot-name)
					   (car (cddr type-list)))
		      (list T)
		    (list nil))
		(if (typep (slot-value object slot-name)
			   (cddr type-list))
		    (list T)
		  (list nil)))
	    (list nil))
	  ))
       (t
	(list type-list)))
      )
    ))

;;; typepΥץ쥼ơ󥯥饹ؤγĥؿ
;;; object                       --> ǤդΥ֥
;;; presentation-class-name-list --> ץ쥼ơ󥯥饹
;;;                                  ̾ڤӤΥꥹȡ
;;;                                  饹ѤѼԤ
;;;                                  󥹥󥹤Υåͤ
;;;                                  ץ쥼ơ󥯥饹ȽǤǤ롣
;;;                                  (饹̾  å̾  ʤ)
;;; ¹
;;;  (presentation-classp 10 '(or (integer 1 30) string))
;;;  (presentation-classp <instancs> '(and (foo :slot1 integer) 
;;;                                        (foo :slote (integer (2) (10)))))
(defun presentation-classp (object presentation-class-name-list)
  (if (listp presentation-class-name-list)
	  (let* ((class-type-list
			  (car (make-class-type-list1 presentation-class-name-list 
							   object))))
		(typep object class-type-list))
	(if (get presentation-class-name-list 'present-class)
		(let ((my-type
			   (mapcan
				#'(lambda(z)
					(list z))
				(get presentation-class-name-list 'present-class))))
		  (push 'or  my-type)
		  (typep object my-type))
	  (typep object presentation-class-name-list)
	  )
	)
)

;;; ꥹȤɽ뤿ؿ
(defun child-list-display (child-list stream)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-inside-output-as-presentation
   (child-list stream)
   (write-string "(" stream)
   (force-output stream)
   (dolist 
	(item child-list)
	(if (listp item)
		(child-list-display item stream)
	  (with-inside-output-as-presentation
	   (item stream)
	   (write-string (format nil "~s " item) stream)
	   (force-output stream))))
   (write-string ") " stream)
   (force-output stream)))

(defun list-display (my-list stream type)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-output-as-presentation
   (my-list stream type)
   (write-string "(" stream)
   (force-output stream)
   (dolist (item my-list)
			(if (listp item)
			   (child-list-display item stream) 
			  (with-inside-output-as-presentation
			   (item stream)
			   (write-string (format nil "~s " item) stream);
			   (force-output stream))))
   (write-string ")" stream)
   (force-output stream)
   ))

;;; ֥Ȥץ쥼Ȥ
;;; object --> 륪֥
;;; stream --> 륹ȥ꡼
;;; presentation-class --> ץ쥼ơ󥯥饹
(defun present (object stream &optional presentation-class)
  (let ((type (if presentation-class
				  presentation-class
				(class-name (class-of object)))))
	(if (listp object)
		(list-display object stream type)
	  (with-output-as-presentation 
	   (object stream  type)
	   (write-string object stream)
	   (force-output stream)))
	))


;;; ץ쥼Ȥ줿֥Ȥγξ˻ꤷ
;;; ֤xyСobject
;;; ؿ
(defun present-on-xy (present-object x y class-list)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((flg nil))
    (dolist 
     (item (slot-value present-object `draw-method-list))
     (if (apply (car (second item)) x y (second (second item)))
	 (when (presentation-classp 
		(slot-value (third item) '_display-presented-instance)
		class-list)
	       (setf flg (third item))
	       (return)))
	 )
    flg))


;;; ɥɽƤƤΥץ쥼ơ
;;; 褷ξ˥ޥ뤫Ĵ٤
;;; ؿ
(defun find-presentation-on-mouse (present-object x y class-list)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((ret (present-on-xy present-object x y class-list)))
    (if ret
	ret
      (let ((object-list (slot-value  
			  (slot-value present-object '_presented-stream)
			  `present-list)))
	(setf ret nil)
	(dolist 
	 (item object-list)
	 (when 
	  (and (slot-value item 'draw-method-list)
	       (not (slot-value item 'parent-presentation)))
	  (unless 
	   (eq item present-object)
	   (when 
	    (region-overlap-p item present-object)
	    (with-region-slots
	     ((l1 left) (b1 bottom)) present-object
	     (with-region-slots 
	      ((l2 left) (b2 bottom)) item
	      (if (setf ret (present-on-xy item (+ (- l1 l2) x)
					   (+ (- b1 b2) y) class-list))
		  (return))))))))
	ret)
      )))


;;; ץ쥼Ȥ֥ȤɽΥꥢ
;;; ѼԤϡδؿ˥᥽åɤ򵭽Ҥ
;;; ǥեȥ᥽å  (ȤǰϤ)
;;; object --> ѼԤץ쥼Ȥ֥ (object specifier)
;;; stream --> ɥȥ꡼
(defmethod clear-present-selection-mark ((object T) 
										 (stream window-stream))
  (mark-present-object-internal stream)
  object)

;;; ץ쥼Ȥ֥Ȥɽ
;;; ѼԤϡδؿ˥᥽åɤ򵭽Ҥ
;;; ǥեȥ᥽å  (ȤǰϤ)
;;; object --> ѼԤץ쥼Ȥ֥ (object specifier)
;;; stream --> ɥȥ꡼
(defmethod set-present-selection-mark ((object T) 
										 (stream window-stream))
  (mark-present-object-internal stream)
  object)

(defun drawing-length (my method-list)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((i 0)
		(method nil))
	(dolist (item method-list)
			(when (eq (third item) my)
				  (incf i)
				  (setf method (car item))))
	(values i method)))

(defun default-region-mark (region tno)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (special *black-color*))
  (when region
		(with-region-slots 
		 (left bottom width height) region
		 (yy-protocol-26 tno 
						 left 
						 bottom width height 2 
						 (avialble-operation *black-color*)
						 (color-no *black-color*) "")
   )))

;;; Ȥɽ
;;; ؿ
(defun mark-present-object-internal (stream)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   ((pp present-selection) (tno world-territory-no)) stream
   (when 
	pp
	(multiple-value-bind
	 (no method-l) (drawing-length  pp (slot-value pp 'draw-method-list))
	 (if (< 1 no)
		 (default-region-mark pp tno)
	   (let* ((draw-m (car method-l))
			  (nn 0)
			  (new-p nil)
			  (rest-arg (cddr (second method-l))))
		 (with-region-slots
		  (left bottom)  (until-root-presentation pp)
		  (setf new-p 
				(mapcar #'(lambda (X) (if (oddp (incf nn))
										  (+ left X)
										(+ bottom X)))
						(second (second method-l)))))
		 (cond
		  ((eq draw-m #'yy-protocol-21-pr)
		   (apply #'yy-protocol-21-mark tno new-p rest-arg))
		  ((eq draw-m #'yy-protocol-22-pr)
		   (apply #'yy-protocol-22-mark tno new-p rest-arg))
		  ((eq draw-m #'yy-protocol-23)
		   (apply #'yy-protocol-23-mark tno new-p rest-arg))
		  ((eq draw-m #'yy-protocol-24)
		   (apply #'yy-protocol-24-mark tno new-p rest-arg))
		  ((eq draw-m #'yy-protocol-25-pr)
		   (apply #'yy-protocol-25-mark tno new-p rest-arg))
		  ((eq draw-m #'yy-protocol-26-pr)
		   (apply #'yy-protocol-26-mark tno new-p rest-arg))
		  ((eq draw-m #'yy-protocol-27)
		   (apply #'yy-protocol-27-mark tno new-p rest-arg))
		  ((eq draw-m #'yy-protocol-28-pr)
		   (apply #'yy-protocol-28-mark tno new-p rest-arg))
		  ((eq draw-m #'yy-protocol-29-pr)
		   (apply #'yy-protocol-29-mark tno new-p rest-arg))
		  ((eq draw-m #'yy-protocol-30-pr)
		   (apply #'yy-protocol-30-mark tno new-p rest-arg))
		  ((eq draw-m #'yy-protocol-41-pr)
		   (apply #'yy-protocol-41-mark tno new-p rest-arg))
		  ((eq draw-m #'yy-protocol-42-pr)
		   (apply #'yy-protocol-42-mark tno new-p rest-arg))
		  (t
		   (default-region-mark pp tno))
		  ))
	   )))))

	
;;; ץ쥼ơɽؿ
;;; object --> ץ쥼ơ󥪥֥
;;; window --> ɥȥ꡼
;;; ؿ
(defun selection-mark-present (object window)
  (with-slots 
   (present-selection) window
   (unless 
	(eq object present-selection)
	;;ߤɽä
	(if present-selection
		(clear-present-selection-mark 
		 (slot-value present-selection '_display-presented-instance)
		 window)
	  )
	;; ꤹ
	(setf present-selection object)
	(set-present-selection-mark
	 (slot-value present-selection '_display-presented-instance)
	 window)
	))
  )


;;; ץ쥼ơ󥪥֥ȤΥܥ᥽å
;;; ֤ɽ
;;; ץ쥼Ȥ줿֥Ȥ˥ޥߤ
;;; ȿ
;;; ؿ
(defun presentation-kakunin (object state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((window-stream (slot-value object '_presented-stream))
		(real-present-ob nil))
	(unless 
	 (slot-value window-stream 'present-selection-ok)
	 (when 
	  (setf  real-present-ob
			 (find-presentation-on-mouse 
			  object 
			  (mouse-state-x-position state)
			  (mouse-state-y-position state)
			  (presentation-class-list window-stream)))
	  (when (presentation-classp 
			 (slot-value real-present-ob '_display-presented-instance)
			 (presentation-class-list window-stream))
			(selection-mark-present real-present-ob window-stream))
	  ))))

;;; ץ쥼ơ󥪥֥ȤΥܥ᥽å
;;; 򤵤줿֥Ȥμ
;;; ѼԤܥ򥯥åȿ롣
;;; ؿ
(defun presentation-ok (object mouse-state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore mouse-state))
  (let ((window-stream (slot-value object '_presented-stream)))
	(when (slot-value window-stream 'present-selection)
		  (setf (slot-value window-stream 'present-selection-ok)
				(slot-value window-stream 'present-selection))
		  (clear-present-selection-mark 
		   (slot-value window-stream 'present-selection) window-stream)
		  (setf (slot-value window-stream 'present-selection) nil))))


;;; ץ쥼ơ󥪥֥ȤΥܥ᥽å
;;; ֤ɽβ
;;; ޥΰ褫Ф˸ƤӽФ
;;; ؿ
(defun presentation-out (object mouse-state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore mouse-state))
  (let ((window-stream (slot-value object '_presented-stream)))
	(clear-present-selection-mark 
	 (slot-value window-stream 'present-selection) window-stream)
	(setf (slot-value window-stream 'present-selection) nil)))


;;; ץ쥼ơ󥪥֥ȤΥܥ᥽å
;;; ߡؿ
;;; ؿ
(defun presentation-in (object mouse-state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
           (ignore object mouse-state))
  nil)

;;; ȥ꡼˥ץ쥼Ȥ졢ѼԤ
;;; ǧ֥ȤǤʤСT֤
;;; ؿ
(defun chech-accept-ok (stream)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if (slot-value stream 'present-selection-ok)
	  T
	nil))

;;; Ʊɥȥ꡼˥ץȤʤ
(defun check-same-window (window uniqu-symbol)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((active-list (slot-value window 'accetpt-active-list)))
	(if (eq uniqu-symbol (car (last active-list)))
		t
	  nil)))

;;; terminate-accept stream
;;; Ϳ줿ȥ꡼ưƤacceptλ롣
;;; stream --> acceptưƤ륹ȥ꡼
(defun terminate-accept (stream)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))

  (setf (slot-value stream 'present-selection-ok) 'end-terminate)

  (if (slot-value stream 'present-selection)
	  ;; ޡä
	  (clear-present-selection-mark 
	   (slot-value stream 'present-selection) stream)
	)
  (if (slot-value stream 'accetpt-active-list)
	  (setf (slot-value stream 'accetpt-active-list)
			(nbutlast (slot-value stream 'accetpt-active-list))))
  t)

;;;ץ쥼Ȥ֥Ȥ
;;;presentation-class-list ץ쥼ơ󥯥饹 
;;;ΥǡϤ롣
;;; common lisp Ƥ뷿
;;; ӤΥꥹȤ鹽롣
;;; Ϥǡϻؼ줿ץ쥼ơ󥯥饹Ȥ
;;; Υ饹뷿(define-presentation-class ؿ
;;; class-list ǻꤷ)ΥǡǤ롣
;;; presentation-class-list --> ץ쥼ơ󥯥饹
;;; stream -->ץ쥼ȤΥȥ꡼Ǥ롣
;;;
;;; : ʳǤϡacceptؿϥƥȤȤƤ
;;; ܡɤϤϰʤ
;;; ͤϡܤ˥ץȤ֥Ȥ
;;; ܤˤϡץȤ:normal
;;; terminate-acceptǶλ줿ϡ
;;; ܤnilܤˤϡ:terminate֤
(defun accept (presentation-class-list stream)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		 (ignore object mouse-state))
  (let ((uniq (gentemp)))

	;; Ʊɥ˥ץȤƯʤ
	(push uniq (slot-value stream 'accetpt-active-list))
	(wait-process 'check-same-window stream uniq)

	;;; ¥ʥå
	(draw-prompt "ϡ֥Ȥξ˥ޥߤ롣ܥǳǧܥΥɥåǰư")
	(let ((present-list (slot-value stream 'present-list))
		  (store-button-down (button1-method stream))
		  (store-method-dn (middle-button-down-1-method stream))
		  (store-method-up (middle-button-up-method stream))
		  (store-method-mv (move-mouse-cursor-method stream))
		  (mask (event-mask stream))
		  (ret1 nil)
		  (ret2 :normal)
		  (ret3 nil))
		   
	  ;; ǽNIL 
	  (setf (slot-value stream 'present-selection-ok) nil)
	  ;; ץ쥼ơΥ٥ȥޥ
	  (dolist (item present-list)
			  (unless (slot-value item 'parent-presentation)
					  (enable-event item)))
	  
	  ;; ɥ˥ޥ᥽åɤꤹ
	  (setf (button1-method stream) nil
			(middle-button-down-1-method stream) 'dammy1
			(middle-button-up-method stream) 'dammy2
			(move-mouse-cursor-method stream) 'present-object-move
			(get 'dammy1 'signle-process) T
			(get 'dammy2 'signle-process) T
			(get 'present-object-move 'signle-process) T
			(event-mask stream) 
			(logior mask *mouse-move* *mouse-middle-up*
					*mouse-middle-1*)
			(slot-value stream 'presentation-class-list ) 
			presentation-class-list)
		   
	  ;; ޥ
	  (yy-protocol-72 (world-territory-no stream)
						   (logand (lognot *mouse-move*) (event-mask stream)))
	  (unwind-protect
			(wait-process 'chech-accept-ok stream)
		(progn
		  ;; ͤȸ
		  (setf 
		   ret1 (slot-value stream 'present-selection-ok)
		   (slot-value stream 'present-selection-ok) nil
		   (button1-method stream) store-button-down
		   (middle-button-down-1-method stream) store-method-dn
		   (middle-button-up-method stream) store-method-up
		   (move-mouse-cursor-method stream) store-method-mv
		   (slot-value stream 'event-mask) mask)
			   
		  ;; ޥκ
		  (yy-protocol-72 (world-territory-no stream) mask)

		  ;; ץ쥼ơΥ٥ȥޥ
		  (dolist (item present-list)
				  (unless (slot-value item 'parent-presentation)
						  (disnable-event item (event-mask item))))

		  (if (eq 'end-terminate ret1)
			  (setf ret1 nil
					ret2 :terminate)
			(setf ret3 (slot-value ret1 '_display-presented-instance)))
			   
		  ;; Ф
		  (setf (slot-value stream 'accetpt-active-list)
				(delete uniq (slot-value stream 'accetpt-active-list))
				(presentation-class-list stream) nil)
		  )
		)
	  (values ret3 ret2 ret1))))


;;; ץ쥼ơ󥤥󥹥󥹤ư
(defun move-present-object-internal (present step-x step-y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))

  (let ((parent (until-root-presentation present)))

	(dolist (item (slot-value parent 'child-present-list))
			(move-present-object-internal-exe item step-x step-y))

	(shift-region-position parent step-x step-y)

	(with-region-slots 
	 (left bottom) parent
	 (yy-protocol-3 (presentation-territory-no parent)
					left bottom)))
  )

(defun move-present-object-internal-exe (present step-x step-y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))

  (shift-region-position present step-x step-y)
  
  (dolist (item (slot-value present 'child-present-list))
		  (move-present-object-internal-exe item step-x step-y)))

;;; object presentation-class
;;; pդޤ stream ɽΤ٤Ƥ
;;; ư뤿˻Ѥؿ
;;; δؿŪˤ moved-presented-object᥽åɤ
;;; ƤӽФ
;;; object  --> ѼԤץ쥼Ȥ֥
;;; presentation-class --> ץ쥼ơ󥯥饹ɽ
;;; move-step-x move-step-y --> ưƥå
;;; ץ쥼ơΥ󥹥 (optional)
(defun move-presented-object 
  (object stream presentation-class move-step-x move-step-y
		  &optional (presentation-instance nil))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
	(if presentation-instance
		(let ((present-list (present-list stream)))
		  (dolist (item present-list)
				  (when (eq item presentation-instance)
						(move-present-object-internal 
						             item move-step-x move-step-y)
						(moved-presented-object
						 (slot-value item '_display-presented-instance) stream
						 move-step-x move-step-y)
						(return))
				  ))
	  (let ((present-list (present-list stream)))
		(dolist 
		 (item present-list)
		 (if (presentation-classp object presentation-class)
			 (when (eq (slot-value item '_display-presented-instance)
					   object)
				   (move-present-object-internal item 
												 move-step-x move-step-y)
				   (moved-presented-object
					(slot-value item '_display-presented-instance) stream
					move-step-x move-step-y)
				   )
		   )
		 ))
  ))

;;; ʬȤ˻Ҥɤ⤬ʤƤ鼫ʬ򳰤
;;; ȥ꡼տ魯 present-list ⳰
(defun delete-myself (presentation stream)
  (if (not (slot-value presentation 'child-present-list))
      (let ((parent (slot-value presentation 'parent-presentation)))
	(setf (slot-value stream 'present-list)
	      (delete presentation (slot-value stream 'present-list)))
	(if parent
	    (setf (slot-value parent 'child-present-list)
		  (delete presentation 
			  (slot-value parent 'child-present-list)))
	  ;; Ʃƥȥõ
	  (progn
	    (with-region-slots
	     (left bottom width height) presentation
	     (setf left 0 bottom 0 width 1 height 1)
	     (yy-protocol-4 (presentation-territory-no presentation)
			    left bottom width height 0 0)
	     (flush-presentation presentation)
	     )))
	nil)
    T))

(defun mapcan-internal1 (x)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (collect-all-children x))

(defun collect-all-children (parent)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (append (list parent)
	  (if (slot-value parent `child-present-list)
	      (mapcan #'mapcan-internal1
		      (slot-value parent 'child-present-list)))
	  ))

(defun take-out-object-from-draw-method (object-list parent)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (dolist (item object-list)
	  (unless (eq parent item)
		  (setf (slot-value item 'draw-method-list) nil)))
  (setf (slot-value parent 'draw-method-list)
	(delete-if #'(lambda (x) (if (and (not (eq (third x) parent))
					  (member (third x) object-list))
				     T
				   nil))
		   (slot-value parent 'draw-method-list)))
   )                	

;;; delete-form-root-presentation-object
;;; ץ쥼ȤƤץ쥼ơοưʲ
;;; ƾõ
;;; stream ---> ץ쥼Ȥȥ꡼
;;; presentation-instance -> ץ쥼ơΥ󥹥 
(defun delete-form-root-presentation-object
  (stream presentation-instance)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((all-p (collect-all-children presentation-instance))
	(parent (slot-value presentation-instance 'parent-presentation))
	(root-parent (until-root-presentation presentation-instance)))
    (setf (slot-value stream 'present-list)
	  (delete-if #'(lambda (x)
			 (if (member x all-p)
			     t
			   nil)) (slot-value stream 'present-list)))
    (if (null parent)
	(progn
	  (take-out-object-from-draw-method all-p root-parent)
	  (flush-presentation root-parent))
      (progn
	(take-out-object-from-draw-method all-p parent)
	(with-region-slots
	 (left bottom width height) root-parent
	 (yy-protocol-4 (presentation-territory-no root-parent)
			left bottom width height 0 0))
	(first-draw-in-presentation root-parent
				    0 0))
	  
	  )))

;;; delete-presentation-object
;;; ץ쥼ȤƤ륪֥Ȥΰɽõ
;;; object  --> ѼԤץ쥼Ȥ֥
;;; presentation-class --> ץ쥼ơ󥯥饹ɽ
;;; ץ쥼ơΥ󥹥 (optional)
(defun delete-presentation-object 
    (object stream presentation-class &optional (presentation-instance nil))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))

  (if presentation-instance
      (let ((root-parent (until-root-presentation presentation-instance)))
	(before-reshape presentation-instance stream)
	(setf (drawing-region stream) nil
	      (presentation-instance stream) nil
	      (slot-value presentation-instance '_display-presented-instance) 
	      nil)
		
	(with-region-slots
	 (left bottom width height) root-parent
			 
	 (multiple-value-bind
	  (ll bb ww hh) (max-size-region root-parent)
	  (setf left ll bottom bb width ww height hh)
	  (delete-myself presentation-instance stream)
	  (when (not (eq root-parent presentation-instance))
		(yy-protocol-4 (presentation-territory-no root-parent)
			       left bottom width height 0 0)
		(first-draw-in-presentation root-parent
					    (world-x-start stream)
					    (world-y-start stream))))))

    (let ((p-list (slot-value stream 'present-list))
	  (root-parent nil))
      (dolist (item p-list)
	      (if (presentation-classp object presentation-class)
		  (when
		   (eq object (slot-value item '_display-presented-instance))
		   (before-reshape item stream)
		   (if (slot-value item 'parent-presentation)
		       (setf  root-parent 
			      (until-root-presentation item)))
		   (delete-myself item stream))))

      (setf (drawing-region stream) nil
	    (presentation-instance stream) nil)

      (when root-parent 
	    (with-region-slots
	     (left bottom width height) root-parent
	     (multiple-value-bind
	      (ll bb ww hh) 
	      (max-size-region root-parent)
		 
	      (setf left ll bottom bb width ww height hh)

	      (yy-protocol-4 (presentation-territory-no root-parent)
						left bottom width height 0 0)))
	    (first-draw-in-presentation root-parent 
					(world-x-start stream)
					(world-y-start stream)
					)))
    ))
	  
;;; end-of-move-presented-object (object specifier) stream 
;;; ץ쥼Ȥ줿֥Ȥޥɽ
;;; ưưλ˸ƤӽФδؿ
;;; ѼԤϡδؿ˥᥽åɤ뤳Ȥ
;;; ¾Ϣư()ư򵭽Ҥ뤳ȤǤ롣
;;; ǥեȥ᥽åɤϡ⤷ʤ
;;; object --> ѼԤץ쥼Ȥ֥ (object specifier)
;;; stream --> ɥȥ꡼
(defmethod end-of-move-presented-object ((object T) (stream window-stream))
  nil)

;;;moved-presented-object (object specifier) stream x y
;;; ؿˤƤӽФ桼ˤäδؿ
;;; ѼԤϡδؿ˥᥽åɤ뤳Ȥ
;;; ¾Ϣư()ư򵭽Ҥ뤳ȤǤ롣
;;; ǥեȥ᥽åɤϡ⤷ʤ
;;; object --> ѼԤץ쥼Ȥ֥ (object specifier)
;;; stream --> ɥȥ꡼
;;; step-x step-y ư
(defmethod moved-presented-object ((object T) (stream window-stream)
								   step-x step-y)
  (declare (ignore step-x step-y))
  nil)


;;;.move-presented-object-alone 
;;;(object stream presentation-class move-step-x move-step-y)
;;;objectpresentation-classդޤ
;;;stream ɽΤ٤Ƥư뤿
;;;Ѥؿ
;;;ϡ¾Ϣư()ưԤʤȤϤǤʤ
;;; object  --> ѼԤץ쥼Ȥ֥
;;; presentation-class --> ץ쥼ơ󥯥饹ɽ
;;; move-step-x move-step-y --> ưƥå
;;;δؿϡmoved-presented-objectƤӽФʤ
(defmethod move-presented-object-alone 
  (object stream presentation-class move-step-x move-step-y 
		  &optional (ins nil))  
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if (null ins)
	  (let ((present-list (slot-value stream 'present-list)))
		(dolist (item present-list)
				(if (presentation-classp object presentation-class)
					(when (eq (slot-value item '_display-presented-instance)
							  object)
						  (move-present-object-internal 
						   item move-step-x move-step-y)
						  )
				  )
				))
	(move-present-object-internal ins move-step-x move-step-y)))

;;;with-shape-presentationؿκǸ˸ƤӽФ
;;;桼ˤäδؿ
;;;ѼԤϡδؿ˥᥽åɤ뤳Ȥ
;;;¾Ϣư()ư򵭽Ҥ뤳ȤǤ롣
;;; ǥեȥ᥽åɤϡʤˤ⤷ʤ
;;; object --> ѼԤץ쥼Ȥ֥ (object specifier)
;;; stream --> ɥȥ꡼
(defmethod shaped-presented-object ((object T) stream)
  (declare (ignore stream))
  nil)

;;; ץ쥼ȤɥΥޥ᥽å
;;; ֤򵭲
(defun dammy1 (object state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (setf (present-move-step object) (list 
				    (mouse-state-x-position state)
				    (mouse-state-y-position state)))

  ;; ɽõ
  (mark-present-object-internal object)
  ;;; ץ쥼ơΥޥ
  (dolist (item (slot-value object 'present-list))
		  (unless (slot-value item 'parent-presentation)
				  (disnable-event item (event-mask item))))

  ;;; ޥΰư᥽åɤΥޥ
  (yy-protocol-72 (world-territory-no object)
				  (event-mask object))
  (values))
		   
;;; ץ쥼ȤɥΥޥ᥽å
;;; Υ֤򵭲
(defun dammy2 (object state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (special *mouse-move*))
  
  (setf (present-move-step object) (list 
				    (mouse-state-x-position state)
				    (mouse-state-y-position state)))
  ;; ɽ
  (mark-present-object-internal object)	 
  ;;; ץ쥼ơΥޥ
  (dolist (item (slot-value object 'present-list))
		  (unless (slot-value item 'parent-presentation)
			  (enable-event item)))
  
  ;; ޥΰưΥ᥽åɤΥޥγ
  (yy-protocol-72 (world-territory-no object)
				  (logand (lognot *mouse-move*) (event-mask object)))

  ;; λ˥᥽åɤƤӽФ
  (end-of-move-presented-object 
   (slot-value (slot-value object 'present-selection) 
	       '_display-presented-instance ) object)
  (values))

		   
;;; 򤵤Ƥץ쥼Ȥ֥Ȥΰư
(defun present-object-move (stream state)
  (declare (special *mouse-middle-1*)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  ;;; Ƥ뤳Ȥǧ
  (when (not (zerop (logand (mouse-state-button-state state)
							*mouse-middle-1*)))
	(with-slots 
	 (present-move-step present-selection) stream
	 (if present-selection
	     (let ((step-x (- (mouse-state-x-position state) 
			      (car present-move-step)))
		   (step-y (- (mouse-state-y-position state)
			      (second present-move-step))))
	       (setf (car present-move-step)
		     (mouse-state-x-position state)
		     (second present-move-step)
		     (mouse-state-y-position state))

	       (move-present-object-internal 
		present-selection step-x step-y)
	       
	       (moved-presented-object 
		(slot-value present-selection '_display-presented-instance)
		stream step-x step-y)
	       )
	   ))))
		   
;;; ɸꥹȤͿ줿ͤɲä
(defun add-world-offset (arg-list add-x add-y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (do ((xy (second arg-list) (cddr xy)))
	  ((null xy))
	  (incf (car xy) add-x)
	  (incf (second xy) add-y)))

;;; ץ쥼ơΥ󥹥󥹤С
;;; Υ֥Ȥ
(defun make-point-object (ob arg-list real-arg)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if ob
      (progn
	(with-slots
	 (draw-method-list) ob
	 (push (list (list #'yy-protocol-20-pr arg-list)
		     (list 'point-point-selection (cdr arg-list)) ob)
	       draw-method-list)))
    (progn
      (with-slots
       (world-x-start world-y-start) real-arg
       (add-world-offset arg-list world-x-start world-y-start)
       (apply #'yy-protocol-20-pr arg-list)))))


;;; ץ쥼ơΥ󥹥󥹤С
;;; Υ֥Ȥ
(defun make-line-object (ob arg-list real-arg)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if ob
      (progn
	(with-slots
	 (draw-method-list) ob
	 (push (list (list #'yy-protocol-21-pr arg-list)
		     (list 'point-line-selection (cdr arg-list)) ob)
	       draw-method-list)))
    (progn
      (with-slots
       (world-x-start world-y-start) real-arg
       (add-world-offset arg-list world-x-start world-y-start)
       (apply #'yy-protocol-21-pr arg-list)))))

;;; ץ쥼ơΥ󥹥󥹤С
;;; Υ֥Ȥ
(defun make-region-object (ob arg-list real-arg)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if ob
      (progn
	(with-slots
	 (draw-method-list) ob
	 (push (list (list #'yy-protocol-26-pr arg-list)
		     (list 'point-region-selection (cdr arg-list)) ob)
	       draw-method-list)))
    (progn
      (with-slots
       (world-x-start world-y-start) real-arg
       (add-world-offset arg-list world-x-start world-y-start)
       (apply #'yy-protocol-26-pr arg-list)))))


;;; ץ쥼ơΥ󥹥󥹤С
;;; Υ֥Ȥ
(defun make-region-object-fill (ob arg-list real-arg)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if ob
      (progn
	(with-slots
	 (draw-method-list) ob
	 (push  (list (list #'yy-protocol-28-pr arg-list)
		      (list 'point-region-selection-fill (cdr arg-list)) ob)
		draw-method-list)))
    (progn
      (with-slots
       (world-x-start world-y-start) real-arg
       (add-world-offset arg-list world-x-start world-y-start)
       (apply #'yy-protocol-28-pr arg-list)))))


;;; ץ쥼ơΥ󥹥󥹤С
;;; ޤΥ֥Ȥ
(defun make-polyline-object (ob arg-list real-arg)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if ob
      (progn
	(with-slots
	 (draw-method-list) ob
	 (push (list (list #'yy-protocol-23 arg-list)
		     (list 'point-polyline-selection (cdr arg-list)) ob)
	       draw-method-list)))
    (progn
      (with-slots
       (world-x-start world-y-start) real-arg
       (add-world-offset arg-list world-x-start world-y-start)
       (apply #'yy-protocol-23 arg-list)))))


;;; ץ쥼ơΥ󥹥󥹤С
;;; ¿ѷȤΥ֥Ȥ
(defun make-polygon-object (ob arg-list real-arg)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if ob
      (progn
	(with-slots
	 (draw-method-list) ob
	 (push (list (list #'yy-protocol-24 arg-list)
		     (list 'point-polygon-selection (cdr arg-list)) ob)
	       draw-method-list)))
	(progn
	  (with-slots
	   (world-x-start world-y-start) real-arg
	   (add-world-offset arg-list world-x-start world-y-start)
	   (apply #'yy-protocol-24 arg-list)))))


;;; ץ쥼ơΥ󥹥󥹤С
;;; ¿ѷΥ֥Ȥ
(defun make-polygon-object-fill (ob arg-list real-arg)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if ob
      (progn
	(with-slots
	 (draw-method-list) ob
	 (push (list (list #'yy-protocol-27 arg-list)
		     (list 'point-polygon-selection-fill (cdr arg-list)) ob)
	       draw-method-list)))
    (progn
      (with-slots
       (world-x-start world-y-start) real-arg
       (add-world-offset arg-list world-x-start world-y-start)
       (apply #'yy-protocol-27 arg-list)))))


;;; ץ쥼ơΥ󥹥󥹤С
;;; ʱߡʱ߸̤ȥ֥Ȥ
(defun make-ellipse-object (ob arg-list real-arg)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if ob
      (progn
	(with-slots
	 (draw-method-list) ob
	 (push (list (list #'yy-protocol-41-pr arg-list)
		     (list 'point-ellipse-selection-p (cdr arg-list)) ob)
	       draw-method-list)))
    (progn
      (with-slots
       (world-x-start world-y-start) real-arg
       (add-world-offset arg-list world-x-start world-y-start)
       (apply #'yy-protocol-41-pr arg-list)))))


;;; ץ쥼ơΥ󥹥󥹤С
;;; ʱߡʱ߸̤ɤ٤֥Ȥ
(defmethod make-ellipse-object-fill (ob arg-list real-arg)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if ob
      (progn
	(with-slots
	 (draw-method-list) ob
	 (push (list (list #'yy-protocol-42-pr arg-list)
		     (list 'point-ellipse-selection-fill (cdr arg-list)) ob)
	       draw-method-list)))
	(progn
	  (with-slots
	   (world-x-start world-y-start) real-arg
	   (add-world-offset arg-list world-x-start world-y-start)
	   (apply #'yy-protocol-42-pr arg-list)))))


;;; ץ쥼ơΥ󥹥󥹤С
;;; ߤȥ֥Ȥ
(defun make-circle-object (ob arg-list real-arg)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if ob
	  (progn
		(with-slots
		 (draw-method-list) ob
		 (push (list (list #'yy-protocol-22-pr arg-list)
					 (list 'point-circle-selection (cdr arg-list)) ob)
					 draw-method-list)))
	(progn
	  (with-slots
	   (world-x-start world-y-start) real-arg
	   (add-world-offset arg-list world-x-start world-y-start)
	   (apply #'yy-protocol-22-pr arg-list)))))
   

;;; ץ쥼ơΥ󥹥󥹤С
;;; ߸ȥ֥Ȥ
(defun make-arc-object (ob arg-list real-arg)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if ob
	  (progn
		(with-slots
		 (draw-method-list) ob
		 (push (list (list #'yy-protocol-25-pr arg-list)
					 (list 'point-arc-selection (cdr arg-list)) ob)
					  draw-method-list)))
	(progn
	  (with-slots
	   (world-x-start world-y-start) real-arg
	   (add-world-offset arg-list world-x-start world-y-start)
	   (apply #'yy-protocol-25-pr arg-list)))))


;;; ɤĤ֤ߤΥ֥Ȥ
(defun make-fill-circle-object (ob arg-list real-arg)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if ob
	  (progn
		(with-slots
		 (draw-method-list) ob
		 (push (list (list #'yy-protocol-29-pr arg-list)
					 (list 'point-fill-circle-selection (cdr arg-list)) ob)
					 draw-method-list)))
	(progn
	  (with-slots
	   (world-x-start world-y-start) real-arg
	   (add-world-offset arg-list world-x-start world-y-start)
	   (apply #'yy-protocol-29-pr arg-list)))))


;;; ץ쥼ơΥ󥹥󥹤С
;;; ɤĤ֤߸̥֥Ȥ
(defun make-fill-arc-object (ob arg-list real-arg)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if ob
	  (progn
	  (with-slots
	   (draw-method-list) ob
	   
	   (push (list (list #'yy-protocol-30-pr arg-list)
				   (list 'point-fill-arc-selection (cdr arg-list)) ob)
				   draw-method-list)))
	(progn
	  (with-slots
	   (world-x-start world-y-start) real-arg
	   (add-world-offset arg-list world-x-start world-y-start)
	   (apply #'yy-protocol-30-pr arg-list)))))


;;; ץ쥼ơΥ󥹥󥹤С
;;; ʸ󥪥֥Ȥ
(defun make-normal-string-object (ob arg-list real-arg)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if ob
	  (progn
		(with-slots
		 (draw-method-list) ob
		 (push  (list (list #'yy-protocol-31-pr arg-list)
					  (list 'point-normal-string-selection (cdr arg-list)) ob)
					  draw-method-list)))
	(progn
	  (with-slots
	   (world-x-start world-y-start) real-arg
	   (add-world-offset arg-list world-x-start world-y-start)
	   (apply #'yy-protocol-31-pr arg-list)))))


;;; ץ쥼ơΥ󥹥󥹤С
;;; Фʸ󥪥֥Ȥ
(defun make-angle-string-object (ob arg-list real-arg)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if ob
	  (progn
		(with-slots
		 (draw-method-list) ob
		 (push (list (list #'yy-protocol-44-pr arg-list)
					 (list 'point-angle-string-selection (cdr arg-list)) ob)
					 draw-method-list)))
	(progn
	  (with-slots
	   (world-x-start world-y-start) real-arg
	   (add-world-offset arg-list world-x-start world-y-start)
	   (apply #'yy-protocol-44-pr arg-list)))))
					   

;;; ץ쥼ơΥ󥹥󥹤С
;;; Ľʸ󥪥֥Ȥ
(defun make-tate-string-object (ob arg-list real-arg)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if ob
	  (progn
		(with-slots
		 (draw-method-list) ob
		 (push (list (list #'yy-protocol-43-pr arg-list)
					 (list 'point-tate-string-selection (cdr arg-list)) ob)
					 draw-method-list)))
	(progn
	  (with-slots
	   (world-x-start world-y-start) real-arg
	   (add-world-offset arg-list world-x-start world-y-start)
	   (apply #'yy-protocol-43-pr arg-list)))))
					   
;;; ץ쥼ơΥ󥹥󥹤С
;;; ڡ⡼ɥƥȥʸΥ֥Ȥ
(defmethod make-page-mode-string-object 
  ((ob display-yy-presentation) arg-list real-arg)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore real-arg))
  (with-slots
   (draw-method-list) ob
   (let ((temp (make-list 4)))
	 (setf (car temp) (list nil arg-list)
		   (second temp) (list 'point-region-selection-fill nil)
		   (third temp) (copy-tree arg-list))
   (push temp draw-method-list))))

;;; ץ쥼ȤƤΤư 
(defun move-presentation-internal (stream add-x add-y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (present-list) stream
   (dolist (item present-list)
		   (shift-region-position item add-x add-y))))


