;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; $@%W%l%<%s%F!<%7%g%s$NA*BrI=<((J
;;; present-mark.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;; Version 1.4   Corded by T.kosaka 1992-07-24

(in-package :yy)

;;;;;;;;;;; $@A*BrI=<($N$?$a$N4X?t(J ;;;;

;;; $@%^!<%/$N$?$a$N4X?t(J
(defun yy-protocol-21-mark (no xys width op edge color dashing)
  #-:CMU
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (special *BLACK-COLOR-NO* *GEQIV* *GXOR*)
		   (ignore op))
  (let ((new-op (if (= color 0 *BLACK-COLOR-NO*)
					*GEQIV*
				  *GXOR*))
		(new-color (if (= color -1)
					   *BLACK-COLOR-NO*
					 color)))
  (if (< 0 (length dashing))
	  (yy-protocol-21 no (car xys) (second xys) (third xys) (fourth xys)
				   width new-op edge new-color "")
	(yy-protocol-21 no (car xys) (second xys) (third xys) (fourth xys)
					width new-op edge new-color "I"))))


(defun yy-protocol-22-mark (no xys radius width op color dashing)
  #-:CMU
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (special *black-color-no* *GEQIV* *GXOR* *MARK-PAT-NO*)
		   (ignore op))
  (let ((new-op (if (= color 0 *BLACK-COLOR-NO*)
					*GEQIV*
				  *GXOR*))
		(new-color (if (= color -1)
					   *BLACK-COLOR-NO*
					 color)))
	(if (< 0 (length dashing))
		(yy-protocol-22 no (car xys) (second xys)
						radius width new-op new-color "")
	  (yy-protocol-22 no (car xys) (second xys)
				   radius width new-op new-color "I"))
	))


;;; $@A*BrI=<((J
(defun yy-protocol-23-mark (no xys-list width op edge connect color dashing)
  #-:CMU
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (special *black-color-no* *GEQIV* *GXOR* *MARK-PAT-NO*)
		   (ignore op))
  (let ((new-op (if (= color 0 *BLACK-COLOR-NO*)
					*GEQIV*
				  *GXOR*))
		(new-color (if (= color -1)
					   *BLACK-COLOR-NO*
					 color)))
	(if (< 0 (length dashing))
		(yy-protocol-23 no xys-list
						width new-op edge connect new-color "")
	  (yy-protocol-23 no xys-list
				   width new-op edge connect new-color "I"))
	))

(defun yy-protocol-24-mark (no xys-list width op connect color dashing)
  #-:CMU
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (special *black-color-no* *GEQIV* *GXOR* *MARK-PAT-NO*)
		   (ignore op))
  (let ((new-op (if (= color 0 *BLACK-COLOR-NO*)
					*GEQIV*
				  *GXOR*))
		(new-color (if (= color -1)
					   *BLACK-COLOR-NO*
					 color)))
	(if (< 0 (length dashing))
		(yy-protocol-24 no xys-list
						width new-op connect new-color "")
	  (yy-protocol-24 no xys-list
				   width new-op connect new-color "I"))
	))

(defun yy-protocol-25-mark (no xys radius theta1 theta2 width op color dashing)
  #-:CMU
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (special *black-color-no* *GEQIV* *GXOR* *MARK-PAT-NO*)
		   (ignore op))
  (let ((new-op (if (= color 0 *BLACK-COLOR-NO*)
					*GEQIV*
				  *GXOR*))
		(new-color (if (= color -1)
					   *BLACK-COLOR-NO*
					 color)))
	(if (< 0 (length dashing))
		(yy-protocol-25 no (car xys) (second xys)
						radius theta1 theta2 width new-op new-color dashing)
	  (yy-protocol-25 no (car xys) (second xys)
					  radius theta1 theta2 width new-op new-color "I"))))

(defun yy-protocol-26-mark (no xys width height linewidt op color dashing)
  #-:CMU
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (special *GXOR* *GEQIV* *BLACK-COLOR-NO*)
		   (ignore op))
  (let ((new-op (if (= color 0 *BLACK-COLOR-NO*)
                    *GEQIV*
                  *GXOR*))
		(new-color (if (= color -1)
					   *BLACK-COLOR-NO*
					 color)))
	(if (< 0 (length dashing))
		(yy-protocol-26 no (car xys) (second xys) width height linewidt 
						new-op new-color dashing)
	  (yy-protocol-26 no (car xys) (second xys) width height linewidt 
					  new-op new-color "I"))))

(defun yy-protocol-27-mark (no xys-list op connect color fill pattern)
  #-:CMU
    (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (special *black-color-no* *GEQIV* *GXOR* *MARK-PAT-NO*)
		   (ignore op pattern))
  (let ((new-op (if (= color 0 *BLACK-COLOR-NO*)
					*GEQIV*
				  *GXOR*))
		(new-color (if (= color -1)
					   *BLACK-COLOR-NO*
					 color)))
	(yy-protocol-27 no xys-list new-op  connect new-color fill *MARK-PAT-NO*)))



;;; $@A*BrI=<(MQ(J
(defun yy-protocol-28-mark (no xys width height op color pattern)
  #-:CMU
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (special *black-color-no* *GEQIV* *GXOR* *MARK-PAT-NO*)
		   (ignore op pattern))
  (let ((new-op (if (= color 0 *BLACK-COLOR-NO*)
                    *GEQIV*
                  *GXOR*))
		(new-color (if (= color -1)
					   *BLACK-COLOR-NO*
					 color)))
  (yy-protocol-28 no (car xys) (second xys) 
				  width height new-op new-color *MARK-PAT-NO*))
  )


(defun yy-protocol-29-mark (no xys radius op color pattern)
  #-:CMU
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (special *black-color-no* *GEQIV* *GXOR* *MARK-PAT-NO*)
		   (ignore op pattern))
  (let ((new-op (if (= color 0 *BLACK-COLOR-NO*)
					*GEQIV*
				  *GXOR*))
		(new-color (if (= color -1)
					   *BLACK-COLOR-NO*
					 color)))
	(yy-protocol-29 no (car xys) (second xys) radius new-op new-color 
					*MARK-PAT-NO*)))


(defun yy-protocol-30-mark (no xys radius theta1 theta2 op color 
							 pattern a-moded)
  #-:CMU
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (special *black-color-no* *GEQIV* *GXOR* *MARK-PAT-NO*)
		   (ignore op pattern))
  (let ((new-op (if (= color 0 *BLACK-COLOR-NO*)
					*GEQIV*
				  *GXOR*))
		(new-color (if (= color -1)
					   *BLACK-COLOR-NO*
					 color)))
  (yy-protocol-30 no (car xys) (second xys)
				  radius theta1 theta2 new-op new-color 
				  *MARK-PAT-NO* a-moded)))

(defun yy-protocol-41-mark (no xys width height theta1 theta2 lwidth op 
							   color dashing)
  #-:CMU
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (special *black-color-no* *GEQIV* *GXOR* *MARK-PAT-NO*)
		   (ignore op))
  (let ((new-op (if (= color 0 *BLACK-COLOR-NO*)
					*GEQIV*
				  *GXOR*))
		(new-color (if (= color -1)
					   *BLACK-COLOR-NO*
					 color)))
  (if (< 0 (length dashing))
	  (yy-protocol-41 no (car xys) (second xys)
				  width height theta1 theta2 lwidth new-op new-color "")
	(yy-protocol-41 no (car xys) (second xys)
					width height theta1 theta2 lwidth new-op color "I")))
  )

(defun yy-protocol-42-mark (no xys width height theta1 theta2 op color pattern
							 arc_mode)
  #-:CMU
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (special *black-color-no* *GEQIV* *GXOR* *MARK-PAT-NO*)
		   (ignore op pattern))
  (let ((new-op (if (= color 0 *BLACK-COLOR-NO*)
					*GEQIV*
				  *GXOR*))
		(new-color (if (= color -1)
					   *BLACK-COLOR-NO*
					 color)))
	(yy-protocol-42 no (car xys) (second xys)
					width height theta1 theta2 new-op new-color 
					*MARK-PAT-NO* arc_mode)))


;;;;;;;;; $@A*BrI=<($N4X?t=*N;(J
