;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; lisp-depend.lisp
;;; $@=hM}7O$K0MB8$7$?4X?t$d%^%/%m$rDj5A(J
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.3.1 92/07/07 by t.kosaka (kosaka@csrl.aoyama.ac.jp)

(in-package :yy)

#+CMU
(declaim (inline csetupserver)
         (inline cwriteinternal)
         (inline cread1internal)
         (inline cread2)
	 (inline caccess)
	 (inline cstore)
	 (inline cstore2)
	 (inline cstoremul)
	 (inline unixselection)
	 (inline gettimer)
	 (inline alamsetup))

#+CMU
(defmacro alam_setup (no)
  `(alamsetup ,no))

;;; current-process
;;; $@8:;&$N%W%m%;%9$r5a$a$k(J
(defun current-process ()
  #+:EXCL
  mp::*current-process*
  #+:lucid
  *current-process*
  #+:symbolics
  SCL:*current-process*
  #-(or :EXCL :lucid :symbolics)
  :CURRENT-PROCESS
  )

;;; RUN-PROCESS
;;; $@%W%m%;%9$r@8@.$7!"<B9T$9$k(J
;;; ARGS. FUNCTION	: $@4X?tL>(J (SYMBOL)
;;;	  ARGS		: FUNCTION$@$N(JARGUMENTS
;;; VALS. FUNCTION-RESULT
(DEFUN RUN-PROCESS (FUNCTION &REST ARGS)
  #+:LUCID
  (declare (special *STACK-SIZE*))
  #+:LUCID
  (lucid::MAKE-PROCESS :NAME (STRING FUNCTION)
		       :FUNCTION 'yy-start-process
		       :ARGS (push function ARGS)
		       :STACK-SIZE *STACK-SIZE*
		       )
  #+:EXCL
  (apply #'MP:PROCESS-RUN-FUNCTION 
	 (STRING FUNCTION) 'yy-start-process (push FUNCTION ARGS))
  #+symbolics
  (progn 
    (apply 'process:PROCESS-RUN-FUNCTION
	   (STRING FUNCTION) 'yy-start-process (push FUNCTION args)))
  #-(OR :LUCID :EXCL symbolics)
  (apply 'yy-start-process (push FUNCTION ARGS))
  )

;;; waite-process
;;; $@>r7o$,@.N)$9$k$^$G%W%m%;%9$rDd;_$9$k(J
;;; ARGS
;;;        function     ; $@>r7o$N4X?t(J
;;;        args         ; $@>r7o4X?t$N0z?t(J
;;; VALS. non-NIL
;;;  update 2.Nov.90 added apply
;;;  update 3.Nov.90 added apply
;;;  update 4.July.92 added apply
(defun wait-process (function &rest args)
  #-:CMU
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (special *event-method-process* *WHOSTATE*))
  #-CMU
  (if (eq *event-loop-process* 
	  (current-process))
      (start-event-loop))

  #+:LUCID
  ;; added apply 3.Nov.90 yohta
  (apply #'lucid::PROCESS-WAIT *WHOSTATE* FUNCTION ARGS)
  #+:EXCL
  ;; added apply 3.Nov.90 yohta
  (apply #'MP:PROCESS-WAIT *WHOSTATE* FUNCTION ARGS)
  #+symbolics
  (apply 'process:process-wait *WHOSTATE* FUNCTION ARGS)
  #-(OR :LUCID :EXCL symbolics)
  (loop 
    (if (apply function ARGS)
		(return))
    (sleep 0.5))
  )


;;; real-waite-process
;;; $@>r7o$,@.N)$9$k$^$G%W%m%;%9$rDd;_$9$k(J
;;; ARGS
;;;        function     ; $@>r7o$N4X?t(J
;;;        args         ; $@>r7o4X?t$N0z?t(J
;;; VALS. non-NIL
;;;  update 2.Nov.90 added apply
;;;  update 3.Nov.90 added apply
;;;  update 4.July.92 added apply
(defun real-wait-process (function &rest args)
  #-:CMU
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (special *event-method-process* *WHOSTATE*))
  #+:LUCID
  ;; added apply 3.Nov.90 yohta
  (apply #'lucid::PROCESS-WAIT *WHOSTATE* FUNCTION ARGS)
  #+:EXCL
  ;; added apply 3.Nov.90 yohta
  (apply #'MP:PROCESS-WAIT *WHOSTATE* FUNCTION ARGS)
  #+symbolics
  (apply 'process:process-wait *WHOSTATE* FUNCTION ARGS)
  #-(OR :LUCID :EXCL symbolics)
  (loop 
    (if (apply function ARGS)
	(return))
    (sleep 0.5))
  )

;;; process-throw 
;;; $@%W%m%;%94V$K$^$?$,$C$F(J
;;; throw $@$r<B9T(J
#-(or symbolics CMU)
(defun process-throw (process tag &rest return)
  (if (eq (current-process) process)
      (throw tag (car return))
      #+:EXCL
      (mp::process-interrupt process 
			     #'(lambda (x) (throw tag x)) (car return))
      #+:LUCID
      (interrupt-process process 
			 #'(lambda (x) (throw tag x)) (car return))
      #-(OR :LUCID :EXCL symbolics)
      (thorw tag return)
      ))

;;; KILLED-PROCESS
;;; $@%W%m%;%9$r>CLG$5$;$k(J
;;; ARGS. PROCESS      : $@%W%m%;%9(J
;;; VALS. non-NIL
(DEFUN KILLED-PROCESS (PROCESS)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  #+:LUCID
  (lucid::kill-process process)
  #+:EXCL
  (unwind-protect
      (mp:process-kill process)
    (setf *yy-process-table* (delete process *yy-process-table*)))
  #+symbolics
  (unwind-protect
      (process:process-kill process)
    (setf *yy-process-table* (delete process *yy-process-table*)))
  #-(OR :LUCID :EXCL symbolics)
  (declare (ignore process))
  nil
  )

;;; $@%W%m%;%9$r0l;~E*$KDd;_$9$k!#(J
(defun disable-process (process)
  #+EXCL
  (if (mp:process-active-p process)
	  (mp:process-disable process)
	nil)
  #+LUCID
  (if (process-active-p process)
	  (deactivate-procee process)
	nil)
  #+SYMBOLICS
  (if (process:active-p process)
	  (process:disable process)
	nil)
  #-(or EXCL LUCID SYMBOLICS)
  nil)

;;; $@%W%m%;%9$r3+;O$9$k(J
(defun enable-process (process)
  #+EXCL
  (mp:process-enable process)
  #+LUCID
  (activate-process process)
  #+SYMBOLICS
  (process:enable process)
  #-(or EXCL LUCID SYMBOLICS)
  nil)



;;; Set -l to sting for LUCID 
(defun set-l (list)
  (let ((ret nil))
    (dotimes (i (length list))
      (push (format nil "-l~a" (nth i list)) ret))
    ret))

;;; 
;;; FOREIGN FUNCTION INTERFACE
;;;
#|
;;; LOAD-FOREIGN
;;; ARGS. FILES		: STRING OR A-LIST-OF-STRINGS
;;;	  LIBRARIES	: STRING OR A-LIST-OF-STRINGS
;;; $@Cm0U!*(J
;;; (1) Math. library is "m" in Allegro Common Lisp,
;;;     but the library is "-lm" in Lucid Common Lisp.
#-symbolics
(DEFUN LOAD-FOREIGN (FILES &rest LIBRARIES)
  #+:LUCID
  (IF LIBRARIES
      (lucid::LOAD-FOREIGN-FILES FILES (set-l LIBRARIES))
      (lucid::LOAD-FOREIGN-FILES FILES))
  #+:EXCL
  (IF LIBRARIES
      (LOAD FILES
	    :SYSTEM-LIBRARIES LIBRARIES)
      (LOAD (IF (CONSP FILES) (CAR FILES) FILES)
	    :FOREIGN-FILES (IF (CONSP FILES) (CDR FILES))))
  #+:CMU
  (extensions:load-foreign files LIBRARIES)
  #-(OR :LUCID :EXCL)
  (ERROR "LOAD-FOREIGN: Sorry. Your LISP implementation is not supported.")
  )
|#

;;; yy-ignore-errors
;;; $@%Q%C%1!<%8$,$3$H$J$k$N$G$^$H$a$k(J
;;; $@;HMQ$O!"(Jignore-erroes $@$HF1$8(J
(defmacro yy-ignore-errors (&rest body)
  #+Symbolics
  `(scl:ignore-errors ,@body)
  #+ExCL
  `(excl::ignore-errors ,@body)
  #-(or Symbolics ExCL)
  `(ignore-errors ,@body)
  )

;;; $@2~9TJ8;z$rJQ99$7$FJ8;z$N%j%9%H$+$i(J
;;; $@%G!<%?$r<h$j=P$9(J
(defun take-out-car-moji (moji-list)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  #+:SYMBOLICS
  (if (char= (car moji-list) #\newline)
      (code-char 10)
      (car moji-list))
  #-:SYMBOLICS
  (car moji-list))

(defun push-car-moji (moji moji-list)
  #+:SYMBOLICS
  (if (= (char-code moji) 10)
	  (push #\newline moji-list)
	(push moji moji-list))
  #-:SYMBOLICS
  (push moji moji-list)
  )
	

;;; UNIX$@2~9TJ8;z$r(JSYMBOLICS$@MQ$KJQ99$9$k(J
(defun real-line-feed-char (char)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  #+:symbolics
  (case 
    (char-code char)
    ((10 13)
     #\linefeed)
    (t
      char))
  char)

(defun make-real-read-string (my-list)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (coerce my-list 'simple-string))

#|  (coerce (mapcan #'(lambda (x) (if (char= x #\") 
;									  (list #\\ #\")
									(list #\")
									(list x)))
					my-list) 'simple-string))
|#

(defun read-end-check (string cr-flg)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((ret-val1 nil) (ret-val2 nil))
	(multiple-value-setq
      (ret-val1 ret-val2)
      ;; 13.Aug.90 yohta added #+ExCL and #-ExCL
      (yy-ignore-errors
	   (read-from-string string)))
	
    ;; Modifyed by Yohta on 2.Nov.90
    ;; For ignore-errors of multi-lisp-implementation.
    ;; On case of Symbolics, 
    ;; 2nd returned value is error condition.
    ;; But the other case, 
    ;; 2nd returned value is last form result or
    ;; error condition.

	(if #-:Symbolics (numberp ret-val2)
	    #+:Symbolics (not ret-val2)
		(typecase 
		 ret-val1
		 ((or cons CHARACTER SIMPLE-ARRAY) T)
		 (t 
		  (if cr-flg
			  (typecase 
			   ret-val1
			   ((or SYMBOL number COMPLEX) T)
			   (t
				nil))
			nil)))
		nil)
  ))


;;; $@J8;zNs%j%9%H$K(JUNIX$@$N2~9TJ8;z$,$"$l$P!"(J
;;; LISP$@$N2~9T%3!<%I$KJQ49$9$k(J
(defun change-to-real-line-feed (string)
  #+:SYMBOLICS
  (dotimes 
    (i (length string))
    (if (or (= 10 (char-code (char string i)))
	    (= 13 (char-code (char string i))))
	(setf (char string i) #\Newline)))
  string)


;;;defne lock.
#+Symbolics
(defvar *fd-lock* (process:make-lock "YY port 1 lock"
				     :recursive t))

;;; SIGALAM$@$NDd;_(J
#+CMU
(defun stop-sigalm ()
  (without-interrupts
   (enable-interrupt 14 #'dummy)
   (alam_setup 0)))

;;; alam$@$N$?$a$N%@%_!<4X?t(J (CMU)
#+CMU
(defun dummy (signal code scp)
  (declare (ignore signal code scp)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  )

;;; sigalme $@$G(J $@DLCN=hM}$r5/F0$9$k(J (CMU)
#+CMU 
(defun tuuchi-start (signal code scp)
  (declare (ignore signal code scp)
	   (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (special *tuuchi-function*))
  (if *tuuchi-function*
      (funcall *tuuchi-function*)
      )
  )

;;;
;;; PRTCLIF.C $@$KBP1~$9$k(J SYMBOLICS $@$N$?$a$N(J LISP $@%3!<%IDj5A!#(J
;;;
;;; $@%W%m%;%94VDL?.$N$?$a$N%$%s%?%U%'!<%9(J
;;;  
#+Symbolics
(defvar *fd1* nil)
#+Symbolics
(defvar *fd2* nil)
#+Symbolics
(defvar *YYMAGIC* 14876.)
#+Symbolics
(defvar *YYPROTO-INET-PORT* 6750)
#+Symbolics
(defvar *null-string* (make-string 4))

#+Symbolics
;;; YY $@%5!<%P$N$?$a$N!"(J TCP $@%]!<%H$r%*!<%W%s$9$k!#(J
;;; $@$?$@$7!"(JTCP $@0J30$N@\B3$OL59MN8!#(J
(defun open-yy-stream (host no port)
  (let ((host (net:parse-host host)))
    (if (< no 0)
	(tcp:open-tcp-stream host port nil :characters nil)
	(tcp:open-tcp-stream host (+ *YYPROTO-INET-PORT* no) nil :characters nil))))
       

#+Symbolics
;;;$@$R$H$D$N(J FIXNUM $@$r%P%$%HG[Ns$KJQ49$9$k!#(J
(defun fixnum-to-byte-array (fixnum)	
  (coerce (multiple-value-list (fixnum-to-bytes fixnum)) '(array (unsigned-byte 8))))

#+Symbolics
;;;;$@$R$H$D$N%9%H%j%s%0$r%P%$%HG[Ns$KJQ49$9$k!#(J
(defun string-to-byte-array (string &optional (size 0))
  (when (> size (length string))
    (setq string (zl:array-grow string size)))
  (scl:string-to-ascii string))
 

#+Symbolics
;;;$@%P%$%HG[Ns$N(J start $@$+$i(J end $@$^$G$r!"(Jfixnum $@$N%j%9%H$K$7$FJV$9!#(J
(defun byte-array-to-multi-fixnum (byte-array start end)
  (loop for i from start below end by 4
	collect
	  (logior (ash (aref byte-array (+ 0 i)) 24)
		  (ash (aref byte-array (+ 1 i)) 16)
		  (ash (aref byte-array (+ 2 i)) 8)
		  (aref byte-array (+ 3 i)))))

#+Symbolics
;;;$@%P%$%HG[Ns$N(J start $@$+$i(J end $@$^$G$r!"(Jfixnum $@$K$7$FJV$9!#(J
;;;$@C"$7!"(J(- end start) $@$O(J 4 $@$G$J$1$l$P$J$i$J$$!#(J($@%N!<%A%'%C%/(J)
(defun byte-array-to-fixnum (byte-array start end)
  (loop finally (return fixnum)
	with fixnum = 0
	for i from start below end
	do
    (setq fixnum (logior (ash fixnum (* (- i start) 8))
			 (aref byte-array i)))))

#+Symbolics
;;;$@%P%$%HG[Ns$N(J start $@$+$i(J end $@$^$G$r!"%9%H%j%s%0$H$7$FJV$9!#(J
(defun byte-array-to-string (byte-array start end)
  (let ((ascii-string (subseq byte-array start end)))
    ;;Yy $@%5!<%P$+$i(J NULL $@%9%H%j%s%0$,E>Aw$5$l$?;~!"(Jnil $@$rLa$jCM$H$9$k!#(J
    ;;UNIX(C) $@$N(J NULL $@%9%H%j%s%0$,!"(JSymbolics $@$G$O(J $@%;%s%?%I%C%H$,FbMF$N(J
    ;;$@%9%H%j%s%0$H$7$F07$o$l$k!#$=$l$rHr$1$k$?$a$K>r7oDI2C!#(J
    (if (= (aref ascii-string 0) 0)
	nil
	(scl:ascii-to-string ascii-string))))
  
#+Symbolics
;;;YY $@%5!<%P$N8GDjD9%G!<%?(J($@%G!<%?%?%$%W(J: fixnum)$@$rFI$_9~$s$G%j%9%H$K$7$FJV$9!#(J
(defun read-yy-fixed-data (stream count-of-segment)
  (let* ((byte-count (* count-of-segment 4))
	 (byte-array (make-array byte-count
				 :element-type '(unsigned-byte 8))))
    (scl:send stream :string-in nil byte-array 0 byte-count)
    (byte-array-to-multi-fixnum byte-array 0 byte-count)))	

#+Symbolics
;;;$@%j%W%i%$%Q%1%C%HFb$N2DJQD9%G!<%?$N(J length $@$N%9%H%"$N$?$a$N(J ID.
(defvar *yy-server-reply-length-variable*
	'(:server-host-id-length :port-number-length 
	  :invent-host-id-length :invent-port-number-length))

#+Symbolics
;;;$@%j%W%i%$%Q%1%C%HFb$N<B:]$N2DJQD9%G!<%?$N%9%H%"$N$?$a$N(J ID.
(defvar *yy-server-reply-data-variable*
	'(:server-host-id :port-number :invent-host-id :invent-port-number))

#+symbolics
;;;UNIX C $@$N(J NULL $@%9%H%j%s%0$r8+$D$1$k$?$a$KMQ0U!#(J
(defvar *null-character* (code-char 0))

#+Symbolics
;;;YY $@%5!<%P$N2DJQD9%G!<%?(J($@%G!<%?%?%$%W(J: $@%9%H%j%s%0(J)$@$rFI$_9~$s$G%j%9%H$K$7$FJV$9!#(J
;;;  $@Nc(J) '($@%"%$%F%`L>(J $@CM(J $@%"%$%F%`L>(J $@CM(J ...)
(defun read-yy-variable-data (stream count-of-segment)
  (let* ((list-of-variable-data nil)
	 (variable-data-length 0)
	 (start-pos 0)
	 (end-pos 0)
	 (byte-count (* count-of-segment 4))
	 (byte-array (make-array byte-count
				 :element-type '(unsigned-byte 8))))

    ;;$@2DJQD9%G!<%?$NFI$_9~$_!#$?$@$7!"7?JQ49$O9T$J$o$:A4$F%P%$%J%j%G!<%?!#(J
    (scl:send stream :string-in nil byte-array 0 byte-count)

    ;;$@%G!<%?D9$r%A%'%C%/$7$F!"J8;zNs$H$N%Z%"%j%9%H$r:n@.$9$k!#(J
    (loop finally (return list-of-variable-data)
	  with string-or-fixnum
	  with segument-idx = 0
	  for length-variable in *yy-server-reply-length-variable*
	  for data-variable in *yy-server-reply-data-variable*
	  doing
      (setq start-pos (* segument-idx 4)
	    end-pos (+ start-pos 4))
      
      ;;4$@%*%/%F%C%H$N%P%$%H%G!<%?$+$i3F2DJQ%G!<%?$N%G!<%?D9$r5a$a$k!#(J
      (setq variable-data-length
	    ;;$@3F2DJQ%G!<%?D9$rFI$_9~$_!"<!$N2DJQ%G!<%?$N(J byte-array $@Cf$N%]%7%7%g%s$r(J
	    ;;$@%;%C%H$9$k!#(J
	    (byte-array-to-fixnum byte-array start-pos end-pos)
	    segument-idx (+ segument-idx 1))

      ;;$@2DJQ%G!<%?$N%G!<%?D9$r%;%C%H!#(J
;      (push (list length-variable variable-data-length)
;	    list-of-variable-data)
      (push variable-data-length list-of-variable-data)
      (push length-variable list-of-variable-data)
						
      (if (<= variable-data-length 0)
;	  (push (list data-variable nil) list-of-variable-data)
	  (progn
	    (push nil list-of-variable-data)
	    (push data-variable list-of-variable-data))
	  (progn
	    (setq start-pos end-pos
		  end-pos (+ start-pos variable-data-length)
		  string-or-fixnum
		  (if (member data-variable '(:server-host-id :invent-host-id))
		      (byte-array-to-string byte-array start-pos end-pos)
		      (byte-array-to-fixnum byte-array start-pos end-pos))
		  segument-idx (+ segument-idx 1))
;	    (push
;	      (list data-variable string-or-fixnum) list-of-variable-data)
	    (push string-or-fixnum list-of-variable-data)
	    (push data-variable list-of-variable-data)
	    ))
      )))


#+Symbolics
;;;$@;XDj$5$l$?%9%H%j!<%`(J(YY $@%5!<%P$X$N(J TCP $@%M%C%H%o!<%/%]!<%H(J)$@$X!"%P%$%H%G!<%?$r=q$-9~$`!#(J
(defun write-yy-data (data start end &optional stream)
  (scl:send stream :string-out data start end)
  (scl:send stream :force-output))

;;;
;;; $@%W%m%;%94VDL?.$N$?$a$N6&DL4X?tDj5A(J
;;; Symbolics $@$O!"(JLisp $@$G5-=R!"(JUNIX$@>e$N=hM}7O$O!"(JC$@8@8l$G5-=R(J
;;; 

;;; YY$@%5!<%P$H$N%;%C%H%"%C%W(J
#+LUCID
(lucid::def-foreign-function (c_setup_server 
			       (:return-type :fixnum))
			     (no :fixnum)
			     (string :simple-vector-type)
			     (dnumber :fixnum)
			     (user_name :simple-vector-type)
			     (passwd :simple-vector-type))
#+EXCL
(ff:defforeign 'c_setup_server
	       :arguments '(fixnum (array (unsigned-byte 8)) fixnum
				   (array (unsigned-byte 8))
				   (array (unsigned-byte 8)))
	       :return-type :fixnum)

#+CMU
(defun make-c-string (size)
  (make-string size))

#+CMU
(defun c_setup_server (network hostname dnumber user-name passwd)
  (let ((a-hostname (make-c-string (length hostname)))
		(a-user-name (make-c-string (length user-name)))
		(a-passwd (make-c-string (length passwd))))

    (format t "Args are :~a ~a ~%" hostname a-hostname)
    (dotimes (i (length hostname))
      (setf (char a-hostname i) (char hostname i)))

    (dotimes (i (length user-name))
      (setf (char a-user-name i) (char user-name i)))

    (dotimes (i (length passwd))
      (setf (char a-passwd i) (char passwd i)))
    (csetupserver network a-hostname dnumber "" ""))
  )

#+Symbolics
(defun c_setup_server (network hostname dnumber user-name passwd)
  ;; $@%m!<%+%k%[%9%H$N(J YY $@%5!<%P$H%3%M%/%H$9$k$N$+%A%'%C%/(J!!
  ;; 10 Feb 92, Symbolics $@$K(J YY $@%5!<%P$OB8:_$7$J$$$N$G!"(J
  ;; $@I,$:(J Internet $@@\B3$H$J$k!#(J
  (if (= network 1)
      (setf *fd1* (open-yy-stream hostname dnumber 0))
      (setf *fd1* (open-yy-stream net:local-host *YYPROTO-INET-PORT* dnumber))	
      )

  ;;$@=i4|%Q%1%C%HAw?.(J
  (let* ((user-name-length (length user-name))	;$@<B:]$NM-8zJ8;zNs?t(J
	 (passwd-length (length passwd))	;$@<B:]$NM-8zJ8;zNs?t(J
	 (paded-user-name-length (floor (+ user-name-length 3) 4))
	 (paded-passwd-length (floor (+ passwd-length 3) 4))
	 ;;$@%H!<%?%k%5%$%:$O@\B3%f!<%6<1JL;R$H@\B3%f!<%6G'>Z%G!<%?$NM-L5$K$h$j!"2DJQ!#(J 
	 (total-packet-size (+ 6
			       paded-user-name-length	;$@%Q%C%G%#%s%0$5$l$?J8;zNs?t(J
			       paded-passwd-length)))	;$@%Q%C%G%#%s%0$5$l$?J8;zNs?t(J

    ;;YY $@%5!<%P$X$N%M%C%H%o!<%/%9%H%j!<%`$N=i4|2=!#(J
    (scl:send *fd1* :clear-output)

    ;;YY $@%W%m%H%3%k<1JL(J ID $@$NE>Aw!#(J
    (write-yy-data (fixnum-to-byte-array *YYMAGIC*) 0 4 *fd1*)

    ;;$@%P!<%8%g%s<1JL;R$NE>Aw!#(J
    (write-yy-data (fixnum-to-byte-array 0) 0 4 *fd1*)
    
    ;;Connection $@<oJL$NE>Aw!#(J
    (write-yy-data (fixnum-to-byte-array 0) 0 4 *fd1*)

    ;;$@A4BN$ND9$5(J($@%V%m%C%/?t(J)$@$NE>Aw!#(J
    (write-yy-data (fixnum-to-byte-array total-packet-size) 0 4 *fd1*)

    ;;$@4uK>%Q%1%C%H:GBgD9(J($@%V%m%C%/?t(J)$@$NE>Aw!#(J
    (write-yy-data (fixnum-to-byte-array 256) 0 4 *fd1*)
    
    ;;$@@\B3%f!<%6<1JL;R(J($@D9$5(J)$@$NE>Aw!#$?$@$7!"$=$ND9$5$O<B:]$N%f!<%6%M!<%`J8;zNs?t!#(J
    (write-yy-data (fixnum-to-byte-array user-name-length) 0 4 *fd1*)

    (when (> user-name-length 0)		
      ;;$@@\B3%f!<%6<1JL;R(J($@J8;zNs(J)$@$NE>Aw!#$?$@$7!"J8;zNs$K$O%Q%G%#%s%0$5$l$?J8;z$b4^$`!#(J
      ;;(floor (+ user-name-length 3) 4)$@$O!"%Q%G%#%s%0J8;z$r4^$`J8;zNs?t$r5a$a$k!#(J
      (write-yy-data (string-to-byte-array user-name paded-user-name-length)
		     0 (floor (+ user-name-length 3) 4) *fd1*))

    ;;$@@\B3%f!<%6G'>Z%G!<%?(J($@D9$5(J)$@$NE>Aw!#$?$@$7!"$=$ND9$5$O<B:]$N%Q%9%o!<%IJ8;zNs?t!#(J
    (write-yy-data (fixnum-to-byte-array passwd-length) 0 4 *fd1*)

    (when (> passwd-length 0)			
      ;;$@@\B3%f!<%6G'>Z%G!<%?(J($@J8;zNs(J)$@$NE>Aw!#$?$@$7!"J8;zNs$K$O%Q%G%#%s%0$5$l$?J8;z$b4^$`!#(J
      ;;(floor (+ passwd-length 3) 4)$@$O!"%Q%G%#%s%0J8;z$r4^$`J8;zNs?t$r5a$a$k!#(J
      (write-yy-data (string-to-byte-array passwd-length paded-passwd-length)
		     0 (floor (+ passwd-length 3) 4) *fd1*))

    ;;$@%9!<%Q(J YY $@%5!<%P$+$i$N<u?.!#(J
    ;;$@<u?.%G!<%?$O!"8GDjD9%G!<%?(J(fixnum)$@$H2DJQD9%G!<%?%"%$%F%`L>$HCM$N%j%9%H$rMWAG$H$9$k(J($@O"A[(J)$@%j%9%H$H$9$k!#(J 
    (let* ((fix-data (read-yy-fixed-data *fd1* 6))	;$@8GDjD9%G!<%?$NFI$_9~$_!#(J
	   (variable-data			;$@2DJQD9%G!<%?$NFI$_9~$_!#(J
	     (read-yy-variable-data *fd1* (- (nth 2 fix-data) 6))))	
    
      (cond ((/= (getf variable-data :server-host-id-length)
;		  (get-variable-data :server-host-id-length variable-data)
		 0)
	     (close *fd1*)

	     (if (getf variable-data :server-host-id)
;		  (get-variable-data :server-host-id variable-data) 
		 (setq *fd1*
		       (open-yy-stream
			 (getf variable-data :server-host-id)
;			  (get-variable-data :server-host-id variable-data)
			 -1
			 (getf variable-data :port-number)
;			  (get-variable-data :port-number variable-data)
			 ))
		 (setq *fd1*
		       (open-yy-stream
			 hostname
			 -1
			 (getf variable-data :port-number)
;			  (get-variable-data :port-number variable-data)
			 )))

	     (if (/= (getf variable-data :invent-host-id-length)
;		      (get-variable-data :invent-host-id-length variable-data)
		     0)
		 (if (getf variable-data :invent-host-id)
;		      (get-variable-data :invent-host-id variable-data)
		     (setq *fd2*
			   (open-yy-stream
			     (getf variable-data :invent-host-id)
;			      (get-variable-data :invent-host-id variable-data)
			     -1
			     (getf variable-data :invent-port-number)
;			      (get-variable-data :invent-port-number variable-data)
			     ))
		     (setq *fd2*
			   (open-yy-stream
			     hostname
			     -1
			     (getf variable-data :invent-port-number)
;			      (get-variable-data :invent-port-number variable-data)
			     )))
		 (error
		   "Yy Server isn't support on Genara, ~
                     so you must connect Yy Server via Internet."))
	     )
	    (t
	     ;;0 $@$O(J UNIX $@%I%a%$%s!"(J1 $@$O(J Inet $@%I%a%$%s$N%M%C%H%o!<%/@\B3$r0UL#$9$k!#(J
	     (if (/= (getf variable-data :invent-host-id-length)
;		     (get-variable-data :invent-host-id-length variable-data)
		     0)
		 ;;$@>r7o@.N)It$O(J *fd1* $@$H0[$J$k%[%9%H$K!"IT@.N)It$OF1$8%[%9%H$K%M%C%H%o!<%/@\B3(J
		 ;;$@$r;n$_$k!#(J($@%P!<%8%g%s(J1.3.1 $@$G$O!"I,$:F1$8%[%9%H$K@\B3$r9T$J$&!#(J)
		 (if (getf variable-data :invent-host-id)
;		     (get-variable-data :invent-host-id variable-data)
		     (setq *fd2*
			   (open-yy-stream
			     (getf variable-data :invent-host-id)
;			     (get-variable-data :invent-host-id variable-data)
			     -1
			     (getf variable-data :invent-port-number)
;			     (get-variable-data :invent-port-number variable-data)
			     ))
		     (setq *fd2*
			   (open-yy-stream
			     hostname
			     -1
			     (getf variable-data :invent-port-number)
;			    (get-variable-data :invent-port-number variable-data)
			     )))
		 (error
		   "Genera doesn't support Yy Server,~
                    so you must connect Yy Server via Internet."))
	     ))
      (elt fix-data 3))))
;;; YY$@%5!<%P$H$N%;%C%H%"%C%W(J $@$3$3$^$G(J

;;; $@DL?.%]!<%H$K%G!<%?$rE>Aw(J
#+LUCID
(lucid::def-foreign-function (c_write_internal
			       (:return-type :fixnum))
			     (string :simple-vector-type)
			     (no :fixnum))
#+EXCL
(ff:defforeign 'c_write_internal
	       :arguments '((array (unsigned-byte 8)) fixnum)
	       :return-type :fixnum)

#+CMU
(defmacro c_write_internal (data len)
  `(cwriteinternal ,data ,len))

#+Symbolics
(defun c_write_internal (pack lng)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((array (make-array (* 4 lng) :element-type '(unsigned-byte 8)
			   :displaced-to pack))
;	(string (make-array (* 4 lng) :element-type 'string-char
;			    :displaced-to pack))
	)
    (scl:send *fd1* :string-out array 0 (* lng 4))
    (scl:send *fd1* :force-output)
    ))

;;; $@DL?.%]!<%H$+$i%G!<%?F@$k(J
#+LUCID
(lucid::def-foreign-function (c_read1_internal
			       (:return-type :fixnum))
			     (string :simple-vector-type)
			     (no :fixnum))
#+EXCL
(ff:defforeign 'c_read1_internal
	       :arguments '((array (unsigned-byte 8)) fixnum)
	       :return-type :fixnum)

#+CMU
(defmacro c_read1_internal (data no)
  `(cread1internal ,data ,no))

#+LUCID
(lucid::def-foreign-function (c_read1_no_wait
			       (:return-type :fixnum))
			     (string :simple-vector-type)
			     (no :fixnum))
#+EXCL
(ff:defforeign 'c_read1_no_wait
	       :arguments '((array (unsigned-byte 8)) fixnum)
	       :return-type :fixnum)

#+Symbolics
(defun c_read1_internal (retpack retlng)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((array (make-array (* 4 retlng) :element-type '(unsigned-byte 8)
			   :displaced-to retpack))
;	(string (make-array (* 4 retlng) :element-type 'string-char
;			    :displaced-to retpack))
	)
    (scl:send *fd1* :string-in nil array 0 (* retlng 4))
    ))

;;; $@F~NOMQDL?.%]!<%H$+$i%G!<%?$rF@$k(J
#+LUCID
(lucid::def-foreign-function (c_read2
			       (:return-type :fixnum))
			     (string :simple-vector-type)
			     (no :fixnum)
			     (byte :fixnum))
#+EXCL
(ff:defforeign 'c_read2
	       :arguments '((array (unsigned-byte 8)) fixnum fixnum)
	       :return-type :fixnum)

#+CMU
(defmacro c_read2 (data no count)
  `(cread2 ,data ,no ,count))

#+Symbolics
(defun c_read2 (retpack retlng &optional (start 0))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((array (make-array (+ start (* 4 retlng)) 
			   :element-type '(unsigned-byte 8)
			   :displaced-to retpack))
;	(string (make-array (+ start (* 4 retlng)) :element-type 'string-char
;			    :displaced-to retpack))
	)
    (scl:send *fd2* :string-in nil array start (+ start (* retlng 4)))
    ))

;;; $@%Q%1%C%H$+$i%G!<%?$r<h$j=P$9(J
#+(or Symbolics Lucid EXCL)
;;; element-type is changed to '(unsigned-byte 8)
(defun c_access (data no)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (vector data)
		   (integer no))
  (let ((n (* no 4)))
	#-EXCL
    (logior (ash (svref data n) 24)
			(ash (svref data (+ 1 n)) 16)
			(ash (svref data (+ 2 n))  8)
			(ash (svref data (+ 3 n))  0))
	#+EXCL
    (logior (ash (aref data (+ 0 n)) 24)
			(ash (aref data (+ 1 n)) 16)
			(ash (aref data (+ 2 n))  8)
			(ash (aref data (+ 3 n))  0))

	)
)

#+:CMU
(defsetf c_access c_store)

#+:CMU
;;; element-type is changed to '(unsigned-byte 8)
(defun c_access (data no)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (string data)
		   (fixnum no))
  (let ((n (* no 4)))
    (logior (ash (char-code (char data (+ 0 n))) 24)
			(ash (char-code (char data (+ 1 n))) 16)
			(ash (char-code (char data (+ 2 n)))  8)
			(ash (char-code (char data (+ 3 n)))  0))
	)
)

#+(or EXCL LUCID)
(defsetf c_access c_store)

;;; $@%Q%1%C%H$X%G!<%?=q$-9~$`(J
#+(or Symbolics Lucid EXCL)
(defun c_store (data no1 no2)
  (declare (integer no1 no2)
		   (vector data)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((n (* no1 4)))
	#-EXCL
	(setf (svref data  n) (ldb (byte 8 24) no2)
		  (svref data (+ 1 n)) (ldb (byte 8 16) no2)
		  (svref data (+ 2 n)) (ldb (byte 8 8)  no2)
		  (svref data (+ 3 n)) (ldb (byte 8 0)  no2))
	#+EXCL
	(setf (aref data (+ 0 n)) (ldb (byte 8 24) no2)
		  (aref data (+ 1 n)) (ldb (byte 8 16) no2)
		  (aref data (+ 2 n)) (ldb (byte 8 8)  no2)
		  (aref data (+ 3 n)) (ldb (byte 8 0)  no2))

	;(format t "~%~d ~d ~d ~d" (aref data (+ 0 n))
		;	(aref data (+ 1 n)) (aref data (+ 2 n)) (aref data (+ 3 n)))
	)
  )

#+:CMU
(defun c_store (data no1 no2)
  (declare (integer no2)
		   (fixnum no1)
		   (string data)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((n (* no1 4)))
	(setf (char data (+ 0 n)) (code-char (ldb (byte 8 24) no2))
		  (char data (+ 1 n)) (code-char (ldb (byte 8 16) no2))
		  (char data (+ 2 n)) (code-char (ldb (byte 8 8)  no2))
		  (char data (+ 3 n)) (code-char (ldb (byte 8 0)  no2)))

	;(format t "~%~d ~d ~d ~d" (aref data (+ 0 n))
		;	(aref data (+ 1 n)) (aref data (+ 2 n)) (aref data (+ 3 n)))
	)
  )

;;; $@%Q%1%C%H$r%G!<%?$K=q$-9~$`(J
#+(or Symbolics Lucid EXCL)
(defun c_store2 (data no1 no2)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (integer no1 no2)
		   (vector data))
  (let ((n (* no1 4)))
	#-EXCL
    (setf (svref data n) (get-one-byte no2 3)
		  (svref data (+ 1 n)) (get-one-byte no2 2)
		  (svref data (+ 2 n)) (get-one-byte no2 1)
		  (svref data (+ 3 n)) (get-one-byte no2 0))
	#+EXCL
    (setf (aref data n) (get-one-byte no2 3)
		  (aref data (+ 1 n)) (get-one-byte no2 2)
		  (aref data (+ 2 n)) (get-one-byte no2 1)
		  (aref data (+ 3 n)) (get-one-byte no2 0))
	  ))

#+:CMU
(defun c_store2 (data no1 no2)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (fixnum no1)
		   (integer no2)
		   (string data))
  (c_store data no1 no2))


;;; $@%Q%1%C%H$KJ8;zNs$r=q$-9~$`(J
#+LUCID
(lucid::def-foreign-function (c_store_string
			       (:return-type :unsigned-32bit))
			     (string :simple-vector-type)
			     (no :fixnum)
			     (data :simple-string)
			     (start :fixnum)
			     (length :fixnum))

#+(and EXCL (not ICS))
(ff:defforeign 'c_store_string 
	       :arguments '((array (unsigned-byte 8))
			    fixnum simple-string fixnum fixnum)
	       :return-type :integer)

#+CMU
(defun c_store_string (pack no data start length)
  #-CMU
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((offset (* no 4)))
    (dotimes 
      (i length)
      (setf (char pack (+ i offset)) (char data (+ i start))))
    length
    ))
	
#+Symbolics
(defun c_store_string (pack no string start end)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (loop for i from start below end
	for j from (* 4 no) 
	do
    (setf (aref pack j) (char-code (aref string i))))
  end)

;;; $@9q:]J8;zNsBP1~$N>l9g(J
#+(and EXCL ICS)
(ff:defforeign 'c_store_string_ics
	       :arguments '((array (unsigned-byte 8))
                            fixnum simple-string fixnum fixnum)
               :return-type :integer)

;;; $@%$%a!<%8%Y%/%?!<$r%Q%1%C%H$K@_Dj$9$k(J
#+LUCID
(lucid::def-foreign-function (c_store_vector
			       (:return-type :unsigned-32bit))
			     (string :simple-vector-type)
			     (no :fixnum)
			     (data :simple-vector-type)
			     (start :fixnum)
			     (length :fixnum))
#+EXCL
(ff:defforeign 'c_store_vector
	       :arguments '((array (unsigned-byte 8))
			    fixnum (array (unsigned-byte 8)) fixnum fixnum)
	       :return-type :integer)
#+CMU
(defun c_store_vector (pack no data start length)
  #-CMU
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((offset (* no 4)))
    (dotimes 
      (i length)
      (setf (char pack (+ i offset)) (code-char (aref data (+ i start)))))
    )
  length)

#+Symbolics
(defun c_store_vector (pack no string start length)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (loop for i from start below (+ length start)
	for j from (* 4 no) 
	do
    (setf (aref pack j) (aref string i)))
  length)

;;; $@%/%m!<%:(J
#+LUCID
(lucid::def-foreign-function (c_close
			       (:return-type :unsigned-32bit)))
#+EXCL
(ff:defforeign 'c_close
	       :return-type :integer)

;;; $@B?=E0z?t$N@_Dj(J
#+ (OR Symbolics Lucid Excl CMU)
(defun c_store_mul (pack no d1 d2 d3 d4 d5 d6 d7 d8 d9 d10)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (integer no))
  (c_store2 pack no d1)
  (c_store2 pack (+ no 1) d2)
  (c_store2 pack (+ no 2) d3)
  (c_store2 pack (+ no 3) d4)
  (c_store2 pack (+ no 4) d5)
  (c_store2 pack (+ no 5) d6)
  (c_store2 pack (+ no 6) d7)
  (c_store2 pack (+ no 7) d8)
  (c_store2 pack (+ no 8) d9)
  (c_store2 pack (+ no 9) d10))
  
;;; selection  (EXCL)
#+EXCL
(ff:defforeign 'unix_selection
	       :arguments '(fixnum)
	       :return-type :integer)

#+CMU
(defmacro unix_selection (no)
  `(unixselection ,no))

(defun get-max-message-size ()
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (special *max-message-size*))
  *max-message-size*)
  
  
;;; $@%Q%1%C%H$N@8@.(J
#-:CMU
(defun make-packet (&optional (packet-size (get-max-message-size)))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (integer packet-size))
  (make-array (* packet-size 4) :element-type '(unsigned-byte 8))
  )

#+:CMU
(defun make-packet (&optional (packet-size (get-max-message-size)))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (integer packet-size))
  (make-string (* packet-size 4))
  )

;;; real-length
;;; $@J8;zNs$N(JEUC$@$H$7$?;~$ND9$5$r5a$a$k(J
;;; (real-length string)
;;; args. string = $@J8;zNs(J
;;; vsl.  EUC$@$G$NJ8;z?t(J
;;; added Symbolics 31.Oct.90
(defun real-length (string)
  (declare
    #-CMU
    (inline > incf)
    (optimize (compilation-speed 0) (speed 3) (safety 0))
	(array string))
  #+(or LUCID CMU (and EXCL (not ICS)) Symbolics)
  (length string)
  #+(and EXCL ICS)
  (let ((count 0)
	(len (length string)))
    (dotimes (i len)
      (if (> (char-code (char string i)) #xA1)
	  ;;; $@4A;z(J
	  (incf count 2)
	  (incf count 1)))
    count))

;;; End of file
