;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;;  Active-region 
;;;  active-region.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka
;;;   updata 1.21 90/11/06 by T.kosaka

;;; $@%"%/%F%#%V%j!<%8%g%s%s%/%i%9(J
;;; 6/14 1990 $@8E:d(J
;;; Version 1.0   Coded by t.kosaka 1990-6-14

(in-package :yy)

;;; active-region$@$r>C5n$9$k(J
;;; flush-active-region active-region &optioanal (territory T)
;;; ARG.
;;;          active-region = $@%"%/%F%#%V%j!<%8%g%s(J
;;;          territory     = $@$b$7(JT$@$J$i$P!"%F%j%H%j!<$N>C5n(J
(defmethod flush-active-region ((a-region active-region)
				&optional (territory T))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (dolist (item (active-region-list a-region))
	  (flush-active-region item NIL))
  
  ;;; $@4XO"IU$1$r2r=|(J
  (delete-lisp-object (active-region-territory-no a-region))

  ;;;  $@?F$N$+$i<+J,$r<h$j=|$/(J
  (setf (active-region-list (active-region-parent a-region))
	(delete a-region 
		(active-region-list (active-region-parent a-region))))

  ;;; $@%F%j%H%j!<$NGK2u(J
  (if territory
      (yy-protocol-5 (active-region-territory-no a-region)))

  (setf (active-region-territory-no a-region) nil))


;;; print-object
(defmethod  print-object ((object active-region) stream)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots 
   (left bottom width height) object
   (format stream "\#<Active Region :Left ~a :Bottom ~a :Width ~a :Height ~a>"
	left bottom width height)))

;;; parent-stream
(defmethod parent-stream ((object active-region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (parent-stream (active-region-parent object)))

;;; $@%"%/%F%#%V%j!<%8%g%s$N$?$a$N?F$+$i$N(Jleft$@$rJV$9(J
(defgeneric real-left (parent x)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (:method ((parent active-region) x)
	   x)
  (:method ((parent window-stream) x)
	   (+ (world-x-start parent) x)))

;;; $@%"%/%F%#%V%j!<%8%g%s$N$?$a$N?F$+$i$N(Jbottom$@$rJV$9(J
(defgeneric real-bottom (parent y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (:method ((parent active-region) y)
	   y)
  (:method ((parent window-stream) y)
	   (+ (with-translate-coordinate-stream y parent)
			    (world-y-start parent))
	   ))

;;; $@%"%/%F%#%V%j!<%8%g%s$N$?$a$N?F$N%F%j%H%j!<HV9f$rJV$9(J
(defgeneric parent-territory-no (parent)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (:method ((parent window-stream))
	   (world-territory-no parent))
  (:method ((parent active-region))
	   (active-region-territory-no parent)))

;;; $@%"%/%F%#%V%j!<%8%g%s@8@.(J
(defun make-active-region (&rest rest 
			   &key (region  nil)
				(left 0) (right 0)
				(top 0) (bottom 0)
				(width nil) (height nil)
				(parent *ROOT-WINDOW*)
				(button1-method nil)
				(left-button-down-1-method nil)
				(middle-button-down-1-method nil)
				(right-button-down-1-method nil)
				(button-up-method nil)
				(left-button-up-method nil)
				(middle-button-up-method nil)
				(right-button-up-method nil)
				(button2-method nil)
				(left-button-down-2-method nil)
				(middle-button-down-2-method nil)
				(right-button-down-2-method nil)
				(move-mouse-cursor-method nil)
				(mouse-cursor-in-method nil)
				(mouse-cursor-out-method nil)
				(mouse-cursor-wait-method nil)
				(class 'active-region)
				&allow-other-keys
				)
  (declare (inline +)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((lleft (if region
		   (region-left region)
		 left))
	 (bbottom (if region 
		     (region-bottom region)
		   bottom))
	 (rright (if region
		    (region-right region)
		   (if width
		       (+ left width)
		     right)))
	 (ttop (if region
		  (region-top region)
		 (if height
		     (+ bottom height)
		   top))))
	 
  (apply #'make-instance 
	 class
	 :left lleft
	 :right rright
	 :bottom bbottom
	 :top ttop
	 :active-region-parent parent
	 :button-1 button1-method
	 :left-button-down-1 left-button-down-1-method
	 :middle-button-down-1 middle-button-down-1-method
	 :right-button-down-1 right-button-down-1-method
	 :button-up button-up-method
	 :left-button-up left-button-up-method
	 :middle-button-up middle-button-up-method
	 :right-button-up right-button-up-method
	 :button-2 button2-method
	 :left-button-down-2 left-button-down-2-method
	 :middle-button-down-2 middle-button-down-2-method
	 :right-button-down-2 right-button-down-2-method
	 :move-mouse-cursor move-mouse-cursor-method
	 :mouse-cursor-in mouse-cursor-in-method
	 :mouse-cursor-out mouse-cursor-out-method
	 :mouse-cursor-wait mouse-cursor-wait-method rest))
)

(defmethod initialize-instance :after ((instance active-region) &rest arg &key &allow-other-keys)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((t-no 0)
	(left (region-left instance))
	(bottom (region-bottom instance))
	(parent (active-region-parent instance))
	(mask (get-avialble-mask arg)))
	      
    ;;; $@%F%j%H%j!<$H$N4XO"$E$1(J
    (setf t-no (with-object-make-territory instance
		      :x (real-left parent left)
		      :y (real-bottom parent bottom)
		      :width (region-width instance)
		      :height (region-height instance)
		      :parent (parent-territory-no parent)
		      :visible T :drawable nil :fence T))

    ;;; $@?F$KEPO?(J
    (push instance (active-region-list parent))

    ;;; $@%F%j%H%j!<HV9f$N@_Dj(J
    (setf (active-region-territory-no instance)
	  t-no)
    
    ;;; $@%$%Y%s%H%^%9%/$N@_Dj(J
    (setf (slot-value instance 'event-mask) mask)
    
    ;;; YY$@%5!<%P$KDLCN(J
    (yy-protocol-72 t-no mask)
    (values)))


;;; $@%"%/%F%#%V%j!<%8%g%sMQ$N%a%=%C%I$N@_Dj(J

;;; $@%$%Y%s%H%a%=%C%I%_%-%7%s$N%"%/%;%C%5(J SETF
(defmethod (setf event-mask) :after ((new-mask integer)
                              (event-method active-region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (setf (slot-value event-method 'event-mask)
        (logior new-mask (slot-value event-method 'event-mask)))
  (yy-protocol-72 (active-region-territory-no event-method)
		  (slot-value event-method 'event-mask)))

;;; $@%\%?%s$,2!2<$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(J setf
(defmethod (setf button1-method) :after (new-value
                                       (event-method active-region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (when new-value
      (yy-protocol-72 (active-region-territory-no event-method)
                  (slot-value event-method 'event-mask))))

;;; $@:8%\%?%s$,2!2<$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(J SETF
(defmethod (setf left-button-down-1-method) :after (new-value
                                       (event-method active-region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (when new-value
      (yy-protocol-72 (active-region-territory-no event-method)
                  (slot-value event-method 'event-mask))))

;;; $@Cf%\%?%s$,2!2<$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(J SETF
(defmethod (setf middle-button-down-1-method) :after (new-value
                           (event-method active-region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (when new-value
      (yy-protocol-72 (active-region-territory-no event-method)
                  (slot-value event-method 'event-mask))))

;;; $@1&%\%?%s$,2!2<$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(J
(defmethod (setf right-button-down-1-method) :after (new-value
                            (event-method active-region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (when new-value
      (yy-protocol-72 (active-region-territory-no event-method)
                  (slot-value event-method 'event-mask))))

;;; $@%\%?%s$,N%$5$l$?;~5/F0$9$k%a%=%C%I(J
(defmethod (setf button-up-method) :after (new-value
                                     (event-method active-region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (when new-value
      (yy-protocol-72 (active-region-territory-no event-method)
                  (slot-value event-method 'event-mask))))

;;; $@:8%\%?%s$,N%$5$l$?;~5/F0$9$k%a%=%C%I(J
(defmethod (setf left-button-up-method) :after (new-value
                            (event-method active-region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (when new-value
      (yy-protocol-72 (active-region-territory-no event-method)
                  (slot-value event-method 'event-mask))))

;;; $@Cf%\%?%s$,N%$5$l$?;~5/F0$9$k%a%=%C%I(J
(defmethod (setf middle-button-up-method) :after (new-value
                           (event-method active-region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (when new-value
      (yy-protocol-72 (active-region-territory-no event-method)
                  (slot-value event-method 'event-mask))))

;;; $@1&%\%?%s$,N%$5$l$?;~5/F0$9$k%a%=%C%I(J
(defmethod (setf right-button-up-method) :after (new-value
                           (event-method active-region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (when new-value
      (yy-protocol-72 (active-region-territory-no event-method)
                  (slot-value event-method 'event-mask))))

;;; $@%\%?%s$,%@%V%k%/%j%C%/$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(J
(defmethod (setf button2-method) :after (new-value
                           (event-method active-region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (when new-value
      (yy-protocol-72 (active-region-territory-no event-method)
                  (slot-value event-method 'event-mask))))

;;; $@:8%\%?%s$,%@%V%k%/%j%C%/$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(J
(defmethod (setf left-button-down-2-method) :after (new-value
                           (event-method active-region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (when new-value
      (yy-protocol-72 (active-region-territory-no event-method)
                  (slot-value event-method 'event-mask))))


;;; $@Cf%\%?%s$,%@%V%k%/%j%C%/$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(J
(defmethod (setf middle-button-down-2-method) :after (new-value
                           (event-method active-region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (when new-value
      (yy-protocol-72 (active-region-territory-no event-method)
                  (slot-value event-method 'event-mask))))


;;; $@1&%\%?%s$,%@%V%k%/%j%C%/$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(J
(defmethod (setf right-button-down-2-method) :after (new-value
                           (event-method active-region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if new-value
    (yy-protocol-72 (active-region-territory-no event-method)
                  (slot-value event-method 'event-mask))))

;;; $@%^%&%9%+!<%=%k$,F0$/$3$H$K$h$j5/F0$9$k%a%=%C%I(J
(defmethod (setf move-mouse-cursor-method) :after (new-value
                           (event-method active-region ))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if new-value
    (yy-protocol-72 (active-region-territory-no event-method)
                  (slot-value event-method 'event-mask))))
	    

;;; $@%^%&%9%+!<%=%k$,F~$C$?;~$K5/F0$9$k%a%=%C%I(J
(defmethod (setf mouse-cursor-in-method) :after (new-value
                           (event-method active-region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (when new-value
      (yy-protocol-72 (active-region-territory-no event-method)
                  (slot-value event-method 'event-mask))))


;;; $@%^%&%9%+!<%=%k$,=P$?;~$K5/F0$9$k%a%=%C%I(J
(defmethod (setf mouse-cursor-out-method) :after (new-value
                           (event-method  active-region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if new-value
    (yy-protocol-72 (active-region-territory-no event-method)
                  (slot-value event-method 'event-mask))))


;;; $@%^%&%9%+!<%=%k$,$"$kNN0h$G(JN$@%_%jICDd;_$7$?;~$K5/F0$9$k%a%=%C%I(J
(defmethod (setf mouse-cursor-wait-method) :after (new-value
                           (event-method active-region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if new-value
      (yy-protocol-72 (active-region-territory-no event-method)
                  (slot-value event-method 'event-mask))))

;;; $@%"%/%F%#%V%j!<%8%g%s$NJQ99$K$h$k%F%j%H%j!<$NJQ99(J
(defun change-active-region (region)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots 
   (left (b1 bottom) top width height) region
   (let ((bottom (min (real-bottom (active-region-parent region)
				   b1)
		      (real-bottom (active-region-parent region)
				   top)))
	(parent (active-region-parent region)))

    (yy-protocol-4 (active-region-territory-no region)
		   (real-left parent left)
		    bottom
		    width
		    height))))

;;; left-bottom setf $@%"%/%;%5(J
(defmethod (setf left-bottom) :after 
  ((new-position position) (region active-region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (change-active-region region))

;;; right-top setf $@%"%/%;%5(J
(defmethod (setf right-top ) :after 
  ((new-position position) (region active-region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (change-active-region region))

;;; Region$@$N%3%T!<%a%=%C%I(J
(defmethod region-copy :after ((region active-region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (make-active-region :left (region-left region)
		      :bottom (region-bottom region)
		      :width (region-width region)
		      :height (region-height region)
		      :parent (active-region-parent region)
		      :button1-method (button1-method region) 
		      :left-button-down-1-method 
		      (left-button-down-1-method region)
		      :middle-button-down-1-method
		      (middle-button-down-1-method region) 
		      :right-button-down-1-method 
		      (right-button-down-1-method region) 
		      :button-up-method 
		      (button-up-method region) 
		      :left-button-up-method
		      (left-button-up-method region) 
		      :middle-button-up-method
		      (middle-button-up-method region)
		      :right-button-up-method
		      (right-button-up-method region) 
		      :button2-method (button2-method region) 
		      :left-button-down-2-method
		      (left-button-down-2-method region) 
		      :middle-button-down-2-method
		      (middle-button-down-2-method region) 
		      :right-button-down-2-method
		      (right-button-down-2-method region) 
		      :move-mouse-cursor-method
		      (move-mouse-cursor-method region) 
		      :mouse-cursor-in-method
		      (mouse-cursor-in-method region) 
		      :mouse-cursor-out-method
		      (mouse-cursor-out-method region) 
		      :mouse-cursor-wait-method
		      (mouse-cursor-wait-method region)))

;;; region-left$@$N(JSETF$@%"%/%;%5(J
(defmethod (setf region-left) :after ((left integer) (region active-region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (change-active-region region))

;;; region-top$@$N(JSETF$@%"%/%;%5(J
(defmethod (setf region-top) :after ((top integer) (region active-region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (change-active-region region))

;;; region-right$@$N(JSETF$@%"%/%;%5(J
(defmethod (setf region-right) :after ((right integer) (region active-region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (change-active-region region))

;;; region-bottom$@$N(JSETF$@%"%/%;%5(J
(defmethod (setf region-bottom) :after ((bottom integer) (region active-region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (change-active-region region))

;;; region-width $@$N(JSETF$@%"%/%;%5(J
(defmethod (setf region-width) :after ((width integer) (region active-region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (change-active-region region))

;;; region-height$@$N(JSETF$@%"%/%;%5(J
(defmethod (setf region-height) :after ((height integer) (region active-region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (change-active-region region))

;;; $@%*%V%8%'%/%H$,(Jregion$@$G$"$k$+(J?
(defun active-region-p (region)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (typep region 'active-region))

;;; $@%j!<%8%g%s$N%]%8%7%g%s$N(Jsetf
(defmethod (setf region-position) :after ((new-position position)
                                   (region active-region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (change-active-region region))

;;;$@%j!<%8%g%s$N%]%8%7%g%s$rM?$($i$l$?(JX Y$@$K@_Dj$9$k!#(J
(defmethod set-region-position-xy :after ((region active-region)
				   (x number)
				   (y number))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (change-active-region region))

;;;$@%j!<%8%g%s$N%]%8%7%g%s$rM?$($i$l$?(Jposition$@$K@_Dj$9$k!#(J
(defmethod set-region-position :after ((region active-region) 
				       (new-position position))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (change-active-region region))


;;; $@%"%/%F%#%V%j!<%8%g%s$N?F$NJQ99(J
(defmethod (setf active-region-parent) :after
  ((new-window window-stream) (aregion active-region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((r-bottom (real-bottom (active-region-parent aregion)
			       (region-bottom  aregion))))

	;;; $@%F%j%H%j$N?F$NJQ99(J
    (delete aregion (active-region-list 
		      (active-region-parent aregion)))

    (yy-protocol-6 (active-region-territory-no aregion)
		   (parent-territory-no (active-region-parent aregion))
		   (region-left aregion)  r-bottom)
    (call-next-method)))


;;; $@%"%/%F%#%V%j!<%8%g%s$J$$$N0LCV$r?F$N%&%#%s%I%&%9%H%j!<%`$+$i$N(J
;;; $@0LCV$KJQ99$9$k(J XY
(defmethod translate-root-xy ((a-region active-region) x y)
  (translate-root-xy (active-region-parent a-region)
		     (+ x (region-left a-region))
		     (+ y (region-bottom a-region)))
  )
	
;;; $@%$%Y%s%H$N0l;~Dd;_(J $@%"%/%F%#%V%j!<%8%g%s(J
(defmethod disnable-event ((a-region active-region) mask)
  (let* ((old-mask (event-mask a-region))
         (new-mask (logand (lognot mask) old-mask)))
    (yy-protocol-72 (active-region-territory-no a-region) new-mask)))

;;;$@%$%Y%s%H$N2sI|(J  $@%"%/%F%#%V%j!<%8%g%sMQ(J
(defmethod enable-event ((a-region active-region))
  (yy-protocol-72 (active-region-territory-no a-region)
                  (event-mask a-region)))

