/*
 */

#include <stdio.h>
#include <string.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>	/* Get standard string definations. */

#include <X11/Xaw/Command.h>	
#include <X11/Xaw/Label.h>	
#include <X11/Xaw/Box.h>	
#include <X11/Xaw/Toggle.h>	
#include <X11/Xaw/Cardinals.h>	
#include "conf.h"
#include "abox.h"

extern void exit();

static void Syntax();
static void Quit();
static void Xterm();
static void CallService();

/* ǥեȤե֤ */
static char *LibDir =
#ifdef INST
    YYLIBDIR;
#else /*!INST*/
    ".";
#endif /*!INST*/

String fallback_resources[] = { 
    "*quit*label:    Cancel",
    "*call*label:    Execute",
    "*toggle*label:    XTERM",
    "*info*font:    -*-fixed-*-r-normal--14-*jisx0201.1976-*",
    NULL,
};

#ifdef withoption
static XrmOptionDescRec options[] = {
    {"-hspace",	"*Box.hSpace",	XrmoptionSepArg,	NULL},
    {"-vspace",	"*Box.vSpace",	XrmoptionSepArg,	NULL},
};
#endif nooption

/*
 * ܥץưƤѼ̾ΰ user 
 */
static void get_user_name(user)
    char *user;
{
    struct passwd *pwd;
    strcpy(user, 
	   ((pwd = getpwuid(getuid())) != (struct passwd *)NULL)?
	   pwd->pw_name: "nobody");
    /*NoReturnValue*/
}



struct yy_call_request YYReq;	/* ȯԤ׵ */

main(argc, argv)
    int argc;
    char **argv;
{
    int i;
    XtAppContext app_con;
    Widget toplevel, box, command, call_command;
    Display *mydisp;
    char localhost[128];
    char username[64];
    char buf[4096];
    Arg args[10];


    toplevel = XtAppInitialize(&app_con, "Xyycall",
#ifdef withoption
			       options, XtNumber(options),
#else /*!withoption*/
			       NULL, ZERO,
#endif /*!withoption*/
			       &argc, argv, fallback_resources,
			       NULL, ZERO);

    /* YY-server ۥ̾ȤƼۥ̾
     * X server ۥ̾
     */
    YYReq.req_name = YYReq.req_user = YYReq.req_key = "";
    YYReq.req_xdisp = YYReq.req_server = YYReq.req_option = "";

    gethostname(localhost, sizeof(localhost));
    YYReq.req_server = localhost;
    mydisp = XtDisplay(toplevel); /* ΥޥɤưƤ Display */
    YYReq.req_xdisp = DisplayString(mydisp);
    if (YYReq.req_xdisp[0]==':' || strncmp(YYReq.req_xdisp, "unix:", 5)==0) {
	/* ':0.0'  'unix:0.0'  '<localhostname>:0.0' ˤ */
	register char *s = strchr(YYReq.req_xdisp, ':');
	static char dispname_buf[128];
	strcpy(dispname_buf, localhost);
	strcat(dispname_buf, s);
	YYReq.req_xdisp = dispname_buf;
    }
    get_user_name(username);
    YYReq.req_user = username;

    /* argv[2] ǼեβϤԤʤ
     */
    if (argc != 2) Syntax(app_con, argv[0]);
    if (strchr(argv[1],'/') != (char *)NULL) {
	if (read_description(&YYReq, argv[1]) < 0) {
	    fprintf(stderr, "Can't understand description file %s\n", argv[1]);
	    Syntax(app_con, argv[0]);
	}
    } else {
	char fpath[1024];
	sprintf(fpath, "%s/DESC/%s.desc", LibDir, argv[1]);
	if (read_description(&YYReq, fpath) < 0) {
	    fprintf(stderr, "Unknown YY-service %s\n", argv[1]);
	    Syntax(app_con, argv[0]);
	}
    }
    if ((YYReq.req_name=search_command(&YYReq, COM_DEFINE)) == (char *)NULL) {
	fprintf(stderr, "Can't understand description file %s\n", argv[1]);
	exit(1);
    }

    /* 
     * Create a Box widget and put all children in that box widget.
     * 
     */
    box = XtCreateManagedWidget("box", boxWidgetClass, toplevel,
				NULL, ZERO);

    /*
     * Put a command widget in the box.
     */
    command = XtCreateManagedWidget("call", commandWidgetClass,
				    box, NULL, ZERO);
    XtAddCallback(command, XtNcallback, CallService, NULL);

    command = XtCreateManagedWidget("quit", commandWidgetClass, box,
				    NULL, ZERO);
    XtAddCallback(command, XtNcallback, Quit, NULL);

    command = XtCreateManagedWidget("toggle", toggleWidgetClass, box,
				    NULL, ZERO);
    XtAddCallback(command, XtNcallback, Xterm, NULL);
    
    sprintf(buf, "YY Service Information\n Service Name: %s\n X server: %s\n YY-server: %s\n User Name: %s",
	    YYReq.req_name, YYReq.req_xdisp, YYReq.req_server, YYReq.req_user);
    XtSetArg(args[0], XtNlabel, buf);
    command = XtCreateManagedWidget("info", labelWidgetClass, box,
				    args, ONE);
    XtRealizeWidget(toplevel);
    XtAppMainLoop(app_con);
}

static void CallService(w, client_data, call_data)
    Widget w;
    XtPointer client_data, call_data;
{
    char *host = search_command(&YYReq, COM_HOST);
    struct hostent *hp;
    struct sockaddr_in addr;
    int sock;
    char strbuf[1024];
    int pid;

    if (host == (char *)NULL ||
	(hp = gethostbyname(host)) == (struct hostent *)NULL) {
	fprintf(stderr, "Can't get service host\n");
	XtDestroyApplicationContext(XtWidgetToApplicationContext(w));
	exit(1);
    }
    bzero((char *)&addr, sizeof(addr));
    addr.sin_family = hp->h_addrtype;
    bcopy(*hp->h_addr_list, &addr.sin_addr, hp->h_length);
    addr.sin_port = htons(YYCALLPORT);

    if ((sock = socket(PF_INET, SOCK_STREAM, 0)) < 0) {
	perror("socket");
	XtDestroyApplicationContext(XtWidgetToApplicationContext(w));
	exit(1);
    }
    if (connect(sock, &addr, sizeof(addr)) < 0) {
	perror("connect");
	XtDestroyApplicationContext(XtWidgetToApplicationContext(w));
	exit(1);
    }

    sprintf(strbuf, "%s;%s;;%s;%s;%s;\n",
	    YYReq.req_name, YYReq.req_user,
	    YYReq.req_xdisp, YYReq.req_server, YYReq.req_option);
    write(sock, strbuf, strlen(strbuf));
    sleep(1);
    shutdown(sock, 0);
    close(sock);

    XtDestroyApplicationContext(XtWidgetToApplicationContext(w));
    exit(0);
}

/*
 */
static void Xterm(w, client_data, call_data)
    Widget w;
    XtPointer client_data, call_data;
{
    if (YYReq.req_option[0] == '\0') {
	YYReq.req_option = "xterm";
	/*fprintf(stderr, "Xterm ON\n");*/
    } else {
	YYReq.req_option = "";
	/*fprintf(stderr, "Xterm OFF\n");*/
    }
}


/*	Function Name: Quit
 *	Description: This function prints a message to stdout.
 *	Arguments: w - ** UNUSED **
 *                 call_data - ** UNUSED **
 *                 client_data - ** UNUSED **
 *	Returns: none
 */

static void Quit(w, client_data, call_data)
    Widget w;
    XtPointer client_data, call_data;
{
    XtDestroyApplicationContext(XtWidgetToApplicationContext(w));
    exit(0);
}

/*
 */

static void Syntax(ac, call)
    XtAppContext ac;	/* Application Context */
    char *call;		/* the name of this Application */
{
    XtDestroyApplicationContext(ac);
    fprintf(stderr, "Usage: %s yy-service-name\n",
	    call);
    exit(1);
}
