/* Main Part of Application Box for YYonX
 * This file is part of YY-server of YYonX (Version 1.5)
 * $Id: super.c,v 3.0 1992/10/08 04:59:44 keisuke Exp keisuke $
 */

#ifndef lint
static char *RcsId =
    "$Id: super.c,v 3.0 1992/10/08 04:59:44 keisuke Exp keisuke $";
#endif

/****************************************************************************
%%%COPYRIGHT%%%
;;; Authors:
;;;   Version 1.0 90/02/26 by Keisuke 'Keiko' Tanaka
;;;				(keisuke@csrl.aoyama.ac.jp)
;;;
****************************************************************************/

/****************************************************************************
  $Revision: 3.0 $ Written by Keisuke 'Keiko' Tanaka
  $Date: 1992/10/08 04:59:44 $
****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <syslog.h>
#include "abox.h"

/*
 * եʸβ
 *
 * "...." ǤΤ " Ϥ
 * \x ʸ x Ƥ˱ưʸѴ
 * Ϣ³ʸϰʸ ' ' ˡζʸϤʤ
 *  â"..." ξˤϤϹԤʤʤ
 *
 * BUG:
 *  str ΰľѹ
 *  ̤ȤƤȤʸĹûʤ뤳Ȥ
 *   (Ƥ餷Ĺʤ뤳ȤϤꤨʤ)
 */
static char *parse_line(str)
    char *str;
{
    register char *s = str;
    register char *p = str;
    int sp = 0;
    int dquote = 0;

    if (*s == '"') { dquote = 1; s++; }
    for ( ; *s != '\0'; s++) {
	if (dquote && *s == '"') break;
	if (*s == '\\' && *(s+1) != '\0') {
	    s++;
	    if (sp) { *p++ = ' '; sp = 0; }
	    switch(*s) {
	    case 'n': *p++ = '\n'; break;
	    case 'r': *p++ = '\r'; break;
	    case 't': *p++ = '\t'; break;
	    case 'h': *p++ = '\010'; break;
	    case 'D': *p++ = '\177'; break;
	    default: *p++ = *s; break;
	    }
	} else if (!dquote && isspace(*s)) {
	    sp++;
	} else {
	    if (sp) { *p++ = ' '; sp = 0; }
	    *p++ = *s;
	}
    }
    *p = '\0';
    return str;
}

/*
 * req ¤ req->req_name ǻꤵ줿ӥ
 * ӥեɤ߹ߤϤ
 * Ϸ̤ req ¤ req->req_command ꤵ
 */
int read_description(req, fpath)
    struct yy_call_request *req;
    char *fpath;
{
    FILE *fp;
    char buf[4096];
    struct yy_call_command dummy;
    struct yy_call_command *last = &dummy;

    if ((fp = fopen(fpath, "r")) == (FILE *)NULL) {
	syslog(LOG_ERR, "Can't find description file for %s", req->req_name);
	return -1;
    }

    while (fgets(buf, sizeof(buf), fp)) {
	register char *s;
	syslog(LOG_DEBUG, "Read line: %s", buf);
	if (!isalpha(buf[0]) || strchr(buf, ':') == (char *)NULL)
	    continue;
	syslog(LOG_DEBUG, "Parse line: %s", buf);
	if ((s = strchr(buf, '\n')) != (char *)NULL) *s = '\0';
 	last->com_next = (struct yy_call_command *)
	    malloc(sizeof(struct yy_call_command));
	s = strdup(buf);
	if (last->com_next == (struct yy_call_command *)NULL ||
	    s == (char *)NULL)
	    continue;

	last = last->com_next;
	last->com_next = (struct yy_call_command *)NULL;

	last->com_label = s;
	if ((s = strchr(s, ':')) == (char *)NULL) continue;/*ʤ*/
	for (s++; *s != '\0' && isspace(*s); s++) ;
	
	last->com_string = parse_line(s);
    }
    req->req_command = dummy.com_next;
    return 0; /*No Error*/
}    

char *search_command(req, str)
    struct yy_call_request *req;
    char *str;
{
    register struct yy_call_command *cmd;
    for (cmd = req->req_command; cmd ; cmd = cmd->com_next)
	if (isSameCOM(cmd->com_label,str)) return cmd->com_string;
    return (char *)NULL;
}


/*
 * Local variables:
 * eval: (set-kanji-fileio-code 'EUC)
 * end:
 */
