;;; -*- Mode: LISP; Package: YY-GEO; Syntax: Common-Lisp; Base: 10 -*-
(in-package :yy-geo)

(defmacro with-switch-default-look ((switch) &body body)	;default look of switch
  `(progn (draw-switch ,switch :active)
	  ,@body
	  (draw-switch ,switch :deactive)))

(defvar *pi* (COERCE pi 'single-float))

(defvar *r-color*)
(defvar *g-color*)
(defvar *b-color*)
(defvar *y-color*)
(defvar *m-color*)

(defun make-color (red green blue)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (unless (numberp red) (setf red 0))
  (unless (numberp green) (setf green 0))
  (unless (numberp blue) (setf blue 0))
  (let ((color (yy::make-color :red red :green green :blue blue)))
    (if (eq yy::*white-color* color)		;for Black and white display
	yy::*black-color*
	color)))

(defun replacing-item (list old new)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (maplist #'(lambda (list)
	       (when (eq (car list) old)
		 (rplaca list new)))
	       list)
  list)

(defun insert-between (list v1 v2 v)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((1st (car list))
	(last (car (last list))))
    (if (or (and (eql 1st v1)
		 (eql last v2))
	    (and (eql 1st v2)
		 (eql last v1)))
	(rplacd (last list) (list v))
      
	(let ((v1-list (member v1 list))
	      (v2-list (member v2 list)))
	  (if (< (length v1-list) (length v2-list))
	      (rplacd v2-list (cons v v1-list))
	      (rplacd v1-list (cons v v2-list)))))
    list))

(defun get-next-element (item-list)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  ;; return value must be positive integer
  ;; If return value is 0, not good item list
  (if (null item-list)
      1
      (+ 1
	 (let ((ans -1))
	   (dolist (item item-list ans)
	     (with-slots (sequence-number) item
	       (if (and (numberp sequence-number)
			(< ans sequence-number))
		   (setf ans sequence-number))))))))

(defun nth-with-ring (pos list &optional (length (length list)))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((positive (mod pos length)))
    (nth positive list)))


