/*********************************************************
 *
 * Copyright (c) 1991 Regents of the University of California
 *
 * Prompter module.  The prompter reads commands from it's standard
 * input and uses them to control actors in a non blocking
 * manner.  The protocol is as follows:
 *
 *	POSITION <x y>	Set the position of the window.
 *	SIZE <w h>	Set the size of the window.
 *	START		Start output at position specified.
 *	STOP		Stop output.
 *	EXIT		Close and exit.
 *
 * $Author$
 * $Source$
 * $Revision$
 * $Date$
 *
 *********************************************************/

#include <stdio.h>
#include <signal.h>

#include "util.h"

void
DoExit(status)
int status;

    {
    DoStop();	/* Just in case they forgot */
    CleanUp();	/* Close file desriptors, etc. */
    exit (status);
    }

static void
BailOut()

    {
    DoExit(255);
    }

main (argc, argv)
int argc;
char **argv;

    {
    char *args[256];
    char command[64];
    int i;

    Init();
    signal (SIGINT, BailOut);
    while (1)
	{
	/* Read the command */
	i = read (0, command, 256);
	command[i] = 0;
	argc = parse (command, args);

	if ((argc == 3) && MatchCommand (args[0], "POSITION"))
	    DoPosition (atoi(args[1]), atoi(args[2]));
	else if ((argc == 3) && MatchCommand (args[0], "SIZE"))
	    DoSize (atoi(args[1]), atoi(args[2]));
	else if ((argc == 1) && MatchCommand (args[0], "START"))
	    DoStart ();
	else if ((argc == 1) && MatchCommand (args[0], "CLEAR"))
	    DoClear ();
	else if ((argc == 1) && MatchCommand (args[0], "STOP"))
	    DoStop ();
	else if ((argc == 1) && (MatchCommand (args[0], "EXIT") ||
				 MatchCommand (args[0], "QUIT")))
	    DoExit(1);
	else if (i == 0)
	    DoExit(1);
	else
	    (void)fprintf (stderr, "%s: Can't understand %s\n",
		     argv[0], command);
	}
    }
