#include <stdio.h>
#include <X11/Intrinsic.h>
#include <sun/pipio.h>
#include <sunwindow/rect.h>
#include <pixrect/pixrect.h>
#include <pixrect/pr_planegroups.h>

static int videoOn;
static int fd = -1;
static Pixrect *the_screen;
static int videoX, videoY;
static int videoWidth = 640;
static int videoHeight = 480;

void
VideoXRefresh (x, y, w, h)
int x, y, w, h;

    {
    XRefresh (x-2, y-2, w+4, h+4);
    }

void
Init()

    {
    int init, source;
    struct rect srect;

    if (fd != -1)
	return;

    /******************************************************
      Get the file descriptor.
    ******************************************************/

    fd = open("/dev/cgeight0", O_RDWR, 0);

    /******************************************************
      Set video planes to accept video input from RasterOps board.
    ******************************************************/

    the_screen = pr_open("/dev/fb");

    /******************************************************
      Do I/O control for RasterOps board.
    ******************************************************/
    init = PIPIO_NTSC;
    source = PIPIO_YC;
    /* source = PIPIO_COMPOSITE; */
    srect.r_left   = 100;
    srect.r_top    = 16;
    srect.r_width  = 640;
    srect.r_height = 480;
    ioctl(fd, PIPIO_S_INITIALIZE, &init);
    ioctl(fd, PIPIO_S_SOURCE, &source);
    ioctl(fd, PIPIO_S_SIGRECT, &srect);
    pr_set_plane_group(the_screen, PIXPG_VIDEO_ENABLE);
    }

void
DoStart ()

    {
    int on_signal = 1;

    pr_rop(the_screen, 0, 0, 1152, 900, PIX_CLR, NULL, 0, 0);
    pr_rop(the_screen, videoX, videoY, videoWidth, videoHeight,
		       PIX_SET, NULL, 0, 0);
    usleep (500000);	/* wait for 1/2 second... */
    ioctl(fd, PIPIO_S_PIP_ON_OFF, &on_signal);
    videoOn = 1;
    }

void
DoStop ()

    {
    int off_signal = 0;

    ioctl(fd, PIPIO_S_PIP_ON_OFF, &off_signal);
    videoOn = 0;
    }

void
CleanUp()

    {
    if (fd != -1)
	{
	close(fd);
	fd = -1;
	pr_set_plane_group(the_screen, PIXPG_24BIT_COLOR);
	pr_close(the_screen);
	}
    }

void
DoClear ()

    {
    VideoXRefresh (videoX, videoY, videoWidth, videoHeight);
    }

void
DoPosition (x, y)
int x, y;

    {
    struct rect d_rect;
    int videoWasOn;
    int dx, dy;

    videoWasOn = videoOn;
    dx = x - videoX;
    dy = y - videoY;
    if (videoOn) 
	{
	DoStop();
	if (dx < 0)
	    VideoXRefresh (videoX+videoWidth+dx, videoY, 1-dx, videoHeight);
	else if (dx > 0)
	    VideoXRefresh (videoX, videoY, dx+1, videoHeight);
	if (dy < 0)
	    VideoXRefresh (videoX, videoY+videoHeight+dy, videoWidth, 1-dy);
	else if (dy > 0)
	    VideoXRefresh (videoX, videoY, videoWidth, 1+dy);
	}

    videoX = d_rect.r_left   = x;
    videoY = d_rect.r_top    = y;
    d_rect.r_width  = videoWidth;
    d_rect.r_height = videoHeight;
    ioctl(fd, PIPIO_S_OUTRECT, &d_rect);
    if (videoWasOn) 
	DoStart();
    }

void
DoSize (w, h)
int w, h;

    {
    struct rect d_rect;
    int videoWasOn;

    videoWasOn = videoOn;
    if (videoOn) 
	{
	DoStop();
	if (w < videoWidth)
	    VideoXRefresh (videoX+w-1, videoY, videoWidth-w+2, videoHeight);
	if (h < videoHeight)
	    VideoXRefresh (videoX, videoY+h-1, videoWidth, videoHeight-h+2);
	}

    d_rect.r_left   = videoX;
    d_rect.r_top    = videoY;
    videoWidth = d_rect.r_width  = w;
    videoHeight = d_rect.r_height = h;
    ioctl(fd, PIPIO_S_OUTRECT, &d_rect);
    if (videoWasOn)
	DoStart();
    }
