;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/widgets/table/RCS/tf-button.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:09:11 $
;;;

(in-package "PT")

(defclass tf-button (click-button)
  ((left-image
    :initarg :left-image 
    :initform (make-image :name "scoot" :file "squares.bitmap")
    :type image
    :accessor left-image)
   (middle-image
    :initarg :middle-image 
    :initform nil
    :type image
    :accessor middle-image)
   (right-image
    :initarg :right-image 
    :initform (make-image :name "revert" :file "end.bitmap")
    :type image
    :accessor right-image)
   (normal-image
    :initarg :normal-image 
    :initform (make-image :name "swap" :file "swap.bitmap")
    :type image
    :accessor normal-image)))

(defun make-tf-button (&rest args)
  (apply #'make-instance 'tf-button :allow-other-keys t args))

(defmethod (setf inverted) (val (self tf-button) &aux pu)
  (if val
      (progn
       (setq pu (pushed self))
       (cond ((eq pu :left)
	      (setf (value self) (left-image self)))
	     ((eq pu :middle)
	      (setf (value self) (middle-image self)))
	     ((eq pu :right)
	      (setf (value self) (right-image self)))))
       (setf (value self) (normal-image self)))
  (repaint self)
  val)
