;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/widgets/table/RCS/list-of-str.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:09:11 $
;;;

(in-package "PT")

;;;
;;; Class definition for los-gadget
;;;

(defclass los-gadget (gadget) 
 ((offset :initarg :offset :initform 0 :type integer :reader offset)
  (gc-spec :initform '((gc-res (:font "8x13"))
		       (gc-gray (:paint "gray50"))))
  (gc-gray :type vector :initform nil :reader gc-gray)
  (curr-idx :initarg :curr-idx :initform nil :type list :reader curr-idx)
  (min-rows :initarg :min-rows :initform 5 :type integer :reader min-rows)
  (font :initform "8x13")
  (x-pad :initarg :x-pad :initform 4 :type integer :reader x-pad)
  (y-pad :initarg :y-pad :initform 4 :type integer :reader y-pad)
  (background :initform "white")))

(defmethod (setf curr-idx) (value (self los-gadget))
  (unless (equalp value (curr-idx self))
	  (setf (slot-value self 'curr-idx) value)
	  (repaint self :clear t)))

(defmethod (setf min-rows) (value (self los-gadget))
  (unless (eq value (min-rows self))
	  (setf (slot-value self 'min-rows) value)
	  (calc-base-size self)))

(defmethod (setf offset) (value (self los-gadget))
  (if (>= (+ value (rows-vis self)) (length (value self)))
      (setq value (max 0 (- (length (value self)) (rows-vis self)))))
  (if (< value 0) (setq value 0))
  (unless (eq value (offset self))
	  (setf (slot-value self 'offset) value)
	  (repaint self :clear t)))

(defmethod (setf x-pad) (value (self los-gadget))
  (unless (eq value (x-pad self))
	  (setf (slot-value self 'x-pad) value)
	  (calc-base-size self)))

(defmethod (setf y-pad) (value (self los-gadget))
  (unless (eq value (y-pad self))
	  (setf (slot-value self 'y-pad) value)
	  (calc-base-size self)))

(defmethod (setf font) (value (self los-gadget))
  (call-next-method)
  (when (attached-p self)
	(attach value)
	(setf (xlib:gcontext-font (gc-res self)) (res value)))
  (calc-base-size self))

(defmethod calc-base-size ((self los-gadget))
  (if (not (attached-p (font self)))
      (return-from calc-base-size))
  (let* ((min-rows (min-rows self))
	 (bw 0)
	 (bh 0)
	 (font (font self))
	 (val (value self))
	 (x-pad (x-pad self))
	 (y-pad (y-pad self))
	 (min-w 10))
	(dolist (v val)
		(setq min-w (max min-w (text-width v :font font))))
	(setq bw (+ x-pad x-pad min-w)
	      bh (+ y-pad (* min-rows (+ y-pad (font-ascent font)))))
	(if (and (eq bw (base-width self))
		 (eq bh (base-height self)))
	    (repaint self :clear t)
	    (setf (base-size self) (list bw bh)))))

(defmethod new-instance ((self los-gadget)
			 &key
			 (font nil)
			 &allow-other-keys)
  (call-next-method)
  (setq font (slot-value self 'font))
  (unless (font-p font)
	  (setq font (get-font font)))
  (unless (font-p font)
	  (warn "list-of-str.new-instance:  illegal font ~s" font)
	  (setq font (get-font "8x13")))
  (setf (font self) font)
  self)

;;;
;;; Constructor Function...
;;;

(defun make-los-gadget (&rest keys)
  (apply #'make-instance 'los-gadget :allow-other-keys t keys))

;;;
;;; Define the setf method on value that's an integer...
;;;

(defmethod (setf value) ((value list) (self los-gadget))
  (unless (equalp value (value self))
	  (setf (slot-value self 'value) value)
	  (calc-base-size self)
	  (repaint self)))

(defmethod do-attach ((self los-gadget))
  (call-next-method)
  (when (attached-p self)
	(attach (font self))
	(setf (xlib:gcontext-font (gc-res self)) (res (font self)))))

(defun find-index-of-item (self y)
  (+ (offset self) (truncate y (+ (y-pad self) (height (font self))))))

(defmethod rows-vis ((self los-gadget))
  (let* ((h (height self))
	 (start-y (repaint-y self))
	 (y-pad (y-pad self))
	 (font (font self))
	 (val-list (value self))
	 (y (+ start-y y-pad))
	 (fh (height font))
	 (max-y (+ h start-y (- fh)))
	 (dy (+ y-pad fh))
	 (rv 0))
	(dolist (val val-list)
		(incf rv)
		(incf y dy)
		(if (>= y max-y) (return)))
	rv))

;;;
;;; Define a function to repaint the los -- just
;;; Sets an area of the window proportial to it's value.
;;;

(defmethod do-repaint ((self los-gadget)
		       &key
		       (clear nil)
		       &allow-other-keys)
  (if clear (clear self))
  (let* ((res (res self))
	 (curr (curr-idx self))
	 (start-x (repaint-x self))
	 (start-y (repaint-y self))
	 (x-pad (x-pad self))
	 (y-pad (y-pad self))
	 (w (- (width self) x-pad x-pad))
	 (font (font self))
	 (offset (offset self))
	 (val-list (nthcdr offset (value self)))
	 (fh (font-height font))
	 (fa (font-ascent font))
	 (x (+ start-x x-pad))
	 (y (+ start-y y-pad fh))
	 (h fh)
	 (max-y (+ y w start-x start-y))
	 (dy (+ y-pad fh))
	 (gc (gc-res self))
	 (gc-gray (gc-gray self))
	 (y2 (truncate y-pad 2))
	 (i offset))
	(dolist (val val-list)
		(xlib:draw-image-glyphs res (gc-res self) x y val)
		(xlib:draw-line res gc-gray (1+ start-x) (- y fa y2)
				(+ 1 start-x w) (- y fa y2))
		(if (member i curr)
		    (xlib:draw-rectangle res gc (1+ start-x) (- y fa) w h))
		(incf y dy)
		(incf i)
		(if (>= y max-y) (return)))
	(xlib:draw-line res gc-gray (1+ start-x) (- y fa y2)
			(+ 1 start-x w) (- y fa y2))))
