;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/widgets/table/RCS/data-utils.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:09:11 $
;;;

(in-package "PT")

;;;
;;; 	Functions, macros, and methods to return an element in the given 
;;;	portal, array, or list
;;;

(defmethod element ((self list) n)
  (elt self n))

(defmethod (setf element) (val (self list) n)
  (setf (elt self n) val))

(defmethod element ((self portal) n)
  (aref (slot-value self 'array) n))

(defmethod element ((self array) n)
  (aref self n 0))

(defmethod (setf element) (val (self array) n)
  (setf (aref self n 0) val))

(defun nth-element (n struct &key slot)
  (if (listp struct)
      (nth n struct)
      (if slot
	  (slot-value struct slot)
	  (slot-value struct (clos::slotd-name (nth n (clos::class-slots 
						      (clos::class-of 
						       struct))))))))

(defmethod entry ((self array) row col)
  (aref self row col))

(defmethod entry ((self portal) row col &aux tup)
  (setq tup (aref (slot-value self 'array) row))
  (slot-value tup (clos::slotd-name (nth col (clos::class-slots
					     (clos::class-of tup))))))

(defmethod set-entry ((self array) row col new-val)
  (setf (aref self row col) new-val))

(defmethod set-entry ((self portal) row col new-val)
  (declare (ignore row col new-val))
  (warn "Can't do data-base operations yet. . ."))

(defmethod num-elements ((self portal))
  (slot-value self 'count))

(defmethod num-elements ((self array))
  (array-dimension self 0))

(defmethod num-elements ((self list))
  (length self))

(defmethod num-cols ((self array))
  (array-dimension self 1))

(defmethod num-cols ((self list))
  (length (car self)))

(defmethod num-cols ((self portal))
  (length (clos::class-slots (clos::class-of (aref (slot-value self 'array) 0)))))

