(in-package "PT")

#{(progn
   (unless *map-sound-loaded*
	   #+allegro
	   (load *map-sound-file*
		 :foreign-files *map-sound-foreign-files*
		 :system-libraries *map-sound-system-libraries*)
	   #+lucid
	   (load-foreign-files *map-sound-file*)
	   #+lucid
	   (load-foreign-libraries *map-sound-foreign-files*)
	   #+lucid
	   (load-foreign-libraries *map-sound-system-libraries*)
	   (setq *map-sound-loaded* t))

#+lucid
   (def-foreign-struct audio-hdr
     (sample_rate :type :unsigned-16bit)
     (samples_per_unit :type :unsigned-16bit)
     (bytes_per_unit :type :unsigned-16bit)
     (channels :type :unsigned-16bit)
     (encoding :type :unsigned-16bit)
     (data_size :type :unsigned-16bit))

#+allegro
   (ff:defforeign 'read-sound-internal
	       :entry-point "_ReadSound"
	       :return-type :fixnum
	       :arguments '(simple-string))
#+lucid
   (def-foreign-function 
     (read-sound-internal (:name "_ReadSound")
			  (:return-type :fixnum))
     (fname :simple-string))
#+allegro
   (ff:defforeign 'write-sound-internal
	       :entry-point "_WriteSound"
	       :return-type :fixnum
	       :arguments '(simple-string))
#+lucid
   (def-foreign-function
     (write-sound-internal (:name "_WriteSound")
			   (:return-type :fixnum))
     (fname :simple-string))
#+allegro
   (ff:defforeign 'play-sound-internal
	       :entry-point "_PlaySound"
	       :return-type :fixnum
	       :arguments t)
#+lucid
   (def-foreign-function
     (play-sound-internal (:name "_PlaySound")
			  (:return-type :fixnum)))
#+allegro
   (ff:defforeign 'sound-length-internal
	       :entry-point "_SoundLength"
	       :return-type :fixnum
	       :arguments t)
#+lucid
   (def-foreign-function
     (sound-length-internal (:name "_SoundLength")
			    (:return-type :fixnum)))
#+allegro
   (ff:defforeign 'sound-sample-rate-internal
	       :entry-point "_SoundSampleRate"
	       :return-type :fixnum
	       :arguments t)
#+lucid
   (def-foreign-function
     (sound-sample-rate-internal (:name "SoundSampleRate")
				 (:return-type :fixnum)))
#+allegro
   (ff:defforeign 'sound-bytes-per-unit-internal
	       :entry-point "_SoundBytesPerUnit"
	       :return-type :fixnum
	       :arguments t)
#+lucid
   (def-foreign-function 
     (sound-bytes-per-unit-internal (:name "_SoundBytesPerUnit")
				    (:return-type :fixnum)))
#+allegro
   (ff:defforeign 'sound-channels-internal
	       :entry-point "_SoundChannels"
	       :return-type :fixnum
	       :arguments t)
#+lucid
   (def-foreign-function
     (sound-channels-internal (:name "_SoundChannels")
			      (:return-type :fixnum)))
#+allegro   
   (ff:defforeign 'sound-samples-per-unit-internal
	       :entry-point "_SoundSamplesPerUnit"
	       :return-type :fixnum
	       :arguments t)
#+lucid
   (def-foreign-function
     (sound-samples-per-unit-internal (:name "_SoundSamplesPerUnit")
				      (:return-type :fixnum)))
#+allegro   
   (ff:defforeign 'get-sound-data-internal
	       :entry-point "_GetSoundData"
	       :return-type :void
	       :arguments t)
#+lucid
   (def-foreign-function
     (get-sound-data-internal (:name "_GetSoundData")
			      (:return-type :null))
     (data :simple-string))
#+allegro
   (ff:defforeign 'set-sound-params-internal
	       :entry-point "_SetSoundParams"
	       :return-type :void
	       :arguments t)
#+lucid
   (def-foreign-function
     (set-sound-params-internal (:name "_SetSoundParams")
				(:return-type :null))
     (sample_rate :fixnum)
     (bytes_per_unit :fixnum)
     (channels :fixnum)
     (samples_per_unit :fixnum))
#+allegro   
   (ff:defforeign 'set-sound-data-internal
	       :entry-point "_SetSoundData"
	       :return-type :void
	       :arguments t))
#+lucid
   (def-foreign-function
     (set-sound-data-internal (:name "_SetSoundData")
			      (:return-type :null))
     (data :simple-string)
     (start :fixnum)
     (end :fixnum))

(defun sound-to-int (idx)
  (declare (optimize (speed 3) (safety 0)))
  (aref *sound-to-int-array* idx))

(defun read-sound (path)
  (if (not (zerop (read-sound-internal path)))
      (let ((rv (make-sound)))
	   (setf (sound-length rv) (sound-length-internal)
		 (sound-sample-rate rv) (sound-sample-rate-internal)
		 (sound-bytes-per-unit rv) (sound-bytes-per-unit-internal)
		 (sound-channels rv) (sound-channels-internal)
		 (sound-samples-per-unit rv) (sound-samples-per-unit-internal))
	   (setf (sound-data rv) (make-array (sound-length rv) 
					     :element-type 'xlib::card8))
	   (get-sound-data-internal (sound-data rv))
	   rv)
      nil))

(defun write-sound (sound path)
  (set-sound-params-internal (sound-sample-rate sound)
			     (sound-bytes-per-unit sound)
			     (sound-channels sound)
			     (sound-samples-per-unit sound))
  (set-sound-data-internal (sound-data sound) 0 (sound-length sound))
  (not (zerop (write-sound-internal path))))

(defun play-sound (sound &key 
			 (start 0) 
			 (end (sound-length sound)))
  (let ((data (make-array (1+ (- end start))
			  :element-type 'xlib::card8
			  :displaced-to (sound-data sound)
			  :displaced-index-offset start)))
       (set-sound-params-internal (sound-sample-rate sound)
				  (sound-bytes-per-unit sound)
				  (sound-channels sound)
				  (sound-samples-per-unit sound))
       (set-sound-data-internal data start end)
       (not (zerop (play-sound-internal)))))
