;;;
;;; Shared Object Hierarchy
;;;
;;; Copyright (c) 1986 Regents of the University of California
;;; 
;;; Permission to use, copy, modify, and distribute this software and its
;;; documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notice appear in all copies and
;;; that both that copyright notice and this permission notice appear in
;;; supporting documentation, and that the name of the University of
;;; California not be used in advertising or publicity pertaining to
;;; distribution of the software without specific, written prior
;;; permission.  The University of California makes no representations
;;; about the suitability of this software for any purpose.  It is
;;; provided "as is" without express or implied warranty.
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/widgets/soh/RCS/mylow.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:08:49 $
;;;

(in-package 'pcl)

;;;
;;; Define macros that access the slots in a handle.
;;; Handle is defined in the file dbclass.cl.
;;; (pcl/low.cl).
;;; I could have used iwmc-class-static-slots.
;;; But since we need performance, %iwmc-class-static-slots
;;; is used, which is compiled in line.
;;;

(defun %get-static-slot--handle (handle slot-index)
  (%svref (%iwmc-class-static-slots handle) slot-index))

(defun %set-static-slot--handle (handle slot-index value)
  (setf (%svref (%iwmc-class-static-slots handle) slot-index) value))

(defun handle-id (handle)
  (%get-static-slot--handle handle 0))

#|
(defun handle-set-id (handle oid)
  (%set-static-slot--handle handle 0 oid))
|#
(defun handle-set-id (handle oid)
  (%set-static-slot--handle handle 0 oid)
  (if (handle-instance handle)
      (setf (sohid handle) (cadr oid))))

(defun handle-instance (handle)
  (%get-static-slot--handle handle 1))

(defun handle-set-instance (handle instance)
  (%set-static-slot--handle handle 1 instance))

(defun handle-mode (handle)
  (%get-static-slot--handle handle 2))

(defun handle-set-mode (handle mode)
  (%set-static-slot--handle handle 2 mode))

(defun handle-indb (handle)
  (%get-static-slot--handle handle 3))

(defun handle-set-indb (handle indb)
  (%set-static-slot--handle handle 3 indb))

(defun handle-modified (handle)
  (%get-static-slot--handle handle 4))

(defun handle-set-modified (handle modified)
  (%set-static-slot--handle handle 4 modified))

(defun handle-pinned (handle)
  (%get-static-slot--handle handle 5))

(defun handle-set-pinned (handle pinned)
  (%set-static-slot--handle handle 5 pinned))

#|
;;;
;;; Define function interfaces for macros in low.cl.
;;; Easier for debugging.
;;;

(defun get-static-slot--handle (handle slot-index)
  (%get-static-slot--handle handle slot-index))

(defun set-static-slot--handle (handle slot-index value)
  (%set-static-slot--handle handle slot-index value))
|#
